.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XScreenSaver 1 "17-Jun-99" "X Version 11"
.SH NAME
webcollage - decorate the screen with random images from the web
.SH SYNOPSIS
.B webcollage
[\-display \fIhost:display.screen\fP] [\-root] [\-verbose]
[\-delay \fIsecs\fP] [\-timeout \fIsecs\fP] [\-background \fIbg\fP]
[\-filter \fIcommand\fP] [\-filter2 \fIcommand\fP]
[\-http\-proxy host[:port]]
.SH DESCRIPTION
The \fIwebcollage\fP program pulls random image off of the World Wide Web
and scatters them on the root window.  One satisfied customer described it
as "a nonstop pop culture brainbath."  This program finds its images by
doing random web searches, and extracting images from the returned pages.
It places the images on the root window by using the
.BR xv (1),
.BR giftopnm (1),
and
.BR djpeg (1)
tools.

\fIwebcollage\fP is written in
.BR perl (1)
and requires Perl 5.
.SH OPTIONS
.I webcollage
accepts the following options:
.TP 8
.B \-root
Draw on the root window.  This option is manditory: drawing to a window
other than the root window is not yet supported.
.TP 8
.B \-verbose \fRor\fP \-v
Print diagnostics to stderr.  Multiple \fI-v\fP switches increase the
amount of output.  \fI-v\fP will print out only the URLs of the 
images; \fI-vv\fP will print all the commands being run; and \fI-vvv\fP
will print more than you care about.
.TP 8
.B \-delay \fIseconds\fP
How long to sleep between images.  Default 1 second.  (Remember that
this program probably spends a lot of time waiting for the network.)
.TP 8
.B \-background \fIcolor-or-ppm\fP
What to use for the background onto which images are pasted.  This may be
a color name, a hexadecimal RGB specification in the form '#rrggbb', or 
the name of a PPM file.
.TP 8
.B \-timeout \fIseconds\fP
How long to wait for a URL to complete before giving up on it and
moving on to the next one.
Default 30 seconds.
.TP 8
.B \-filter \fIcommand\fP
Filter all source images through this command.  The command must take
a PPM file on stdin, and write a new PPM file to stdout.  One good 
choice for a filter would be:
.EX
webcollage -root -filter 'vidwhacker -stdin -stdout'
.EE
.TP 8
.B \-filter2 \fIcommand\fP
Filter the \fIcomposite\fP image through this command.  The \fI-filter\fP
option applies to the sub-images; the \fI-filter2\fP applies to the
final, full-screen image.
.TP 8
.B \-http\-proxy \fIhost:port\fP
If you must go through a proxy to connect to the web, you can specify it 
with this option, or with the \fB$http_proxy\fP or \fB$HTTP_PROXY\fP 
environment variables.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B http_proxy\fR or \fPHTTP_PROXY
to get the default HTTP proxy host and port.
.SH FILES AND URLS
.TP
.I /usr/dict/words \fRor\fP /usr/share/lib/dict/words
To find the random words to feed to search engines.
.PP
.I http://random.yahoo.com/bin/ryl, http://image.altavista.com/
To find random web pages.
.SH BUGS
When drawing on the root window, it always uses the default colormap.
This is actually a limitation of xv.  But regardless, when using this
program with xscreensaver, it must be given the \fBdefault-n\fP 
visual specification (see the
.BR xscreensaver (1)
manual for more details.)

Only the GIF and JPEG image formats are supported.

Transparent and animating GIFs are not supported.

It's slow.

Too many of the images that it finds are text, not pictures.  This is 
because most of the web is pictures of text.  Which is pretty sad.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xv (1),
.BR ppmmake (1),
.BR giftopnm (1),
.BR pnmpaste (1),
.BR pnmscale (1),
.BR djpeg (1),
.BR cjpeg (1),
.BR xdpyinfo (1),
.BR perl (1),
.BR vidwhacker (1),
.BR dadadodo (1)
.SH COPYRIGHT
Copyright \(co 1998, 1999 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 24-May-98.
