 /*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTCIULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALER_H
#define DIALER_H

/* Some of these need to configurable from the properties box */
#define TOTAL_FRAMES   36
#define WIDGET_HEIGHT  48
#define WIDGET_WIDTH   48
#define IMAGE_FILENAME "gnome-ppp-animation.png"
#define IMAGE_FILENAME_FILLED "gnome-ppp-filled.png"

typedef struct _Dialer
{
   Account         *account;
   GList           *account_list;
   GtkWidget       *menu;
   GtkWidget       *applet;
   GtkWidget       *submenu;
   GtkWidget       *button;
   GtkWidget       *input_dialog;
   GtkWidget       *about;
   GtkWidget       *property_box;
   GtkWidget       *drawing_area;
   GdkImlibImage   *image;
   GdkImlibImage   *image_filled;
   GdkPixmap       *pixmap;
   GdkPixmap       *pixmap_filled;
   GdkPixmap       *back_pixmap;
   GdkBitmap       *mask;
   GdkBitmap       *mask_filled;
   gboolean        stop;
   gboolean        filled;
   gint            state;
   gint            timer_id;
   gint            frame_num;
   gint            total_frames;
   gint            timeouttime;
   gint            clock_timeout;
   gint            animation_speed;
   gint            tmp_speed;
} Dialer;

/* Callbacks and utility function prototypes */
static void ppp_message_handler(Account *account, PPPMessageType msg,
                                gchar *text, gpointer data);
static int lower_link(Dialer *dialer);
static int raise_link(Dialer *dialer);
static void menu_position_func(GtkMenu *menu, gint *x, gint *y, gpointer data);
static void hide_widgets(GtkWidget *widget, GtkWidget *toggle);
static void link_raise_cb(GtkWidget *widget, Dialer *dial);
static void link_lower_cb(GtkWidget *widget, Dialer *dial);
static void about_cb(AppletWidget *widget, gpointer data);
static gint button_press(GtkWidget *widget, GdkEventButton *evt);
static void add_submenu_item(gpointer data, gpointer user_data);
static GtkWidget *setup_submenu(void);
static void build_submenu(Dialer *dialer);
static void properties(AppletWidget *applet, gpointer data);

#endif /* DIALER_H */
