#include "maillist.h"
#include <stdio.h>
#include <stdlib.h>

@interface Listserv : MailList
@end

@implementation Listserv
- (BOOL) sendControlMessage:(id) persona
			   :(const char *) ctlmsg
			   :(const char *) data
{
  FILE *mailout;
  char subj[256];
  char *mycmd;

  g_snprintf(subj, sizeof(subj),
	     "From GNOME mailman for %s <%s>.\n",
	     [persona getFullName],
	     [persona getEmailAddress]);
  mailout = [self sendMail:persona
		  :[self getControlAddress]
		  :subj];
  if(mailout) {
    if(!strcmp(ctlmsg, "subscribe"))
	mycmd = "sub";
    else if(!strcmp(ctlmsg, "unsubscribe"))
	mycmd = "signoff";
    else
	mycmd = (char *)ctlmsg;
    fprintf(mailout, "%s %s %s %s\n",
	    mycmd,
	    [self getName],
	    [persona getFullName],
	    data?data:NULL);
    pclose(mailout);
    return TRUE;
  } else
    return FALSE;
}

@end
