#ifndef _GTKFUNC_H
#define _GTKFUNC_H

#include "datatype.h"

struct sokandlb
{
	int sok;
	GtkWidget *lb_userwin;
#if 0
	GtkWidget *lb_syswin;
#endif
	GtkWidget *window;
	int online;
	int offline;
};

struct URLInfo
{
	struct sokandlb *data;
	GtkWidget *url;
	GtkWidget *desc;
	int cindex;
};

extern GtkWidget *found_list;
extern int start_new_info;

void icq_quit( GtkWidget *widget, struct sokandlb *data );
void icq_refresh( struct sokandlb *data,
                  int sok, GdkInputCondition cond );
void icq_msgbox( char *message_text, char *sender, DWORD uin,
                 struct sokandlb *data );
GtkWidget *create_menu ( struct sokandlb *data );
void show_contact_message( int cx, struct sokandlb *data );
gint icq_sendmessage_window( GtkWidget *clist, GdkEventButton *event,
                             struct sokandlb *data );
int stay_connected( struct sokandlb *data );
void icq_sendmessage( GtkWidget *button, struct sokandlb *data );
void show_personal_info( GtkWidget *widget, struct sokandlb *data );
void dump_personal_info( DWORD uin );
void rename_uin( GtkWidget *widget, struct sokandlb *data );
void authorize_uin( GtkWidget *widget, struct sokandlb *data );
void search_window( GtkWidget *widget, struct sokandlb *data );
void display_mess_history( GtkWidget *widget, struct sokandlb *data );
void update_personal_history( char *message, int index );
void change_nick_window( GtkWidget *widget, struct sokandlb *data );
void change_away_window( GtkWidget *widget, gpointer data );
void read_next( GtkWidget *widget, struct sokandlb *data );
#if 0
void icq_sysmessage_window( GtkWidget *clist, GdkEventButton *event,
                            struct sokandlb *data );
#endif

void send_chat_request( GtkWidget *widget, GtkWidget *entry );
void request_chat( GtkWidget *widget, struct sokandlb *data );

void request_file( GtkWidget *widget, struct sokandlb *data, char *defaultfile );
void request_file_default( GtkWidget *widget, struct sokandlb *data );
void send_url_window( GtkWidget *widget, struct sokandlb *data, char *defaulturl );
void send_url_window_default( GtkWidget *widget, struct sokandlb *data );

void remove_user( GtkWidget *widget, struct sokandlb *data );
void show_info_new( SOK_T sok, int uin );
void retrieve_away_message( GtkWidget *widget, struct sokandlb *data );

void icq_set_status_online( GtkWidget *widget, struct sokandlb *data );
void icq_set_status_offline( GtkWidget *widget, struct sokandlb *data );
void icq_set_status_away( GtkWidget *widget, struct sokandlb *data );
void icq_set_status_na( GtkWidget *widget, struct sokandlb *data );
void icq_set_status_invisible( GtkWidget *widget, struct sokandlb *data );
void icq_set_status_dnd( GtkWidget *widget, struct sokandlb *data );
void icq_set_status_occ( GtkWidget *widget, struct sokandlb *data );
void icq_set_status_ffc( GtkWidget *widget, struct sokandlb *data );
void add_to_inv_list( GtkWidget *widget, struct sokandlb *data );
void remove_from_inv_list( GtkWidget *widget, struct sokandlb *data );
void add_to_vis_list( GtkWidget *widget, struct sokandlb *data );
void remove_from_vis_list( GtkWidget *widget, struct sokandlb *data );
void change_winsize( GtkWidget *widget, gpointer data );
void icq_sendmessage_window_from_menu( GtkWidget *widget,
                                       struct sokandlb *data );
void display_url( GtkWidget *widget, char *url );

#endif
