#include <string.h>
#include "gnomeicu.h"
#include "dialog.h"

void change_show( GtkWidget *widget, int *toggle_me );

void OK_Box( char *header, char *message )
{
	GtkWidget *dialog;
	GtkWidget *text = NULL;
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *scrollbar;
	GtkWidget *hbox;
	GtkWidget *vbox;

#ifdef TRACE_FUNCTION
	g_print( "OK_Box\n" );
#endif
	
	dialog = gtk_window_new( GTK_WINDOW_DIALOG );
	
	gtk_signal_connect( GTK_OBJECT( dialog ), "destroy", GTK_SIGNAL_FUNC( gtk_widget_destroyed ), &dialog );
	
	gtk_window_set_title( GTK_WINDOW( dialog ), "GnomeICU: Message" );
	gtk_container_border_width( GTK_CONTAINER( dialog ), 10 );

/*	if( message == NULL || strcmp( message, "" ) )
	{
		gtk_widget_set_usize( dialog, 350, 250 );
	}
*/	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( dialog ), vbox );

	label = gtk_label_new( header );
	gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 5 );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.5, 1 );
	gtk_widget_show( label );	

	if( message == NULL || strcmp( message, "" ) )
	{
		hbox = gtk_hbox_new( FALSE, 0 );
		
		text = gtk_text_new( NULL, NULL );

		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );

		gtk_box_pack_start( GTK_BOX( hbox ), text, TRUE, TRUE, 0 );
		gtk_widget_show( text );
	
		scrollbar = gtk_vscrollbar_new( GTK_TEXT( text )->vadj );
		gtk_box_pack_start( GTK_BOX( hbox ), scrollbar, FALSE, FALSE, 0 );
		gtk_widget_show( scrollbar );

		gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 5 );
		gtk_widget_show( hbox );
	}

	hbox = gtk_hbox_new( FALSE, 0 );

	button = gtk_button_new_with_label( "OK" );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( dialog ) );
	gtk_widget_set_usize( button, 100, 30 );
	gtk_box_pack_end( GTK_BOX( hbox ), button, TRUE, FALSE, 5 );
	gtk_widget_show( button );
	
	gtk_box_pack_end( GTK_BOX( vbox ), hbox, FALSE, FALSE, 5 );
	gtk_widget_show( hbox );
	
	gtk_widget_show( vbox );

	gtk_widget_show( dialog );

	if( strcmp( message, "" ) )
	{
		gtk_widget_realize( text );
		gtk_text_freeze( GTK_TEXT( text ) );
		gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL, message, -1 );
		gtk_text_thaw( GTK_TEXT( text ) );
	}
}

void AMessage_Box( char *header, char *message, int uin )
{
	GtkWidget *dialog;
	GtkWidget *text = NULL;
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *scrollbar;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *show_again;

	int cx;

#ifdef TRACE_FUNCTION
	g_print( "AMessage_Box\n" );
#endif

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].uin == uin )
			break;
	}

	if( Contacts[ cx ].show_again == FALSE )
		return;

	dialog = gtk_window_new( GTK_WINDOW_DIALOG );
	
	gtk_signal_connect( GTK_OBJECT( dialog ), "destroy", GTK_SIGNAL_FUNC( gtk_widget_destroyed ), &dialog );
	
	gtk_window_set_title( GTK_WINDOW( dialog ), "GnomeICU: Message" );
	gtk_container_border_width( GTK_CONTAINER( dialog ), 10 );

/*	if( message == NULL || strcmp( message, "" ) )
	{
		gtk_widget_set_usize( dialog, 350, 250 );
	}
*/	
	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( dialog ), vbox );

	label = gtk_label_new( header );
	gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, TRUE, 5 );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.5, 1 );
	gtk_widget_show( label );	

	if( message == NULL || strcmp( message, "" ) )
	{
		hbox = gtk_hbox_new( FALSE, 0 );
		
		text = gtk_text_new( NULL, NULL );

		gtk_text_set_word_wrap( GTK_TEXT( text ), TRUE );

		gtk_box_pack_start( GTK_BOX( hbox ), text, TRUE, TRUE, 0 );
		gtk_widget_show( text );
	
		scrollbar = gtk_vscrollbar_new( GTK_TEXT( text )->vadj );
		gtk_box_pack_start( GTK_BOX( hbox ), scrollbar, FALSE, FALSE, 0 );
		gtk_widget_show( scrollbar );

		gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 5 );
		gtk_widget_show( hbox );
	}

	show_again = gtk_check_button_new_with_label( "Show again" );
	gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( show_again ),
	                             Contacts[ cx ].show_again );
	gtk_box_pack_start( GTK_BOX( vbox ), show_again, FALSE, FALSE, 0 );
	gtk_widget_show( show_again );

	gtk_signal_connect( GTK_OBJECT( show_again ), "clicked",
	                    (GtkSignalFunc)change_show, &Contacts[ cx ].show_again );

	hbox = gtk_hbox_new( FALSE, 0 );

	button = gtk_button_new_with_label( "OK" );
	gtk_signal_connect_object( GTK_OBJECT( button ), "clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( dialog ) );
	gtk_widget_set_usize( button, 100, 30 );
	gtk_box_pack_end( GTK_BOX( hbox ), button, TRUE, FALSE, 5 );
	gtk_widget_show( button );
	
	gtk_box_pack_end( GTK_BOX( vbox ), hbox, FALSE, FALSE, 5 );
	gtk_widget_show( hbox );
	
	gtk_widget_show( vbox );

	gtk_widget_show( dialog );

	if( strcmp( message, "" ) )
	{
		gtk_widget_realize( text );
		gtk_text_freeze( GTK_TEXT( text ) );
		gtk_text_insert( GTK_TEXT( text ), 0, 0, 0, message, -1 );		
		gtk_text_thaw( GTK_TEXT( text ) );
	}
}

void change_show( GtkWidget *widget, int *toggle_me )
{
#ifdef TRACE_FUNCTION
	g_print( "change_show\n" );
#endif
   
	*toggle_me = !*toggle_me;
}
