/*****************************************************************************/
/*  options.h - the global variables for the program                         */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

/* This are the pixmaps and the masks for some of the built in icons */
GdkPixmap *dotdot_pixmap, *dir_pixmap, *linkdir_pixmap, *linkfile_pixmap,
   *exe_pixmap, *doc_pixmap, *open_dir_pixmap;
GdkBitmap *dotdot_mask, *dir_mask, *linkdir_mask, *linkfile_mask, 
   *exe_mask, *doc_mask, *open_dir_mask;

GtkItemFactory *factory; /* Our menus */
GHashTable *bookmarks_htable; /* Hash table into bookmarks menu */

struct pix_ext *registered_exts; /* Registered file extensions */
struct conn_categories *hostcat; /* Our host categories/sites for the connection
                                    manager */

struct ftp_transfer_data *file_transfers = NULL; /* All of our transfers */

pthread_mutex_t transfer_mutex = PTHREAD_MUTEX_INITIALIZER, /* Mutex for 
          protecting the file_transfers struct */

                log_mutex = PTHREAD_MUTEX_INITIALIZER; /* Mutex for protecting
                                    the file_transfer_logs struct */

GList *viewedit_processes = NULL, /* This holds information about each open 
                                     view/edit process */

      *file_transfer_logs = NULL; /* Waiting log entries from the threads */

GtkWidget *logwdw, /* Logging text widget */
          *dlwdw, /* Download list box */
          *local_frame, /* gtk_frame for the local window (for saving geometry) */
          *remote_frame, /* gtk_frame for the remote window (for saving geometry) */
          *log_table, /* gtk_table for the logging window (for saving geometry */
          *transfer_scroll, /* gtk_scroll for the transfer window (for saving geometry */
          *firewall_btn, /* Stores state of whether to use firewall or not */
          *stop_btn, /* The stop button */
          *openurl_btn, /* The openurl button */
          *hostedit, /* The host edit field on the toolbar */
          *useredit, /* The user edit field on the toolbar */
          *passedit, /* The password edit field on the toolbar */
          *portedit; /* The port edit field on the toolbar */

struct ftp_window_data window1, /* Local window data structs */
                       window2; /* Remote window data structs */

/* Several options */
char *emailaddr = NULL, /* What to send when we log in as anonymous */
     *edit_program = NULL, /* Our default editor */
     *view_program = NULL; /* Our default file viewer */

int do_one_transfer_at_a_time = 1, /* Only allow one transfer at a time. The other
                                      transfers will be queued */
    start_file_transfers = 1, /* Shall we start the file transfers yet? */
    transfer_in_progress = 0, /* Any transfers transferring files? */
    use_cache = 1, /* Shall we use the cache? */
    passive_transfer = 1, /* Are we sending PASV or PORT to the server */
    sort_dirs_first = 1, /* Put the dirs first when sorting */
    confirm_delete = 1, /* Confirm to delete files */
    use_default_dl_types = 1, /* If this is set, then files will use their
                                 default dl type. For example, if you set in
                                 the config file .txt files to have a default
                                 option of ASCII, and if this setting is set,
                                 it will use ASCII. Otherwise, it would use
                                 the setting in the FTP menu */
    show_hidden_files = 1, /* Show hidden files */
    reconnect_diag = 1, /* Bring up the reconnect dialog */
    preserve_attribs = 1, /* Preserve file attribs after each download */
    refresh_files = 0, /* Refresh the listbox after each file is done */
    save_geometry = 1, /* Shall we use geometry management? */
    listbox_local_width = 265, /* Width of the local listbox */
    listbox_remote_width = 265, /* Width of the remote listbox */
    listbox_file_height = 265, /* Height of the local/remote listbox */
    transfer_height = 80, /* Height of the transfer window */
    log_height = 105, /* Height of the logging window */
    timeout = 0, /* Timeout for the connection */
    retries = 3, /* Number of auto-retries to connection */
    sleep_time = 30, /* Number of seconds to wait between retries */
    listbox_filename_width = 100, /* Width of the filename column in the listbox */
    listbox_size_width = 85, /* Width of the filename column in the listbox */
    listbox_user_width = 65, /* Width of the filename column in the listbox */
    listbox_group_width = 65, /* Width of the filename column in the listbox */
    listbox_date_width = 120, /* Width of the filename column in the listbox */
    listbox_attribs_width = 75; /* Width of the filename column in the listbox */
char *firewall_host, /* Firewall host */
     *firewall_username, /* Firewall username */
     *firewall_password, /* Firewall password */
     *firewall_account, /* Firewall account (optional) */
     *proxy_config; /* The way to log into the proxy server */
int firewall_port = 21; /* What port to connect to? */
float maxkbs = 0; /* The max KB/s a file transfer can get */