/*****************************************************************************/
/*  chmod_dialog.c - the chmod dialog box                                    */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

static void dochmod(GtkWidget *widget, struct ftp_window_data *wdata);

static GtkWidget *suid, *sgid,
		 *ur, *uw, *ux,
		 *gr, *gw, *gx,
		 *or, *ow, *ox;

void chmod_dialog (gpointer data) {
   GtkWidget *tempwid, *dialog, *hbox, *vbox;
   struct ftp_window_data *wdata;
   struct ftp_file_data *tempfle;
   
   wdata = (struct ftp_window_data *) data;
   if (!check_status (_("Chmod"), wdata, 1, 1, 1)) return;

   dialog = gtk_dialog_new ();
   gtk_window_set_title (GTK_WINDOW (dialog), _("Chmod"));
   gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), 10);
   gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->action_area), 5);
   gtk_box_set_spacing (GTK_BOX(GTK_DIALOG (dialog)->vbox), 5);
   gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (dialog)->action_area), TRUE);
   gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
   gtk_signal_connect_object (GTK_OBJECT (dialog), "delete_event", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));
      
   tempwid = gtk_label_new (_("You can now adjust the attributes of your file(s)\nNote: Not all ftp servers support the chmod feature"));
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), tempwid, FALSE, FALSE, FALSE);
   gtk_widget_show (tempwid);
   
   hbox = gtk_hbox_new(TRUE, 5);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, FALSE, FALSE, FALSE);
   gtk_widget_show(hbox);

   tempwid = gtk_frame_new (_("Special"));
   gtk_box_pack_start (GTK_BOX (hbox), tempwid, FALSE, FALSE, FALSE);
   gtk_widget_show (tempwid);

   if (wdata->local == 0) gtk_widget_set_sensitive (tempwid, 0);
      
   vbox = gtk_vbox_new (TRUE, 5);
   gtk_container_add (GTK_CONTAINER (tempwid), vbox);
   gtk_widget_show (vbox);
   
   suid = gtk_check_button_new_with_label ("SUID");
   gtk_box_pack_start (GTK_BOX (vbox), suid, FALSE, FALSE, FALSE);
   gtk_widget_show (suid);

   sgid = gtk_check_button_new_with_label (_("SGID"));
   gtk_box_pack_start (GTK_BOX (vbox), sgid, FALSE, FALSE, FALSE);
   gtk_widget_show (sgid);

   tempwid = gtk_frame_new (_("User"));
   gtk_box_pack_start (GTK_BOX (hbox), tempwid, FALSE, FALSE, FALSE);
   gtk_widget_show (tempwid);
   
   vbox = gtk_vbox_new (TRUE, 5);
   gtk_container_add (GTK_CONTAINER (tempwid), vbox);
   gtk_widget_show (vbox);
   
   ur = gtk_check_button_new_with_label (_("Read"));
   gtk_box_pack_start (GTK_BOX (vbox), ur, FALSE, FALSE, FALSE);
   gtk_widget_show (ur);

   uw = gtk_check_button_new_with_label (_("Write"));
   gtk_box_pack_start (GTK_BOX (vbox), uw, FALSE, FALSE, FALSE);
   gtk_widget_show (uw);

   ux = gtk_check_button_new_with_label (_("Execute"));
   gtk_box_pack_start (GTK_BOX (vbox), ux, FALSE, FALSE, FALSE);
   gtk_widget_show (ux);

   tempwid = gtk_frame_new (_("Group"));
   gtk_box_pack_start (GTK_BOX (hbox), tempwid, FALSE, FALSE, FALSE);
   gtk_widget_show (tempwid);
   
   vbox = gtk_vbox_new (TRUE, 5);
   gtk_container_add (GTK_CONTAINER (tempwid), vbox);
   gtk_widget_show (vbox);
   
   gr = gtk_check_button_new_with_label (_("Read"));
   gtk_box_pack_start (GTK_BOX (vbox), gr, FALSE, FALSE, FALSE);
   gtk_widget_show (gr);

   gw = gtk_check_button_new_with_label (_("Write"));
   gtk_box_pack_start (GTK_BOX (vbox), gw, FALSE, FALSE, FALSE);
   gtk_widget_show (gw);

   gx = gtk_check_button_new_with_label (_("Execute"));
   gtk_box_pack_start (GTK_BOX (vbox), gx, FALSE, FALSE, FALSE);
   gtk_widget_show (gx);

   tempwid = gtk_frame_new (_("Other"));
   gtk_box_pack_start (GTK_BOX (hbox), tempwid, FALSE, FALSE, FALSE);
   gtk_widget_show (tempwid);
   
   vbox = gtk_vbox_new (TRUE, 5);
   gtk_container_add (GTK_CONTAINER (tempwid), vbox);
   gtk_widget_show (vbox);
   
   or = gtk_check_button_new_with_label (_("Read"));
   gtk_box_pack_start (GTK_BOX (vbox), or, FALSE, FALSE, FALSE);
   gtk_widget_show (or);

   ow = gtk_check_button_new_with_label (_("Write"));
   gtk_box_pack_start (GTK_BOX (vbox), ow, FALSE, FALSE, FALSE);
   gtk_widget_show (ow);

   ox = gtk_check_button_new_with_label (_("Execute"));
   gtk_box_pack_start (GTK_BOX (vbox), ox, FALSE, FALSE, FALSE);
   gtk_widget_show (ox);

   tempwid = gtk_button_new_with_label (_("Change"));
   GTK_WIDGET_SET_FLAGS (tempwid, GTK_CAN_DEFAULT);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), tempwid, TRUE, TRUE, FALSE);
   gtk_signal_connect (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (dochmod), (gpointer) wdata);
   gtk_signal_connect_object (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));
   gtk_widget_grab_default(tempwid);
   gtk_widget_show(tempwid);

   tempwid = gtk_button_new_with_label (_("  Cancel  "));
   GTK_WIDGET_SET_FLAGS (tempwid, GTK_CAN_DEFAULT);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), tempwid, TRUE, TRUE, FALSE);
   gtk_signal_connect_object (GTK_OBJECT (tempwid), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (dialog));
   gtk_widget_show (tempwid);

   if (wdata->numselected == 1) {
      if ((tempfle = get_next_selected_filename (wdata->hdata->files)) == NULL) {
         ftp_log (gftp_logging_error, NULL, _("Internal gFTP Error: Could not find a selected file. This is probably a bug. Please email masneyb@seul.org about it\n"));
         return;
      }
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (suid), tolower (tempfle->attribs[3]) == 's');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sgid), tolower (tempfle->attribs[6]) == 's');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ur), tempfle->attribs[1] == 'r');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (uw), tempfle->attribs[2] == 'w');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ux), tempfle->attribs[3] == 'x');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gr), tempfle->attribs[4] == 'r');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gw), tempfle->attribs[5] == 'w');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gx), tempfle->attribs[6] == 'x');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (or), tempfle->attribs[7] == 'r');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ow), tempfle->attribs[8] == 'w');
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ox), tempfle->attribs[9] == 'x');
   }
   gtk_widget_show (dialog);
}         
/*****************************************************************************/
static void dochmod (GtkWidget *widget, struct ftp_window_data *wdata) {
   struct ftp_file_data *tempfle;
   int success, cur;
   mode_t mode;
   
   mode = 0;
   if (wdata->local == 0) {
      cur = 0;
      if (GTK_TOGGLE_BUTTON (ur)->active) cur += 4;
      if (GTK_TOGGLE_BUTTON (uw)->active) cur += 2;
      if (GTK_TOGGLE_BUTTON (ux)->active) cur += 1;
      mode = mode * 10 + cur;

      cur = 0;
      if (GTK_TOGGLE_BUTTON (gr)->active) cur += 4;
      if (GTK_TOGGLE_BUTTON (gw)->active) cur += 2;
      if (GTK_TOGGLE_BUTTON (gx)->active) cur += 1;
      mode = mode * 10 + cur;

      cur = 0;
      if (GTK_TOGGLE_BUTTON (or)->active) cur += 4;
      if (GTK_TOGGLE_BUTTON (ow)->active) cur += 2;
      if (GTK_TOGGLE_BUTTON (ox)->active) cur += 1;
      mode = mode * 10 + cur;
   }
   else {
      if (GTK_TOGGLE_BUTTON (suid)->active) mode |= S_ISUID;
      if (GTK_TOGGLE_BUTTON (sgid)->active) mode |= S_ISGID;
      if (GTK_TOGGLE_BUTTON (ur)->active) mode |= S_IRUSR;
      if (GTK_TOGGLE_BUTTON (uw)->active) mode |= S_IWUSR;
      if (GTK_TOGGLE_BUTTON (ux)->active) mode |= S_IXUSR;
      if (GTK_TOGGLE_BUTTON (gr)->active) mode |= S_IRGRP;
      if (GTK_TOGGLE_BUTTON (gw)->active) mode |= S_IWGRP;
      if (GTK_TOGGLE_BUTTON (gx)->active) mode |= S_IXGRP;
      if (GTK_TOGGLE_BUTTON (or)->active) mode |= S_IROTH;
      if (GTK_TOGGLE_BUTTON (ow)->active) mode |= S_IWOTH;
      if (GTK_TOGGLE_BUTTON (ox)->active) mode |= S_IXOTH;
   }
   
   tempfle = get_next_selected_filename (wdata->hdata->files);
   success = -1;
   while (tempfle != NULL) {
      if (wdata->local == 1) {
         success = chmod (tempfle->file, mode);
         if (success != 0) {
            ftp_log (gftp_logging_error, NULL, _("Error: Could not change mode of %s to %d: %s\n"), tempfle->file, mode, g_strerror (errno));
         }
         else {
            ftp_log (gftp_logging_misc, NULL, _("Successfully changed mode of %s to %d\n"), tempfle->file, mode);
         }
      }
      else {
         if (wdata->local == 2 && !ftp_connect (wdata->hdata, 0)) success = -1;
         else {
            wdata->hdata->getdir = 1;
            success = gftp_chmod (wdata->hdata->ftpdata, tempfle->file, mode);
         }
      }
      tempfle = get_next_selected_filename (tempfle->next);
   }
   if (success == 0) refresh (wdata);
}
/*****************************************************************************/
