#include "E.h"
static ImageClass  *d_ic_default = NULL;
static ImageClass  *db_ic_default = NULL;
static TextClass   *d_tc_default = NULL;
static TextClass   *db_tc_default = NULL;

Dialog             *
CreateDialog(char *name)
{
  Dialog             *d;

  d = Emalloc(sizeof(Dialog));
  d->name = duplicate(name);
  d->title = NULL;
  d->text = NULL;
  d->num_buttons = 0;
  d->win = 0;
  d->button = NULL;
  d->win = ECreateWindow(root.win, -20, -20, 2, 2, 0);
  d->tclass = FindItem("DIALOG", 0, LIST_FINDBY_NAME, LIST_TYPE_TCLASS);
  d->iclass = FindItem("DIALOG", 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS);
  if (!d->tclass)
    {
      if (!d_tc_default)
	{
	  d_tc_default = CreateTclass();
	  d_tc_default->norm.normal = CreateTextState();
	  d_tc_default->norm.normal->fontname =
	    duplicate("-*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*");
	  d_tc_default->norm.normal->fg_col.r = 0;
	  d_tc_default->norm.normal->fg_col.g = 0;
	  d_tc_default->norm.normal->fg_col.b = 0;
	}
      d->tclass = d_tc_default;
    }
  if (!d->iclass)
    {
      if (!d_ic_default)
	{
	  d_ic_default = CreateIclass();
	  d_ic_default->name = NULL;
	  d_ic_default->norm.normal = CreateImageState();
	  d_ic_default->norm.normal->hihi.r = 255;
	  d_ic_default->norm.normal->hihi.g = 255;
	  d_ic_default->norm.normal->hihi.b = 255;
	  d_ic_default->norm.normal->hi.r = 220;
	  d_ic_default->norm.normal->hi.g = 220;
	  d_ic_default->norm.normal->hi.b = 220;
	  d_ic_default->norm.normal->bg.r = 160;
	  d_ic_default->norm.normal->bg.g = 160;
	  d_ic_default->norm.normal->bg.b = 160;
	  d_ic_default->norm.normal->lo.r = 100;
	  d_ic_default->norm.normal->lo.g = 100;
	  d_ic_default->norm.normal->lo.b = 100;
	  d_ic_default->norm.normal->lolo.r = 0;
	  d_ic_default->norm.normal->lolo.g = 0;
	  d_ic_default->norm.normal->lolo.b = 0;
	  d_ic_default->norm.normal->bevelstyle = BEVEL_NEXT;
	  d_ic_default->norm.clicked = CreateImageState();
	  d_ic_default->norm.clicked->hihi.r = 0;
	  d_ic_default->norm.clicked->hihi.g = 0;
	  d_ic_default->norm.clicked->hihi.b = 0;
	  d_ic_default->norm.clicked->hi.r = 100;
	  d_ic_default->norm.clicked->hi.g = 100;
	  d_ic_default->norm.clicked->hi.b = 100;
	  d_ic_default->norm.clicked->bg.r = 160;
	  d_ic_default->norm.clicked->bg.g = 160;
	  d_ic_default->norm.clicked->bg.b = 160;
	  d_ic_default->norm.clicked->lo.r = 220;
	  d_ic_default->norm.clicked->lo.g = 220;
	  d_ic_default->norm.clicked->lo.b = 220;
	  d_ic_default->norm.clicked->lolo.r = 255;
	  d_ic_default->norm.clicked->lolo.g = 255;
	  d_ic_default->norm.clicked->lolo.b = 255;
	  d_ic_default->norm.clicked->bevelstyle = BEVEL_NEXT;
	  d_ic_default->padding.left = 8;
	  d_ic_default->padding.right = 8;
	  d_ic_default->padding.top = 8;
	  d_ic_default->padding.bottom = 8;
	}
      d->iclass = d_ic_default;
    }
  return d;
}

void
FreeDButton(DButton * db)
{
  if (db->text)
    Efree(db->text);
  Efree(db);
}

void
FreeDialog(Dialog * d)
{
  int                 i;

  if (d->name)
    Efree(d->name);
  if (d->title)
    Efree(d->title);
  if (d->text)
    Efree(d->text);
  for (i = 0; i < d->num_buttons; i++)
    FreeDButton(d->button[i]);
  if (d->button)
    Efree(d->button);
  Efree(d);
}

void
DialogRestart(int val, void *data)
{
  doExit("restart");
  val = 0;
  data = NULL;
}

void
DialogQuit(int val, void *data)
{
  doExit("error");
  val = 0;
  data = NULL;
}

void
DialogAlert(char *fmt,...)
{
/*  Dialog             *__d; */
  char                text[10240];
  va_list             ap;

  SC_Kill();
  va_start(ap, fmt);
  Evsnprintf(text, 10240, fmt, ap);
  va_end(ap);
/*
 * if ((disp) &&
 * (FindItem("DIALOG", 0, LIST_FINDBY_NAME, LIST_TYPE_TCLASS)) &&
 * (FindItem("DIALOG", 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS)) &&
 * (FindItem("DIALOG_BUTTON", 0, LIST_FINDBY_NAME, LIST_TYPE_TCLASS)) &&
 * (FindItem("DIALOG_BUTTON", 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS)))
 * {
 * __d = CreateDialog("DIALOG");
 * DialogSetTitle(__d, "Attention !!!");
 * DialogSetText(__d, text);
 * DialogAddButton(__d, "Ignore", NULL, 1);
 * DialogAddButton(__d, "Restart Enlightenment", DialogRestart, 1);
 * DialogAddButton(__d, "Exit Enlightenment", DialogQuit, 1);
 * ShowDialog(__d);
 * }
 * else */
  Alert(text);
}

void
DialogAlertOK(char *fmt,...)
{
/*  Dialog             *__d; */
  char                text[10240];
  va_list             ap;

  va_start(ap, fmt);
  Evsnprintf(text, 10240, fmt, ap);
  va_end(ap);
/*
 * if ((disp) &&
 * (FindItem("DIALOG", 0, LIST_FINDBY_NAME, LIST_TYPE_TCLASS)) &&
 * (FindItem("DIALOG", 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS)) &&
 * (FindItem("DIALOG_BUTTON", 0, LIST_FINDBY_NAME, LIST_TYPE_TCLASS)) &&
 * (FindItem("DIALOG_BUTTON", 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS)))
 * {
 * __d = CreateDialog("DIALOG");
 * DialogSetTitle(__d, "Attention !!!");
 * DialogSetText(__d, text);
 * DialogAddButton(__d, "OK", NULL, 1);
 * ShowDialog(__d);
 * }
 * else */
  {
    ASSIGN_ALERT("Attention !!!", "OK", " ", " ");
    Alert(text);
    RESET_ALERT;
  }
}

void
DialogSetParamText(Dialog * d, char *fmt,...)
{
  char                text[10240];
  va_list             ap;

  va_start(ap, fmt);
  Evsnprintf(text, 10240, fmt, ap);
  va_end(ap);
  DialogSetText(d, text);
}

void
DialogSetText(Dialog * d, char *text)
{
  int                 w, h;

  if (d->text)
    Efree(d->text);
  d->text = duplicate(text);
  if ((!d->tclass) || (!d->iclass))
    return;
  TextSize(d->tclass, 0, 0, STATE_NORMAL, text, &w, &h, 17);
  d->w = w + d->iclass->padding.left + d->iclass->padding.right;
  d->h = h + d->iclass->padding.top + d->iclass->padding.bottom;
}

void
DialogSetTitle(Dialog * d, char *title)
{
  if (d->title)
    Efree(d->title);
  d->title = duplicate(title);
}

void
DialogAddButton(Dialog * d, char *text, void (*func) (int val, void *data), char close)
{
  DButton            *db;
  int                 w, h;

  db = Emalloc(sizeof(DButton));
  d->num_buttons++;
  d->button = Erealloc(d->button, d->num_buttons * (sizeof(DButton *)));
  d->button[d->num_buttons - 1] = db;
  db->text = duplicate(text);
  db->func = func;
  db->win = ECreateWindow(d->win, -20, -20, 2, 2, 0);
  XMapWindow(disp, db->win);
  db->x = -1;
  db->y = -1;
  db->w = -1;
  db->h = -1;
  db->hilited = 0;
  db->clicked = 0;
  db->close = close;
  db->tclass = FindItem("DIALOG_BUTTON", 0, LIST_FINDBY_NAME, LIST_TYPE_TCLASS);
  db->iclass = FindItem("DIALOG_BUTTON", 0, LIST_FINDBY_NAME, LIST_TYPE_ICLASS);
  if (!db->tclass)
    {
      if (!db_tc_default)
	{
	  db_tc_default = CreateTclass();
	  db_tc_default->norm.normal = CreateTextState();
	  db_tc_default->norm.normal->fontname =
	    duplicate("-*-helvetica-*-r-*-*-12-*-*-*-*-*-*-*");
	  db_tc_default->norm.normal->fg_col.r = 0;
	  db_tc_default->norm.normal->fg_col.g = 0;
	  db_tc_default->norm.normal->fg_col.b = 0;
	}
      db->tclass = db_tc_default;
    }
  if (!db->iclass)
    {
      if (!db_ic_default)
	{
	  db_ic_default = CreateIclass();
	  db_ic_default->name = NULL;
	  db_ic_default->norm.normal = CreateImageState();
	  db_ic_default->norm.normal->hihi.r = 255;
	  db_ic_default->norm.normal->hihi.g = 255;
	  db_ic_default->norm.normal->hihi.b = 255;
	  db_ic_default->norm.normal->hi.r = 240;
	  db_ic_default->norm.normal->hi.g = 240;
	  db_ic_default->norm.normal->hi.b = 240;
	  db_ic_default->norm.normal->bg.r = 190;
	  db_ic_default->norm.normal->bg.g = 190;
	  db_ic_default->norm.normal->bg.b = 190;
	  db_ic_default->norm.normal->lo.r = 130;
	  db_ic_default->norm.normal->lo.g = 130;
	  db_ic_default->norm.normal->lo.b = 130;
	  db_ic_default->norm.normal->lolo.r = 0;
	  db_ic_default->norm.normal->lolo.g = 0;
	  db_ic_default->norm.normal->lolo.b = 0;
	  db_ic_default->norm.normal->bevelstyle = BEVEL_NEXT;
	  db_ic_default->norm.clicked = CreateImageState();
	  db_ic_default->norm.clicked->hihi.r = 0;
	  db_ic_default->norm.clicked->hihi.g = 0;
	  db_ic_default->norm.clicked->hihi.b = 0;
	  db_ic_default->norm.clicked->hi.r = 130;
	  db_ic_default->norm.clicked->hi.g = 130;
	  db_ic_default->norm.clicked->hi.b = 130;
	  db_ic_default->norm.clicked->bg.r = 190;
	  db_ic_default->norm.clicked->bg.g = 190;
	  db_ic_default->norm.clicked->bg.b = 190;
	  db_ic_default->norm.clicked->lo.r = 240;
	  db_ic_default->norm.clicked->lo.g = 240;
	  db_ic_default->norm.clicked->lo.b = 240;
	  db_ic_default->norm.clicked->lolo.r = 255;
	  db_ic_default->norm.clicked->lolo.g = 255;
	  db_ic_default->norm.clicked->lolo.b = 255;
	  db_ic_default->norm.clicked->bevelstyle = BEVEL_NEXT;
	  db_ic_default->padding.left = 8;
	  db_ic_default->padding.right = 8;
	  db_ic_default->padding.top = 8;
	  db_ic_default->padding.bottom = 8;
	}
      db->iclass = db_ic_default;
    }
  TextSize(db->tclass, 0, 0, STATE_NORMAL, text, &w, &h, 17);
  db->w = w + db->iclass->padding.left + db->iclass->padding.right;
  db->h = h + db->iclass->padding.top + db->iclass->padding.bottom;
  XSelectInput(disp, db->win, EnterWindowMask | LeaveWindowMask |
	       ButtonPressMask | ButtonReleaseMask | ExposureMask);
}

void
DialogDrawButton(Dialog * d, int bnum)
{
  int                 state;

  state = STATE_NORMAL;
  if ((d->button[bnum]->hilited) && (d->button[bnum]->clicked))
    state = STATE_CLICKED;
  else if ((d->button[bnum]->hilited) && (!d->button[bnum]->clicked))
    state = STATE_HILITED;
  else if (!(d->button[bnum]->hilited) && (d->button[bnum]->clicked))
    state = STATE_CLICKED;
  IclassApply(d->button[bnum]->iclass, d->button[bnum]->win,
	      d->button[bnum]->w, d->button[bnum]->h, 0, 0,
	      state, 0);
  TclassApply(d->button[bnum]->iclass, d->button[bnum]->win,
	      d->button[bnum]->w, d->button[bnum]->h,
	      0, 0, state, 1, d->button[bnum]->tclass,
	      d->button[bnum]->text);
}

void
DialogActivateButton(Window win, int inclick)
{
  Dialog             *d;
  int                 bnum;
  char                doact = 0;

  d = FindDialogButton(win, &bnum);
  if (!d)
    return;
  if ((d->button[bnum]->hilited) && (d->button[bnum]->clicked) &&
      (inclick == 3))
    doact = 1;
  if (inclick == 0)
    d->button[bnum]->hilited = 1;
  if (inclick == 1)
    d->button[bnum]->hilited = 0;
  if (inclick == 2)
    d->button[bnum]->clicked = 1;
  if (inclick == 3)
    d->button[bnum]->clicked = 0;
  DialogDrawButton(d, bnum);
  if ((doact) && (d->button[bnum]->func))
    (d->button[bnum]->func) (bnum, d);
  if ((doact) && (d->button[bnum]->close))
    DialogClose(d);
}

void
DialogDraw(Dialog * d)
{
  if ((!d->tclass) || (!d->iclass))
    return;
  TclassApply(d->iclass, d->win, d->w, d->h,
	      0, 0, STATE_NORMAL, 1, d->tclass,
	      d->text);
}

void
DialogRedraw(Dialog * d)
{
  int                 i;

  if ((!d->tclass) || (!d->iclass))
    return;
  for (i = 0; i < d->num_buttons; i++)
    DialogDrawButton(d, i);
  DialogDraw(d);
}

void
ShowDialog(Dialog * d)
{
  char                pq;
  int                 i, w, h, mw, mh;
  EWin               *ewin;
  XTextProperty       xtp;

  SC_Kill();
  if (d->title)
    {
      xtp.encoding = XA_STRING;
      xtp.format = 8;
      xtp.value = (unsigned char *)(d->title);
      xtp.nitems = strlen((char *)(xtp.value));
      XSetWMName(disp, d->win, &xtp);
    }
  ewin = FindEwinByDialog(d);
  if (ewin)
    {
      RaiseEwin(ewin);
      ShowEwin(ewin);
      return;
    }
  w = 0;
  h = 0;

  w = d->w;
  h = d->h;
  mw = 0;
  mh = 0;
  for (i = 0; i < d->num_buttons; i++)
    {
      if (d->button[i]->w > mw)
	mw = d->button[i]->w;
      if (d->button[i]->h > mh)
	mh = d->button[i]->h;
    }
  h += d->iclass->padding.top + d->iclass->padding.bottom + mh;

  if ((d->iclass->padding.left + d->iclass->padding.right +
       (d->num_buttons * (mw + d->iclass->padding.left +
			  d->iclass->padding.right)))
      > w)
    w = d->iclass->padding.left + d->iclass->padding.right +
      (d->num_buttons * (mw + d->iclass->padding.left +
			 d->iclass->padding.right));

  for (i = 0; i < d->num_buttons; i++)
    {
      d->button[i]->x =
	(((w - (d->iclass->padding.left + d->iclass->padding.right)) -
	  (d->num_buttons * (mw + d->iclass->padding.left +
			     d->iclass->padding.right))) / 2) +
	d->iclass->padding.left +
	(i * (mw + d->iclass->padding.left + d->iclass->padding.right)) +
	d->iclass->padding.left;
      d->button[i]->y = d->h - d->iclass->padding.bottom +
	d->iclass->padding.top;

      d->button[i]->w = mw;
      d->button[i]->h = mh;
      XMoveResizeWindow(disp, d->button[i]->win,
			d->button[i]->x, d->button[i]->y,
			d->button[i]->w, d->button[i]->h);
    }
  d->w = w;
  d->h = d->h - d->iclass->padding.bottom;
  XResizeWindow(disp, d->win, w, h);
  pq = queue_up;
  queue_up = 0;
  IclassApply(d->iclass, d->win, w, h, 0, 0, STATE_NORMAL, 0);

  for (i = 0; i < d->num_buttons; i++)
    IclassApply(d->button[i]->iclass, d->button[i]->win,
		d->button[i]->w, d->button[i]->h, 0, 0,
		STATE_NORMAL, 0);
  queue_up = pq;

  ewin = AddInternalToFamily(d->win, 1, "DEFAULT");
  XSelectInput(disp, d->win, ExposureMask | PointerMotionMask |
	       EnterWindowMask | LeaveWindowMask |
	       FocusChangeMask);
  if (ewin)
    {
      DesktopRemoveEwin(ewin);
      ewin->layer = 4;
      DesktopAddEwinToTop(ewin);
      MoveEwin(ewin, (root.w - ewin->w) / 2, (root.h - ewin->h) / 2);
      RestackEwin(ewin);
      ShowEwin(ewin);
      ewin->dialog = d;
    }
  if (!FindDialog(d->win))
    AddItem(d, d->name, d->win, LIST_TYPE_DIALOG);
  XSync(disp, False);
  DialogRedraw(d);
}

void
DialogClose(Dialog * d)
{
  EWin               *ewin;
  XEvent              ev;

  if (!d)
    return;
  ewin = FindEwinByDialog(d);
  if (ewin)
    {
      HideEwin(ewin);
      ev.xunmap.window = d->win;
      HandleUnmap(&ev);
    }
  RemoveItem(NULL, d->win, LIST_FINDBY_ID, LIST_TYPE_DIALOG);
  XDestroyWindow(disp, d->win);
  FreeDialog(d);
}
