#include "E.h"

Clone              *
CloneEwin(EWin * ewin)
{
  Clone              *c;
  Pixmap              pmap;
  GC                  gc;
  XGCValues           gcv;

  c = Emalloc(sizeof(Clone));
  c->name = NULL;
  c->win = ECreateWindow(ewin->parent, ewin->x, ewin->y, ewin->w, ewin->h, 1);
  pmap = XCreatePixmap(disp, c->win, ewin->w, ewin->h, root.depth);
  XSetWindowBackgroundPixmap(disp, c->win, pmap);
  gcv.subwindow_mode = IncludeInferiors;
  gc = XCreateGC(disp, c->win, GCSubwindowMode, &gcv);
  XCopyArea(disp, ewin->win, pmap, gc, 0, 0, ewin->w, ewin->h, 0, 0);
  XFreeGC(disp, gc);
  XFreePixmap(disp, pmap);
  XShapeCombineShape(disp, c->win, ShapeBounding, 0, 0, ewin->win,
		     ShapeBounding, ShapeSet);
  XMapWindow(disp, c->win);
  return c;
}

void
FreeClone(Clone * c)
{
  XDestroyWindow(disp, c->win);
  Efree(c);
}

void
RemoveClones(void)
{
  Clone              *c;

  while ((c = RemoveItem("CLONE", 0, LIST_FINDBY_NAME, LIST_TYPE_CLONE)))
    FreeClone(c);
}

void
CloneDesktop(int d)
{
  int                 i;

  for (i = 0; i < desks.desk[d].num; i++)
    {
      EWin               *ewin;

      ewin = desks.desk[d].list[i];
      if ((ewin) && (ewin->sticky))
	{
	  Clone              *c;

	  c = CloneEwin(ewin);
	  AddItem(c, "CLONE", c->win, LIST_TYPE_CLONE);
	}
    }
}
