/*
 * seejpeg.h
 *
 * Copyright (C) 1993-1996 Evan Harris
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

/* 	$Id: seejpeg.h,v 1.4 1996/09/28 22:13:03 evan Exp $	 */

#include <stdlib.h>
#include <stdio.h>
#include <jpeglib.h>

/* display.c */
void chiptype_init();
void gamma_table_init(double gamma);
void display_init(int image_width, int image_height, int components);
void display_set_palette(int num_colors, JSAMPARRAY colormap, int components);
void display_set_greyscale_palette(void);
void display_rows(int num_rows, JSAMPARRAY pixel_data, int image_width,
		  int components);
void scroll_until_end(void);
void display_shutdown(void);

/* image.c */
int read_image_file (char *filename);

/* jpeg.c */
int read_JPEG_file (char *filename);
void error_exit (const char *msgtext);
void trace_message (const char *msgtext);

/* cmap.c */
void translate_init(void);
void translate_row(int width, JSAMPARRAY rgb_row, JSAMPARRAY cmap_row);

/* variables */
extern int opt_greyscale, opt_onepass, opt_quantize, opt_verbose;
extern int opt_forcemode, opt_widthonly, opt_doublex, opt_doubley;
extern int opt_slideshow, opt_cycle, opt_centre;
extern double opt_fuzz, opt_gamma;

extern int go_backwards;

#define GAMMA_TABLE_SIZE 256
unsigned int gamma_table[GAMMA_TABLE_SIZE];

/*
 * The video mode we test for to see if hicolor or truecolor modes are
 * available.
 *
 * If this mode is not available we assume that only colour mapped
 * (256 colour) modes are available and we automatically set two pass
 * quantization for the user.  Unfortunately, two pass quantization in
 * JPEG is a memory pig.
 */

#ifndef TESTMODE
#define TESTMODE G640x480x32K
#endif
