.\" Copyright (c) 1980, 1990, 1993
.\"	The Regents of the University of California.  All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" Style notes for the tcsh manpage:
.\" 
.\" - Tags in lists are bold, except in the FILES section where they are
.\"   italic.
.\" 
.\" - References are bold for section headings and environment and shell
.\"   variables and italic for commands (externals, builtins, aliases, and
.\"   editor commands) and arguments to commands.
.\" 
.\" - Be careful with the .B and .I macros: they only handle a limited number
.\"   of words. Work around this with \fB and \fI, but only if absolutely
.\"   necessary, since tcsh.man2html uses .B/.I to find name anchors.
.\" 
.\" - Indent in multiples of 4, usually 8.
.\" 
.\" - Use `', not '' or "", except of course in shell syntax examples.
.\"   '' at the beginning of a line will vanish!
.\" 
.\" - Use \-, not -.
.\" 
.\" - Include the tilde when naming dotfiles. `~/.login', not `.login'.
.\" 
.\" - Refer to external commands in manpage format, e.g. `csh(1)'. However,
.\"   tcsh is `tcsh', not `tcsh(1)', because this is the tcsh manpage (and
.\"   see the next note anyway).
.\" 
.\" - Say `the shell', not `tcsh', unless distinguishing between tcsh and csh.
.\" 
.\" - Say `shell variable'/`environment variable' instead of `variable'
.\"   and `builtin command'/`editor command' instead of `builtin' or `command'
.\"   unless the distinction is absolutely clear from context.
.\" 
.\" - Use the simple present tense. `The shell uses', not `The shell will use'.
.\" 
.\" - IMPORTANT: Cross-reference as much as possible. Commands, variables,
.\"   etc. in the reference section should be mentioned in the appropriate
.\"   descriptive section, or at least in the reference-section description
.\"   of another command (or whatever) which is mentioned in a description
.\"   section. Remember to note OS-specific things in "OS variant support",
.\"   new features in NEW FEATURES and referenced external commands in SEE
.\"   ALSO.
.\" 
.\" - tcsh.man2html depends heavily on the specific nroff commands used in the
.\"   manpage when the script was written. Please stick closely to the style
.\"   used here if you can. In particular, please don't use nroff commands
.\"   which aren't already used herein.
.\" 
.TH TCSH 1 "2 October 1998" "Astron 6.08.00"
.SH NAME
tcsh \- C shell with file name completion and command line editing
.SH SYNOPSIS
.B tcsh \fR[\fB\-bcdefFimnqstvVxX\fR] [\fB\-Dname\fR[\fB=value\fR]] [arg ...]
.br
.B tcsh \-l
.SH DESCRIPTION
\fItcsh\fR is an enhanced but completely compatible version of the Berkeley
UNIX C shell, \fIcsh\fR(1).
It is a command language interpreter usable both as an interactive login
shell and a shell script command processor.
It includes a command-line editor (see \fBThe command-line editor\fR),
programmable word completion (see \fBCompletion and listing\fR),
spelling correction (see \fBSpelling correction\fR),
a history mechanism (see \fBHistory substitution\fR),
job control (see \fBJobs\fR)
and a C-like syntax.
The \fBNEW FEATURES\fR section describes major enhancements of \fItcsh\fR
over \fIcsh\fR(1). 
Throughout this manual, features of
\fItcsh\fR not found in most \fIcsh\fR(1) implementations
(specifically, the 4.4BSD \fIcsh\fR)
are labeled with `(+)', and features which are present in \fIcsh\fR(1)
but not usually documented are labeled with `(u)'.
.SS "Argument list processing"
If the first argument (argument 0) to the shell is `\-' then it is a
login shell.  A login shell can be also specified by invoking the shell with
the \fB\-l\fR flag as the only argument.
.PP
The rest of the flag arguments are interpreted as follows:
.TP 4
.B \-b
Forces a ``break'' from option processing, causing any
further shell arguments to be treated as non-option arguments.  The remaining
arguments will not be interpreted as shell options.  This may be used to pass
options to a shell script without confusion or possible subterfuge.  The shell
will not run a set-user ID script without this option.
.TP 4
.B \-c
Commands are read from the following argument (which must be present, and
must be a single argument),
stored in the \fBcommand\fR shell variable for reference, and executed.
Any remaining arguments are placed in the \fBargv\fR shell variable.
.TP 4
.B \-d
The shell loads the directory stack from \fI~/.cshdirs\fR as described under
\fBStartup and shutdown\fR, whether or not it is a login shell. (+)
.TP 4
.B \-D\fIname\fR[=\fIvalue\fR]
Sets the environment variable \fIname\fR to \fIvalue\fR. (Domain/OS only) (+)
.TP 4
.B \-e
The shell exits if any invoked command terminates abnormally or
yields a non-zero exit status.
.TP 4
.B \-f
The shell ignores \fI~/.tcshrc\fR, and thus starts faster.
.TP 4
.B \-F
The shell uses \fIfork\fR(2) instead of \fIvfork\fR(2) to spawn processes. (Convex/OS only) (+)
.TP 4
.B \-i
The shell is interactive and prompts for its top-level input, even if
it appears to not be a terminal.  Shells are interactive without this option if
their inputs and outputs are terminals.
.TP 4
.B \-l
The shell is a login shell. Only applicable if \fB\-l\fR is the only
flag specified.
.TP 4
.B \-m
The shell loads \fI~/.tcshrc\fR even if it does not belong to the effective
user. Newer versions of \fIsu\fR(1) can pass \fB\-m\fR to the shell. (+)
.TP 4
.B \-n
The shell parses commands but does not execute them.
This aids in debugging shell scripts.
.TP 4
.B \-q 
The shell accepts SIGQUIT (see \fBSignal handling\fR) and behaves when
it is used under a debugger. Job control is disabled. (u)
.TP 4
.B \-s
Command input is taken from the standard input.
.TP 4
.B \-t
The shell reads and executes a single line of input.  A `\\' may be used to
escape the newline at the end of this line and continue onto another line.
.TP 4
.B \-v
Sets the \fBverbose\fR shell variable, so that
command input is echoed after history substitution.
.TP 4
.B \-x
Sets the \fBecho\fR shell variable, so that commands are echoed
immediately before execution.
.TP 4
.B \-V
Sets the \fBverbose\fR shell variable even before executing \fI~/.tcshrc\fR.
.TP 4
.B \-X
Is to \fB\-x\fR as \fB\-V\fR is to \fB\-v\fR.
.PP
After processing of flag arguments, if arguments remain but none of the
\fB\-c\fR, \fB\-i\fR, \fB\-s\fR, or \fB\-t\fR options were given, the first
argument is taken as the name of a file of commands, or ``script'', to
be executed.  The shell opens this file and saves its name for possible
resubstitution by `$0'.  Since many systems use either the standard
version 6 or version 7 shells whose shell scripts are not compatible
with this shell, the shell uses such a `standard' shell to execute a script
whose first character is not a `#', i.e. which does not start with a
comment.
.PP
Remaining arguments are placed in the \fBargv\fR shell variable.
.SS "Startup and shutdown"
A login shell begins by executing commands from the system files
\fI/etc/csh.cshrc\fR and \fI/etc/csh.login\fR.
It then executes commands from files in the user's \fBhome\fR directory:
first \fI~/.tcshrc\fR (+)
or, if \fI~/.tcshrc\fR is not found, \fI~/.cshrc\fR,
then \fI~/.history\fR (or the value of the \fBhistfile\fR shell variable),
then \fI~/.login\fR,
and finally \fI~/.cshdirs\fR (or the value of the \fBdirsfile\fR shell variable) (+).
The shell may read \fI/etc/csh.login\fR before instead of after
\fI/etc/csh.cshrc\fR, and \fI~/.login\fR before instead of after
\fI~/.tcshrc\fR or \fI~/.cshrc\fR and \fI~/.history\fR, if so compiled;
see the \fBversion\fR shell variable. (+)
.PP
Non-login shells read only \fI/etc/csh.cshrc\fR and \fI~/.tcshrc\fR
or \fI~/.cshrc\fR on startup.
.PP
Commands like \fIstty\fR(1) and \fItset\fR(1),
which need be run only once per login, usually go in one's \fI~/.login\fR file.
Users who need to use the same set of files with both \fIcsh\fR(1) and
\fItcsh\fR can have only a \fI~/.cshrc\fR which checks for the existence of the
\fBtcsh\fR shell variable (q.v.) before using \fItcsh\fR-specific commands,
or can have both a \fI~/.cshrc\fR and a \fI~/.tcshrc\fR which \fIsource\fRs
(see the builtin command) \fI~/.cshrc\fR.
The rest of this manual uses `\fI~/.tcshrc\fR' to mean `\fI~/.tcshrc\fR or,
if \fI~/.tcshrc\fR is not found, \fI~/.cshrc\fR'.
.PP
In the normal case, the shell begins reading commands from the terminal,
prompting with `> '.  (Processing of arguments and the use of the shell to
process files containing command scripts are described later.)
The shell repeatedly reads a line of command input, breaks it into words,
places it on the command history list, parses it and executes each command
in the line.
.PP
One can log out by typing `^D' on an empty line, `logout' or `login' or
via the shell's autologout mechanism (see the \fBautologout\fR shell variable).
When a login shell terminates it sets the \fBlogout\fR shell variable to
`normal' or `automatic' as appropriate, then
executes commands from the files
\fI/etc/csh.logout\fR and \fI~/.logout\fR. The shell may drop DTR on logout
if so compiled; see the \fBversion\fR shell variable.
.PP
The names of the system login and logout files vary from system to system for
compatibility with different \fIcsh\fR(1) variants; see \fBFILES\fR.
.SS Editing
We first describe \fBThe command-line editor\fR.
The \fBCompletion and listing\fR and \fBSpelling correction\fR sections
describe two sets of functionality which are implemented as editor commands
but which deserve their own treatment.
Finally, \fBEditor commands\fR lists and describes
the editor commands specific to the shell and their default bindings.
.SS "The command-line editor (+)"
Command-line input can be edited using key sequences much like those used in
GNU Emacs or \fIvi\fR(1).
The editor is active only when the \fBedit\fR shell variable is set, which
it is by default in interactive shells.
The \fIbindkey\fR builtin can display and change key bindings.
Emacs-style key bindings are used by default
(unless the shell was compiled otherwise; see the \fBversion\fR shell variable),
but \fIbindkey\fR can change the key bindings to \fIvi\fR-style bindings en masse.
.PP
The shell always binds the arrow keys (as defined in the \fBTERMCAP\fR
environment variable) to
.PP
.PD 0
.RS +4
.TP 8
down
\fIdown-history\fR
.TP 8
up
\fIup-history\fR
.TP 8
left
\fIbackward-char\fR
.TP 8
right
\fIforward-char\fR
.PD
.RE
.PP
unless doing so would alter another single-character binding.
One can set the arrow key escape sequences to the empty string with \fIsettc\fR
to prevent these bindings.
The ANSI/VT100 sequences for arrow keys are always bound.
.PP
Other key bindings are, for the most part, what Emacs and \fIvi\fR(1)
users would expect and can easily be displayed by \fIbindkey\fR, so there
is no need to list them here. Likewise, \fIbindkey\fR can list the editor
commands with a short description of each.
.PP
Note that editor commands do not have the same notion of a ``word'' as does the
shell. The editor delimits words with any non-alphanumeric characters not in
the shell variable \fBwordchars\fR, while the shell recognizes only whitespace
and some of the characters with special meanings to it, listed under
\fBLexical structure\fR.
.SS "Completion and listing (+)"
The shell is often able to complete words when given a unique abbreviation.
Type part of a word (for example `ls /usr/lost') and hit the tab key to
run the \fIcomplete-word\fR editor command.
The shell completes the filename `/usr/lost' to `/usr/lost+found/',
replacing the incomplete word with the complete word in the input buffer.
(Note the terminal `/'; completion adds a `/' to the
end of completed directories and a space to the end of other completed words,
to speed typing and provide a visual indicator of successful completion.
The \fBaddsuffix\fR shell variable can be unset to prevent this.)
If no match is found (perhaps `/usr/lost+found' doesn't exist),
the terminal bell rings.
If the word is already complete (perhaps there is a `/usr/lost' on your
system, or perhaps you were thinking too far ahead and typed the whole thing)
a `/' or space is added to the end if it isn't already there.
.PP
Completion works anywhere in the line, not just at the end; completed
text pushes the rest of the line to the right. Completion in the middle of a word
often results in leftover characters to the right of the cursor which need
to be deleted.
.PP
Commands and variables can be completed in much the same way.
For example, typing `em[tab]' would complete `em' to
`emacs' if \fIemacs\fR were the only command on your system beginning with `em'.
Completion can find a command in any directory in \fBpath\fR or if
given a full pathname.
Typing `echo $ar[tab]' would complete `$ar' to `$argv'
if no other variable began with `ar'.
.PP
The shell parses the input buffer to determine whether the word you want to
complete should be completed as a filename, command or variable.
The first word in the buffer and the first word following
`;', `|', `|&', `&&' or `||' is considered to be a command.
A word beginning with `$' is considered to be a variable.
Anything else is a filename. An empty line is `completed' as a filename.
.PP
You can list the possible completions of a word at any time by typing `^D'
to run the \fIdelete-char-or-list-or-eof\fR editor command.
The shell lists the possible completions using the \fIls\-F\fR builtin (q.v.)
and reprints the prompt and unfinished command line, for example:
.IP "" 4
> ls /usr/l[^D]
.br
lbin/       lib/        local/      lost+found/
.br
> ls /usr/l
.PP
If the \fBautolist\fR shell variable is set, the shell lists the remaining
choices (if any) whenever completion fails:
.IP "" 4
> set autolist
.br
> nm /usr/lib/libt[tab]
.br
libtermcap.a@ libtermlib.a@
.br
> nm /usr/lib/libterm
.PP
If \fBautolist\fR is set to `ambiguous', choices are listed only when
completion fails and adds no new characters to the word being completed.
.PP
A filename to be completed can contain variables, your own or others' home
directories abbreviated with `~' (see \fBFilename substitution\fR) and
directory stack entries abbreviated with `='
(see \fBDirectory stack substitution\fR). For example,
.IP "" 4
> ls ~k[^D]
.br
kahn    kas     kellogg
.br
> ls ~ke[tab]
.br
> ls ~kellogg/
.PP
or
.IP "" 4
> set local = /usr/local
.br
> ls $lo[tab]
.br
> ls $local/[^D]
.br
bin/ etc/ lib/ man/ src/ 
.br
> ls $local/
.PP
Note that variables can also be expanded explicitly with the
\fIexpand-variables\fR editor command.
.PP
\fIdelete-char-or-list-or-eof\fR only lists at the end of the line;
in the middle of a line it deletes the character under the cursor and
on an empty line it logs one out or, if \fBignoreeof\fR is set, does nothing.
`M-^D', bound to the editor command \fIlist-choices\fR, lists completion
possibilities anywhere on a line, and \fIlist-choices\fR (or any one of the
related editor commands which do or don't delete, list and/or log out,
listed under \fIdelete-char-or-list-or-eof\fR) can be bound to `^D' with
the \fIbindkey\fR builtin command if so desired.
.PP
The \fIcomplete-word-fwd\fR and \fIcomplete-word-back\fR editor commands
(not bound to any keys by default) can be used to cycle up and down through
the list of possible completions, replacing the current word with the next or
previous word in the list.
.PP
The shell variable \fBfignore\fR can be set to a list of suffixes to be
ignored by completion. Consider the following:
.IP "" 4
> ls
.br
Makefile        condiments.h~   main.o          side.c
.br
README          main.c          meal            side.o
.br
condiments.h    main.c~
.br
> set fignore = (.o \\~)
.br
> emacs ma[^D]
.br
main.c   main.c~  main.o
.br
> emacs ma[tab]
.br
> emacs main.c
.PP
`main.c~' and `main.o' are ignored by completion (but not listing),
because they end in suffixes in \fBfignore\fR.
Note that a `\\' was needed in front of `~' to prevent it from being
expanded to \fBhome\fR as described under \fBFilename substitution\fR.
\fBfignore\fR is ignored if only one completion is possible.
.PP
If the \fBcomplete\fR shell variable is set to `enhance', completion
1) ignores case and 2) considers periods, hyphens and underscores
(`.', `\-' and `_') to be word separators and hyphens and underscores to
be equivalent. If you had the following files
.IP "" 4
comp.lang.c      comp.lang.perl   comp.std.c++
.br
comp.lang.c++    comp.std.c
.PP
and typed `mail \-f c.l.c[tab]', it would be completed to
`mail \-f comp.lang.c', and ^D would list `comp.lang.c' and `comp.lang.c++'.
`mail \-f c..c++[^D]' would list `comp.lang.c++' and `comp.std.c++'. Typing
`rm a\-\-file[^D]' in the following directory
.IP "" 4
A_silly_file    a-hyphenated-file    another_silly_file
.PP
would list all three files, because case is ignored and hyphens and
underscores are equivalent. Periods, however, are not equivalent to
hyphens or underscores.
.PP
Completion and listing are affected by several other shell variables:
\fBrecexact\fR can be set to complete on the shortest possible unique
match, even if more typing might result in a longer match:
.IP "" 4
> ls
.br
fodder   foo      food     foonly
.br
> set recexact
.br
> rm fo[tab]
.PP
just beeps, because `fo' could expand to `fod' or `foo', but if we type
another `o',
.IP "" 4
> rm foo[tab]
.br
> rm foo
.PP
the completion completes on `foo', even though `food' and `foonly'
also match.
\fBautoexpand\fR can be set to run the \fIexpand-history\fR editor command
before each completion attempt, \fBautocorrect\fR can be set to
spelling-correct the word to be completed (see \fBSpelling correction\fR)
before each completion attempt and \fBcorrect\fR can be set to complete
commands automatically after one hits `return'.
\fBmatchbeep\fR can be set to make completion beep or not beep in a variety
of situations, and \fBnobeep\fR can be set to never beep at all.
\fBnostat\fR can be set to a list of directories and/or patterns which
match directories to prevent the completion mechanism from \fIstat\fR(2)ing
those directories.
\fBlistmax\fR and \fBlistmaxrows\fR can be set to limit the number of items
and rows (respectively) that are listed without asking first.
\fBrecognize_only_executables\fR can be set to make the shell list only
executables when listing commands, but it is quite slow.
.PP
Finally, the \fIcomplete\fR builtin command can be used to tell the shell how
to complete words other than filenames, commands and variables.
Completion and listing do not work on glob-patterns (see \fBFilename substitution\fR),
but the \fIlist-glob\fR and \fIexpand-glob\fR editor commands perform
equivalent functions for glob-patterns.
.SS "Spelling correction (+)"
The shell can sometimes correct the spelling of filenames, commands and variable names
as well as completing and listing them.
.PP
Individual words can be spelling-corrected with the \fIspell-word\fR
editor command (usually bound to M-s and M-S)
and the entire input buffer with \fIspell-line\fR (usually bound to M-$).
The \fBcorrect\fR shell variable can be set to `cmd' to correct the
command name or `all' to correct the entire line each time return is typed,
and \fBautocorrect\fR can be set to correct the word to be completed
before each completion attempt.
.PP
When spelling correction is invoked in any of these ways and
the shell thinks that any part of the command line is misspelled,
it prompts with the corrected line:
.IP "" 4
> set correct = cmd
.br
> lz /usr/bin
.br
CORRECT>ls /usr/bin (y|n|e|a)?
.PP
One can answer `y' or space to execute the corrected line,
`e' to leave the uncorrected command in the input buffer,
`a' to abort the command as if `^C' had been hit, and
anything else to execute the original line unchanged.
.PP
Spelling correction recognizes user-defined completions (see the
\fIcomplete\fR builtin command). If an input word in a position for
which a completion is defined resembles a word in the completion list,
spelling correction registers a misspelling and suggests the latter
word as a correction. However, if the input word does not match any of
the possible completions for that position, spelling correction does
not register a misspelling.
.PP
Like completion, spelling correction works anywhere in the line,
pushing the rest of the line to the right and possibly leaving
extra characters to the right of the cursor.
.PP
Beware: spelling correction is not guaranteed to work the way one intends,
and is provided mostly as an experimental feature. 
Suggestions and improvements are welcome.
.SS "Editor commands (+)"
`bindkey' lists key bindings and `bindkey \-l' lists and briefly describes
editor commands.
Only new or especially interesting editor commands are described here.
See \fIemacs\fR(1) and \fIvi\fR(1) for descriptions of each editor's
key bindings.
.PP
The character or characters to which each command is bound by default is
given in parentheses. `^\fIcharacter\fR' means a control character and
`M-\fIcharacter\fR' a meta character, typed as escape-\fIcharacter\fR
on terminals without a meta key. Case counts, but commands which are bound
to letters by default are bound to both lower- and uppercase letters for
convenience.
.TP 8
.B complete-word \fR(tab)
Completes a word as described under \fBCompletion and listing\fR.
.TP 8
.B complete-word-back \fR(not bound)
Like \fIcomplete-word-fwd\fR, but steps up from the end of the list.
.TP 8
.B complete-word-fwd \fR(not bound)
Replaces the current word with the first word in the list of possible
completions. May be repeated to step down through the list.
At the end of the list, beeps and reverts to the incomplete word.
.TP 8
.B complete-word-raw \fR(^X-tab)
Like \fIcomplete-word\fR, but ignores user-defined completions.
.TP 8
.B copy-prev-word \fR(M-^_)
Copies the previous word in the current line into the input buffer.
See also \fIinsert-last-word\fR.
.TP 8
.B dabbrev-expand \fR(M-/)
Expands the current word to the most recent preceding one for which
the current is a leading substring, wrapping around the history list
(once) if necessary.
Repeating \fIdabbrev-expand\fR without any intervening typing
changes to the next previous word etc., skipping identical matches
much like \fIhistory-search-backward\fR does.
.TP 8
.B delete-char \fR(not bound)
Deletes the character under the cursor.
See also \fIdelete-char-or-list-or-eof\fR.
.TP 8
.B delete-char-or-eof \fR(not bound)
Does \fIdelete-char\fR if there is a character under the cursor
or \fIend-of-file\fR on an empty line.
See also \fIdelete-char-or-list-or-eof\fR.
.TP 8
.B delete-char-or-list \fR(not bound)
Does \fIdelete-char\fR if there is a character under the cursor
or \fIlist-choices\fR at the end of the line.
See also \fIdelete-char-or-list-or-eof\fR.
.TP 8
.B delete-char-or-list-or-eof \fR(^D)
Does \fIdelete-char\fR if there is a character under the cursor,
\fIlist-choices\fR at the end of the line
or \fIend-of-file\fR on an empty line.
See also those three commands, each of which only does a single action, and 
\fIdelete-char-or-eof\fR, \fIdelete-char-or-list\fR and \fIlist-or-eof\fR,
each of which does a different two out of the three.
.TP 8
.B down-history \fR(down-arrow, ^N)
Like \fIup-history\fR, but steps down, stopping at the original input line.
.TP 8
.B end-of-file \fR(not bound)
Signals an end of file, causing the shell to exit unless the \fBignoreeof\fR
shell variable (q.v.) is set to prevent this.
See also \fIdelete-char-or-list-or-eof\fR.
.TP 8
.B expand-history \fR(M-space)
Expands history substitutions in the current word.
See \fBHistory substitution\fR.
See also \fImagic-space\fR, \fItoggle-literal-history\fR and
the \fBautoexpand\fR shell variable.
.TP 8
.B expand-glob \fR(^X-*)
Expands the glob-pattern to the left of the cursor.
See \fBFilename substitution\fR.
.TP 8
.B expand-line \fR(not bound)
Like \fIexpand-history\fR, but
expands history substitutions in each word in the input buffer,
.TP 8
.B expand-variables \fR(^X-$)
Expands the variable to the left of the cursor.
See \fBVariable substitution\fR.
.TP 8
.B history-search-backward \fR(M-p, M-P)
Searches backwards through the history list for a command beginning with
the current contents of the input buffer up to the cursor and copies it
into the input buffer.
The search string may be a glob-pattern (see \fBFilename substitution\fR)
containing `*', `?', `[]' or `{}'.
\fIup-history\fR and \fIdown-history\fR will proceed from the
appropriate point in the history list.
Emacs mode only.
See also \fIhistory-search-forward\fR and \fIi-search-back\fR.
.TP 8
.B history-search-forward \fR(M-n, M-N)
Like \fIhistory-search-backward\fR, but searches forward.
.TP 8
.B i-search-back \fR(not bound)
Searches backward like \fIhistory-search-backward\fR, copies the first match
into the input buffer with the cursor positioned at the end of the pattern,
and prompts with `bck: ' and the first match. Additional characters may be
typed to extend the search, \fIi-search-back\fR may be typed to continue
searching with the same pattern, wrapping around the history list if
necessary, (\fIi-search-back\fR must be bound to a
single character for this to work) or one of the following special characters
may be typed:
.PP
.RS +8
.RS +4
.PD 0
.TP 8
^W
Appends the rest of the word under the cursor to the search pattern.
.TP 8
delete (or any character bound to \fIbackward-delete-char\fR)
Undoes the effect of the last character typed and deletes a character
from the search pattern if appropriate.
.TP 8
^G
If the previous search was successful, aborts the entire search.
If not, goes back to the last successful search.
.TP 8
escape
Ends the search, leaving the current line in the input buffer.
.RE
.PD
.PP
Any other character not bound to \fIself-insert-command\fR terminates the
search, leaving the current line in the input buffer, and
is then interpreted as normal input. In particular, a carriage return
causes the current line to be executed.
Emacs mode only.
See also \fIi-search-fwd\fR and \fIhistory-search-backward\fR.
.RE
.TP 8
.B i-search-fwd \fR(not bound)
Like \fIi-search-back\fR, but searches forward.
.TP 8
.B insert-last-word \fR(M-_)
Inserts the last word of the previous input line (`!$') into the input buffer.
See also \fIcopy-prev-word\fR.
.TP 8
.B list-choices \fR(M-^D)
Lists completion possibilities as described under \fBCompletion and listing\fR.
See also \fIdelete-char-or-list-or-eof\fR and \fIlist-choices-raw\fR.
.TP 8
.B list-choices-raw \fR(^X-^D)
Like \fIlist-choices\fR, but ignores user-defined completions.
.TP 8
.B list-glob \fR(^X-g, ^X-G)
Lists (via the \fIls\-F\fR builtin) matches to the glob-pattern
(see \fBFilename substitution\fR) to the left of the cursor.
.TP 8
.B list-or-eof \fR(not bound)
Does \fIlist-choices\fR
or \fIend-of-file\fR on an empty line.
See also \fIdelete-char-or-list-or-eof\fR.
.TP 8
.B magic-space \fR(not bound)
Expands history substitutions in the current line,
like \fIexpand-history\fR, and appends a space.
\fImagic-space\fR is designed to be bound to the spacebar,
but is not bound by default.
.TP 8
.B normalize-command \fR(^X-?)
Searches for the current word in PATH and, if it is found, replaces it with
the full path to the executable. Special characters are quoted. Aliases are
expanded and quoted but commands within aliases are not. This command is
useful with commands which take commands as arguments, e.g. `dbx' and `sh \-x'.
.TP 8
.B normalize-path \fR(^X-n, ^X-N)
Expands the current word as described under the `expand' setting
of the \fBsymlinks\fR shell variable.
.TP 8
.B overwrite-mode \fR(unbound)
Toggles between input and overwrite modes.
.TP 8
.B run-fg-editor \fR(M-^Z)
Saves the current input line and
looks for a stopped job with a name equal to the last component of the
file name part of the \fBEDITOR\fR or \fBVISUAL\fR environment variables,
or, if neither is set, `ed' or `vi'.
If such a job is found, it is restarted as if `fg %\fIjob\fR' had been
typed.  This is used to toggle back and forth between an editor and
the shell easily.  Some people bind this command to `^Z' so they
can do this even more easily.
.TP
.B run-help \fR(M-h, M-H)
Searches for documentation on the current command, using the same notion of
`current command' as the completion routines, and prints it. There is no way
to use a pager; \fIrun-help\fR is designed for short help files.
Documentation should be in a file named \fIcommand\fR.help, \fIcommand\fR.1,
\fIcommand\fR.6, \fIcommand\fR.8 or \fIcommand\fR, which should be in one
of the directories listed in the \fBHPATH\fR enviroment variable.
If there is more than one help file only the first is printed.
.TP 8
.B self-insert-command \fR(text characters)
In insert mode (the default), inserts the typed character into the input line after the character under the cursor.
In overwrite mode, replaces the character under the cursor with the typed character.
The input mode is normally preserved between lines, but the
\fBinputmode\fR shell variable can be set to `insert' or `overwrite' to put the
editor in that mode at the beginning of each line.
See also \fIoverwrite-mode\fR.
.TP 8
.B sequence-lead-in \fR(arrow prefix, meta prefix, ^X)
Indicates that the following characters are part of a
multi-key sequence. Binding a command to a multi-key sequence really creates
two bindings: the first character to \fIsequence-lead-in\fR and the
whole sequence to the command. All sequences beginning with a character
bound to \fIsequence-lead-in\fR are effectively bound to \fIundefined-key\fR
unless bound to another command.
.TP 8
.B spell-line \fR(M-$)
Attempts to correct the spelling of each word in the input buffer, like
\fIspell-word\fR, but ignores words whose first character is one of
`\-', `!', `^' or `%', or which contain `\\', `*' or `?', to avoid problems
with switches, substitutions and the like.
See \fBSpelling correction\fR.
.TP 8
.B spell-word \fR(M-s, M-S)
Attempts to correct the spelling of the current word as described
under \fBSpelling correction\fR.
Checks each component of a word which appears to be a pathname.
.TP 8
.B toggle-literal-history \fR(M-r, M-R)
Expands or `unexpands' history substitutions in the input buffer.
See also \fIexpand-history\fR and the \fBautoexpand\fR shell variable.
.TP 8
.B undefined-key \fR(any unbound key)
Beeps.
.TP 8
.B up-history \fR(up-arrow, ^P)
Copies the previous entry in the history list into the input buffer.
If \fBhistlit\fR is set, uses the literal form of the entry.
May be repeated to step up through the history list, stopping at the top.
.TP 8
.B vi-search-back \fR(?)
Prompts with `?' for a search string (which may be a glob-pattern, as with
\fIhistory-search-backward\fR), searches for it and copies it into the
input buffer. The bell rings if no match is found.
Hitting return ends the search and leaves the last match in the input
buffer.
Hitting escape ends the search and executes the match.
\fIvi\fR mode only.
.TP 8
.B vi-search-fwd \fR(/)
Like \fIvi-search-back\fR, but searches forward.
.TP 8
.B which-command \fR(M-?)
Does a \fIwhich\fR (see the description of the builtin command) on the
first word of the input buffer.
.SS "Lexical structure"
The shell splits input lines into words at blanks and tabs.  The special
characters `&', `|', `;', `<', `>', `(', and `)' and the doubled characters
`&&', `||', `<<' and `>>' are always separate words, whether or not they are
surrounded by whitespace.
.PP
When the shell's input is not a terminal, the character `#' is taken to begin a
comment. Each `#' and the rest of the input line on which it appears is
discarded before further parsing.
.PP
A special character (including a blank or tab) may be prevented from having
its special meaning, and possibly made part of another word, by preceding it
with a backslash (`\\') or enclosing it in single (`''), double (`"') or
backward (``') quotes. When not otherwise quoted a newline preceded by a `\\'
is equivalent to a blank, but inside quotes this sequence results in a
newline.
.PP
Furthermore, all \fBSubstitutions\fR (see below) except \fBHistory substitution\fR
can be prevented by enclosing the strings (or parts of strings)
in which they appear with single quotes or by quoting the crucial character(s)
(e.g. `$' or ``' for \fBVariable substitution\fR or \fBCommand substitution\fR respectively)
with `\\'. (\fBAlias substitution\fR is no exception: quoting in any way any
character of a word for which an \fIalias\fR has been defined prevents
substitution of the alias. The usual way of quoting an alias is to precede it
with a backslash.) \fBHistory substitution\fR is prevented by
backslashes but not by single quotes.  Strings quoted with double or backward
quotes undergo \fBVariable substitution\fR and \fBCommand substitution\fR, but other
substitutions are prevented.
.PP
Text inside single or double quotes becomes a single word (or part of one).
Metacharacters in these strings, including blanks and tabs, do not form
separate words.  Only in one special case (see \fBCommand substitution\fR
below) can a double-quoted string yield parts of more than one word;
single-quoted strings never do. Backward quotes are special: they signal
\fBCommand substitution\fR (q.v.), which may result in more than one word.
.PP
Quoting complex strings, particularly strings which themselves contain quoting
characters, can be confusing. Remember that quotes need not be used as they are
in human writing! It may be easier to quote not an entire string, but only
those parts of the string which need quoting, using different types of quoting
to do so if appropriate.
.PP
The \fBbackslash_quote\fR shell variable (q.v.) can be set to make backslashes
always quote `\\', `'', and `"'. (+) This may make complex quoting tasks
easier, but it can cause syntax errors in \fIcsh\fR(1) scripts.
.SS Substitutions
We now describe the various transformations the shell performs on the input in
the order in which they occur. We note in passing the data structures involved
and the commands and variables which affect them. Remember that substitutions
can be prevented by quoting as described under \fBLexical structure\fR.
.SS "History substitution"
Each command, or ``event'', input from the terminal is saved in the history
list.  The previous command is always saved, and the \fBhistory\fR shell
variable can be set to a number to save that many commands. The \fBhistdup\fR
shell variable can be set to not save duplicate events or consecutive duplicate
events.
.PP
Saved commands are numbered sequentially from 1 and stamped with the time.
It is not usually necessary to use event numbers, but the current event number
can be made part of the prompt by placing an `!' in the \fBprompt\fR shell variable.
.PP
The shell actually saves history in expanded and literal (unexpanded) forms.
If the \fBhistlit\fR shell variable is set, commands that display and store
history use the literal form.
.PP
The \fIhistory\fR builtin command can print, store in a file, restore
and clear the history list at any time,
and the \fBsavehist\fR and \fBhistfile\fR shell variables can be can be set to
store the history list automatically on logout and restore it on login.
.PP
History substitutions introduce words from the history list into the input
stream, making it easy to repeat commands, repeat arguments of a previous
command in the current command, or fix spelling mistakes in the previous
command with little typing and a high degree of confidence.
.PP
History substitutions begin with the character `!'. They may begin anywhere in
the input stream, but they do not nest.  The `!' may be preceded by a `\\' to
prevent its special meaning; for convenience, a `!' is passed unchanged when it
is followed by a blank, tab, newline, `=' or `('.  History substitutions also
occur when an input line begins with `^'.  This special abbreviation will be
described later. The characters used to signal history substitution (`!' and
`^') can be changed by setting the \fBhistchars\fR shell variable. Any input
line which contains a history substitution is printed before it is executed.
.PP
A history substitution may have an ``event specification'', which indicates
the event from which words are to be taken, a ``word designator'',
which selects particular words from the chosen event, and/or a ``modifier'',
which manipulates the selected words.
.PP
An event specification can be
.PP
.PD 0
.RS +4
.TP 8
.I n
A number, referring to a particular event
.TP 8
\-\fIn\fR
An offset, referring to the event \fIn\fR before the current event
.TP 8
#
The current event.
This should be used carefully in \fIcsh\fR(1), where there is no check for
recursion. \fItcsh\fR allows 10 levels of recursion. (+)
.TP 8
!
The previous event (equivalent to `\-1')
.TP 8
.I s
The most recent event whose first word begins with the string \fIs\fR
.TP 8
?\fIs\fR?
The most recent event which contains the string \fIs\fR.
The second `?' can be omitted if it is immediately followed by a newline.
.RE
.PD
.PP
For example, consider this bit of someone's history list:
.IP "" 4
\ 9  8:30    nroff \-man wumpus.man
.br
10  8:31    cp wumpus.man wumpus.man.old
.br
11  8:36    vi wumpus.man
.br
12  8:37    diff wumpus.man.old wumpus.man
.PP
The commands are shown with their event numbers and time stamps.
The current event, which we haven't typed in yet, is event 13.
`!11' and `!\-2' refer to event 11.
`!!' refers to the previous event, 12. `!!' can be abbreviated `!' if it is
followed by `:' (`:' is described below).
`!n' refers to event 9, which begins with `n'.
`!?old?' also refers to event 12, which contains `old'.
Without word designators or modifiers history references simply expand to the
entire event, so we might type `!cp' to redo the copy command or `!!|more'
if the `diff' output scrolled off the top of the screen.
.PP
History references may be insulated from the surrounding text with braces if
necessary.  For example, `!vdoc' would look for a command beginning with
`vdoc', and, in this example, not find one, but `!{v}doc' would expand
unambiguously to `vi wumpus.mandoc'.
Even in braces, history substitutions do not nest.
.PP
(+) While \fIcsh\fR(1) expands, for example, `!3d' to event 3 with the
letter `d' appended to it, \fItcsh\fR expands it to the last event beginning
with `3d'; only completely numeric arguments are treated as event numbers.
This makes it possible to recall events beginning with numbers.
To expand `!3d' as in \fIcsh\fR(1) say `!\\3d'.
.PP
To select words from an event we can follow the event specification by a `:'
and a designator for the desired words.  The words of an input line are
numbered from 0, the first (usually command) word being 0, the second word
(first argument) being 1, etc. The basic word designators are:
.PP
.PD 0
.RS +4
.TP 8
0
The first (command) word
.TP 8
.I n
The \fIn\fRth argument
.TP 8
^
The first argument, equivalent to `1'
.TP 8
$
The last argument
.TP 8
%
The word matched by an ?\fIs\fR? search
.TP 8
.I x\-y
A range of words
.TP 8
.I \-y
Equivalent to \fI`0\-y'\fR
.TP 8
*
Equivalent to `^\-$', but returns nothing if the event contains only 1 word
.TP 8
.I x*
Equivalent to \fI`x\-$'\fR
.TP 8
.I x\-
Equivalent to \fI`x*'\fR, but omitting the last word (`$')
.PD
.RE
.PP
Selected words are inserted into the command line separated by single blanks.
For example, the `diff' command in the previous example might have been
typed as `diff !!:1.old !!:1' (using `:1' to select the first argument
from the previous event) or `diff !\-2:2 !\-2:1' to select and swap the
arguments from the `cp' command. If we didn't care about the order of the
`diff' we might have said `diff !\-2:1\-2' or simply `diff !\-2:*'.
The `cp' command might have been written `cp wumpus.man !#:1.old', using `#'
to refer to the current event.
`!n:\- hurkle.man' would reuse the first two words from the `nroff' command
to say `nroff \-man hurkle.man'.
.PP
The `:' separating the event specification from the word designator can be
omitted if the argument selector begins with a `^', `$', `*', `%' or `\-'.
For example, our `diff' command might have been `diff !!^.old !!^' or,
equivalently, `diff !!$.old !!$'. However, if `!!' is abbreviated `!',
an argument selector beginning with `\-' will be interpreted as an event
specification.
.PP
A history reference may have a word designator but no event specification.
It then references the previous command.
.ig \" Not true, but we thought it was for a long time ...
, unless a previous history reference
occurred on the same line in which case this form repeats the previous
reference.  Thus `!?foo?^ !$' gives the first and last arguments from the
command matching `?foo?'.
..
Continuing our `diff' example, we could have said simply `diff
!^.old !^' or, to get the arguments in the opposite order, just `diff !*'.
.PP
The word or words in a history reference can be edited, or ``modified'',
by following it with one or more modifiers, each preceded by a `:':
.PP
.PD 0
.RS +4
.TP 8
h
Remove a trailing pathname component, leaving the head.
.TP 8
t
Remove all leading pathname components, leaving the tail.
.TP 8
r
Remove a filename extension `.xxx', leaving the root name.
.TP 8
e
Remove all but the extension.
.TP 8
u
Uppercase the first lowercase letter.
.TP 8
l
Lowercase the first uppercase letter.
.TP 8
s\fI/l/r/\fR
Substitute \fIl\fR for \fIr\fR.
\fIl\fR is simply a string like \fIr\fR, not a regular expression as in
the eponymous \fIed\fR(1) command.
Any character may be used as the delimiter in place of `/';
a `\\' can be used to quote the delimiter inside \fIl\fR and \fIr\fR.
The character `&' in the \fIr\fR is replaced by \fIl\fR; `\\' also quotes `&'.
If \fIl\fR is empty (``''), the \fIl\fR from a previous substitution or the
\fIs\fR from a previous `?\fIs\fR?' event specification is used.
The trailing delimiter may be omitted if it is immediately followed by a newline.
.TP 8
&
Repeat the previous substitution.
.TP 8
g
Apply the following modifier once to each word.
.TP 8
a (+)
Apply the following modifier as many times as possible to a single word.
`a' and `g' can be used together to apply a modifier globally.
In the current implementation, using the `a' and `s' modifiers together can
lead to an infinite loop. For example, `:as/f/ff/' will never terminate.
This behavior might change in the future.
.TP 8
p
Print the new command line but do not execute it.
.TP 8
q
Quote the substituted words, preventing further substitutions.
.TP 8
x
Like q, but break into words at blanks, tabs and newlines.
.PD
.RE
.PP
Modifiers are applied only to the first modifiable word (unless `g' is used).
It is an error for no word to be modifiable.
.PP
For example, the `diff' command might have been written as `diff wumpus.man.old
!#^:r', using `:r' to remove `.old' from the first argument on the same line
(`!#^'). We could say `echo hello out there', then `echo !*:u' to capitalize
`hello', `echo !*:au' to say it out loud, or `echo !*:agu' to really shout.
We might follow `mail \-s "I forgot my password" rot' with `!:s/rot/root' to
correct the spelling of `root' (but see \fBSpelling correction\fR for a
different approach).
.PP
There is a special abbreviation for substitutions.
`^', when it is the first character on an input line, is equivalent to `!:s^'.
Thus we might have said `^rot^root' to make the spelling correction in the
previous example.
This is the only history substitution which does not explicitly begin with `!'.
.PP
(+) In \fIcsh\fR as such, only one modifier may be applied to each history
or variable expansion. In \fItcsh\fR, more than one may be used, for example
.IP "" 4
% mv wumpus.man /usr/man/man1/wumpus.1
.br
% man !$:t:r
.br
man wumpus
.PP
In \fIcsh\fR, the result would be `wumpus.1:r'. A substitution followed by a
colon may need to be insulated from it with braces:
.IP "" 4
> mv a.out /usr/games/wumpus
.br
> setenv PATH !$:h:$PATH
.br
Bad ! modifier: $.
.br
> setenv PATH !{\-2$:h}:$PATH
.br
setenv PATH /usr/games:/bin:/usr/bin:.
.PP
The first attempt would succeed in \fIcsh\fR but fails in \fItcsh\fR,
because \fItcsh\fR expects another modifier after the second colon
rather than `$'.
.PP
Finally, history can be accessed through the editor as well as through
the substitutions just described.
The \fIup-\fR and \fIdown-history\fR, \fIhistory-search-backward\fR and
\fI-forward\fR, \fIi-search-back\fR and \fI-fwd\fR,
\fIvi-search-back\fR and \fI-fwd\fR, \fIcopy-prev-word\fR
and \fIinsert-last-word\fR editor commands search for
events in the history list and copy them into the input buffer.
The \fItoggle-literal-history\fR editor command switches between the
expanded and literal forms of history lines in the input buffer.
\fIexpand-history\fR and \fIexpand-line\fR expand history substitutions
in the current word and in the entire input buffer respectively.
.SS "Alias substitution"
The shell maintains a list of aliases which can be set, unset and printed by
the \fIalias\fR and \fIunalias\fR commands.  After a command line is parsed
into simple commands (see \fBCommands\fR) the first word of each command,
left-to-right, is checked to see if it has an alias.  If so, the first word is
replaced by the alias. If the alias contains a history reference, it undergoes
\fBHistory substitution\fR (q.v.) as though the original command were the
previous input line. If the alias does not contain a history reference, the
argument list is left untouched.
.PP
Thus if the alias for `ls' were `ls \-l' the command `ls /usr' would become `ls
\-l /usr', the argument list here being undisturbed.  If the alias for `lookup'
were `grep !^ /etc/passwd' then `lookup bill' would become `grep bill
/etc/passwd'.  Aliases can be used to introduce parser metasyntax.  For
example, `alias print 'pr \e!* | lpr'' defines a ``command'' (`print') which
\fIpr\fR(1)s its arguments to the line printer.
.PP
Alias substitution is repeated until the first word of the command has no
alias. If an alias substitution does not change the first word (as in the
previous example) it is flagged to prevent a loop. Other loops are detected and
cause an error.
.PP
Some aliases are referred to by the shell; see \fBSpecial aliases\fR.
.SS "Variable substitution"
The shell maintains a list of variables, each of which has as value a list of
zero or more words.
The values of shell variables can be displayed and changed with the
\fIset\fR and \fIunset\fR commands.
The system maintains its own list of ``environment'' variables.
These can be displayed and changed with \fIprintenv\fR, \fIsetenv\fR and
\fIunsetenv\fR.
.PP
(+) Variables may be made read-only with `set \-r' (q.v.)
Read-only variables may not be modified or unset;
attempting to do so will cause an error.
Once made read-only, a variable cannot be made writable,
so `set \-r' should be used with caution.
Environment variables cannot be made read-only.
.PP
Some variables are set by the shell or referred to by it.
For instance, the \fBargv\fR variable is an image of the shell's argument
list, and words of this variable's value are referred to in special ways.
Some of the variables referred to by the shell are toggles;
the shell does not care what their value is, only whether they are set or not.
For instance, the \fBverbose\fR variable is a toggle which causes command
input to be echoed.  The \fB\-v\fR command line option sets this variable.
\fBSpecial shell variables\fR lists all variables which are referred to by the shell.
.PP
Other operations treat variables numerically.  The `@' command permits numeric
calculations to be performed and the result assigned to a variable.  Variable
values are, however, always represented as (zero or more) strings.  For the
purposes of numeric operations, the null string is considered to be zero, and
the second and subsequent words of multiword values are ignored.
.PP
After the input line is aliased and parsed, and before each command is
executed, variable substitution is performed keyed by `$' characters.  This
expansion can be prevented by preceding the `$' with a `\e' except within `"'s
where it \fIalways\fR occurs, and within `''s where it \fInever\fR occurs.
Strings quoted by ``' are interpreted later (see \fBCommand substitution\fR
below) so `$' substitution does not occur there until later,
if at all.  A `$' is passed unchanged if followed by a blank, tab, or
end-of-line.
.PP
Input/output redirections are recognized before variable expansion, and are
variable expanded separately.  Otherwise, the command name and entire argument
list are expanded together.  It is thus possible for the first (command) word
(to this point) to generate more than one word, the first of which becomes the
command name, and the rest of which become arguments.
.PP
Unless enclosed in `"' or given the `:q' modifier the results of variable
substitution may eventually be command and filename substituted.  Within `"', a
variable whose value consists of multiple words expands to a (portion of a)
single word, with the words of the variable's value separated by blanks.  When
the `:q' modifier is applied to a substitution the variable will expand to
multiple words with each word separated by a blank and quoted to prevent later
command or filename substitution.
.PP
The following metasequences are provided for introducing variable values into
the shell input.  Except as noted, it is an error to reference a variable which
is not set.
.PP
.PD 0
$\fIname\fR
.TP 8
${\fIname\fR}
Substitutes the words of the value of variable \fIname\fR, each separated
by a blank.  Braces insulate \fIname\fR from following characters which would
otherwise be part of it.  Shell variables have names consisting of up to 20
letters and digits starting with a letter.  The underscore character is
considered a letter.  If \fIname\fR is not a shell variable, but is set in the
environment, then that value is returned (but `:' modifiers and the other forms
given below are not available in this case).
.PP
$\fIname\fR[\fIselector\fR]
.TP 8
${\fIname\fR[\fIselector\fR]}
Substitutes only the selected words from the value of \fIname\fR.
The \fIselector\fR is subjected to `$' substitution and may consist of
a single number or two numbers separated by a `\-'.
The first word of a variable's value is numbered `1'.
If the first number of a range is omitted it defaults to `1'.
If the last member of a range is omitted it defaults to `$#\fIname\fR'.
The \fIselector\fR `*' selects all words.
It is not an error for a range to be empty if the
second argument is omitted or in range.
.TP 8
$0
Substitutes the name of the file from which command input
is being read.  An error occurs if the name is not known.
.PP
$\fInumber\fR
.TP 8
${\fInumber\fR}
Equivalent to `$argv[\fInumber\fR]'.
.TP 8
$*
Equivalent to `$argv', which is equivalent to `$argv[*]'.
.PD
.PP
The `:' modifiers described under \fBHistory substitution\fR, except for `:p',
can be applied to the substitutions above. More than one may be used. (+)
Braces may be needed to insulate a variable substitution from a literal colon
just as with \fBHistory substitution\fR (q.v.); any modifiers must appear
within the braces.
.PP
The following substitutions can not be modified with `:' modifiers.
.PP
.PD 0
$?\fIname\fR
.TP 8
${?\fIname\fR}
Substitutes the string `1' if \fIname\fR is set, `0' if it is not.
.TP 8
$?0
Substitutes `1' if the current input filename is known, `0' if it is not.
Always `0' in interactive shells.
.PP
$#\fIname\fR
.TP 8
${#\fIname\fR}
Substitutes the number of words in \fIname\fR.
.TP 8
$#
Equivalent to `$#argv'. (+)
.PP
$%\fIname\fR
.TP 8
${%\fIname\fR}
Substitutes the number of characters in \fIname\fR. (+)
.PP
$%\fInumber\fR
.TP 8
${%\fInumber\fR}
Substitutes the number of characters in $argv[\fInumber\fR]. (+)
.TP 8
$?
Equivalent to `$status'. (+)
.TP 8
$$
Substitutes the (decimal) process number of the (parent) shell.
.TP 8
$!
Substitutes the (decimal) process number of the last
background process started by this shell.
.TP 8
$<
Substitutes a line from the standard input, with no further interpretation
thereafter.  It can be used to read from the keyboard in a shell script.
(+) While \fIcsh\fR always quotes $<, as if it were equivalent to `$<:q',
\fItcsh\fR does not. Furthermore, when \fItcsh\fR is waiting for a line to be
typed the user may type an interrupt to interrupt the sequence into
which the line is to be substituted, but \fIcsh\fR does not allow this.
.PD
.PP
The editor command \fIexpand-variables\fR, normally bound to `^X-$',
can be used to interactively expand individual variables.
.SS "Command, filename and directory stack substitution"
The remaining substitutions are applied selectively to the arguments of builtin
commands.  This means that portions of expressions which are not evaluated are
not subjected to these expansions.  For commands which are not internal to the
shell, the command name is substituted separately from the argument list.  This
occurs very late, after input-output redirection is performed, and in a child
of the main shell.
.SS "Command substitution"
Command substitution is indicated by a command enclosed in ``'.  The output
from such a command is broken into separate words at blanks, tabs and newlines,
and null words are discarded. The output is variable and command substituted
and put in place of the original string.
.PP
Command substitutions inside double
quotes (`"') retain blanks and tabs; only newlines force new words.  The single
final newline does not force a new word in any case.  It is thus possible for a
command substitution to yield only part of a word, even if the command outputs
a complete line.
.SS "Filename substitution"
If a word contains any of the characters `*', `?', `[' or `{' or begins with
the character `~' it is a candidate for filename substitution, also known as
``globbing''. This word is then regarded as a pattern (``glob-pattern''), and
replaced with an alphabetically sorted list of file names which match the
pattern.
.PP
In matching filenames, the character `.' at the beginning of a filename or
immediately following a `/', as well as the character `/' must be matched
explicitly.  The character `*' matches any string of characters, including the
null string.  The character `?' matches any single character.  The sequence
`[...]' matches any one of the characters enclosed.  Within `[...]', a pair of
characters separated by `\-' matches any character lexically between the two.
.PP
(+) Some glob-patterns can be negated:
The sequence `[^...]' matches any single character \fInot\fR specified by the
characters and/or ranges of characters in the braces.
.PP
An entire glob-pattern can also be negated with `^':
.IP "" 4
> echo *
.br
bang crash crunch ouch
.br
> echo ^cr*
.br
bang ouch
.PP
Glob-patterns which do not use `?', `*', or `[]' or which use `{}' or `~'
(below) are not negated correctly.
.PP
The metanotation `a{b,c,d}e' is a shorthand for `abe ace ade'.
Left-to-right order is preserved: `/usr/source/s1/{oldls,ls}.c' expands
to `/usr/source/s1/oldls.c /usr/source/s1/ls.c'. The results of matches are
sorted separately at a low level to preserve this order:
`../{memo,*box}' might expand to `../memo ../box ../mbox'.
(Note that `memo' was not sorted with the results of matching `*box'.)
It is not an error when this construct expands to files which do not exist,
but it is possible to get an error from a command to which the expanded list
is passed.
This construct may be nested.
As a special case the words `{', `}' and `{}' are passed undisturbed.
.PP
The character `~' at the beginning of a filename refers to home directories.
Standing alone, i.e. `~', it expands to the invoker's home directory as
reflected in the value of the \fBhome\fR shell variable. When followed by a
name consisting of letters, digits and `\-' characters the shell searches for a
user with that name and substitutes their home directory; thus `~ken' might
expand to `/usr/ken' and `~ken/chmach' to `/usr/ken/chmach'.  If the character
`~' is followed by a character other than a letter or `/' or appears elsewhere
than at the beginning of a word, it is left undisturbed.
A command like `setenv MANPATH /usr/man:/usr/local/man:~/lib/man' does not,
therefore, do home directory substitution as one might hope.
.PP
It is an error for a glob-pattern containing `*', `?', `[' or `~', with or
without `^', not to match any files. However, only one pattern in a list of
glob-patterns must match a file (so that, e.g., `rm *.a *.c *.o' would fail
only if there were no files in the current directory ending in `.a', `.c', or
`.o'), and if the \fBnonomatch\fR shell variable is set a pattern (or list
of patterns) which matches nothing is left unchanged rather than causing
an error.
.PP
The \fBnoglob\fR shell variable can be set to prevent filename substitution,
and the \fIexpand-glob\fR editor command, normally bound to `^X-*', can be
used to interactively expand individual filename substitutions.
.SS "Directory stack substitution (+)"
The directory stack is a list of directories, numbered from zero, used by the
\fIpushd\fR, \fIpopd\fR and \fIdirs\fR builtin commands (q.v.).
\fIdirs\fR can print, store in a file, restore and clear the directory stack
at any time, and the \fBsavedirs\fR and \fBdirsfile\fR shell variables can be set to
store the directory stack automatically on logout and restore it on login.
The \fBdirstack\fR shell variable can be examined to see the directory stack and
set to put arbitrary directories into the directory stack.
.PP
The character `=' followed by one or more digits expands to an entry in
the directory stack. The special case `=\-' expands to the last directory in
the stack. For example,
.IP "" 4
> dirs \-v
.br
0       /usr/bin 
.br
1       /usr/spool/uucp 
.br
2       /usr/accts/sys
.br
> echo =1
.br
/usr/spool/uucp
.br
> echo =0/calendar
.br
/usr/bin/calendar
.br
> echo =\-
.br
/usr/accts/sys
.PP
The \fBnoglob\fR and \fBnonomatch\fR shell variables and the \fIexpand-glob\fR
editor command apply to directory stack as well as filename substitutions.
.SS "Other substitutions (+)"
There are several more transformations involving filenames, not strictly
related to the above but mentioned here for completeness.
\fIAny\fR filename may be expanded to a full path when the
\fBsymlinks\fR variable (q.v.) is set to `expand'.
Quoting prevents this expansion, and
the \fInormalize-path\fR editor command does it on demand.
The \fInormalize-command\fR editor command expands commands in PATH into
full paths on demand.
Finally, \fIcd\fR and \fIpushd\fR interpret `\-' as the old working directory
(equivalent to the shell variable \fBowd\fR).
This is not a substitution at all, but an abbreviation recognized only by
those commands. Nonetheless, it too can be prevented by quoting.
.SS Commands
The next three sections describe how the shell executes commands and
deals with their input and output.
.SS Simple commands, pipelines and sequences
A simple command is a sequence of words, the first of which specifies the
command to be executed.  A series of simple commands joined by `|' characters
forms a pipeline.  The output of each command in a pipeline is connected to the
input of the next.
.PP
Simple commands and pipelines may be joined into sequences with `;', and will
be executed sequentially.  Commands and pipelines can also be joined into
sequences with `||' or `&&', indicating, as in the C language, that the second
is to be executed only if the first fails or succeeds respectively.
.PP
A simple command, pipeline or sequence may be placed in parentheses, `()',
to form a simple command, which may in turn be a component of a pipeline or
sequence. A command, pipeline or sequence can be executed
without waiting for it to terminate by following it with an `&'.
.SS "Builtin and non-builtin command execution"
Builtin commands are executed within the shell.  If any component of a
pipeline except the last is a builtin command, the pipeline is executed
in a subshell.
.PP
Parenthesized commands are always executed in a subshell.
.IP "" 4
(cd; pwd); pwd
.PP
thus prints the \fBhome\fR directory, leaving you where you were
(printing this after the home directory), while
.IP "" 4
cd; pwd
.PP
leaves you in the \fBhome\fR directory.  Parenthesized commands are most often
used to prevent \fIcd\fR from affecting the current shell.
.PP
When a command to be executed is found not to be a builtin command the shell
attempts to execute the command via \fIexecve\fR(2).  Each word in the variable
\fBpath\fR names a directory in which the shell will look for the
command.  If it is given neither a \fB\-c\fR nor a \fB\-t\fR option, the shell
hashes the names in these directories into an internal table so that it will
only try an \fIexecve\fR(2) in a directory if there is a possibility that the
command resides there.  This greatly speeds command location when a large
number of directories are present in the search path.  If this mechanism has
been turned off (via \fIunhash\fR), if the shell was given a \fB\-c\fR or
\fB\-t\fR argument or in any case for each directory component of \fBpath\fR
which does not begin with a `/', the shell concatenates the current working
directory with the given command name to form a path name of a file which it
then attempts to execute.
.PP
If the file has execute permissions but is not an executable to the system
(i.e. it is neither an executable binary nor a script which specifies its
interpreter), then it is assumed to be a file containing shell commands and
a new shell is spawned to read it. The \fIshell\fR special alias may be set
to specify an interpreter other than the shell itself.
.PP
On systems which do not understand the `#!' script interpreter convention
the shell may be compiled to emulate it; see the \fBversion\fR shell
variable\fR. If so, the shell checks the first line of the file to
see if it is of the form `#!\fIinterpreter\fR \fIarg\fR ...'. If it is,
the shell starts \fIinterpreter\fR with the given \fIarg\fRs and feeds the
file to it on standard input.
.SS Input/output
The standard input and standard output of a command may be redirected with the
following syntax:
.PP
.PD 0
.TP 8
< \fIname
Open file \fIname\fR (which is first variable, command and filename
expanded) as the standard input.
.TP 8
<< \fIword
Read the shell input up to a line which is identical to \fIword\fR. \fIword\fR
is not subjected to variable, filename or command substitution, and each input
line is compared to \fIword\fR before any substitutions are done on this input
line.  Unless a quoting `\e', `"', `' or ``' appears in \fIword\fR variable and
command substitution is performed on the intervening lines, allowing `\e' to
quote `$', `\e' and ``'.  Commands which are substituted have all blanks, tabs,
and newlines preserved, except for the final newline which is dropped.  The
resultant text is placed in an anonymous temporary file which is given to the
command as standard input.
.PP
> \fIname
.br
>! \fIname
.br
>& \fIname
.TP 8
>&! \fIname
The file \fIname\fR is used as standard output.  If the file does not exist
then it is created; if the file exists, its is truncated, its previous contents
being lost.
.RS +8
.PD
.PP
If the shell variable \fBnoclobber\fR is set, then the file must not exist or be a
character special file (e.g. a terminal or `/dev/null') or an error results.
This helps prevent accidental destruction of files.  In this case the `!' forms
can be used to suppress this check.
.PP
The forms involving `&' route the diagnostic output into the specified file as
well as the standard output.  \fIname\fR is expanded in the same way as `<'
input filenames are.
.PD 0
.RE
.PP
>> \fIname
.br
>>& \fIname
.br
>>! \fIname
.TP 8
>>&! \fIname
Like `>', but appends output to the end of \fIname\fR.
If the shell variable \fBnoclobber\fR is set, then it is an error for
the file \fInot\fR to exist, unless one of the `!' forms is given.
.PD
.PP
A command receives the environment in which the shell was invoked as modified
by the input-output parameters and the presence of the command in a pipeline.
Thus, unlike some previous shells, commands run from a file of shell commands
have no access to the text of the commands by default; rather they receive the
original standard input of the shell.  The `<<' mechanism should be used to
present inline data.  This permits shell command scripts to function as
components of pipelines and allows the shell to block read its input.  Note
that the default standard input for a command run detached is \fInot\fR
the empty file \fI/dev/null\fR, but the original standard input of the shell.
If this is a terminal and if the process attempts to read from the terminal,
then the process will block and the user will be notified (see \fBJobs\fR).
.PP
Diagnostic output may be directed through a pipe with the standard output.
Simply use the form `|&' rather than just `|'.
.PP
The shell cannot presently redirect diagnostic output without also redirecting
standard output, but `(\fIcommand\fR > \fIoutput-file\fR) >& \fIerror-file\fR'
is often an acceptable workaround.  Either \fIoutput-file\fR or
\fIerror-file\fR may be `/dev/tty' to send output to the terminal.
.SS Features
Having described how the shell accepts, parses and executes
command lines, we now turn to a variety of its useful features.
.SS "Control flow"
The shell contains a number of commands which can be used to regulate the
flow of control in command files (shell scripts) and (in limited but
useful ways) from terminal input.  These commands all operate by forcing the
shell to reread or skip in its input and, due to the implementation,
restrict the placement of some of the commands.
.PP
The \fIforeach\fR, \fIswitch\fR, and \fIwhile\fR statements, as well as the
\fIif-then-else\fR form of the \fIif\fR statement, require that the major
keywords appear in a single simple command on an input line as shown below.
.PP
If the shell's input is not seekable, the shell buffers up input whenever
a loop is being read and performs seeks in this internal buffer to
accomplish the rereading implied by the loop.  (To the extent that this
allows, backward \fIgoto\fRs will succeed on non-seekable inputs.)
.SS Expressions
The \fIif\fR, \fIwhile\fR and \fIexit\fR builtin commands
use expressions with a common syntax. The expressions can include any
of the operators described in the next three sections. Note that the \fI@\fR
builtin command (q.v.) has its own separate syntax.
.SS "Logical, arithmetical and comparison operators"
These operators are similar to those of C and have the same precedence.
They include
.IP "" 4
||  &&  |  ^  &  ==  !=  =~  !~  <=  >=
.br
<  > <<  >>  +  \-  *  /  %  !  ~  (  )
.PP
Here the precedence increases to the right, `==' `!=' `=~' and `!~', `<='
`>=' `<' and `>', `<<' and `>>', `+' and `\-', `*' `/' and `%' being, in
groups, at the same level.  The `==' `!=' `=~' and `!~' operators compare
their arguments as strings; all others operate on numbers.  The operators
`=~' and `!~' are like `!=' and `==' except that the right hand side is a
glob-pattern (see \fBFilename substitution\fR) against which the left hand
operand is matched.  This reduces the need for use of the \fIswitch\fR
builtin command in shell scripts when all that is really needed is
pattern matching.
.PP
Strings which begin with `0' are considered octal numbers.  Null or
missing arguments are considered `0'.  The results of all expressions are
strings, which represent decimal numbers.  It is important to note that
no two components of an expression can appear in the same word; except
when adjacent to components of expressions which are syntactically
significant to the parser (`&' `|' `<' `>' `(' `)') they should be
surrounded by spaces.
.SS "Command exit status"
Commands can be executed in expressions and their exit status
returned by enclosing them in braces (`{}'). Remember that the braces should
be separated from the words of the command by spaces. Command executions
succeed, returning true, i.e. `1', if the command exits with status 0,
otherwise they fail, returning false, i.e. `0'.  If more detailed status
information is required then the command should be executed outside of an
expression and the \fBstatus\fR shell variable examined.
.SS "File inquiry operators"
Some of these operators perform true/false tests on files and related
objects. They are of the form \fB\-\fIop file\fR, where \fIop\fR is one of
.PP
.PD 0
.RS +4
.TP 4
.B r
Read access
.TP 4
.B w
Write access
.TP 4
.B x
Execute access
.TP 4
.B X
Executable in the path or shell builtin, e.g. `\-X ls' and `\-X ls\-F' are
generally true, but `\-X /bin/ls' is not (+)
.TP 4
.B e
Existence
.TP 4
.B o
Ownership
.TP 4
.B z
Zero size
.TP 4
.B s
Non-zero size (+)
.TP 4
.B f
Plain file
.TP 4
.B d
Directory
.TP 4
.B l
Symbolic link (+) *
.TP 4
.B b
Block special file (+)	
.TP 4
.B c
Character special file (+)
.TP 4
.B p
Named pipe (fifo) (+) *
.TP 4
.B S
Socket special file (+) *
.TP 4
.B u
Set-user-ID bit is set (+)	
.TP 4
.B g
Set-group-ID bit is set (+)	
.TP 4
.B k
Sticky bit is set (+)
.TP 4
.B t
\fIfile\fR (which must be a digit) is an open file descriptor
for a terminal device (+)
.TP 4
.B R
Has been migrated (convex only) (+)
.TP 4
.B L
Applies subsequent operators in a multiple-operator test to a symbolic link
rather than to the file to which the link points (+) *
.RE
.PD
.PP
\fIfile\fR is command and filename expanded and then tested to
see if it has the specified relationship to the real user.  If \fIfile\fR
does not exist or is inaccessible or, for the operators indicated by `*',
if the specified file type does not exist on the current system,
then all enquiries return false, i.e. `0'.
.PP
These operators may be combined for conciseness: `\-\fIxy file\fR' is
equivalent to `\-\fIx file\fR && \-\fIy file\fR'. (+) For example, `\-fx' is true
(returns `1') for plain executable files, but not for directories.
.PP
\fBL\fR may be used in a multiple-operator test to apply subsequent operators
to a symbolic link rather than to the file to which the link points.
For example, `\-lLo' is true for links owned by the invoking user.
\fBLr\fR, \fBLw\fR and \fBLx\fR are always true for links and false for
non-links. \fBL\fR has a different meaning when it is the last operator
in a multiple-operator test; see below.
.PP
It is possible but not useful, and sometimes misleading, to combine operators
which expect \fIfile\fR to be a file with operators which do not,
(e.g. \fBX\fR and \fBt\fR). Following \fBL\fR with a non-file operator
can lead to particularly strange results.
.PP
Other operators return other information, i.e. not just `0' or `1'. (+)
They have the same format as before; \fIop\fR may be one of
.PP
.PD 0
.RS +4
.TP 8
.B A
Last file access time, as the number of seconds since the epoch
.TP 8
.B A:
Like \fBA\fR, but in timestamp format, e.g. `Fri May 14 16:36:10 1993'
.TP 8
.B M
Last file modification time
.TP 8
.B M:
Like \fBM\fR, but in timestamp format
.TP 8
.B C
Last inode modification time
.TP 8
.B C:
Like \fBC\fR, but in timestamp format
.TP 8
.B D
Device number
.TP 8
.B I
Inode number
.TP 8
.B F
Composite \fBf\fRile identifier, in the form \fIdevice\fR:\fIinode\fR
.TP 8
.B L
The name of the file pointed to by a symbolic link
.TP 8
.B N
Number of (hard) links
.TP 8
.B P
Permissions, in octal, without leading zero
.TP 8
.B P:
Like \fBP\fR, with leading zero
.TP 8
.B P\fImode
Equivalent to `\-P \fIfile\fR & \fImode\fR', e.g. `\-P22 \fIfile\fR' returns
`22' if \fIfile\fR is writable by group and other, `20' if by group only,
and `0' if by neither
.TP 8
.B P\fImode\fB:
Like \fBP\fImode\fB:\fR, with leading zero
.TP 8
.B U
Numeric userid
.TP 8
.B U:
Username, or the numeric userid if the username is unknown
.TP 8
.B G
Numeric groupid
.TP 8
.B G:
Groupname, or the numeric groupid if the groupname is unknown
.TP 8
.B Z
Size, in bytes
.RE
.PD
.PP
Only one of these operators may appear in a multiple-operator test, and it
must be the last. Note that \fBL\fR has a different meaning at the end of and
elsewhere in a multiple-operator test. Because `0' is a valid return value
for many of these operators, they do not return `0' when they fail: most
return `\-1', and \fBF\fR returns `:'.
.PP
If the shell is compiled with POSIX defined (see the \fBversion\fR shell
variable), the result of a file inquiry is based on the permission bits of
the file and not on the result of the \fIaccess\fR(2) system call.
For example, if one tests a file with \fB\-w\fR whose permissions would
ordinarily allow writing but which is on a file system mounted read-only,
the test will succeed in a POSIX shell but fail in a non-POSIX shell.
.PP
File inquiry operators can also be evaluated with the \fIfiletest\fR builtin
command (q.v.) (+).
.SS Jobs
The shell associates a \fIjob\fR with each pipeline.  It keeps a table of
current jobs, printed by the \fIjobs\fR command, and assigns them small integer
numbers.  When a job is started asynchronously with `&', the shell prints a
line which looks like
.IP "" 4
[1] 1234
.PP
indicating that the job which was started asynchronously was job number 1 and
had one (top-level) process, whose process id was 1234.
.PP
If you are running a job and wish to do something else you may hit the suspend
key (usually `^Z'),
which sends a STOP signal to the current job.  The shell will then normally
indicate that the job has been `Suspended' and print another prompt.
If the \fBlistjobs\fR shell variable is set, all jobs will be listed
like the \fIjobs\fR builtin command; if it is set to `long' the listing will
be in long format, like `jobs \-l'.
You can then manipulate the state of the suspended job.
You can put it in the
``background'' with the \fIbg\fR command or run some other commands and
eventually bring the job back into the ``foreground'' with \fIfg\fR.
(See also the \fIrun-fg-editor\fR editor command.)
A `^Z' takes effect immediately and is like an interrupt
in that pending output and unread input are discarded when it is typed.
The \fIwait\fR builtin command causes the shell to wait for all background
jobs to complete.
.PP
The `^]' key sends a delayed suspend signal, which does not generate a STOP
signal until a program attempts to \fIread\fR(2) it, to the current job.
This can usefully be typed ahead when you have prepared some commands for a
job which you wish to stop after it has read them.
The `^Y' key performs this function in \fIcsh\fR(1); in \fItcsh\fR,
`^Y' is an editing command. (+)
.PP
A job being run in the background stops if it tries to read from the
terminal.  Background jobs are normally allowed to produce output, but this can
be disabled by giving the command `stty tostop'.  If you set this tty option,
then background jobs will stop when they try to produce output like they do
when they try to read input.
.PP
There are several ways to refer to jobs in the shell.  The character `%'
introduces a job name.  If you wish to refer to job number 1, you can name it
as `%1'.  Just naming a job brings it to the foreground; thus `%1' is a synonym
for `fg %1', bringing job 1 back into the foreground.  Similarly, saying `%1 &'
resumes job 1 in the background, just like `bg %1'. A job can also be named
by an unambigous prefix of the string typed in to start it: `%ex' would
normally restart a suspended \fIex\fR(1) job, if there were only one suspended
job whose name began with the string `ex'.  It is also possible to say
`%?\fIstring\fR' to specify a job whose text contains \fIstring\fR, if there
is only one such job.
.PP
The shell maintains a notion of the current and previous jobs.  In output
pertaining to jobs, the current job is marked with a `+' and the previous job
with a `\-'.  The abbreviations `%+', `%', and (by analogy with the syntax of
the \fIhistory\fR mechanism) `%%' all refer to the current job, and `%\-' refers
to the previous job.
.PP
The job control mechanism requires that the \fIstty\fR(1) option `new' be set
on some systems.  It is an artifact from a `new' implementation of the tty
driver which allows generation of interrupt characters from the keyboard to
tell jobs to stop.  See \fIstty\fR(1) and the \fIsetty\fR builtin command for
details on setting options in the new tty driver.
.SS "Status reporting"
The shell learns immediately whenever a process changes state.  It normally
informs you whenever a job becomes blocked so that no further progress is
possible, but only just before it prints a prompt.  This is done so that it
does not otherwise disturb your work.  If, however, you set the shell variable
\fBnotify\fR, the shell will notify you immediately of changes of status in
background jobs.  There is also a shell command \fInotify\fR which marks a
single process so that its status changes will be immediately reported.  By
default \fInotify\fR marks the current process; simply say `notify' after
starting a background job to mark it.
.PP
When you try to leave the shell while jobs are stopped, you will be
warned that `You have stopped jobs.' You may use the \fIjobs\fR command to see
what they are.  If you do this or immediately try to exit again, the shell will
not warn you a second time, and the suspended jobs will be terminated.
.SS "Automatic, periodic and timed events (+)"
There are various ways to run commands and take other actions automatically
at various times in the ``life cycle'' of the shell. They are summarized here,
and described in detail under the appropriate \fBBuiltin commands\fR,
\fBSpecial shell variables\fR and \fBSpecial aliases\fR.
.PP
The \fIsched\fR builtin command puts commands in a scheduled-event list,
to be executed by the shell at a given time.
.PP
The \fIbeepcmd\fR, \fIcwdcmd\fR, \fIperiodic\fR and \fIprecmd\fR
\fBSpecial aliases\fR can be set, respectively, to execute commands when the shell wants
to ring the bell, when the working directory changes, every \fBtperiod\fR
minutes and before each prompt.
.PP
The \fBautologout\fR shell variable can be set to log out or lock the shell
after a given number of minutes of inactivity.
.PP
The \fBmail\fR shell variable can be set to check for new mail periodically.
.PP
The \fBprintexitvalue\fR shell variable can be set to print the exit status
of commands which exit with a status other than zero.
.PP
The \fBrmstar\fR shell variable can be set to ask the user, when `rm *' is
typed, if that is really what was meant.
.PP
The \fBtime\fR shell variable can be set to execute the \fItime\fR builtin
command after the completion of any process that takes more than a given
number of CPU seconds.
.PP
The \fBwatch\fR and \fBwho\fR shell variables can be set to report when
selected users log in or out, and the \fIlog\fR builtin command reports
on those users at any time.
.SS "Native Language System support (+)"
The shell is eight bit clean
(if so compiled; see the \fBversion\fR shell variable)
and thus supports character sets needing this capability.
NLS support differs depending on whether or not
the shell was compiled to use the system's NLS (again, see \fBversion\fR).
In either case, 7-bit ASCII is the default for character classification
(e.g. which characters are printable) and sorting,
and changing the \fBLANG\fR or \fBLC_CTYPE\fR environment variables
causes a check for possible changes in these respects.
.PP
When using the system's NLS, the \fIsetlocale\fR(3) function is called
to determine appropriate character classification and sorting.
This function typically examines the \fBLANG\fR and \fBLC_CTYPE\fR
environment variables; refer to the system documentation for further details.
When not using the system's NLS, the shell simulates it by assuming that the
ISO 8859-1 character set is used
whenever either of the \fBLANG\fR and \fBLC_CTYPE\fR variables are set, regardless of
their values. Sorting is not affected for the simulated NLS.
.PP
In addition, with both real and simulated NLS, all printable
characters in the range \e200\-\e377, i.e. those that have
M-\fIchar\fR bindings, are automatically rebound to \fIself-insert-command\fR.
The corresponding binding for the escape-\fIchar\fR sequence, if any, is
left alone.
These characters are not rebound if the \fBNOREBIND\fR environment variable
is set. This may be useful for the simulated NLS or a primitive real NLS
which assumes full ISO 8859-1. Otherwise, all M-\fIchar\fR bindings in the
range \e240\-\e377 are effectively undone.
Explicitly rebinding the relevant keys with \fIbindkey\fR
is of course still possible.
.PP
Unknown characters (i.e. those that are neither printable nor control
characters) are printed in the format \ennn.
If the tty is not in 8 bit mode, other 8 bit characters are printed by
converting them to ASCII and using standout mode. The shell
never changes the 7/8 bit mode of the tty and tracks user-initiated
changes of 7/8 bit mode. NLS users (or, for that matter, those who want to
use a meta key) may need to explicitly set
the tty in 8 bit mode through the appropriate \fIstty\fR(1)
command in, e.g., the \fI~/.login\fR file.
.SS "OS variant support (+)"
A number of new builtin commands are provided to support features in
particular operating systems. All are described in detail in the
\fBBuiltin commands\fR section.
.PP
On systems that support TCF (aix-ibm370, aix-ps2), 
\fIgetspath\fR and \fIsetspath\fR get and set the system execution path,
\fIgetxvers\fR and \fIsetxvers\fR get and set the experimental version prefix
and \fImigrate\fR migrates processes between sites. The \fIjobs\fR builtin
prints the site on which each job is executing.
.PP
Under Domain/OS, \fIinlib\fR adds shared libraries to the current environment,
\fIrootnode\fR changes the rootnode and \fIver\fR changes the systype.
.PP
Under Mach, \fIsetpath\fR is equivalent to Mach's \fIsetpath\fR(1).
.PP
Under Masscomp/RTU and Harris CX/UX, \fIuniverse\fR sets the universe.
.PP
Under Harris CX/UX, \fIucb\fR or \fIatt\fR runs a command under the specified
universe.
.PP
Under Convex/OS, \fIwarp\fR prints or sets the universe.
.PP
The \fBVENDOR\fR, \fBOSTYPE\fR and \fBMACHTYPE\fR environment variables
indicate respectively the vendor, operating system and machine type
(microprocessor class or machine model) of the
system on which the shell thinks it is running.
These are particularly useful when sharing one's home directory between several
types of machines; one can, for example,
.IP "" 4
set path = (~/bin.$MACHTYPE /usr/ucb /bin /usr/bin .)
.PP
in one's \fI~/.login\fR and put executables compiled for each machine in the
appropriate directory.
.PP
The \fBversion\fR shell
variable indicates what options were chosen when the shell was compiled.
.PP
Note also the \fInewgrp\fR builtin, the \fBafsuser\fR and
\fBecho_style\fR shell variables and the system-dependent locations of
the shell's input files (see \fBFILES\fR).
.SS "Signal handling"
Login shells ignore interrupts when reading the file \fI~/.logout\fR.
The shell ignores quit signals unless started with \fB\-q\fR.
Login shells catch the terminate signal, but non-login shells inherit the
terminate behavior from their parents.
Other signals have the values which the shell inherited from its parent.
.PP
In shell scripts, the shell's handling of interrupt and terminate signals
can be controlled with \fIonintr\fR, and its handling of hangups can be
controlled with \fIhup\fR and \fInohup\fR.
.PP
The shell exits on a hangup (see also the \fBlogout\fR shell variable).  By
default, the shell's children do too, but the shell does not send them a
hangup when it exits.  \fIhup\fR arranges for the shell to send a hangup to
a child when it exits, and \fInohup\fR sets a child to ignore hangups.
.SS "Terminal management (+)"
The shell uses three different sets of terminal (``tty'') modes:
`edit', used when editing, `quote', used when quoting literal characters,
and `execute', used when executing commands.
The shell holds some settings in each mode constant, so commands which leave
the tty in a confused state do not interfere with the shell.
The shell also matches changes in the speed and padding of the tty.
The list of tty modes that are kept constant
can be examined and modified with the \fIsetty\fR builtin.
Note that although the editor uses CBREAK mode (or its equivalent),
it takes typed-ahead characters anyway.
.PP
The \fIechotc\fR, \fIsettc\fR and \fItelltc\fR commands can be used to
manipulate and debug terminal capabilities from the command line.
.PP
On systems that support SIGWINCH or SIGWINDOW, the shell
adapts to window resizing automatically and adjusts the environment
variables \fBLINES\fR and \fBCOLUMNS\fR if set. If the environment
variable \fBTERMCAP\fR contains li# and co# fields, the shell adjusts
them to reflect the new window size.
.SH REFERENCE
The next sections of this manual describe all of the available
\fBBuiltin commands\fR, \fBSpecial aliases\fR and
\fBSpecial shell variables\fR.
.SS "Builtin commands"
.TP 8
.B %\fIjob
A synonym for the \fIfg\fR builtin command.
.TP 8
.B %\fIjob \fB&
A synonym for the \fIbg\fR builtin command.
.TP 8
.B :
Does nothing, successfully.
.PP
.B @
.br
.B @ \fIname\fB = \fIexpr
.br
.B @ \fIname\fR[\fIindex\fR]\fB = \fIexpr
.br
.B @ \fIname\fB++\fR|\fB--
.PD 0
.TP 8
.B @ \fIname\fR[\fIindex\fR]\fB++\fR|\fB--
The first form prints the values of all shell variables.
.PD
.RS +8
.PP
The second form assigns the value of \fIexpr\fR to \fIname\fR.
The third form assigns the value of \fIexpr\fR to the \fIindex\fR'th
component of \fIname\fR; both \fIname\fR and its \fIindex\fR'th component
must already exist.
.PP
\fIexpr\fR may contain the operators `*', `+', etc. as in C.
If \fIexpr\fR contains `<', `>', `&' or `' then at least that part of
\fIexpr\fR must be placed within `()'.
Note that the syntax of \fIexpr\fR has nothing to do with that described
under \fBExpressions\fR.
.PP
The fourth and fifth forms increment (`++') or decrement (`\-\-') \fIname\fR
or its \fIindex\fR'th component.
.PP
The space between `@' and \fIname\fR is required.  The spaces between
\fIname\fR and `=' and between `=' and \fIexpr\fR are optional.  Components of
\fIexpr\fR must be separated by spaces.
.RE
.PD
.TP 8
.B alias \fR[\fIname \fR[\fIwordlist\fR]]
Without arguments, prints all aliases.
With \fIname\fR, prints the alias for name.
With \fIname\fR and \fIwordlist\fR, assigns
\fIwordlist\fR as the alias of \fIname\fR.
\fIwordlist\fR is command and filename substituted.
\fIname\fR may not be `alias' or `unalias'.
See also the \fIunalias\fR builtin command.
.ig \" Obsolete tcsh command
.TP 8
.B aliases \fR[\fIfile\fR] (+)
Without arguments, prints all aliases.
With \fIfile\fR, loads a list of aliases from \fIfile\fR, one per line.
Retained only for downward compatibility.
..
.TP 8
.B alloc
Shows the amount of dynamic memory acquired, broken down into used and free
memory.  With an argument shows the number of free and used blocks in each size
category.  The categories start at size 8 and double at each step.  This
command's output may vary across system types, since systems other than the VAX
may use a different memory allocator.
.TP 8
.B bg \fR[\fB%\fIjob\fR ...]
Puts the specified jobs (or, without arguments, the current job)
into the background, continuing each if it is stopped.
\fIjob\fR may be a number, a string, `', `%', `+' or `\-' as described
under \fBJobs\fR.
.ig \" Obsolete tcsh command
.TP 8
.B bind \fR[\fBdefaults\fR|\fBemacs\fR|\fBvi\fR|\fIkey\fR|\fIkey command\fR] (+)
An older version of \fIbindkey\fR, retained only for downward compatibility.
Without arguments, lists all bound keys and the editor command to which each is bound.
`bind defaults', `bind emacs' and `bind vi' are equivalent to
`bindkey \-d', `bindkey \-e' and `bindkey \-v'.
With \fIkey\fR, lists the editor command to which \fIkey\fR is bound.
With \fIkey\fR and \fIcommand\fR, binds the editor command \fIcommand\fR to \fIkey\fR.
.IP "" 8
\fIkey\fR may be a literal character,
a control character written ^\fIcharacter\fR (e.g. `^A'),
a meta character written M-\fIcharacter\fR (e.g. `M-A')
or a function key written F-\fIstring\fR (e.g. `F-foo').
For the function key form to work, the function key prefix must be
bound to \fIsequence-lead-in\fR and \fIstring\fR must not contain that prefix.
..
.PP
.B bindkey \fR[\fB\-l\fR|\fB\-d\fR|\fB\-e\fR|\fB\-v\fR|\fB\-u\fR] (+)
.br
\fBbindkey \fR[\fB\-a\fR] [\fB\-b\fR] [\fB\-k\fR] [\fB\-r\fR] [\fB\-\-\fR] \fIkey \fR(+)
.PD 0
.TP 8
\fBbindkey \fR[\fB\-a\fR] [\fB\-b\fR] [\fB\-k\fR] [\fB\-c\fR|\fB\-s\fR] [\fB\-\-\fR] \fIkey command \fR(+)
.\" .B macro can't take too many words, so I used \fB in the previous tags
Without options, the first form lists all bound keys and the editor command to which each is bound,
the second form lists the editor command to which \fIkey\fR is bound and
the third form binds the editor command \fIcommand\fR to \fIkey\fR.
Options include:
.PD
.PP
.PD 0
.RS +8
.TP 4
.B \-l
Lists all editor commands and a short description of each.
.TP 4
.B \-d
Binds all keys to the standard bindings for the default editor.
.TP 4
.B \-e
Binds all keys to the standard GNU Emacs-like bindings.
.TP 4
.B \-v
Binds all keys to the standard \fIvi\fR(1)-like bindings.
.TP 4
.B \-a
Lists or changes key-bindings in the alternative key map.
This is the key map used in \fIvi\fR command mode.
.TP 4
.B \-b
\fIkey\fR is interpreted as 
a control character written ^\fIcharacter\fR (e.g. `^A') or
C-\fIcharacter\fR (e.g. `C-A'),
a meta character written M-\fIcharacter\fR (e.g. `M-A'),
a function key written F-\fIstring\fR (e.g. `F-string'),
or an extended prefix key written X-\fIcharacter\fR (e.g. `X-A').
.TP 4
.B \-k
\fIkey\fR is interpreted as a symbolic arrow key name, which may be one of
`down', `up', `left' or `right'.
.TP 4
.B \-r
Removes \fIkey\fR's binding.
Be careful: `bindkey \-r' does \fInot\fR bind \fIkey\fR to
\fIself-insert-command\fR (q.v.), it unbinds \fIkey\fR completely.
.TP 4
.B \-c
\fIcommand\fR is interpreted as a builtin or external command instead of an
editor command.
.TP 4
.B \-s
\fIcommand\fR is taken as a literal string and treated as terminal input
when \fIkey\fR is typed. Bound keys in \fIcommand\fR are themselves
reinterpreted, and this continues for ten levels of interpretation.
.TP 4
.B \-\-
Forces a break from option processing, so the next word is taken as \fIkey\fR
even if it begins with '\-'.
.TP 4
.B \-u \fR(or any invalid option)
Prints a usage message.
.PD
.PP
\fIkey\fR may be a single character or a string.
If a command is bound to a string, the first character of the string is bound to
\fIsequence-lead-in\fR and the entire string is bound to the command.
.PP
Control characters in \fIkey\fR can be literal (they can be typed by preceding
them with the editor command \fIquoted-insert\fR, normally bound to `^V') or
written caret-character style, e.g. `^A'. Delete is written `^?'
(caret-question mark).  \fIkey\fR and \fIcommand\fR can contain backslashed
escape sequences (in the style of System V \fIecho\fR(1)) as follows:
.RS +4
.TP 8
.PD 0
.B \ea
Bell
.TP 8
.B \eb
Backspace
.TP 8
.B \ee
Escape
.TP 8
.B \ef
Form feed
.TP 8
.B \en
Newline
.TP 8
.B \er
Carriage return
.TP 8
.B \et
Horizontal tab
.TP 8
.B \ev
Vertical tab
.TP 8
.B \e\fInnn
The ASCII character corresponding to the octal number \fInnn\fR
.PD
.RE
.PP
`\e' nullifies the special meaning of the following character, if it has
any, notably `\\' and `^'.
.RE
.TP 8
.B break
Causes execution to resume after the \fIend\fR of the nearest
enclosing \fIforeach\fR or \fIwhile\fR. The remaining commands on the
current line are executed.  Multi-level breaks are thus
possible by writing them all on one line.
.TP 8
.B breaksw
Causes a break from a \fIswitch\fR, resuming after the \fIendsw\fR.
.TP 8
.B builtins \fR(+)
Prints the names of all builtin commands.
.TP 8
.B bye \fR(+)
A synonym for the \fIlogout\fR builtin command.
Available only if the shell was so compiled;
see the \fBversion\fR shell variable.
.TP 8
.B case \fIlabel\fB:
A label in a \fIswitch\fR statement as discussed below.
.TP 8
.B cd \fR[\fB\-p\fR] [\fB\-l\fR] [\fB\-n\fR|\fB\-v\fR] [\fIname\fR]
If a directory \fIname\fR is given, changes the shell's working directory
to \fIname\fR. If not, changes to \fBhome\fR.
If \fIname\fR is `\-' it is interpreted as the previous working directory
(see \fBOther substitutions\fR). (+)
If \fIname\fR is not a subdirectory of the current directory
(and does not begin with `/', `./' or `../'), each component of the variable
\fBcdpath\fR is checked to see if it has a subdirectory \fIname\fR. Finally, if
all else fails but \fIname\fR is a shell variable whose value
begins with `/', then this is tried to see if it is a directory.
.RS +8
.PP
With \fB\-p\fR, prints the final directory stack, just like \fIdirs\fR.
The \fB\-l\fR, \fB\-n\fR and \fB\-v\fR flags have the same effect on \fIcd\fR
as on \fIdirs\fR, and they imply \fB\-p\fR. (+)
.PP
See also the \fBimplicitcd\fR shell variable.
.RE
.TP 8
.B chdir
A synonym for the \fIcd\fR builtin command.
.TP 8
.B complete \fR[\fIcommand\fR [\fIword\fB/\fIpattern\fB/\fIlist\fR[\fB:\fIselect\fR]\fB/\fR[[\fIsuffix\fR]\fB/\fR] ...]] (+)
Without arguments, lists all completions.
With \fIcommand\fR, lists completions for \fIcommand\fR.
With \fIcommand\fR and \fIword\fR etc., defines completions.
.RS +8
.PP
\fIcommand\fR may be a full command name or a glob-pattern
(see \fBFilename substitution\fR). It can begin with `\-' to indicate that
completion should be used only when \fIcommand\fR is ambiguous.
.PP
\fIword\fR specifies which word relative to the current word
is to be completed, and may be one of the following:
.PP
.PD 0
.RS +4
.TP 4
.B c
Current-word completion.
\fIpattern\fR is a glob-pattern which must match the beginning of the current word on
the command line. \fIpattern\fR is ignored when completing the current word.
.TP 4
.B C
Like \fBc\fR, but includes \fIpattern\fR when completing the current word.
.TP 4
.B n
Next-word completion.
\fIpattern\fR is a glob-pattern which must match the beginning of the previous word on
the command line.
.TP 4
.B N
Like \fBn\fR, but must match the beginning of the word two before the current word.
.TP 4
.B p
Position-dependent completion.
\fIpattern\fR is a numeric range, with the same syntax used to index shell
variables, which must include the current word.
.PD
.RE
.ig \" No longer true in 6.05.04
.PP
When \fIpattern\fR is a glob-pattern (for \fBc\fR, \fBC\fR, \fBn\fR and
\fBN\fR-type completion), a \fIpattern\fR of `*' does not match an empty
word.
..
.PP
\fIlist\fR, the list of possible completions, may be one of the following:
.PP
.PD 0
.RS +4
.TP 8
.B a
Aliases
.TP 8
.B b
Bindings (editor commands)
.TP 8
.B c
Commands (builtin or external commands)
.TP 8
.B C
External commands which begin with the supplied path prefix
.TP 8
.B d
Directories
.TP 8
.B D
Directories which begin with the supplied path prefix
.TP 8
.B e
Environment variables
.TP 8
.B f
Filenames
.TP 8
.B F
Filenames which begin with the supplied path prefix
.TP 8
.B g
Groupnames
.TP 8
.B j
Jobs
.TP 8
.B l
Limits
.TP 8
.B n
Nothing
.TP 8
.B s
Shell variables
.TP 8
.B S
Signals
.TP 8
.B t
Plain (``text'') files
.TP 8
.B T
Plain (``text'') files which begin with the supplied path prefix
.TP 8
.B v
Any variables
.TP 8
.B u
Usernames
.TP 8
.B x
Like \fBn\fR, but prints \fIselect\fR when \fIlist-choices\fR is used.
.TP 8
.B X
Completions
.TP 8
$\fIvar\fR
Words from the variable \fIvar\fR
.TP 8
(...)
Words from the given list
.TP 8
`...`
Words from the output of command
.PD
.RE
.PP
\fIselect\fR is an optional glob-pattern.
If given, only words from \fIlist\fR which match \fIselect\fR are considered
and the \fBfignore\fR shell variable is ignored.
The last three types of completion may not have a \fIselect\fR
pattern, and \fBx\fR uses \fIselect\fR as an explanatory message when
the \fIlist-choices\fR editor command is used.
.PP
\fIsuffix\fR is a single character to be appended to a successful
completion.  If null, no character is appended. If omitted (in which
case the fourth delimiter can also be omitted), a slash is appended to
directories and a space to other words.
.PP
Now for some examples. Some commands take only directories as arguments,
so there's no point completing plain files.
.IP "" 4
> complete cd 'p/1/d/'
.PP
completes only the first word following `cd' (`p/1') with a directory.
\fBp\fR-type completion can also be used to narrow down command completion:
.IP "" 4
> co[^D]
.br
complete compress
.br
> complete \-co* 'p/0/(compress)/'
.br
> co[^D]
.br
> compress
.PP
This completion completes commands (words in position 0, `p/0')
which begin with `co' (thus matching `co*') to `compress' (the only
word in the list).
The leading `\-' indicates that this completion is to be used only with
ambiguous commands.
.IP "" 4
> complete find 'n/\-user/u/'
.PP
is an example of \fBn\fR-type completion. Any word following `find' and
immediately following `\-user' is completed from the list of users.
.IP "" 4
> complete cc 'c/\-I/d/'
.PP
demonstrates \fBc\fR-type completion. Any word following `cc' and beginning
with `\-I' is completed as a directory. `\-I' is not taken as part of the
directory because we used lowercase \fBc\fR.
.PP
Different \fIlist\fRs are useful with different commands.
.IP "" 4
> complete alias 'p/1/a/'
.br
> complete man 'p/*/c/'
.br
> complete set 'p/1/s/'
.br
> complete true 'p/1/x:Truth has no options./'
.PP
These complete words following `alias' with aliases, `man' with commands,
and `set' with shell variables.
`true' doesn't have any options, so \fBx\fR does nothing when completion
is attempted and prints `Truth has no options.' when completion choices are listed.
.PP
.ig \" Changed in 6.05.04
The \fIman\fR example, and several other examples below, use
\fBp\fR-type completion, rather than \fBC\fR- or \fBn\fR-type, so that
`*' will match an empty word.
..
Note that the \fIman\fR example, and several other examples below, could
just as well have used 'c/*' or 'n/*' as 'p/*'.
.PP
Words can be completed from a variable evaluated at completion time,
.IP "" 4
> complete ftp 'p/1/$hostnames/'
.br
> set hostnames = (rtfm.mit.edu tesla.ee.cornell.edu)
.br
> ftp [^D]
.br
rtfm.mit.edu tesla.ee.cornell.edu
.br
> ftp [^C]
.br
> set hostnames = (rtfm.mit.edu tesla.ee.cornell.edu uunet.uu.net)
.br
> ftp [^D]
.br
rtfm.mit.edu tesla.ee.cornell.edu uunet.uu.net
.PP
or from a command run at completion time:
.IP "" 4
> complete kill 'p/*/`ps | awk \\{print\\ \\$1\\}`/'
.br
> kill \-9 [^D]
.br
23113 23377 23380 23406 23429 23529 23530 PID
.PP
Note that the \fIcomplete\fR command does not itself quote its arguments,
so the braces, space and `$' in `{print $1}' must be quoted explicitly.
.PP
One command can have multiple completions:
.IP "" 4
> complete dbx 'p/2/(core)/' 'p/*/c/'
.PP
completes the second argument to `dbx' with the word `core' and all other
arguments with commands. Note that the positional completion is specified
before the next-word completion.
Since completions are evaluated from left to right, if
the next-word completion were specified first it would always match
and the positional completion would never be executed. This is a
common mistake when defining a completion.
.PP
The \fIselect\fR pattern is useful when a command takes only files with
particular forms as arguments. For example,
.IP "" 4
> complete cc 'p/*/f:*.[cao]/'
.PP
completes `cc' arguments only to files ending in `.c', `.a', or `.o'.
\fIselect\fR can also exclude files, using negation of a glob-pattern as
described under \fBFilename substitution\fR. One might use
.IP "" 4
> complete rm 'p/*/f:^*.{c,h,cc,C,tex,1,man,l,y}/'
.PP
to exclude precious source code from `rm' completion. Of course, one
could still type excluded names manually or override the completion
mechanism using the \fIcomplete-word-raw\fR or \fIlist-choices-raw\fR
editor commands (q.v.).
.PP
The `C', `D', `F' and `T' \fIlist\fRs are like `c', `d', `f' and `t'
respectively, but they use the \fIselect\fR argument in a different way: to
restrict completion to files beginning with a particular path prefix. For
example, the Elm mail program uses `=' as an abbreviation for one's mail
directory. One might use
.IP "" 4
> complete elm c@=@F:$HOME/Mail/@
.PP
to complete `elm \-f =' as if it were `elm \-f ~/Mail/'. Note that we used `@'
instead of `/' to avoid confusion with the \fIselect\fR argument, and we used
`$HOME' instead of `~' because home directory substitution only works at the
beginning of a word.
.PP
\fIsuffix\fR is used to add a nonstandard suffix
(not space or `/' for directories) to completed words.
.IP "" 4
> complete finger 'c/*@/$hostnames/' 'p/1/u/@'
.PP
completes arguments to `finger' from the list of users, appends an `@',
and then completes after the `@' from the `hostnames' variable. Note
again the order in which the completions are specified.
.PP
Finally, here's a complex example for inspiration:
.IP "" 4
> complete find \\
.br
\'n/\-name/f/' 'n/\-newer/f/' 'n/\-{,n}cpio/f/' \e
.br
\'n/\-exec/c/' 'n/\-ok/c/' 'n/\-user/u/' \e
.br
\'n/\-group/g/' 'n/\-fstype/(nfs 4.2)/' \e
.br
\'n/\-type/(b c d f l p s)/' \e
.br
\'c/\-/(name newer cpio ncpio exec ok user \e
.br
group fstype type atime ctime depth inum \e
.br
ls mtime nogroup nouser perm print prune \e
.br
size xdev)/' \e
.br
\'p/*/d/'
.PP
This completes words following `\-name', `\-newer', `\-cpio' or `ncpio'
(note the pattern which matches both) to files,
words following `\-exec' or `\-ok' to commands, words following `user'
and `group' to users and groups respectively
and words following `\-fstype' or `\-type' to members of the
given lists. It also completes the switches themselves from the given list
(note the use of \fBc\fR-type completion)
and completes anything not otherwise completed to a directory. Whew.
.PP
Remember that programmed completions are ignored if the word being completed
is a tilde substitution (beginning with `~') or a variable (beginning with `$').
\fIcomplete\fR is an experimental feature, and the syntax may change
in future versions of the shell.
See also the \fIuncomplete\fR builtin command.
.RE
.TP 8
.B continue
Continues execution of the nearest enclosing \fIwhile\fR or \fIforeach\fR.
The rest of the commands on the current line are executed.
.TP 8
.B default:
Labels the default case in a \fIswitch\fR statement.
It should come after all \fIcase\fR labels.
.PP
.B dirs \fR[\fB\-l\fR] [\fB\-n\fR|\fB\-v\fR]
.br
.B dirs \-S\fR|\fB\-L \fR[\fIfilename\fR] (+)
.PD 0
.TP 8
.B dirs \-c \fR(+)
The first form prints the directory stack. The top of the stack is at the
left and the first directory in the stack is the current directory.
With \fB\-l\fR, `~' or `~\fIname\fP' in the output is expanded explicitly
to \fBhome\fR or the pathname of the home directory for user \fIname\fP. (+)
With \fB\-n\fR, entries are wrapped before they reach the edge of the screen. (+)
With \fB\-v\fR, entries are printed one per line, preceded by their stack postions. (+)
If more than one of \fB\-n\fR or \fB\-v\fR is given, \fB\-v\fR takes precedence.
\fB\-p\fR is accepted but does nothing.
.PD
.RS +8
.PP
With \fB\-S\fR, the second form saves the directory stack to \fIfilename\fR
as a series of \fIcd\fR and \fIpushd\fR commands.
With \fB\-L\fR, the shell sources \fIfilename\fR, which is presumably
a directory stack file saved by the \fB\-S\fR option or the \fBsavedirs\fR
mechanism.
In either case, \fBdirsfile\fR is used if \fIfilename\fR is not given and
\fI~/.cshdirs\fR is used if \fBdirsfile\fR is unset.
.PP
Note that login shells do the equivalent of `dirs \-L' on startup
and, if \fBsavedirs\fR is set, `dirs \-S' before exiting.
Because only \fI~/.tcshrc\fR is normally sourced before \fI~/.cshdirs\fR,
\fBdirsfile\fR should be set in \fI~/.tcshrc\fR rather than \fI~/.login\fR.
.PP
The last form clears the directory stack.
.RE
.TP 8
.B echo \fR[\fB\-n\fR] \fIword\fR ...
Writes each \fIword\fR to the shell's standard
output, separated by spaces and terminated with a newline.
The \fBecho_style\fR shell variable may be set to emulate (or not) the flags and escape
sequences of the BSD and/or System V versions of \fIecho\fR; see \fIecho\fR(1).
.TP 8
.B echotc \fR[\fB\-sv\fR] \fIarg\fR ... (+)
Exercises the terminal capabilities (see \fItermcap\fR(5)) in \fIargs\fR.
For example, 'echotc home' sends the cursor to the home position,
\&'echotc cm 3 10' sends it to column 3 and row 10, and
\&'echotc ts 0; echo "This is a test."; echotc fs' prints "This is a test."
in the status line.
.RS +8
.PP
If \fIarg\fR is 'baud', 'cols', 'lines', 'meta' or 'tabs', prints the
value of that capability ("yes" or "no" indicating that the terminal does
or does not have that capability). One might use this to make the output
from a shell script less verbose on slow terminals, or limit command
output to the number of lines on the screen:
.IP "" 4
> set history=`echotc lines`
.br
> @ history\-\-
.PP
Termcap strings may contain wildcards which will not echo correctly.
One should use double quotes when setting a shell variable to a terminal
capability string, as in the following example that places the date in
the status line:
.IP "" 4
> set tosl="`echotc ts 0`"
.br
> set frsl="`echotc fs`"
.br
> echo \-n "$tosl";date; echo \-n "$frsl"
.PP
With \fB\-s\fR, nonexistent capabilities return the empty string rather
than causing an error.
With \fB\-v\fR, messages are verbose.
.RE
.PP
.B else
.br
.B end
.br
.B endif
.PD 0
.TP 8
.B endsw
See the description of the \fIforeach\fR, \fIif\fR, \fIswitch\fR, and
\fIwhile\fR statements below.
.PD
.TP 8
.B eval \fIarg\fR ...
Treats the arguments as input to the
shell and executes the resulting command(s) in the context
of the current shell. This is usually used to execute commands
generated as the result of command or variable substitution,
since parsing occurs before these substitutions.
See \fItset\fR(1) for a sample use of \fIeval\fR.
.TP 8
.B exec \fIcommand\fR
Executes the specified command in place of the current shell.
.TP 8
.B exit \fR[\fIexpr\fR]
The shell exits either with the value of the specified \fIexpr\fR
(an expression, as described under \fBExpressions\fR)
or, without \fIexpr\fR, with the value of the \fBstatus\fR variable.
.TP 8
.B fg \fR[\fB%\fIjob\fR ...]
Brings the specified jobs (or, without arguments, the current job)
into the foreground, continuing each if it is stopped.
\fIjob\fR may be a number, a string, `', `%', `+' or `\-' as described
under \fBJobs\fR.
See also the \fIrun-fg-editor\fR editor command.
.TP 8
.B filetest \-\fIop file\fR ... (+)
Applies \fIop\fR (which is a file inquiry operator as described under
\fBFile inquiry operators\fR) to each \fIfile\fR and returns the results as a
space-separated list.
.PP
.B foreach \fIname \fB(\fIwordlist\fB)
.br
\&...
.PD 0
.TP 8
.B end
Successively sets the variable \fIname\fR to each member of
\fIwordlist\fR and executes the sequence of commands between this command
and the matching \fIend\fR.  (Both \fIforeach\fR and \fIend\fR
must appear alone on separate lines.)  The builtin command
\fIcontinue\fR may be used to continue the loop prematurely and
the builtin command \fIbreak\fR to terminate it prematurely.
When this command is read from the terminal, the loop is read once
prompting with `foreach? ' (or \fBprompt2\fR) before any statements in
the loop are executed.  If you make a mistake typing in a
loop at the terminal you can rub it out.
.PD
.TP 8
.B getspath \fR(+)
Prints the system execution path. (TCF only)
.TP 8
.B getxvers \fR(+)
Prints the experimental version prefix. (TCF only)
.TP 8
.B glob \fIwordlist
Like \fIecho\fR, but no `\\' escapes are recognized and words are
delimited by null characters in the output.  Useful for
programs which wish to use the shell to filename expand a list of words.
.TP 8
.B goto \fIword
\fIword\fR is filename and command-substituted to
yield a string of the form `label'.  The shell rewinds its
input as much as possible, searches for a line of the
form `label:', possibly preceded by blanks or tabs, and
continues execution after that line.
.TP 8
.B hashstat
Prints a statistics line indicating how effective the
internal hash table has been at locating commands (and avoiding
\fIexec\fR's). An \fIexec\fR is attempted for each component of the
\fBpath\fR where the hash function indicates a possible hit, and
in each component which does not begin with a `/'.
.IP
On machines without \fIvfork\fR(2), prints only the number and size of
hash buckets.
.PP
.B history \fR[\fB\-hTr\fR] [\fIn\fR]
.br
.B history \-S\fR|\fB\-L|\fB\-M \fR[\fIfilename\fR] (+)
.PD 0
.TP 8
.B history \-c \fR(+)
The first form prints the history event list.
If \fIn\fR is given only the \fIn\fR most recent events are printed or saved.
With \fB\-h\fR, the history list is printed without leading numbers. If
\fB-T\fR is specified, timestamps are printed also in comment form.
(This can be used to
produce files suitable for loading with 'history \-L' or 'source \-h'.)
With \fB\-r\fR, the order of printing is most recent
first rather than oldest first.
.PD
.RS +8
.PP
With \fB\-S\fR, the second form saves the history list to \fIfilename\fR.
If the first word of the \fBsavehist\fR shell variable is set to a
number, at most that many lines are saved.  If the second word of
\fBsavehist\fR is set to `merge', the history list is merged with the
existing history file instead of replacing it (if there is one) and
sorted by time stamp. (+) Merging is intended for an environment like
the X Window System
with several shells in simultaneous use.  Currently it only
succeeds when the shells quit nicely one after another.
.PP
With \fB\-L\fR, the shell appends \fIfilename\fR, which is presumably a
history list saved by the \fB\-S\fR option or the \fBsavehist\fR mechanism,
to the history list.
\fB\-M\fR is like \fB\-L\fR, but the contents of \fIfilename\fR are merged
into the history list and sorted by timestamp.
In either case, \fBhistfile\fR is used if \fIfilename\fR is not given and
\fI~/.history\fR is used if \fBhistfile\fR is unset.
`history \-L' is exactly like 'source \-h' except that it does not require a
filename.
.PP
Note that login shells do the equivalent of `history \-L' on startup
and, if \fBsavehist\fR is set, `history \-S' before exiting.
Because only \fI~/.tcshrc\fR is normally sourced before \fI~/.history\fR,
\fBhistfile\fR should be set in \fI~/.tcshrc\fR rather than \fI~/.login\fR.
.PP
If \fBhistlit\fR is set, the first and second forms print and save the literal
(unexpanded) form of the history list.
.PP
The last form clears the history list.
.RE
.TP 8
.B hup \fR[\fIcommand\fR] \fR(+)
With \fIcommand\fR, runs \fIcommand\fR such that it will exit on a hangup
signal and arranges for the shell to send it a hangup signal when the shell
exits.
Note that commands may set their own response to hangups, overriding \fIhup\fR.
Without an argument (allowed only in a shell script), causes the shell to
exit on a hangup for the remainder of the script.
See also \fBSignal handling\fR and the \fInohup\fR builtin command.
.TP 8
.B if (\fIexpr\fB) \fIcommand
If \fIexpr\fR (an expression, as described under \fBExpressions\fR)
evaluates true, then \fIcommand\fR is executed.
Variable substitution on \fIcommand\fR happens early, at the same time it
does for the rest of the \fIif\fR command.
\fIcommand\fR must be a simple command, not an alias, a pipeline, a command list
or a parenthesized command list, but it may have arguments.
Input/output redirection occurs even if \fIexpr\fR is
false and \fIcommand\fR is thus \fInot\fR executed; this is a bug.
.PP
.B if (\fIexpr\fB) then
.br
\&...
.br
.B else if (\fIexpr2\fB) then
.br
\&...
.br
.B else
.br
\&...
.PD 0
.TP 8
.B endif
If the specified \fIexpr\fR is true then the commands to the
first \fIelse\fR are executed; otherwise if \fIexpr2\fR is true then
the commands to the second \fIelse\fR are executed, etc.  Any
number of \fIelse-if\fR pairs are possible; only one \fIendif\fR is
needed.  The \fIelse\fR part is likewise optional.  (The words
\fIelse\fR and \fIendif\fR must appear at the beginning of input lines;
the \fIif\fR must appear alone on its input line or after an
\fIelse\fR.)
.PD
.TP 8
.B inlib \fIshared-library\fR ... (+)
Adds each \fIshared-library\fR to the current environment. There is no way
to remove a shared library. (Domain/OS only)
.TP 8
.B jobs \fR[\fB\-l\fR]
Lists the active jobs. With \fB\-l\fR, lists process
IDs in addition to the normal information. On TCF systems, prints
the site on which each job is executing.
.PP
.B kill \fR[\fB\-\fIsignal\fR] \fB%\fIjob\fR|\fIpid\fR ...
.PD 0
.TP 8
.B kill \-l
The first form sends the specified \fIsignal\fR (or, if none is given,
the TERM (terminate) signal) to the specified jobs or processes.
\fIjob\fR may be a number, a string, `', `%', `+' or `\-' as described
under \fBJobs\fR.
Signals are either given by number or by name (as given in
\fI/usr/include/signal.h\fR, stripped of the prefix `SIG').
There is no default \fIjob\fR; saying just `kill' does not send a signal
to the current job.  If the signal being sent is TERM (terminate)
or HUP (hangup), then the job or process is sent a
CONT (continue) signal as well.
The second form lists the signal names.
.PD
.ig \" Obsolete tcsh command
.TP 8
.B linedit \fR(+)
A synonym for the \fIecho\fR builtin command.
..
.TP 8
.B limit \fR[\fB\-h\fR] [\fIresource\fR [\fImaximum-use\fR]]
Limits the consumption by the current process and each
process it creates to not individually exceed \fImaximum-use\fR on
the specified \fIresource\fR. If no \fImaximum-use\fR is given, then
the current limit is printed; if no \fIresource\fR is given, then
all limitations are given.  If the \fB\-h\fR flag is given, the
hard limits are used instead of the current limits.  The
hard limits impose a ceiling on the values of the current
limits.  Only the super-user may raise the hard limits, but
a user may lower or raise the current limits within the legal range.
.RS +8
.PP
Controllable resources currently include \fIcputime\fR (the
maximum number of cpu-seconds to be used by each process),
\fIfilesize\fR (the largest single file which can be created),
\fIdatasize\fR (the maximum growth of the data+stack region via
sbrk(2) beyond the end of the program text), \fIstacksize\fR (the
maximum size of the automatically-extended stack region),
\fIcoredumpsize\fR (the size of the largest core dump that will be created),
and \fImemoryuse\fR, the maximum amount of physical memory a process
may have allocated to it at a given time.
.PP
\fImaximum-use\fR may be given as a (floating point or
integer) number followed by a scale factor.  For all limits
other than \fIcputime\fR the default scale is `k' or `kilobytes'
(1024 bytes); a scale factor of `m' or `megabytes' may also
be used.  For \fIcputime\fR the default scaling is `seconds',
while `m' for minutes or `h' for hours, or a time of the
form `mm:ss' giving minutes and seconds may be used.
.PP
For both \fIresource\fR names and scale factors, unambiguous
prefixes of the names suffice.
.RE
.TP 8
.B log \fR(+)
Prints the \fBwatch\fR shell variable and reports on each user indicated
in \fBwatch\fR who is logged in, regardless of when they last logged in.
See also \fIwatchlog\fR.
.TP 8
.B login
Terminates a login shell, replacing it with an instance of
\fI/bin/login.\fR This is one way to log off, included for
compatibility with \fIsh\fR(1).
.TP 8
.B logout
Terminates a login shell.  Especially useful if \fBignoreeof\fR is set.
.TP 8
.B ls\-F \fR[\-\fIswitch\fR ...] [\fIfile\fR ...] (+)
Lists files like `ls \-F', but much faster. It identifies each type of
special file in the listing with a special character:
.PP
.RS +8
.PD 0
.TP 4
/
Directory
.TP 4
*
Executable
.TP 4
#
Block device
.TP 4
%
Character device
.TP 4
|
Named pipe (systems with named pipes only)
.TP 4
=
Socket (systems with sockets only)
.TP 4
@
Symbolic link (systems with symbolic links only)
.TP 4
+
Hidden directory (AIX only) or context dependent (HP/UX only)
.TP 4
:
Network special (HP/UX only)
.PD
.PP
If the \fBlistlinks\fR shell variable is set, symbolic links are identified
in more detail (only, of course, on systems which have them):
.PP
.PD 0
.TP 4
@
Symbolic link to a non-directory
.TP 4
>
Symbolic link to a directory 
.TP 4
&
Symbolic link to nowhere
.PD
.PP
\fBlistlinks\fR also slows down \fIls\-F\fR and causes partitions holding
files pointed to by symbolic links to be mounted.
.PP
If the \fBlistflags\fR shell variable is set to `x', `a' or `A', or any
combination thereof (e.g. `xA'), they are used as flags to \fIls\-F\fR,
making it act like `ls \-xF', `ls \-Fa', `ls \-FA' or a combination
(e.g. `ls \-FxA').
On machines where `ls \-C' is not the default, \fIls\-F\fR acts like `ls \-CF',
unless \fBlistflags\fR contains an `x', in which case it acts like `ls \-xF'.
\fIls\-F\fR passes its arguments to \fIls\fR(1) if it is given any switches,
so `alias ls ls\-F' generally does the right thing.
.PP
The \fBls\-F\fR builtin can list files using different colors depending on the
filetype or extension. See the \fBcolor\fR \fItcsh\fR variable and the
\fBLS_COLORS\fR environment variable.
.RE
.PP
.B migrate \fR[\fB\-\fIsite\fR] \fIpid\fR|\fB%\fIjobid\fR ... (+)
.PD 0
.TP 8
.B migrate \-\fIsite\fR (+)
The first form migrates the process or job to the site specified or the
default site determined by the system path.
The second form is equivalent to `migrate \-\fIsite\fR $$': it migrates the
current process to the specified site. Migrating the shell
itself can cause unexpected behavior, since the shell
does not like to lose its tty. (TCF only)
.PD
.TP 8
.B newgrp \fR[\fB\-\fR] \fIgroup\fR (+)
Equivalent to `exec newgrp'; see \fInewgrp\fR(1).
Available only if the shell was so compiled;
see the \fBversion\fR shell variable.
.TP 8
.B nice \fR[\fB+\fInumber\fR] [\fIcommand\fR]
Sets the scheduling priority for the shell to \fInumber\fR, or, without
\fInumber\fR, to 4. With \fIcommand\fR, runs \fIcommand\fR at the appropriate
priority.
The greater the \fInumber\fR, the less cpu
the process gets.  The super-user may specify negative
priority by using `nice \-number ...'.  Command is always
executed in a sub-shell, and the restrictions placed on
commands in simple \fIif\fR statements apply.
.TP 8
.B nohup \fR[\fIcommand\fR]
With \fIcommand\fR, runs \fIcommand\fR such that it will ignore hangup signals.
Note that commands may set their own response to hangups, overriding \fInohup\fR.
Without an argument (allowed only in a shell script), causes the shell to
ignore hangups for the remainder of the script.
See also \fBSignal handling\fR and the \fIhup\fR builtin command.
.TP 8
.B notify \fR[\fB%\fIjob\fR ...]
Causes the shell to notify the user asynchronously when the status of any
of the specified jobs (or, without %\fIjob\fR, the current job) changes,
instead of waiting until the next prompt as is usual.
\fIjob\fR may be a number, a string, `', `%', `+' or `\-' as described
under \fBJobs\fR.
See also the \fBnotify\fR shell variable.
.TP 8
.B onintr \fR[\fB\-\fR|\fIlabel\fR]
Controls the action of the shell on interrupts.  Without arguments,
restores the default action of the shell on interrupts,
which is to terminate shell scripts or to return to the
terminal command input level.
With `\-', causes all interrupts to be ignored.
With \fIlabel\fR, causes the shell to execute a `goto \fIlabel\fR'
when an interrupt is received or a child process terminates because it was
interrupted.
.IP "" 8
\fIonintr\fR is ignored if the shell is running detached and in system
startup files (see \fBFILES\fR), where interrupts are disabled anyway.
.TP 8
.B popd \fR[\fB\-p\fR] [\fB\-l\fR] [\fB\-n\fR|\fB\-v\fR] \fR[\fB+\fIn\fR]
Without arguments, pops the directory stack and returns to the new top directory.
With a number `+\fIn\fR', discards the \fIn\fR'th entry in the stack.
.IP "" 8
Finally, all forms of \fIpopd\fR print the final directory stack,
just like \fIdirs\fR. The \fBpushdsilent\fR shell variable can be set to
prevent this and the \fB\-p\fR flag can be given to override \fBpushdsilent\fR.
The \fB\-l\fR, \fB\-n\fR and \fB\-v\fR flags have the same effect on \fIpopd\fR
as on \fIdirs\fR. (+)
.TP 8
.B printenv \fR[\fIname\fR] (+)
Prints the names and values of all environment variables or,
with \fIname\fR, the value of the environment variable \fIname\fR.
.TP 8
.B pushd \fR[\fB\-p\fR] [\fB\-l\fR] [\fB\-n\fR|\fB\-v\fR] [\fIname\fR|\fB+\fIn\fR]
Without arguments, exchanges the top two elements of the directory stack.
If \fBpushdtohome\fR is set, \fIpushd\fR without arguments does `pushd ~',
like \fIcd\fR. (+)
With \fIname\fR, pushes the current working directory onto the directory
stack and changes to \fIname\fR.
If \fIname\fR is `\-' it is interpreted as the previous working directory
(see \fBFilename substitution\fR). (+)
If \fBdunique\fR is set, \fIpushd\fR removes any instances of \fIname\fR
from the stack before pushing it onto the stack. (+)
With a number `+\fIn\fR', rotates the \fIn\fRth element of the
directory stack around to be the top element and changes to it.
If \fBdextract\fR is set, however, `pushd +\fIn\fR' extracts the \fIn\fRth
directory, pushes it onto the top of the stack and changes to it. (+)
.IP "" 8
Finally, all forms of \fIpushd\fR print the final directory stack,
just like \fIdirs\fR. The \fBpushdsilent\fR shell variable can be set to
prevent this and the \fB\-p\fR flag can be given to override \fBpushdsilent\fR.
The \fB\-l\fR, \fB\-n\fR and \fB\-v\fR flags have the same effect on \fIpushd\fR
as on \fIdirs\fR. (+)
.TP 8
.B rehash
Causes the internal hash table of the contents of the
directories in the \fBpath\fR variable to be recomputed.  This is
needed if new commands are added to directories in \fBpath\fR
while you are logged in.  This should only be necessary if
you add commands to one of your own directories, or if a
systems programmer changes the contents of one of the
system directories. Also flushes the cache of home directories
built by tilde expansion.
.TP 8
.B repeat \fIcount command
The specified \fIcommand\fR,
which is subject to the same restrictions as the \fIcommand\fR
in the one line \fIif\fR statement above, is executed \fIcount\fR times.
I/O redirections occur exactly once, even if \fIcount\fR is 0.
.TP 8
.B rootnode //\fInodename \fR(+)
Changes the rootnode to //\fInodename\fR, so that `/' will be interpreted
as `//\fInodename\fR'. (Domain/OS only)
.PP
.B sched \fR(+)
.br
.B sched \fR[\fB+\fR]\fIhh:mm command\fR \fR(+)
.PD 0
.TP 8
.B sched \-\fIn\fR (+)
The first form prints the scheduled-event list.
The \fBsched\fR shell variable may be set to define the format in which
the scheduled-event list is printed.
The second form adds \fIcommand\fR to the scheduled-event list.
For example,
.PD
.RS +8
.IP "" 4
> sched 11:00 echo It\\'s eleven o\\'clock.
.PP
causes the shell to echo `It's eleven o'clock.' at 11 AM.
The time may be in 12-hour AM/PM format
.IP "" 4
> sched 5pm set prompt='[%h] It\\'s after 5; go home: >'
.PP
or may be relative to the current time:
.IP "" 4
> sched +2:15 /usr/lib/uucp/uucico \-r1 \-sother
.PP
A relative time specification may not use AM/PM format.
The third form removes item \fIn\fR from the event list:
.IP "" 4
> sched
.br
     1  Wed Apr  4 15:42  /usr/lib/uucp/uucico \-r1 \-sother
.br
     2  Wed Apr  4 17:00  set prompt=[%h] It's after 5; go home: >
.br
> sched \-2
.br
> sched
.br
     1  Wed Apr  4 15:42  /usr/lib/uucp/uucico \-r1 \-sother
.PP
A command in the scheduled-event list is executed just before the first
prompt is printed after the time when the command is scheduled.
It is possible to miss the exact time when the command is to be run, but 
an overdue command will execute at the next prompt.
A command which comes due while the shell
is waiting for user input is executed immediately.
However, normal operation of an already-running command will not
be interrupted so that a scheduled-event list element may be run.
.PP
This mechanism is similar to, but not the same as, the \fIat\fR(1)
command on some Unix systems.
Its major disadvantage is that it may not run a command at exactly the
specified time.
Its major advantage is that because \fIsched\fR runs directly from 
the shell, it has access to shell variables and other structures.
This provides a mechanism for changing one's working environment
based on the time of day.
.RE
.PP
.B set
.br
.B set \fIname\fR ... 
.br
.B set \fIname\fR\fB=\fIword\fR ...
.br
.B set [\-r] [\-f|\-l] \fIname\fR\fB=(\fIwordlist\fB)\fR ... (+)
.br
.B set \fIname[index]\fR\fB=\fIword\fR ...
.br
.B set \-r \fR(+)
.br
.B set \-r \fIname\fR ... (+)
.PD 0
.TP 8
.B set \-r \fIname\fR\fB=\fIword\fR ... (+)
The first form of the command prints the value of all shell variables.
Variables which contain more than a single word print as a
parenthesized word list.
The second form sets \fIname\fR to the null string.
The third form sets \fIname\fR to the single \fIword\fR. 
The fourth form sets \fIname\fR to the list of words in
\fIwordlist\fR. In all cases the value is command and filename expanded.
If \-r is specified, the value is set read-only. If \-f or \-l are
specified, set only unique words keeping their order.
\-f prefers the first occurrence of a word, and \-l the last.
first occurance of the word
The fifth form sets the \fIindex\fR'th component of name to \fIword\fR;
this component must already exist.
The sixth form lists the names (only) of all shell variables which are read-only.
The seventh form makes \fIname\fR read-only, whether or not it has a value.
The second form sets \fIname\fR to the null string.
The eighth form is the same as the third form, but
make \fIname\fR read-only at the same time.
.PD
.IP "" 8
These arguments can be repeated to set and/or make read-only multiple variables
in a single set command.  Note, however, that variable expansion
happens for all arguments before any setting occurs. Note also that `=' can
be adjacent to both \fIname\fR and \fIword\fR or separated from both by
whitespace, but cannot be adjacent to only one or the other.
See also the \fIunset\fR builtin command.
.TP 8
.B setenv \fR[\fIname \fR[\fIvalue\fR]]
Without arguments, prints the names and values of all environment variables.
Given \fIname\fR, sets the environment variable \fIname\fR to \fIvalue\fR
or, without \fIvalue\fR, to the null string.
.TP 8
.B setpath \fIpath \fR(+)
Equivalent to \fIsetpath\fR(1). (Mach only)
.TP 8
.B setspath\fR LOCAL|\fIsite\fR|\fIcpu\fR ... (+)
Sets the system execution path. (TCF only)
.TP 8
.B settc \fIcap value \fR(+)
Tells the shell to believe that the terminal capability \fIcap\fR
(as defined in \fItermcap\fR(5)) has the value \fIvalue\fR.
No sanity checking is done.
Concept terminal users may have to `settc xn no' to get proper
wrapping at the rightmost column.
.TP 8
.B setty \fR[\fB\-d\fR|\fB\-q\fR|\fB\-x\fR] [\fB\-a\fR] [[\fB+\fR|\fB\-\fR]\fImode\fR] (+)
Controls which tty modes (see \fBTerminal management\fR)
the shell does not allow to change.
\fB\-d\fR, \fB\-q\fR or \fB\-x\fR tells \fIsetty\fR to act
on the `edit', `quote' or `execute' set of tty modes respectively; without
\fB\-d\fR, \fB\-q\fR or \fB\-x\fR, `execute' is used.
.IP "" 8
Without other arguments, \fIsetty\fR lists the modes in the chosen set
which are fixed on (`+mode') or off (`\-mode').
The available modes, and thus the display, vary from system to system.
With \fB\-a\fR, lists all tty modes in the chosen set
whether or not they are fixed.
With \fB+\fImode\fR, \fB\-\fImode\fR or \fImode\fR, fixes \fImode\fR on or off
or removes control from \fImode\fR in the chosen set.
For example, `setty +echok echoe' fixes `echok' mode on and allows commands
to turn `echoe' mode on or off, both when the shell is executing commands.
.TP 8
.B setxvers\fR [\fIstring\fR] (+)
Set the experimental version prefix to \fIstring\fR, or removes it
if \fIstring\fR is omitted. (TCF only)
.TP 8
.B shift \fR[\fIvariable\fR]
Without arguments, discards \fBargv\fR[1] and shifts the members of
\fBargv\fR to the left. It is an error for \fBargv\fR not to be set or to have
less than one word as value. With \fIvariable\fR, performs the
same function on \fIvariable\fR.
.TP 8
.B source \fR[\fB\-h\fR] \fIname\fR [\fIargs\fR ...]
The shell reads and executes commands from \fIname\fR.
The commands are not placed on the history list.
If any \fIargs\fR are given, they are placed in \fBargv\fR. (+)
\fIsource\fR commands may be nested;
if they are nested too deeply the shell may run out of file descriptors.
An error in a \fIsource\fR at any level terminates all nested
\fIsource\fR commands.
With \fB\-h\fR, commands are placed on the history list instead of being
executed, much like `history \-L'.
.TP 8
.B stop \fB%\fIjob\fR|\fIpid\fR ...
Stops the specified jobs or processes which are executing in the background.
\fIjob\fR may be a number, a string, `', `%', `+' or `\-' as described
under \fBJobs\fR.
There is no default \fIjob\fR; saying just `stop' does not stop
the current job.
.TP 8
.B suspend
Causes the shell to stop in its tracks, much as if it had
been sent a stop signal with \fB^Z\fR. This is most often used to
stop shells started by \fIsu\fR(1).
.PP
.B switch (\fIstring\fB)
.br
.B case \fIstr1\fB:
.PD 0
.IP "" 4
\&...
.br
.B breaksw
.PP
\&...
.PP
.B default:
.IP "" 4
\&...
.br
.B breaksw
.TP 8
.B endsw
Each case label is successively matched, against the
specified \fIstring\fR which is first command and filename expanded.
The file metacharacters `*', `?' and `[...]'  may be used
in the case labels, which are variable expanded.  If none
of the labels match before a `default' label is found, then
the execution begins after the default label.  Each case
label and the default label must appear at the beginning of
a line.  The command \fIbreaksw\fR causes execution to continue
after the \fIendsw\fR. Otherwise control may fall through case
labels and default labels as in C.  If no label matches and
there is no default, execution continues after the \fIendsw\fR.
.PD
.TP 8
.B telltc \fR(+)
Lists the values of all terminal capabilities (see \fItermcap\fR(5)).
.TP 8
.B time \fR[\fIcommand\fR]
Executes \fIcommand\fR (which must be a simple command, not an alias,
a pipeline, a command list or a parenthesized command list)
and prints a time summary as described under the \fBtime\fR variable.
If necessary, an extra shell is created to print the time statistic when
the command completes.
Without \fIcommand\fR, prints a time summary for the current shell and its
children.
.TP 8
.B umask \fR[\fIvalue\fR]
Sets the file creation mask to \fIvalue\fR, which is given in octal.
Common values for the mask are
002, giving all access to the group and read and execute access to others, and
022, giving read and execute access to the group and others.
Without \fIvalue\fR, prints the current file creation mask.
.TP 8
.B unalias \fIpattern
.br
Removes all aliases whose names match \fIpattern\fR.
`unalias *' thus removes all aliases.
It is not an error for nothing to be \fIunalias\fRed.
.TP 8
.B uncomplete \fIpattern\fR (+)
Removes all completions whose names match \fIpattern\fR.
`uncomplete *' thus removes all completions.
It is not an error for nothing to be \fIuncomplete\fRd.
.TP 8
.B unhash
Disables use of the internal hash table to speed location of
executed programs.
.TP 8
.B universe \fIuniverse\fR (+)
Sets the universe to \fIuniverse\fR. (Masscomp/RTU only)
.TP 8
.B unlimit \fR[\fB\-h\fR] [\fIresource\fR]
Removes the limitation on \fIresource\fR or, if no \fIresource\fR is
specified, all \fIresource\fR limitations.
With \fB\-h\fR, the corresponding hard limits are removed.
Only the super-user may do this.
.TP 8
.B unset \fIpattern
Removes all variables whose names match \fIpattern\fR, unless they are read-only.
`unset *' thus removes all variables unless they are read-only;
this is a bad idea.
It is not an error for nothing to be \fIunset\fR.
.TP 8
.B unsetenv \fIpattern
Removes all environment variables whose names match \fIpattern\fR.
`unsetenv *' thus removes all environment variables;
this is a bad idea.
It is not an error for nothing to be \fIunsetenv\fRed.
.TP 8
.B ver \fR[\fIsystype\fR [\fIcommand\fR]] (+)
Without arguments, prints \fBSYSTYPE\fR. With \fIsystype\fR, sets \fBSYSTYPE\fR
to \fIsystype\fR. With \fIsystype\fR and \fIcommand\fR, executes \fIcommand\fR
under \fIsystype\fR. \fIsystype\fR may be `bsd4.3' or `sys5.3'.
(Domain/OS only)
.TP 8
.B wait
The shell waits for all background jobs.  If the shell is interactive, an
interrupt will disrupt the wait and cause the shell to print the names and job
numbers of all outstanding jobs.
.TP 8
.B warp \fIuniverse\fR (+)
Sets the universe to \fIuniverse\fR. (Convex/OS only)
.TP 8
.B watchlog \fR(+)
An alternate name for the \fIlog\fR builtin command (q.v.).
Available only if the shell was so compiled;
see the \fBversion\fR shell variable.
.TP 8
.B where \fIcommand\fR (+)
Reports all known instances of \fIcommand\fR, including aliases, builtins and
executables in \fBpath\fR.
.TP 8
.B which\fR \fIcommand\fR (+)
Displays the command that will be executed by the shell after substitutions,
\fBpath\fR searching, etc.
The builtin command is just like \fIwhich\fR(1), but it correctly reports
\fItcsh\fR aliases and builtins and is 10 to 100 times faster.
See also the \fIwhich-command\fR editor command.
.PP
.B while (\fIexpr\fB)\fR
.br
\&...
.PD 0
.TP 8
.B end
Executes the commands between the \fIwhile\fR and the matching \fIend\fR
while \fIexpr\fR (an expression, as described under \fBExpressions\fR)
evaluates non-zero.
\fIwhile\fR and \fIend\fR must appear alone on their input lines.
\fIbreak\fR and \fIcontinue\fR may be used to terminate or continue the
loop prematurely.
If the input is a terminal, the user is prompted the first time
through the loop as with \fIforeach\fR.
.PD
.SS "Special aliases (+)"
If set, each of these aliases executes automatically at the indicated time.
They are all initially undefined.
.TP 8
.B beepcmd
Runs when the shell wants to ring the terminal bell. 
.TP 8
.B cwdcmd 
Runs after every change of working directory. For example, if the user is
working on an X window system using \fIxterm\fR(1) and a re-parenting window
manager that supports title bars such as \fItwm\fR(1) and does
.RS +8
.IP "" 4
> alias cwdcmd  'echo \-n "^[]2;${HOST}:$cwd ^G"'
.PP
then the shell will change the title of the running \fIxterm\fR(1)
to be the name of the host, a colon, and the full current working directory.  
A fancier way to do that is
.IP "" 4
> alias cwdcmd 'echo \-n "^[]2;${HOST}:$cwd^G^[]1;${HOST}^G"'
.PP
This will put the hostname and working directory on the title bar but
only the hostname in the icon manager menu.
.PP
Note that putting a \fIcd\fR, \fIpushd\fR or \fIpopd\fR in \fIcwdcmd\fR
may cause an infinite loop. It is the author's opinion that anyone doing
so will get what they deserve.
.RE
.TP 8
.B periodic 
Runs every \fBtperiod\fR minutes. This provides a convenient means for
checking on common but infrequent changes such as new mail. For example,
if one does
.RS +8
.IP "" 4
> set tperiod = 30
.br
> alias periodic checknews
.PP
then the \fIchecknews\fR(1) program runs every 30 minutes.
If \fIperiodic\fR is set but \fBtperiod\fR is unset or set to 0,
\fIperiodic\fR behaves like \fIprecmd\fR.
.RE
.TP 8
.B precmd 
Runs just before each prompt is printed. For example, if one does
.RS +8
.IP "" 4
> alias precmd date
.PP
then \fIdate\fR(1) runs just before the shell prompts for each command.
There are no limits on what \fIprecmd\fR can be set to do, but discretion
should be used.
.RE
.TP 8
.B shell
Specifies the interpreter for executable scripts which do not themselves
specify an interpreter. The first word should be a full path name to the
desired interpreter (e.g. `/bin/csh' or `/usr/local/bin/tcsh').
.SS "Special shell variables"
The variables described in this section have special meaning to the shell.
.PP
The shell sets \fBaddsuffix\fR, \fBargv\fR, \fBautologout\fR, \fBcommand\fR, \fBecho_style\fR,
\fBedit\fR, \fBgid\fR, \fBgroup\fR, \fBhome\fR, \fBloginsh\fR, \fBoid\fR, \fBpath\fR,
\fBprompt\fR, \fBprompt2\fR, \fBprompt3\fR, \fBshell\fR, \fBshlvl\fR,
\fBtcsh\fR, \fBterm\fR, \fBtty\fR, \fBuid\fR, \fBuser\fR and \fBversion\fR at
startup; they do not change thereafter unless changed by the user. The shell
updates \fBcwd\fR, \fBdirstack\fR, \fBowd\fR and \fBstatus\fR when necessary,
and sets \fBlogout\fR on logout.
.PP
The shell synchronizes \fBafsuser\fR, \fBgroup\fR, \fBhome\fR, \fBpath\fR, \fBshlvl\fR,
\fBterm\fR and \fBuser\fR with the environment variables of the same names:
whenever the environment variable changes the shell changes the corresponding
shell variable to match (unless the shell variable is read-only) and vice
versa. Note that although \fBcwd\fR and \fBPWD\fR have identical meanings, they
are not synchronized in this manner, and that the shell automatically
interconverts the different formats of \fBpath\fR and \fBPATH\fR.
.TP 8
.B addsuffix \fR(+)
If set, filename completion adds `/' to the end of directories and a space
to the end of normal files when they are matched exactly.
Set by default.
.TP 8
.B afsuser \fR(+)
If set, \fBautologout\fR's autolock feature uses its value instead of
the local username for kerberos authentication.
.TP 8
.B ampm \fR(+)
If set, all times are shown in 12-hour AM/PM format.
.TP 8
.B argv
The arguments to the shell. Positional parameters are taken from \fBargv\fR,
i.e. `$1' is replaced by `$argv[1]', etc.
Set by default, but usually empty in interactive shells.
.TP 8
.B autocorrect \fR(+)
If set, the \fIspell-word\fR editor command is invoked automatically before
each completion attempt.
.TP 8
.B autoexpand \fR(+)
If set, the \fIexpand-history\fR editor command is invoked automatically
before each completion attempt.
.TP 8
.B autolist \fR(+)
If set, possibilities are listed after an ambiguous completion.
If set to `ambiguous', possibilities are listed only when no new
characters are added by completion.
.TP 8
.B autologout \fR(+)
The first word is the number of minutes of inactivity before automatic
logout. The optional second word is the number of minutes of inactivity
before automatic locking.
When the shell automatically logs out,
it prints `auto-logout', sets the variable logout to `automatic' and exits.
When the shell automatically locks, the user is required to enter his password
to continue working. Five incorrect attempts result in automatic logout.
Set to `60' (automatic logout after 60 minutes, and no locking) by default
in login and superuser shells, but not if the shell thinks it is running
under a window system (i.e. the \fBDISPLAY\fR environment variable is set),
the tty is a pseudo-tty (pty) or the shell was not so compiled (see the
\fBversion\fR shell variable).
See also the \fBafsuser\fR and \fBlogout\fR shell variables.
.TP 8
.B backslash_quote \fR(+)
If set, backslashes (`\\') always quote `\\', `'', and `"'. This may make
complex quoting tasks easier, but it can cause syntax errors in \fIcsh\fR(1)
scripts.
.TP 8
.B cdpath
A list of directories in which \fIcd\fR should search for
subdirectories if they aren't found in the current directory.
.TP 8
.B color
If set, it enables color display for the builtin \fBls\-F\fR and it passes
\fB\-\-color=auto\fR to \fBls\fR. Alternatively, it can be set to only
\fBls\-F\fR or only \fBls\fR to enable color only to one command. Setting
it to nothing is equivalent to setting it to \fB(ls\-F ls)\fR.
.TP 8
.B command \fR(+)
If set, the command which was passed to the shell with the \fB-c\fR flag (q.v.).
.TP 8
.B complete \fR(+)
If set to `enhance', completion 1) ignores case and 2) considers
periods, hyphens and underscores (`.', `\-' and `_') to be word
separators and hyphens and underscores to be equivalent.
.TP 8
.B correct \fR(+)
If set to `cmd', commands are automatically spelling-corrected.
If set to `complete', commands are automatically completed.
If set to `all', the entire command line is corrected.
.TP 8
.B cwd
The full pathname of the current directory.
See also the \fBdirstack\fR and \fBowd\fR shell variables.
.TP 8
.B dextract \fR(+)
If set, `pushd +\fIn\fR' extracts the \fIn\fRth directory from the directory
stack rather than rotating it to the top.
.TP 8
.B dirsfile \fR(+)
The default location in which `dirs \-S' and `dirs \-L' look for
a history file. If unset, \fI~/.cshdirs\fR is used.
Because only \fI~/.tcshrc\fR is normally sourced before \fI~/.cshdirs\fR,
\fBdirsfile\fR should be set in \fI~/.tcshrc\fR rather than \fI~/.login\fR.
.TP 8
.B dirstack \fR(+)
An array of all the directories on the directory stack.
`$dirstack[1]' is the current working directory, `$dirstack[2]'
the first directory on the stack, etc.
Note that the current working directory is `$dirstack[1]' but `=0' in
directory stack substitutions, etc.
One can change the stack arbitrarily by setting \fBdirstack\fR,
but the first element (the current working directory) is always correct.
See also the \fBcwd\fR and \fBowd\fR shell variables.
.TP 8
.B dspmbyte \fR(+)
If set to `euc', it enables display and editing EUC-kanji(japanese) code.
If set to `sjis', it enables display and editing Shift-JIS(japanese) code.
If set to following format, it enables display and editing original multi-byte code format:
.RS +8
.IP "" 4
> set dspkanji = 0000....(256 bytes)....0000
.PP
table length require \fBjust\fR 256 byte. Each character of 256 characters corresponds from the left from 0x01,0x02... to 0xff of ASCII code. Each character is set to number 0,1,2 and 3. Each number has the following meanings:
  0 ... not use for multi-byte character.
  1 ... use for first byte of multi-byte charcter.
  2 ... use for second byte of multi-byte character.
  3 ... use for both of first byte and second byte of multi-byte character.
  Exapmle:
    if set `001322', first character(means 0x00 of ASCII code) and second character(means 0x01 of ASCII code) is set to `0'. then, it is not use for multi-byte character.3rd character(0x02) is set '2'. it is use for first byte of multi-byte charcter. 4th character(0x03) is set '3'. it is use for both of first byte and second byte of multi-byte character. 5th and 6th character(0x04,0x05) is set '2'. it is use for second byte of multi-byte charcter.
.RE
.TP 8
.B dunique \fR(+)
If set, \fIpushd\fR removes any instances of \fIname\fR
from the stack before pushing it onto the stack.
.TP 8
.B echo
If set, each command with its arguments is echoed just before it is
executed.  For non-builtin commands all expansions occur before
echoing.  Builtin commands are echoed before command and filename
substitution, since these substitutions are then done selectively.
Set by the \fB\-x\fR command line option.
.TP 8
.B echo_style \fR(+)
The style of the \fIecho\fR builtin. May be set to
.PP
.RS +8
.PD 0
.TP 8
bsd
Don't echo a newline if the first argument is `\-n'.
.TP 8
sysv
Recognize backslashed escape sequences in echo strings.
.TP 8
both
Recognize both the `\-n' flag and backslashed escape sequences; the default.
.TP 8
none
Recognize neither.
.PD
.PP
Set by default to the local system default. The BSD and System V
options are described in the \fIecho\fR(1) manpages on the appropriate
systems.
.RE
.TP 8
.B edit \fR(+)
If set, the command-line editor is used.  Set by default in interactive
shells.
.TP 8
.B ellipsis \fR(+)
If set, the `%c'/`%.' and `%C' prompt sequences (see the \fBprompt\fR
shell variable) indicate skipped directories with an ellipsis (`...')
instead of `/<skipped>'.
.TP 8
.B fignore \fR(+)
Lists file name suffixes to be ignored by completion.
.TP 8
.B filec
In \fItcsh\fR, completion is always used and this variable is ignored.
If set in \fIcsh\fR, filename completion is used.
.TP 8
.B gid \fR(+)
The user's real group ID.
.TP 8
.B group \fR(+)
The user's group name.
.TP 8
.B histchars
A string value determining the characters used in \fBHistory
substitution\fR (q.v.).  The first character of its value is used as
the history substitution character, replacing the default character
`!'.  The second character of its value replaces the character `^' in
quick substitutions.
.TP 8
.B histdup \fR(+)
Controls handling of duplicate entries in the history list.  If set to
`all' only unique history events are entered in the history list. If
set to `prev' and the last history event is the same as the current
command, then the current command is not entered in the history.  If
set to `erase' and the same event is found in the history list, that
old event gets erased and the current one gets inserted. Note that the
`prev' and `all' options renumber history events so there are no gaps.
.TP 8
.B histfile \fR(+)
The default location in which `history \-S' and `history \-L' look for
a history file. If unset, \fI~/.history\fR is used.  \fBhistfile\fR is
useful when sharing the same home directory between different machines,
or when saving separate histories on different terminals.  Because only
\fI~/.tcshrc\fR is normally sourced before \fI~/.history\fR,
\fBhistfile\fR should be set in \fI~/.tcshrc\fR rather than
\fI~/.login\fR.
.TP 8
.B histlit \fR(+)
If set, builtin and editor commands and the \fBsavehist\fR mechanism
use the literal (unexpanded) form of lines in the history list.  See
also the \fItoggle-literal-history\fR editor command.
.TP 8
.B history
The first word indicates the number of history events to save.  The
optional second word (+) indicates the format in which history is
printed; if not given, `%h\\t%T\\t%R\\n' is used.  The format sequences
are described below under \fBprompt\fR; note the variable meaning of
`%R'.  Set to `100' by default.
.TP 8
.B home
Initialized to the home directory of the invoker.  The filename
expansion of `\fI~\fR' refers to this variable.
.TP 8
.B ignoreeof
If set to the empty string or `0' and the input device is a terminal,
the \fIend-of-file\fR command (usually generated by the user by typing
`^D' on an empty line) causes the shell to print `Use "exit" to leave
tcsh.' instead of exiting.  This prevents the shell from accidentally
being killed.  If set to a number \fIn\fR, the shell ignores \fIn\fR -
1 consecutive \fIend-of-file\fRs and exits on the \fIn\fRth. (+) If
unset, `1' is used, i.e. the shell exits on a single `^D'.
.TP 8
.B implicitcd \fR(+)
If set, the shell treats a directory name typed as a command as though
it were a request to change to that directory. If set to \fIverbose\fR,
the change of directory is echoed to the standard output. This behavior
is inhibited in non-interactive shell scripts, or for command strings
with more than one word. Changing directory takes precedence over
executing a like-named command, but it is done after alias
substitutions. Tilde and variable expansions work as expected.
.TP 8
.B inputmode \fR(+)
If set to `insert' or `overwrite', puts the editor into that input mode
at the beginning of each line.
.TP 8
.B listflags \fR(+)
If set to `x', `a' or `A', or any combination thereof (e.g. `xA'), they
are used as flags to \fIls\-F\fR, making it act like `ls \-xF', `ls
\-Fa', `ls \-FA' or a combination (e.g. `ls \-FxA'): `a' shows all
files (even if they start with a `.'), `A' shows all files but `.' and
`..', and `x' sorts across instead of down.  If the second word of
\fBlistflags\fR is set, it is used as the path to `ls(1)'.
.TP 8
.B listjobs \fR(+)
If set, all jobs are listed when a job is suspended. If set to `long',
the listing is in long format.
.TP 8
.B listlinks \fR(+)
If set, the \fIls\-F\fR builtin command shows the type of file to which
each symbolic link points.
.TP 8
.B listmax \fR(+)
The maximum number of items which the \fIlist-choices\fR editor command
will list without asking first.
.TP 8
.B listmaxrows \fR(+)
The maximum number of rows of items which the \fIlist-choices\fR editor
command will list without asking first.
.TP 8
.B loginsh \fR(+)
Set by the shell if it is a login shell.  Setting or unsetting it
within a shell has no effect.  See also \fBshlvl\fR.
.TP 8
.B logout \fR(+)
Set by the shell to `normal' before a normal logout, `automatic' before
an automatic logout, and `hangup' if the shell was killed by a hangup
signal (see \fBSignal handling\fR).  See also the \fBautologout\fR
shell variable.
.TP 8
.B mail
The names of the files or directories to check for incoming mail,
separated by whitespace, and optionally preceeded by a numeric word.
Before each prompt, if 10 minutes have passed since the last check, the
shell checks each file and says `You have new mail.' (or, if \fBmail\fR
contains multiple files, `You have new mail in \fIname\fR.') if the
filesize is greater than zero in size and has a modification time
greater than its access time.
.PP
.RS +8
.PD
.PP
If you are in a login shell, then no mail file is reported unless it has
been modified after the time the shell has started up, in order to prevent
redundant notifications.  Most login programs will tell you whether or not
you have mail when you log in.
.PP
If a file specified in \fBmail\fR is a directory, the shell will count each
file within that directory as a separate message, and will report `You have
\fIn\fR mails.' or `You have \fIn\fR mails in \fIname\fR.' as appropriate.
This functionality is provided primarily for those systems which store mail
in this manner, such as the Andrew Mail System.
.PP
If the first word of \fBmail\fR is numeric it is taken as a different mail
checking interval, in seconds.
.PP
Under very rare circumstances, the shell may report `You have mail.' instead
of `You have new mail.'
.RE
.TP 8
.B matchbeep \fR(+)
If set to `never', completion never beeps.
If set to `nomatch', it beeps only when there is no match.
If set to `ambiguous, it beeps when there are multiple matches.
If set to `notunique', it beeps when there is one exact and other longer matches.
If unset, `ambiguous' is used.
.TP 8
.B nobeep \fR(+)
If set, beeping is completely disabled.
See also \fBvisiblebell\fR.
.TP 8
.B noclobber
If set, restrictions are placed on output redirection to insure that files
are not accidentally destroyed and that `>>' redirections refer to existing
files, as described in the \fBInput/output\fR section.
.TP 8
.B noglob
If set, \fBFilename substitution\fR and \fBDirectory stack substitution\fR
(q.v.) are inhibited.  This is most useful in shell scripts which do not deal
with filenames, or after a list of filenames has been obtained and further
expansions are not desirable.
.TP 8
.B nokanji \fR(+)
If set and the shell supports Kanji (see the \fBversion\fR shell variable),
it is disabled so that the meta key can be used.
.TP 8
.B nonomatch
If set, a \fBFilename substitution\fR or \fBDirectory stack substitution\fR
(q.v.) which does not match any
existing files is left untouched rather than causing an error.
It is still an error for the substitution to be
malformed, e.g. `echo [' still gives an error.
.TP 8
.B nostat \fR(+)
A list of directories (or glob-patterns which match directories; see
\fBFilename substitution\fR) that should not be \fIstat\fR(2)ed during a
completion operation. This is usually used to exclude directories which
take too much time to \fIstat\fR(2), for example \fI/afs\fR.
.TP 8
.B notify
If set, the shell announces job completions asynchronously.
The default is to present job completions just before printing a prompt.
.TP 8
.B oid \fR(+)
The user's real organization ID. (Domain/OS only)
.TP 8
.B owd \fR(+)
The old working directory, equivalent to the `\-' used by \fIcd\fR and \fIpushd\fR.
See also the \fBcwd\fR and \fBdirstack\fR shell variables.
.TP 8
.B path
A list of directories in which to look for executable commands.
A null word specifies the current directory.
If there is no \fBpath\fR variable then only full path names will execute.
\fBpath\fR is set by the shell at startup from the \fBPATH\fR environment
variable or, if \fBPATH\fR does not exist, to a system-dependent default
something like `(/usr/local/bin /usr/bsd /bin /usr/bin .)'.
The shell may put `.' first or last in \fBpath\fR or omit it entirely
depending on how it was compiled; see the \fBversion\fR shell variable.
A shell which is given neither the \fB\-c\fR nor the \fB\-t\fR option
hashes the contents of the directories in \fBpath\fR after
reading \fI~/.tcshrc\fR and each time \fBpath\fR is reset.
If one adds a new command to a directory in \fBpath\fR while the shell
is active, one may need to do a \fIrehash\fR for the shell to find it.
.TP 8
.B printexitvalue \fR(+)
If set and an interactive program exits with a non-zero status, the shell
prints `Exit \fBstatus\fR'.
.TP 8
.B prompt
The string which is printed before reading each command from the terminal.
\fBprompt\fR may include any of the following formatting sequences (+), which
are replaced by the given information:
.PP
.RS +8
.PD 0
.TP 4
%/
The current working directory.
.TP 4
%~
The current working directory, but with one's home directory
represented by `~' and other users' home directories represented by
`~user' as per \fBFilename substitution\fR. `~user' substitution
happens only if the shell has already used `~\fIuser\fR' in a pathname
in the current session.
.TP 4
%c[[0]\fIn\fR], %.[[0]\fIn\fR]
The trailing component of the current working directory, or \fIn\fR
trailing components if a digit \fIn\fR is given.
If \fIn\fR begins with `0', the number of skipped components precede
the trailing component(s) in the format `/<\fIskipped\fR>trailing'.
If the \fBellipsis\fR shell variable is set, skipped components
are represented by an ellipsis so the whole becomes `...trailing'.
`~' substitution is done as in `%~' above, but the `~' component
is ignored when counting trailing components.
.TP 4
%C
Like %c, but without `~' substitution.
.TP 4
%h, %!, !
The current history event number.
.TP 4
%M
The full hostname.
.TP 4
%m
The hostname up to the first `.'.
.TP 4
%S (%s)
Start (stop) standout mode.
.TP 4
%B (%b)
Start (stop) boldfacing mode.
.TP 4
%U (%u)
Start (stop) underline mode.
.TP 4
%t, %@
The time of day in 12-hour AM/PM format.
.TP 4
%T
Like `%t', but in 24-hour format (but see the \fBampm\fR shell variable).
.TP 4
%p
The `precise' time of day in 12-hour AM/PM format, with seconds.
.TP 4
%P
Like `%p', but in 24-hour format (but see the \fBampm\fR shell variable).
.TP 4
\e\fIc\fR
\fIc\fR is parsed as in \fIbindkey\fR.
.TP 4
^\fIc\fR
\fIc\fR is parsed as in \fIbindkey\fR.
.TP 4
%%
A single `%'.
.TP 4
%n
The user name.
.TP 4
%d
The weekday in `Day' format.
.TP 4
%D
The day in `dd' format.
.TP 4
%w
The month in `Mon' format.
.TP 4
%W
The month in `mm' format.
.TP 4
%y
The year in `yy' format.
.TP 4
%Y
The year in `yyyy' format.
.TP 4
%l
The shell's tty.
.TP 4
%L
Clears from the end of the prompt to end of the display or the end of the line.
.TP 4
%$
Expands the shell or environment variable name immediately after the `$'.
.TP 4
%#
`>' (or the first character of the \fBpromptchars\fR shell variable)
for normal users, `#' (or the second character of \fBpromptchars\fR)
for the superuser.
.TP 4
%{\fIstring\fR%}
Includes \fIstring\fR as a literal escape sequence.
It should be used only to change terminal attributes and
should not move the cursor location. This
cannot be the last sequence in \fBprompt\fR.
.TP 4
%?
The return code of the command executed just before the prompt.
.TP 4
%R
In \fBprompt2\fR, the status of the parser.
In \fBprompt3\fR, the corrected string.
In \fBhistory\fR, the history string.
.PD
.PP
`%B', `%S', `%U' and `%{\fIstring\fR%}' are available only in
eight-bit-clean shells; see the \fBversion\fR shell variable.
.PP
The bold, standout and underline sequences are often used to distinguish a
superuser shell. For example,
.IP "" 4
> set prompt = "%m [%h] %B[%@]%b [%/] you rang? "
.br
tut [37] \fB[2:54pm]\fR [/usr/accts/sys] you rang? _
.PP
Set by default to `%# ' in interactive shells.
.RE
.TP 8
.B prompt2 \fR(+)
The string with which to prompt in \fIwhile\fR and \fIforeach\fR loops and
after lines ending in `\\'.
The same format sequences may be used as in \fBprompt\fR (q.v.);
note the variable meaning of `%R'.
Set by default to `%R? ' in interactive shells.
.TP 8
.B prompt3 \fR(+)
The string with which to prompt when confirming automatic spelling correction.
The same format sequences may be used as in \fBprompt\fR (q.v.);
note the variable meaning of `%R'.
Set by default to `CORRECT>%R (y|n|e|a)? ' in interactive shells.
.TP 8
.B promptchars \fR(+)
If set (to a two-character string), the `%#' formatting sequence in the
\fBprompt\fR shell variable is replaced with the first character for
normal users and the second character for the superuser.
.TP 8
.B pushdtohome \fR(+)
If set, \fIpushd\fR without arguments does `pushd ~', like \fIcd\fR.
.TP 8
.B pushdsilent \fR(+)
If set, \fIpushd\fR and \fIpopd\fR do not print the directory stack.
.TP 8
.B recexact \fR(+)
If set, completion completes on an exact match even if a longer match is
possible.
.TP 8
.B recognize_only_executables \fR(+)
If set, command listing displays only files in the path that are
executable. Slow.
.TP 8
.B rmstar \fR(+)
If set, the user is prompted before `rm *' is executed.
.TP 8
.B rprompt \fR(+)
The string to print on the right-hand side of the screen (after
the command input) when the prompt is being displayed on the left.
It recognises the same formatting characters as \fBprompt\fR.
It will automatically disappear and reappear as necessary, to ensure that
command input isn't obscured, and will only appear if the prompt,
command input, and itself will fit together on the first line.
If \fBedit\fR isn't set, then \fBrprompt\fR will be printed after
the prompt and before the command input.
.TP 8
.B savedirs \fR(+)
If set, the shell does `dirs \-S' before exiting.
.TP 8
.B savehist
If set, the shell does `history \-S' before exiting.
If the first word is set to a number, at most that many lines are saved.
(The number must be less than or equal to \fBhistory\fR.)
If the second word is set to `merge', the history list is merged with
the existing history file instead of replacing it (if there is one) and
sorted by time stamp and the most recent events are retained. (+)
.TP 8
.B sched \fR(+)
The format in which the \fIsched\fR builtin command prints scheduled events;
if not given, `%h\\t%T\\t%R\\n' is used.
The format sequences are described above under \fBprompt\fR;
note the variable meaning of `%R'.
.TP 8
.B shell
The file in which the shell resides.  This is used in forking
shells to interpret files which have execute bits set, but
which are not executable by the system.  (See the description
of \fBBuiltin and non-builtin command execution\fR.)  Initialized to the
(system-dependent) home of the shell.
.TP 8
.B shlvl \fR(+)
The number of nested shells.
Reset to 1 in login shells.
See also \fBloginsh\fR.
.TP 8
.B status
The status returned by the last command.  If it terminated
abnormally, then 0200 is added to the status.  Builtin commands
which fail return exit status `1', all other builtin commands
return status `0'.
.TP 8
.B symlinks \fR(+)
Can be set to several different values to control symbolic link (`symlink')
resolution:
.RS +8
.PP
If set to `chase', whenever the current directory changes to a directory
containing a symbolic link, it is expanded to the real name of the directory
to which the link points. This does not work for the user's home directory;
this is a bug.
.PP
If set to `ignore', the shell tries to construct a current directory
relative to the current directory before the link was crossed.
This means that \fIcd\fRing through a symbolic link and then `cd ..'ing
returns one to the original directory. This only affects builtin commands
and filename completion.
.PP
If set to `expand', the shell tries to fix symbolic links by actually expanding
arguments which look like path names. This affects any command, not just
builtins. Unfortunately, this does not work for hard-to-recognize filenames,
such as those embedded in command options. Expansion may be prevented by
quoting. While this setting is usually the most convenient, it is sometimes
misleading and sometimes confusing when it fails to recognize an argument
which should be expanded. A compromise is to use `ignore' and use the
editor command \fInormalize-path\fR (bound by default to ^X-n) when necessary.
.PP
Some examples are in order. First, let's set up some play directories:
.IP "" 4
> cd /tmp
.br
> mkdir from from/src to
.br
> ln \-s from/src to/dist
.PP
Here's the behavior with \fBsymlinks\fR unset,
.IP "" 4
> cd /tmp/to/dist; echo $cwd 
.br
/tmp/to/dist
.br
> cd ..; echo $cwd
.br
/tmp/from
.PP
here's the behavior with \fBsymlinks\fR set to `chase',
.IP "" 4
> cd /tmp/to/dst; echo $cwd
.br
/tmp/from/src
.br
> cd ..; echo $cwd
.br
/tmp/from
.PP
here's the behavior with \fBsymlinks\fR set to `ignore',
.IP "" 4
> cd /tmp/to/dist; echo $cwd
.br
/tmp/to/dst
.br
> cd ..; echo $cwd
.br
/tmp/to
.PP
and here's the behavior with \fBsymlinks\fR set to `expand'.
.IP "" 4
> cd /tmp/to/dist; echo $cwd
.br
/tmp/to/dst
.br
> cd ..; echo $cwd
.br
/tmp/to
.br
> cd /tmp/to/dist; echo $cwd
.br
/tmp/to/dst
.br
> cd ".."; echo $cwd
.br
/tmp/from
.br
> /bin/echo ..
.br
/tmp/to
.br
> /bin/echo ".."
.br
\&..
.PP
Note that `expand' expansion 1) works just like `ignore' for builtins
like \fIcd\fR, 2) is prevented by quoting, and 3) happens before
filenames are passed to non-builtin commands.
.RE
.TP 8
.B tcsh \fR(+)
The version number of the shell in the format `R.VV.PP',
where `R' is the major release number, `VV' the current version
and `PP' the patchlevel.
.TP 8
.B term 
The terminal type. Usually set in \fI~/.login\fR as described under
\fBStartup and shutdown\fR.
.TP 8
.B time
If set to a number, then the \fItime\fR builtin (q.v.) executes automatically
after each command which takes more than that many CPU seconds.
If there is a second word, it is used as a format string for the output
of the \fItime\fR builtin. (u) The following sequences may be used in the
format string:
.PP
.RS +8
.PD 0
.TP 4
%U
The time the process spent in user mode in cpu seconds.
.TP 4
%S
The time the process spent in kernel mode in cpu seconds.
.TP 4
%E
The elapsed (wall clock) time in seconds.
.TP 4
%P
The CPU percentage computed as (%U + %S) / %E.
.TP 4
%W
Number of times the process was swapped.
.TP 4
%X
The average amount in (shared) text space used in Kbytes.
.TP 4
%D
The average amount in (unshared) data/stack space used in Kbytes.
.TP 4
%K
The total space used (%X + %D) in Kbytes.
.TP 4
%M
The maximum memory the process had in use at any time in Kbytes.
.TP 4
%F
The number of major page faults (page needed to be brought from disk).
.TP 4
%R
The number of minor page faults.
.TP 4
%I
The number of input operations.
.TP 4
%O
The number of output operations.
.TP 4
%r
The number of socket messages received.
.TP 4
%s
The number of socket messages sent.
.TP 4
%k
The number of signals received.
.TP 4
%w
The number of voluntary context switches (waits).
.TP 4
%c
The number of involuntary context switches.
.PD
.PP
Only the first four sequences are supported on systems without BSD resource
limit functions.
The default time format is `%Uu %Ss %E %P %X+%Dk %I+%Oio %Fpf+%Ww' for
systems that support resource usage reporting and `%Uu %Ss %E %P' for
systems that do not.
.PP
Under Sequent's DYNIX/ptx, %X, %D, %K, %r and %s are not
available, but the following additional sequences are:
.PP
.PD 0
.TP 4
%Y
The number of system calls performed.
.TP 4
%Z
The number of pages which are zero-filled on demand.
.TP 4
%i
The number of times a process's resident set size was increased by the kernel.
.TP 4
%d
The number of times a process's resident set size was decreased by the kernel.
.TP 4
%l
The number of read system calls performed.
.TP 4
%m
The number of write system calls performed.
.TP 4
%p
The number of reads from raw disk devices.
.TP 4
%q
The number of writes to raw disk devices.
.PD
.PP
and the default time format is `%Uu %Ss $E %P %I+%Oio %Fpf+%Ww'.
Note that the CPU percentage can be higher than 100% on multi-processors.
.RE
.TP 8
.B tperiod \fR(+)
The period, in minutes, between executions of the \fIperiodic\fR special alias.
.TP 8
.B tty \fR(+)
The name of the tty, or empty if not attached to one.
.TP 8
.B uid \fR(+)
The user's real user ID.
.TP 8
.B user
The user's login name.
.TP 8
.B verbose
If set, causes the words of each
command to be printed, after history substitution (if any).
Set by the \fB\-v\fR command line option.
.TP 8
.B version \fR(+)
The version ID stamp. It contains the shell's version number (see \fBtcsh\fR),
origin, release date, vendor, operating system and machine (see \fBVENDOR\fR, 
\fBOSTYPE\fR and \fBMACHTYPE\fR) and a comma-separated
list of options which were set at compile time.
Options which are set by default in the distribution are noted.
.PP
.RS +8
.PD 0
.TP 4
8b
The shell is eight bit clean; default
.TP 4
7b
The shell is not eight bit clean
.TP 4
nls
The system's NLS is used; default for systems with NLS
.TP 4
lf
Login shells execute \fI/etc/csh.login\fR before instead of after
\fI/etc/csh.cshrc\fR and \fI~/.login\fR before instead of after
\fI~/.tcshrc\fR and \fI~/.history\fR.
.TP 4
dl
`.' is put last in \fBpath\fR for security; default
.TP 4
nd
`.' is omitted from \fBpath\fR for security
.TP 4
vi
\fIvi\fR-style editing is the default rather than \fIemacs\fR
.TP 4
dtr
Login shells drop DTR when exiting
.TP 4
bye
\fIbye\fR is a synonym for \fIlogout\fR and \fIlog\fR
is an alternate name for \fIwatchlog\fR
.TP 4
al
\fBautologout\fR is enabled; default
.TP 4
kan
Kanji is used and the ISO character set is ignored,
unless the \fBnokanji\fR shell variable is set
.TP 4
sm
The system's \fImalloc\fR(3) is used
.TP 4
hb
The `#!<program> <args>' convention is emulated when executing shell scripts
.TP 4
ng
The \fInewgrp\fR builtin is available
.TP 4
rh
The shell attempts to set the \fBREMOTEHOST\fR environment variable
.TP 4
afs
The shell verifies your password with the kerberos server if local
authentication fails. The \fBafsuser\fR shell variable or the
\fBAFSUSER\fR environment variable override your local username if set.
.PD
.PP
An administrator may enter additional strings to indicate differences
in the local version.
.RE
.TP 8
.B visiblebell \fR(+)
If set, a screen flash is used rather than the audible bell.
See also \fBnobeep\fR.
.TP 8
.B watch \fR(+)
A list of user/terminal pairs to watch for logins and logouts.
If either the user is `any' all terminals are watched for the given user
and vice versa.
Setting \fBwatch\fR to `(any any)' watches all users and terminals.
For example,
.RS +8
.IP "" 4
set watch = (george ttyd1 any console $user any)
.PP
reports activity of the user `george' on ttyd1, any user on the console, and
oneself (or a trespasser) on any terminal.
.PP
Logins and logouts are checked every 10 minutes by default, but the first
word of \fBwatch\fR can be set to a number to check every so many minutes.
For example,
.IP "" 4
set watch = (1 any any)
.PP
reports any login/logout once every minute. For the impatient, the \fIlog\fR
builtin command triggers a \fBwatch\fR report at any time. All current logins
are reported (as with the \fIlog\fR builtin) when \fBwatch\fR is first set.
.PP
The \fBwho\fR shell variable controls the format of \fBwatch\fR reports.
.RE
.TP 8
.B who \fR(+)
The format string for \fBwatch\fR messages. The following sequences
are replaced by the given information:
.PP
.RS +8
.PD 0
.TP 4
%n
The name of the user who logged in/out.
.TP 4
%a
The observed action, i.e. `logged on', `logged off' or `replaced \fIolduser\fR on'.
.TP 4
%l
The terminal (tty) on which the user logged in/out.
.TP 4
%M
The full hostname of the remote host, or `local' if the login/logout was
from the local host.
.TP 4
%m
The hostname of the remote host up to the first `.'.
The full name is printed if it is an IP address or an X Window System display.
.PD
.PP
%M and %m are available only on systems which store the remote hostname in
\fI/etc/utmp\fR.
If unset, `%n has %a %l from %m.' is used, or `%n has %a %l.' on systems
which don't store the remote hostname.
.RE
.TP 8
.B wordchars \fR(+)
A list of non-alphanumeric characters to be considered part of a word by the
\fIforward-word\fR, \fIbackward-word\fR etc. editor commands.
If unset, `*?_\-.[]~=' is used.
.SH ENVIRONMENT
.TP 8
.B AFSUSER \fR(+)
Equivalent to the \fBafsuser\fR shell variable.
.TP 8
.B COLUMNS
The number of columns in the terminal. See \fBTerminal management\fR.
.TP 8
.B DISPLAY
Used by X Window System (see \fIX\fR(1)).
If set, the shell does not set \fBautologout\fR (q.v.).
.TP 8
.B EDITOR
The pathname to a default editor.
See also the \fBVISUAL\fR environment variable
and the \fIrun-fg-editor\fR editor command.
.TP 8
.B GROUP \fR(+)
Equivalent to the \fBgroup\fR shell variable.
.TP 8
.B HOME
Equivalent to the \fBhome\fR shell variable.
.TP 8
.B HOST \fR(+)
Initialized to the name of the machine on which the shell
is running, as determined by the \fIgethostname\fR(2) system call.
.TP 8
.B HOSTTYPE \fR(+)
Initialized to the type of machine on which the shell
is running, as determined at compile time. This variable is obsolete and
will be removed in a future version.
.TP 8
.B HPATH \fR(+)
A colon-separated list of directories in which the \fIrun-help\fR editor
command looks for command documentation.
.TP 8
.B LANG
Gives the preferred character environment.
See \fBNative Language System support\fR.
.TP 8
.B LC_CTYPE
If set, only ctype character handling is changed.
See \fBNative Language System support\fR.
.TP 8
.B LINES
The number of lines in the terminal. See \fBTerminal management\fR.
.TP 8
.B LS_COLORS
The format of this variable is reminicent of the \fBtermcap(5)\fR
file format; a colon-separated list of expressions of the form
"\fIxx=string\fR", where "\fIxx\fR" is a two-character variable name.  The
variables with their associated defaults are:
.PP
.RS +8
.nf
no	0	Normal (non-filename) text
fi	0	Regular file
di	01;34	Directory
ln	01;36	Symbolic link
pi	33	Named pipe (FIFO)
so	01;35	Socket
bd	01;33	Block device
cd	01;32	Character device
ex	01;32	Executable file
mi	(none)	Missing file (defaults to fi)
or	(none)	Orphanned symbolic link (defaults to ln)
lc	^[[	Left code
rc	m	Right code
ec	(none)	End code (replaces lc+no+rc)
.fi
.PP
You only need to include the variables you want to change from
the default.
.PP
File names can also be colorized based on filename extension.
This is specified in the \fBLS_COLORS\fR variable using the syntax
\fB"*ext=string"\fR.  For example, using ISO 6429 codes, to color
all C\-language source files blue you would specify \fB"*.c=34"\fR.
This would color all files ending in \fB.c\fR in blue (34) color.
.PP
Control characters can be written either in C\-style\-escaped
notation, or in stty\-like ^\-notation.  The C\-style notation
adds \fB^[\fR for Escape, \fB\_\fR for a normal space characer,
and \fB?\fR for Delete.  In addition, the \fB^[\fR escape character
can be used to override the default interpretation of \fB^[\fR,
\fB^\fR, \fB:\fR and \fB=\fR.
.PP
Each file will be written as \fB<lc>\fR \fB<color-code>\fR
\fB<rc>\fR \fB<filename>\fR \fB<ec>\fR. If the \fB<ec>\fR
code is undefined, the sequence \fB<lc>\fR \fB<no>
\fB<rc>\fR will be used instead.  This is generally more convenient
to use, but less general.  The left, right and end codes are
provided so you don't have to type common parts over and over
again and to support weird terminals; you will generally not
need to change them at all unless your terminal does not use
ISO 6429 color sequences but a different system.
.PP
If your terminal does use ISO 6429 color codes, you can
compose the type codes (i.e. all except the \fBlc\fR, \fBrc\fR,
and \fBec\fR codes) from numerical commands separated by semicolons.  The
most common commands are:
.PP
.RS +8
.PD 0
.TP 4
0
to restore default color
.TP 4
1
for brighter colors
.TP 4
4
for underlined text
.TP 4
5
for flashing text
.TP 4
30
for black foreground
.TP 4
31
for red foreground
.TP 4
32
for green foreground
.TP 4
33
for yellow (or brown) foreground
.TP 4
34
for blue foreground
.TP 4
35
for purple foreground
.TP 4
36
for cyan foreground
.TP 4
37
for white (or gray) foreground
.TP 4
40
for black background
.TP 4
41
for red background
.TP 4
42
for green background
.TP 4
43
for yellow (or brown) background
.TP 4
44
for blue background
.TP 4
45
for purple background
.TP 4
46
for cyan background
.TP 4
47
for white (or gray) background
.RE
.PP
Not all commands will work on all systems or display devices.
.PP
A few terminal programs do not recognize the default end code
properly.  If all text gets colorized after you do a directory
listing, try changing the \fBno\fR and \fBfi\fR codes from 0 to the
numerical codes for your standard fore- and background colors.
.RE
.TP 8
.B MACHTYPE \fR(+)
The machine type (microprocessor class or machine model), as determined at compile time.
.TP 8
.B NOREBIND \fR(+)
If set, printable characters are not rebound to \fIself-insert-command\fR.
See \fBNative Language System support\fR.
.TP 8
.B OSTYPE \fR(+)
The operating system, as determined at compile time.
.TP 8
.B PATH
A colon-separated list of directories in which to look for executables.
Equivalent to the \fBpath\fR shell variable, but in a different format.
.TP 8
.B PWD \fR(+)
Equivalent to the \fBcwd\fR shell variable, but not synchronized to it;
updated only after an actual directory change.
.TP 8
.B REMOTEHOST \fR(+)
The host from which the user has logged in remotely, if this is the case and
the shell is able to determine it. Set only if the shell was so compiled;
see the \fBversion\fR shell variable.
.TP 8
.B SHLVL \fR(+)
Equivalent to the \fBshlvl\fR shell variable.
.TP 8
.B SYSTYPE \fR(+)
The current system type. (Domain/OS only)
.TP 8
.B TERM
Equivalent to the \fBterm\fR shell variable.
.TP 8
.B TERMCAP
The terminal capability string. See \fBTerminal management\fR.
.TP 8
.B USER
Equivalent to the \fBuser\fR shell variable.
.TP 8
.B VENDOR \fR(+)
The vendor, as determined at compile time.
.TP 8
.B VISUAL
The pathname to a default full-screen editor.
See also the \fBEDITOR\fR environment variable
and the \fIrun-fg-editor\fR editor command.
.SH FILES
.PD 0
.TP 16
.I /etc/csh.cshrc
Read first by every shell.
ConvexOS, Stellix and Intel use \fI/etc/cshrc\fR and
NeXTs use \fI/etc/cshrc.std\fR.
A/UX, AMIX, Cray and IRIX have no equivalent in \fIcsh\fR(1),
but read this file in \fItcsh\fR anyway.
Solaris 2.x does not have it either, but \fItcsh\fR reads \fI/etc/.cshrc\fR. (+)
.TP 16
.I /etc/csh.login
Read by login shells after \fI/etc/csh.cshrc\fR.
ConvexOS, Stellix and Intel use \fI/etc/login\fR,
NeXTs use \fI/etc/login.std\fR, Solaris 2.x uses \fI/etc/.login\fR and
A/UX, AMIX, Cray and IRIX use \fI/etc/cshrc\fR.
.TP 16
.I ~/.tcshrc \fR(+)
Read by every shell after \fI/etc/csh.cshrc\fR or its equivalent.
.TP 16
.I ~/.cshrc
Read by every shell, if \fI~/.tcshrc\fR doesn't exist,
after \fI/etc/csh.cshrc\fR or its equivalent.
This manual uses `\fI~/.tcshrc\fR' to mean `\fI~/.tcshrc\fR or,
if \fI~/.tcshrc\fR is not found, \fI~/.cshrc\fR'.
.TP 16
.I ~/.history
Read by login shells after \fI~/.tcshrc\fR
if \fBsavehist\fR is set, but see also \fBhistfile\fR.
.TP 16
.I ~/.login
Read by login shells after \fI~/.tcshrc\fR or \fI~/.history\fR.
The shell may be compiled to read \fI~/.login\fR before instead of after
\fI~/.tcshrc\fR and \fI~/.history\fR; see the \fBversion\fR shell variable.
.TP 16
.I ~/.cshdirs \fR(+)
Read by login shells after \fI~/.login\fR
if \fBsavedirs\fR is set, but see also \fBdirsfile\fR.
.TP 16
.I /etc/csh.logout
Read by login shells at logout.
ConvexOS, Stellix and Intel use \fI/etc/logout\fR and
NeXTs use \fI/etc/logout.std\fR.
A/UX, AMIX, Cray and IRIX have no equivalent in \fIcsh\fR(1),
but read this file in \fItcsh\fR anyway.
Solaris 2.x does not have it either, but \fItcsh\fR reads \fI/etc/.cshrc\fR. (+)
.TP 16
.I ~/.logout
Read by login shells at logout after \fI/etc/csh.logout\fR or its equivalent.
.TP 16
.I /bin/sh
Used to interpret shell scripts not starting with a `#'.
.TP 16
.I /tmp/sh*
Temporary file for `<<'.
.TP 16
.I /etc/passwd
Source of home directories for `~name' substitutions.
.PD
.PP
The order in which startup files are read may differ if the shell was so
compiled; see \fBStartup and shutdown\fR and the \fBversion\fR shell variable.
.SH "NEW FEATURES (+)"
This manual describes \fItcsh\fR as a single entity,
but experienced \fIcsh\fR(1) users will want to pay special attention to
\fItcsh\fR's new features.
.PP
A command-line editor, which supports GNU Emacs or \fIvi\fR(1)-style
key bindings. See \fBThe command-line editor\fR and \fBEditor commands\fR.
.PP
Programmable, interactive word completion and listing.
See \fBCompletion and listing\fR and the \fIcomplete\fR and \fIuncomplete\fR
builtin commands.
.PP
\fBSpelling correction\fR (q.v.) of filenames, commands and variables.
.PP
\fBEditor commands\fR (q.v.) which perform other useful functions in the middle of
typed commands, including documentation lookup (\fIrun-help\fR),
quick editor restarting (\fIrun-fg-editor\fR) and
command resolution (\fIwhich-command\fR).
.PP
An enhanced history mechanism. Events in the history list are time-stamped.
See also the \fIhistory\fR command and its associated shell variables,
the previously undocumented `#' event specifier and new modifiers
under \fBHistory substitution\fR,
the \fI*-history\fR, \fIhistory-search-*\fR, \fIi-search-*\fR, \fIvi-search-*\fR and
\fItoggle-literal-history\fR editor commands
and the \fBhistlit\fR shell variable.
.PP
Enhanced directory parsing and directory stack handling.
See the \fIcd\fR, \fIpushd\fR, \fIpopd\fR and \fIdirs\fR commands and their associated
shell variables, the description of \fBDirectory stack substitution\fR,
the \fBdirstack\fR, \fBowd\fR and \fBsymlinks\fR shell variables and
the \fInormalize-command\fR and \fInormalize-path\fR editor commands.
.PP
Negation in glob-patterns. See \fBFilename substitution\fR.
.PP
New \fBFile inquiry operators\fR (q.v.) and a \fIfiletest\fR
builtin which uses them.
.PP
A variety of \fBAutomatic, periodic and timed events\fR (q.v.) including
scheduled events, special aliases, automatic logout and terminal locking,
command timing and watching for logins and logouts.
.PP
Support for the Native Language System
(see \fBNative Language System support\fR),
OS variant features
(see \fBOS variant support\fR and the \fBecho_style\fR shell variable)
and system-dependent file locations (see \fBFILES\fR).
.PP
Extensive terminal-managment capabilities. See \fBTerminal management\fR.
.PP
New builtin commands including \fIbuiltins\fR, \fIhup\fR, \fIls\-F\fR,
\fInewgrp\fR, \fIprintenv\fR, \fIwhich\fR and \fIwhere\fR (q.v.).
.PP
New variables that make useful information easily available to the shell.
See the \fBgid\fR, \fBloginsh\fR, \fBoid\fR, \fBshlvl\fR, \fBtcsh\fR,
\fBtty\fR, \fBuid\fR and \fBversion\fR shell variables and the \fBHOST\fR,
\fBREMOTEHOST\fR, \fBVENDOR\fR, \fBOSTYPE\fR and \fBMACHTYPE\fR environment
variables.
.PP
A new syntax for including useful information in the prompt string
(see \fBprompt\fR).
and special prompts for loops and spelling correction
(see \fBprompt2\fR and \fBprompt3\fR).
.PP
Read-only variables. See \fBVariable substitution\fR.
.SH BUGS
When a suspended command is restarted, the shell prints the directory
it started in if this is different from the current directory. This can
be misleading (i.e. wrong) as the job may have changed directories internally.
.PP
Shell builtin functions are not stoppable/restartable.  Command sequences
of the form `a ; b ; c' are also not handled gracefully when stopping is
attempted.  If you suspend `b', the shell will then immediately execute
`c'.  This is especially noticeable if this expansion results from an
\fIalias\fR. It suffices to place the sequence of commands in ()'s to force it
to a subshell, i.e. `( a ; b ; c )'.
.PP
Control over tty output after processes are started is primitive; perhaps
this will inspire someone to work on a good virtual terminal interface.
In a virtual terminal interface much more interesting things could be
done with output control.
.PP
Alias substitution is most often used to clumsily simulate shell procedures;
shell procedures should be provided rather than aliases.
.PP
Commands within loops are not placed in the history
list.  Control structures should be parsed rather than being recognized as
built-in commands.  This would allow control commands to be placed anywhere,
to be combined with `|', and to be used with `&' and `;' metasyntax.
.PP
\fIforeach\fR doesn't ignore here documents when looking for its \fIend\fR.
.PP
It should be possible to use the `:' modifiers on the output of command
substitutions.
.PP
The screen update for lines longer than the screen width is very poor
if the terminal cannot move the cursor up (i.e. terminal type `dumb').
.PP
\fBHPATH\fR and \fBNOREBIND\fR don't need to be environment variables.
.PP
Glob-patterns which do not use `?', `*' or `[]' or which use `{}' or `~'
are not negated correctly.
.PP
The single-command form of \fIif\fR does output redirection even if
the expression is false and the command is not executed.
.PP
\fIls\-F\fR includes file identification characters when sorting filenames
and does not handle control characters in filenames well. It cannot be
interrupted.
.PP
Report bugs to tcsh-bugs@mx.gw.com, preferably with fixes. If you want to
help maintain and test tcsh, send mail to listserv@mx.gw.com with the text
`subscribe tcsh <your name>' on a line by itself in the body. You can
also `subscribe tcsh-bugs <your name>' to get all bug reports, or
`subscribe tcsh-diffs <your name>' to get the development list plus
diffs for each patchlevel.
.SH THE T IN TCSH
In 1964, DEC produced the PDP-6. The PDP-10 was a later re-implementation. It
was re-christened the DECsystem-10 in 1970 or so when DEC brought out the
second model, the KI10.
.PP
TENEX was created at Bolt, Beranek & Newman (a Cambridge, Mass. think tank) in
1972 as an experiment in demand-paged virtual memory operating systems. They
built a new pager for the DEC PDP-10 and created the OS to go with it. It was
extremely successful in academia.
.PP
In 1975, DEC brought out a new model of the PDP-10, the KL10; they intended to
have only a version of TENEX, which they had licensed from BBN, for the new
box. They called their version TOPS-20 (their capitalization is trademarked).
A lot of TOPS-10 users (`The OPerating System for PDP-10') objected; thus DEC
found themselves supporting two incompatible systems on the same hardware--but
then there were 6 on the PDP-11!
.PP
TENEX, and TOPS-20 to version 3, had command completion
via a user-code-level subroutine library called ULTCMD. With version 3, DEC
moved all that capability and more into the monitor (`kernel' for you Unix
types), accessed by the COMND% JSYS (`Jump to SYStem' instruction, the
supervisor call mechanism [are my IBM roots also showing?]).
.PP
The creator of tcsh was impressed by this feature and several others of TENEX
and TOPS-20, and created a version of csh which mimicked them.
.SH LIMITATIONS
Words can be no longer than 1024 characters.
.PP
The system limits argument lists to 10240 characters.
.PP
The number of arguments to a command which involves filename expansion is
limited to 1/6th the number of characters allowed in an argument list.
.PP
Command substitutions may substitute no more characters than are allowed in
an argument list.
.PP
To detect looping, the shell restricts the number of \fIalias\fR
substitutions on a single line to 20.
.SH "SEE ALSO"
csh(1), emacs(1), ls(1), newgrp(1), sh(1), setpath(1), stty(1), su(1),
tset(1), vi(1), x(1), access(2), execve(2), fork(2), killpg(2),
pipe(2), setrlimit(2), sigvec(2), stat(2), umask(2), vfork(2), wait(2),
malloc(3), setlocale(3), tty(4), a.out(5), termcap(5), environ(7),
termio(7), Introduction to the C Shell
.SH VERSION
This manual documents tcsh 6.08.00 (Astron) 1998-10-02.
.SH AUTHORS
.PD 0
.TP 2
William Joy
Original author of \fIcsh\fR(1)
.TP 2
J.E. Kulp, IIASA, Laxenburg, Austria
Job control and directory stack features
.TP 2
Ken Greer, HP Labs, 1981
File name completion
.TP 2
Mike Ellis, Fairchild, 1983
Command name recognition/completion
.TP 2
Paul Placeway, Ohio State CIS Dept., 1983-1993
Command line editor, prompt routines, new glob syntax and numerous fixes
and speedups
.TP 2
Karl Kleinpaste, CCI 1983-4
Special aliases, directory stack extraction stuff, login/logout watch,
scheduled events, and the idea of the new prompt format
.TP 2
Rayan Zachariassen, University of Toronto, 1984
\fIls\-F\fR and \fIwhich\fR builtins and numerous bug fixes, modifications
and speedups
.TP 2
Chris Kingsley, Caltech
Fast storage allocator routines
.TP 2
Chris Grevstad, TRW, 1987
Incorporated 4.3BSD \fIcsh\fR into \fItcsh\fR
.TP 2
Christos S. Zoulas, Cornell U. EE Dept., 1987-94
Ports to HPUX, SVR2 and SVR3, a SysV version of getwd.c, SHORT_STRINGS support
and a new version of sh.glob.c
.TP 2
James J Dempsey, BBN, and Paul Placeway, OSU, 1988
A/UX port
.TP 2
Daniel Long, NNSC, 1988
\fBwordchars\fR
.TP 2
Patrick Wolfe, Kuck and Associates, Inc., 1988
\fIvi\fR mode cleanup
.TP 2
David C Lawrence, Rensselaer Polytechnic Institute, 1989
\fBautolist\fR and ambiguous completion listing
.TP 2
Alec Wolman, DEC, 1989
Newlines in the prompt
.TP 2
Matt Landau, BBN, 1989
\fI~/.tcshrc\fR
.TP 2
Ray Moody, Purdue Physics, 1989
Magic spacebar history expansion
.TP 2
Mordechai ????, Intel, 1989
printprompt() fixes and additions
.TP 2
Kazuhiro Honda, Dept. of Computer Science, Keio University, 1989
Automatic spelling correction and \fBprompt3\fR
.TP 2
Per Hedeland, Ellemtel, Sweden, 1990-
Various bugfixes, improvements and manual updates
.TP 2
Hans J. Albertsson (Sun Sweden)
\fBampm\fR, \fIsettc\fR and \fItelltc\fR
.TP 2
Michael Bloom
Interrupt handling fixes
.TP 2
Michael Fine, Digital Equipment Corp
Extended key support
.TP 2
Eric Schnoebelen, Convex, 1990
Convex support, lots of \fIcsh\fR bug fixes,
save and restore of directory stack
.TP 2
Ron Flax, Apple, 1990
A/UX 2.0 (re)port
.TP 2
Dan Oscarsson, LTH Sweden, 1990
NLS support and simulated NLS support for non NLS sites, fixes
.TP 2
Johan Widen, SICS Sweden, 1990
\fBshlvl\fR, Mach support, \fIcorrect-line\fR, 8-bit printing
.TP 2
Matt Day, Sanyo Icon, 1990
POSIX termio support, SysV limit fixes
.TP 2
Jaap Vermeulen, Sequent, 1990-91
Vi mode fixes, expand-line, window change fixes, Symmetry port
.TP 2
Martin Boyer, Institut de recherche d'Hydro-Quebec, 1991
\fBautolist\fR beeping options, modified the history search to search for
the whole string from the beginning of the line to the cursor.
.TP 2
Scott Krotz, Motorola, 1991
Minix port
.TP 2
David Dawes, Sydney U. Australia, Physics Dept., 1991
SVR4 job control fixes
.TP 2
Jose Sousa, Interactive Systems Corp., 1991
Extended \fIvi\fR fixes and \fIvi\fR delete command
.TP 2
Marc Horowitz, MIT, 1991
ANSIfication fixes, new exec hashing code, imake fixes, \fIwhere\fR
.TP 2
Bruce Sterling Woodcock, sterling@netcom.com, 1991-1995
ETA and Pyramid port, Makefile and lint fixes, \fBignoreeof\fR=n addition, and
various other portability changes and bug fixes
.TP 2
Jeff Fink, 1992
\fIcomplete-word-fwd\fR and \fIcomplete-word-back\fR
.TP 2
Harry C. Pulley, 1992
Coherent port
.TP 2
Andy Phillips, Mullard Space Science Lab U.K., 1992
VMS-POSIX port
.TP 2
Beto Appleton, IBM Corp., 1992
Walking process group fixes, \fIcsh\fR bug fixes,
POSIX file tests, POSIX SIGHUP
.TP 2
Scott Bolte, Cray Computer Corp., 1992
CSOS port
.TP 2
Kaveh R. Ghazi, Rutgers University, 1992
Tek, m88k, Titan and Masscomp ports and fixes. Added autoconf support.
.TP 2
Mark Linderman, Cornell University, 1992
OS/2 port
.TP 2
Mika Liljeberg, liljeber@kruuna.Helsinki.FI, 1992
Linux port
.TP 2
Tim P. Starrin, NASA Langley Research Center Operations, 1993
Read-only variables
.TP 2
Dave Schweisguth, Yale University, 1993-4
New manpage and tcsh.man2html
.TP 2
Larry Schwimmer, Stanford University, 1993
AFS and HESIOD patches
.TP 2
Luke Mewburn, RMIT University, 1994-6
Enhanced directory printing in prompt,
added \fBellipsis\fR and \fBrprompt\fR.
.TP 2
Edward Hutchins, Silicon Graphics Inc., 1996
Added implicit cd.
.TP 2
Martin Kraemer, 1997
Ported to Siemens Nixdorf EBCDIC machine
.TP 2
Amol Deshpande, Microsoft, 1997
Ported to WIN32 (Windows/95 and Windows/NT); wrote all the missing library
and message catalog code to interface to Windows.
.TP 2
Taga Nayuta, 1998
Color ls additions.
.PD
.PP
.SH "THANKS TO"
Bryan Dunlap, Clayton Elwell, Karl Kleinpaste, Bob Manson, Steve Romig,
Diana Smetters, Bob Sutterfield, Mark Verber, Elizabeth Zwicky and all
the other people at Ohio State for suggestions and encouragement
.PP
All the people on the net, for putting up with,
reporting bugs in, and suggesting new additions to each and every version
.PP
Richard M. Alderson III, for writing the `T in tcsh' section
