/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;

    public FileOutputStream(String string) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        try {
            this.fd = new FileDescriptor();
            this.open(string);
            return;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string);
        }
    }

    public FileOutputStream(String string, boolean bl) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        try {
            this.fd = new FileDescriptor();
            if (bl) {
                this.openAppend(string);
                return;
            }
            this.open(string);
            return;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string);
        }
    }

    public FileOutputStream(File file) throws IOException {
        this(file.getPath());
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    private native void open(String var1) throws IOException;

    private native void openAppend(String var1) throws IOException;

    public native void write(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public native void close() throws IOException;

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
                this.flush();
                return;
            }
            this.close();
        }
    }
}

