/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Checkbox
extends Component
implements ItemSelectable {
    String label;
    boolean state;
    CheckboxGroup group;
    transient ItemListener itemListener;
    private static final String base = "checkbox";
    private static int nameCounter;
    private static final long serialVersionUID = 7270714317450821763L;
    private int checkboxSerializedDataVersion = 1;

    synchronized void setStateInternal(boolean bl) {
        this.state = bl;
        CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
        if (checkboxPeer != null) {
            checkboxPeer.setState(bl);
        }
    }

    public Checkbox() {
        this("", false, null);
    }

    public Checkbox(String string) {
        this(string, false, null);
    }

    public Checkbox(String string, boolean bl) {
        this(string, bl, null);
    }

    public Checkbox(String string, boolean bl, CheckboxGroup checkboxGroup) {
        this.name = base + nameCounter++;
        this.label = string;
        this.state = bl;
        this.group = checkboxGroup;
        if (bl && checkboxGroup != null) {
            checkboxGroup.setSelectedCheckbox(this);
        }
    }

    public Checkbox(String string, CheckboxGroup checkboxGroup, boolean bl) {
        this(string, bl, checkboxGroup);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckbox(this);
        }
        super.addNotify();
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
        if (checkboxPeer != null) {
            checkboxPeer.setLabel(string);
        }
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean bl) {
        CheckboxGroup checkboxGroup = this.group;
        if (checkboxGroup != null) {
            if (bl) {
                checkboxGroup.setSelectedCheckbox(this);
            } else if (checkboxGroup.getSelectedCheckbox() == this) {
                bl = true;
            }
        }
        this.setStateInternal(bl);
    }

    public Object[] getSelectedObjects() {
        if (this.state) {
            Object[] objectArray = new Object[]{this.label};
            return objectArray;
        }
        return null;
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        CheckboxGroup checkboxGroup2 = this.group;
        if (checkboxGroup2 != null) {
            checkboxGroup2.setSelectedCheckbox(null);
        }
        Checkbox checkbox = this;
        synchronized (checkbox) {
            this.group = checkboxGroup;
            CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
            if (checkboxPeer != null) {
                checkboxPeer.setCheckboxGroup(checkboxGroup);
            }
            return;
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    protected String paramString() {
        String string = super.paramString();
        String string2 = this.label;
        if (string2 != null) {
            string = String.valueOf(string) + ",label=" + string2;
        }
        return String.valueOf(string) + ",state=" + this.state;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "itemL") {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

