/** 
 *
 * $Id: ContainerP.h,v 1.1 1999/08/17 22:09:49 rwscott Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/


#ifndef XM_CONTAINER_P_H
#define XM_CONTAINER_P_H

#include <Xm/Container.h>
#include <Xm/ManagerP.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Define the container instance part */
typedef struct {
    Dimension margin_width;
    Dimension margin_height;
    unsigned char shadow_type;

    /* private instance variables , don't look here */
    Dimension old_width;
    Dimension old_height;
    Dimension old_shadow_thickness;
    Position old_shadow_x;
    Position old_shadow_y;

    Widget work_area;
    Widget title_area;
    Boolean processing_constraints;
} XmContainerPart;

/* define the full instance record */
typedef struct _XmContainerRec {
    CorePart core;
    CompositePart composite;
    ConstraintPart constraint;
    XmManagerPart manager;
    XmContainerPart container;
} XmContainerRec;

/* Define class part structure */
typedef struct {
    XtPointer extension;
} XmContainerClassPart;

/* Define the full class record */
typedef struct _XmContainerClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart manager_class;
    XmContainerClassPart container_class;
} XmContainerClassRec;

/* Define the Constraint Resources */
typedef struct _XmContainerConstraintPart {
    int unused;
    unsigned char child_type;
    unsigned char child_h_alignment;
    Dimension child_h_spacing;
    unsigned char child_v_alignment;
} XmContainerConstraintPart, *XmContainerContraint;

typedef struct _XmContainerConstraintRec {
    XmManagerConstraintPart manager;
    XmContainerConstraintPart container;
} XmContainerConstraintRec, *XmContainerConstraintPtr;

extern XmContainerClassRec xmContainerClassRec;

#ifdef __cplusplus
}
#endif

#endif
