/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.FramePeer;
import java.util.Vector;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11Image;

class MFramePeer
extends MPanelPeer
implements FramePeer {
    Insets insets;
    static Vector allFrames = new Vector();

    native void create(MComponentPeer var1, Object var2);

    native void pSetTitle(String var1);

    native void pShow();

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pSetIconImage(ImageRepresentation var1);

    public native void setResizable(boolean var1);

    native void addTextComponent();

    MFramePeer(Frame frame) {
        super(frame, new Insets(Integer.getInteger("awt.frame.topInset", 25), Integer.getInteger("awt.frame.leftInset", 5), Integer.getInteger("awt.frame.bottomInset", 5), Integer.getInteger("awt.frame.rightInset", 5)));
        Image image;
        Color color;
        Font font;
        allFrames.addElement(this);
        if (frame.getTitle() != null) {
            this.pSetTitle(frame.getTitle());
        }
        if ((font = frame.getFont()) == null) {
            font = new Font("Dialog", 0, 12);
            frame.setFont(font);
            this.setFont(font);
        }
        if ((color = frame.getBackground()) == null) {
            frame.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = frame.getForeground()) == null) {
            frame.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        if ((image = frame.getIconImage()) != null) {
            this.setIconImage(image);
        }
        this.setResizable(frame.isResizable());
    }

    public void setTitle(String string) {
        this.pSetTitle(string);
    }

    public void dispose() {
        allFrames.removeElement(this);
        super.dispose();
    }

    public void setIconImage(Image image) {
        ImageRepresentation imageRepresentation = ((X11Image)image).getImageRep();
        imageRepresentation.reconstruct(32);
        this.pSetIconImage(imageRepresentation);
    }

    public void setMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = (MMenuBarPeer)MToolkit.targetToPeer(menuBar);
        this.pSetMenuBar(mMenuBarPeer);
        if (this.target.isVisible()) {
            Rectangle rectangle = this.target.bounds();
            this.pReshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.target.invalidate();
            this.target.validate();
        }
    }

    native void pSetMenuBar(MMenuBarPeer var1);

    public void handleActivate() {
        this.postEvent(new WindowEvent((Window)this.target, 205));
    }

    public void handleDeactivate() {
        this.postEvent(new WindowEvent((Window)this.target, 206));
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void toFront() {
        this.pShow();
    }

    public native void toBack();

    public synchronized void handleMoved(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    public synchronized void handleResize(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void print(Graphics graphics) {
        MMenuBarPeer mMenuBarPeer;
        super.print(graphics);
        Frame frame = (Frame)this.target;
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar != null && (mMenuBarPeer = (MMenuBarPeer)MToolkit.targetToPeer(menuBar)) != null) {
            Insets insets = this.insets();
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(insets.left, 24);
                mMenuBarPeer.print(graphics2);
                return;
            }
            finally {
                Object var8_7 = null;
                graphics2.dispose();
            }
        }
    }

    public Insets insets() {
        return this.getInsets();
    }
}

