% -*- SLang -*-
%
% run compiler in a subshell and parse error messages
% The file compile.dat is a database for various compilers.  Set the
% string 'compile_parse_error_function' to the approriate compiler.
% This file reads the function from compile.dat.

%!% compiler name in the database "compile.dat"
!if (is_defined ("compile_parse_error_function"))
  variable compile_parse_error_function = Null_String;

%!% regular expression to extract compile errors
!if (is_defined ("compile_parse_regexp"))
  variable compile_parse_regexp = Null_String;

% extract the regexp if it is not already set.


!if (strlen (compile_parse_regexp))
{   
   !if (strlen (compile_parse_error_function))
     error ("'compile_parse_error_function' needs set.  See jed.rc for info.");
   
   $1 = whatbuf ();
   $2 = expand_jedlib_file ("compile.dat");
   !if (strlen($2)) error ("compile.dat not found!");
     
   setbuf (" *compile.dat tmp*");
   $3 = insert_file_region ($2, strcat ("%@", compile_parse_error_function),
			    "-------");
   if ($3 > 0) evalbuffer ();
   delbuf (whatbuf);
   setbuf ($1);
   if ($3 <= 0)
     {
	error ("Compiler type not in database file compile.dat!");
     }
}


define compile_parse_errors ()
{
   variable cbuf, obuf = "*shell-output*";
   variable line, file;
   if (MINIBUFFER_ACTIVE) return;
   cbuf = pop2buf_whatbuf (obuf);
   if (markp ()) pop_mark_0 ();
   eol ();
   if (eobp) message ("No more errors!");

   while (eol, not (eobp()))
     {
	bol ();
	if (re_fsearch (compile_parse_regexp))
	  {
	     file = regexp_nth_match (1);	% file name
	     line = regexp_nth_match (2);	% line number (string)
	     !if (strlen (line)) return;

	     message (strcat ("Line ", line));
	     bol(); call ("set_mark_cmd"); eol ();
	     while  (1 != file_status (file))
	       {
		  file = read_file_from_mini ("Find this file's errors:");
	       }
	     
	     () = find_file (file);
	     cbuf = whatbuf ();
	     goto_line (integer(line));
	     bol_skip_white ();
	     sw2buf (obuf);
	     break;
	  }
	go_down (1);
     }
   go_down (1);
   pop2buf (cbuf);
}


define compile ()
{
   variable b;
   b = whatbuf();
   call ("save_buffers");   
   do_shell_cmd ();
   bob();
   pop2buf(b);
   compile_parse_errors ();
}
   
define compile_previous_error ()
{
   variable buf = "*shell-output*";
   !if (bufferp(buf))
     {
	flush("Did you compile?");
	return;
     }
   pop2buf(buf);
   go_up(2);
   compile_parse_errors();
}
