/*
 *  Copyright 1995  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 *  $Id$
 */

#include "import.h"

#include <sys/types.h>
#include <errno.h>
#include <prot.h>
#include <stdlib.h>
#include <unistd.h>

#include "debug.h"


static int auth_initialized = 0;

static ushort luid, ruid, euid, rgid, egid;


int
getluid()
{
	dbg_write(2, "getluid\n", 8);
	return syscall(0x59, 1, 0, 0, 0, 0, 0);
}

int
setluid(uid)
	unsigned short uid;
{
	dbg_write(2, "setluid\n", 8);
	return syscall(0x59, 2, uid, 0, 0, 0, 0);
}


/* Check that C2 security is loaded in the kernel and save all uids/gids.
 * If C2 isn't available we are supposed to exit with an error message.
 */
void
set_auth_parameters(argc, argv)
	int argc;
	char *argv[];
{
	dbg_write(2, "set_auth_parameters\n", 20);
	auth_initialized = 1;
	luid = getluid();
	ruid = getuid();
	euid = geteuid();
	rgid = getgid();
	egid = getegid();
}


/* If a call to set_auth_parameters has been made ok, otherwise exit
 * the program.
 */
void
check_auth_parameters()
{
	dbg_write(2, "check_auth_parameters\n", 22);
	if (!auth_initialized)
		exit(1);
}


int
is_starting_egid(gid)
	ushort gid;
{
	dbg_write(2, "is_starting_egid\n", 17);
	return gid == egid ? 1 : 0;
}


int
is_starting_euid(uid)
	ushort uid;
{
	dbg_write(2, "is_starting_euid\n", 17);
	return uid == euid ? 1 : 0;
}


int
is_starting_luid(uid)
	ushort uid;
{
	dbg_write(2, "is_starting_luid\n", 17);
	return uid == luid ? 1 : 0;
}


int
is_starting_rgid(gid)
	ushort gid;
{
	dbg_write(2, "is_starting_rgid\n", 17);
	return gid == rgid ? 1 : 0;
}


int
is_starting_ruid(uid)
	ushort uid;
{
	dbg_write(2, "is_starting_ruid\n", 17);
	return uid == ruid ? 1 : 0;
}


ushort
starting_egid()
{
	dbg_write(2, "starting_egid\n", 14);
	return egid;
}


ushort
starting_euid()
{
	dbg_write(2, "starting_euid\n", 14);
	return euid;
}


ushort
starting_luid()
{
	dbg_write(2, "starting_luid\n", 14);
	return luid;
}


ushort
starting_rgid()
{
	dbg_write(2, "starting_rgid\n", 14);
	return rgid;
}


ushort
starting_ruid()
{
	dbg_write(2, "starting_ruid\n", 14);
	return ruid;
}
