#include <stdio.h>
#include <trace.h>
/**************************************************************************
 *
 * Function:     fsetpos
 *
 * Description:
 *    Alter the file position based upon the filepos information.
 *
 * Entry:
 *    stream  - Pointer to the file stream to be adjusted
 *    pos     - Position to adjust the file.
 *
 * Returns:
 *    0 if successful
 *  <>0 if an error occured
 */

int fsetpos (FILE *stream, const fpos_t *pos)
    {
    int answer;
    FUNC_ENTRY ("fsetpos");
    answer = fseek (stream,*pos,SEEK_SET);
    FUNC_EXIT ("fsetpos");
    return (answer);
    }
