#ifndef _EMU_SYSCALL_H_
#define _EMU_SYSCALL_H_

/* From emu_memory.c */
extern int emu_stkgro(struct sigcontext_struct *sc);
extern int emu_brkctl(struct sigcontext_struct *sc);
extern int emu_brk(struct sigcontext_struct *sc);

/* From emu_time.c */
extern int emu_time(struct sigcontext_struct *sc);

/* From emu_generic.c */
extern int emu_i_sas(struct sigcontext_struct *sc);
extern int emu_i_ass(struct sigcontext_struct *sc);
extern int emu_i_s(struct sigcontext_struct *sc);
extern int emu_i_sls(struct sigcontext_struct *sc);
extern int emu_i_ssl(struct sigcontext_struct *sc);
extern int emu_i_a(struct sigcontext_struct *sc);
extern int emu_i_aa(struct sigcontext_struct *sc);
extern int emu_i_ssa(struct sigcontext_struct *sc);
extern int emu_i_l(struct sigcontext_struct *sc);
extern int emu_i_v(struct sigcontext_struct *sc);

/* From emu_odd.c */
extern int emu_i_pipe(struct sigcontext_struct *sc);
extern int emu_i_fcntl(struct sigcontext_struct *sc);
extern int emu_i_fstat(struct sigcontext_struct *sc);
extern int emu_i_stat(struct sigcontext_struct *sc);
extern int emu_i_ftime(struct sigcontext_struct *sc);
extern int emu_i_ioctl(struct sigcontext_struct *sc);
extern int emu_i_dup(struct sigcontext_struct *sc);

/* From emu_signal.c */
#include "emu_signal.h"

/* From emu_exec.c */
extern int emu_exec(struct sigcontext_struct *sc);

#endif /* _EMU_SYSCALL_H_ */
