/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Toolkit;
import java.awt.peer.FontPeer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.io.CharToByteConverter;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected Properties props;
    protected FontDescriptor defaultFont;
    protected static Hashtable charsetRegistry;
    protected String aliasName;
    protected String styleString;
    private static Properties fprops;
    private static PrintWriter log;
    private static final String LOG_FONT_PROPERTIES = "AWT.LogFontProperties";
    private static final String LOG_FONT_PROPERTIES_FILE = "AWT.LogFontPropertiesFile";

    public PlatformFont(String string, int n) {
        int n2;
        if (fprops == null) {
            this.props = null;
            return;
        }
        this.props = fprops;
        this.aliasName = this.props.getProperty("alias." + string.toLowerCase());
        if (this.aliasName == null) {
            this.aliasName = string.toLowerCase();
        }
        if (this.props.getProperty(String.valueOf(this.aliasName) + ".0") == null && this.props.getProperty(String.valueOf(this.aliasName) + ".plain.0") == null) {
            this.aliasName = "sansserif";
        }
        this.styleString = PlatformFont.styleStr(n);
        Vector vector = new Vector(5);
        int n3 = 0;
        while (true) {
            int[] nArray;
            String string2 = String.valueOf(n3);
            String string3 = this.props.getProperty(String.valueOf(this.aliasName) + "." + this.styleString + "." + string2);
            if (string3 == null && (string3 = this.props.getProperty(String.valueOf(this.aliasName) + "." + string2)) == null) break;
            String string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + this.styleString + "." + string2);
            if (string4 == null && (string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + string2)) == null) {
                string4 = "default";
            }
            CharToByteConverter charToByteConverter = this.getFontCharset(string4.trim(), string3);
            String string5 = this.props.getProperty("exclusion." + this.aliasName + "." + this.styleString + "." + string2);
            if (string5 == null && (string5 = this.props.getProperty("exclusion." + this.aliasName + "." + string2)) == null) {
                string5 = "none";
            }
            if (string5.equals("none")) {
                nArray = new int[]{};
            } else {
                int n4 = 1;
                int n5 = 0;
                while ((n5 = string5.indexOf(44, n5)) != -1) {
                    ++n5;
                    ++n4;
                }
                nArray = new int[n4];
                int n6 = 0;
                while (n6 < n4) {
                    String string6;
                    String string7;
                    int n7 = 0;
                    int n8 = 0;
                    try {
                        string7 = string5.substring(n6 * 10, n6 * 10 + 4);
                        string6 = string5.substring(n6 * 10 + 5, n6 * 10 + 9);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        nArray = new int[]{};
                        break;
                    }
                    try {
                        n7 = Integer.parseInt(string7, 16);
                        n8 = Integer.parseInt(string6, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = new int[]{};
                        break;
                    }
                    nArray[n6] = n7 << 16 | n8;
                    ++n6;
                }
            }
            vector.addElement(new FontDescriptor(string3, charToByteConverter, nArray));
            ++n3;
        }
        this.componentFonts = new FontDescriptor[n3];
        int n9 = 0;
        while (n9 < n3) {
            this.componentFonts[n9] = (FontDescriptor)vector.elementAt(n9);
            ++n9;
        }
        try {
            n2 = Integer.parseInt(this.props.getProperty("default.char", "003f"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 63;
        }
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        int n10 = 0;
        while (n10 < this.componentFonts.length) {
            if (!this.componentFonts[n10].isExcluded((char)n2) && this.componentFonts[n10].fontCharset.canConvert((char)n2)) {
                this.defaultFont = this.componentFonts[n10];
                this.defaultChar = (char)n2;
                return;
            }
            ++n10;
        }
    }

    public boolean mightHaveMultiFontMetrics() {
        return this.props != null;
    }

    private static void logMessage(String string) {
        if (log != null) {
            log.println(string);
        }
    }

    private static boolean loadProperties(String string) {
        Object object;
        SecurityManager.enablePrivilege("UniversalPropertyRead");
        PlatformFont.logMessage("loadProperties(" + string + ")");
        String string2 = System.getProperty("java.font.property.path");
        if (string2 != null) {
            PlatformFont.logMessage("MOZILLA_JAVA_FONT_PROPERTY_PATH is set to \"" + string2 + "\", trying it...");
            if (PlatformFont.loadPropertiesFromFile(string2, string)) {
                return true;
            }
            PlatformFont.logMessage("Read failed from MOZILLA_JAVA_FONT_PROPERTY_PATH.");
        }
        PlatformFont.logMessage("Trying to read from system classpath...");
        try {
            object = ClassLoader.getSystemResourceAsStream(string);
            if (object != null) {
                fprops.load((InputStream)object);
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println("Exception occurred while loading " + string + ": " + iOException);
        }
        PlatformFont.logMessage("System classpath failed; unable to load \"" + string + "\"");
        object = System.getProperty("mozilla.home", ".");
        object = String.valueOf(object) + File.separator + "java" + File.separator + "classes";
        PlatformFont.logMessage("MOZILLA_HOME is set to \"" + (String)object + "\", trying it...");
        if (PlatformFont.loadPropertiesFromFile((String)object, string)) {
            return true;
        }
        PlatformFont.logMessage("Read faild from MOZILLA_HOME.");
        return false;
    }

    private static boolean loadPropertiesFromFile(String string, String string2) {
        SecurityManager.enablePrivilege("UniversalFileRead");
        String string3 = String.valueOf(string) + File.separator + string2;
        try {
            FileInputStream fileInputStream = new FileInputStream(string3);
            fprops.load(fileInputStream);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println("Exception occurred while loading " + string3 + ": " + iOException);
        }
        return false;
    }

    public CharsetString[] makeMultiCharsetString(String string) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length());
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2) {
        CharsetString[] charsetStringArray;
        int n3;
        Object object;
        if (n2 < 1) {
            return new CharsetString[0];
        }
        Vector vector = null;
        char[] cArray2 = new char[n2];
        char c = this.defaultChar;
        Object object2 = this.defaultFont;
        int n4 = 0;
        while (n4 < this.componentFonts.length) {
            if (!this.componentFonts[n4].isExcluded(cArray[n]) && this.componentFonts[n4].fontCharset.canConvert(cArray[n])) {
                object2 = this.componentFonts[n4];
                c = cArray[n];
                break;
            }
            ++n4;
        }
        cArray2[0] = c;
        int n5 = 0;
        int n6 = 1;
        while (n6 < n2) {
            char c2 = cArray[n + n6];
            object = this.defaultFont;
            c = this.defaultChar;
            n3 = 0;
            while (n3 < this.componentFonts.length) {
                if (!this.componentFonts[n3].isExcluded(c2) && this.componentFonts[n3].fontCharset.canConvert(c2)) {
                    object = this.componentFonts[n3];
                    c = c2;
                    break;
                }
                ++n3;
            }
            cArray2[n6] = c;
            if (object2 != object) {
                if (vector == null) {
                    vector = new Vector(3);
                }
                vector.addElement(new CharsetString(cArray2, n5, n6 - n5, (FontDescriptor)object2));
                object2 = object;
                object = this.defaultFont;
                n5 = n6;
            }
            ++n6;
        }
        object = new CharsetString(cArray2, n5, n2 - n5, (FontDescriptor)object2);
        if (vector == null) {
            charsetStringArray = new CharsetString[]{object};
        } else {
            vector.addElement(object);
            charsetStringArray = new CharsetString[vector.size()];
            n3 = 0;
            while (n3 < vector.size()) {
                charsetStringArray[n3] = (CharsetString)vector.elementAt(n3);
                ++n3;
            }
        }
        return charsetStringArray;
    }

    protected abstract CharToByteConverter getFontCharset(String var1, String var2);

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    static {
        String string;
        Object object;
        String string2;
        charsetRegistry = new Hashtable(5);
        try {
            try {
                SecurityManager.enablePrivilege("UniversalPropertyRead");
                string2 = Toolkit.getProperty(LOG_FONT_PROPERTIES, "false");
                if (Boolean.valueOf(string2).booleanValue()) {
                    object = Toolkit.getProperty(LOG_FONT_PROPERTIES_FILE, "props.log");
                    SecurityManager.enablePrivilege("UniversalFileAccess");
                    log = new PrintWriter(new FileOutputStream((String)object), true);
                    PlatformFont.logMessage("font.properties log \"" + (String)object + "\" opened.");
                }
            }
            catch (IOException iOException) {
            }
            string = null;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            SecurityManager.revertPrivilege();
            throw throwable;
        }
        SecurityManager.revertPrivilege();
        SecurityManager.enablePrivilege("UniversalPropertyRead");
        String string3 = System.getProperty("user.language", "en");
        string = System.getProperty("user.region");
        string2 = System.getProperty("file.encoding");
        object = new Properties();
        ((Hashtable)object).put("serif.0", "unknown");
        ((Hashtable)object).put("sansserif.0", "unknown");
        ((Hashtable)object).put("monospaced.0", "unknown");
        ((Hashtable)object).put("dialog.0", "unknown");
        ((Hashtable)object).put("dialoginput.0", "unknown");
        fprops = new Properties((Properties)object);
        boolean bl = false;
        if (string != null && !(bl = PlatformFont.loadProperties("font.properties." + string3 + "_" + string + "_" + string2))) {
            bl = PlatformFont.loadProperties("font.properties." + string3 + "_" + string);
        }
        if (!bl) {
            bl = PlatformFont.loadProperties("font.properties." + string3 + "_" + string2);
        }
        if (!bl) {
            bl = PlatformFont.loadProperties("font.properties." + string3);
        }
        if (!bl) {
            bl = PlatformFont.loadProperties("font.properties");
        }
        if (log != null) {
            fprops.list(log);
        }
    }
}

