/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import netscape.plugin.composer.Composer;
import netscape.plugin.composer.ComposerDocumentReader;
import netscape.plugin.composer.ComposerDocumentWriter;
import netscape.plugin.composer.Document;
import netscape.plugin.composer.PluginManager;

class ComposerDocument
extends Document {
    private Composer composer;
    private String workDirectory;
    private String text;
    private URL base;
    private URL workDirectoryURL;
    private String eventName;
    private URL documentURL;
    private ComposerDocumentReader in;
    private ComposerDocumentWriter out;
    private PluginManager manager;

    public ComposerDocument(Composer composer, String string, URL uRL, String string2, URL uRL2, String string3, URL uRL3) {
        this.composer = composer;
        this.text = string;
        this.workDirectory = string2;
        this.base = uRL;
        this.workDirectoryURL = uRL2;
        this.eventName = string3;
        this.documentURL = uRL3;
    }

    public URL getBase() {
        return this.base;
    }

    public File getWorkDirectory() {
        return new File(this.workDirectory);
    }

    public URL getWorkDirectoryURL() {
        return this.workDirectoryURL;
    }

    public Reader getInput() throws IOException {
        if (this.in != null) {
            throw new IOException("Must close existing input stream first.");
        }
        this.in = new ComposerDocumentReader(this, this.text.toCharArray());
        return this.in;
    }

    public Writer getOutput() throws IOException {
        this.doOutputCheck();
        this.out = new ComposerDocumentWriter(this);
        return this.out;
    }

    private void doOutputCheck() throws IOException {
        if (this.out != null) {
            throw new IOException("Must close existing output stream first.");
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) throws IOException {
        this.doOutputCheck();
        this.text = string;
        this.composer.newText(string);
    }

    void inputDone(ComposerDocumentReader composerDocumentReader) {
        if (composerDocumentReader == this.in) {
            this.in = null;
        }
    }

    void outputDone(ComposerDocumentWriter composerDocumentWriter, String string) {
        if (composerDocumentWriter == this.out) {
            this.out = null;
            try {
                this.setText(string);
                return;
            }
            catch (IOException iOException) {
                System.err.println("Couldn't set text.");
                iOException.printStackTrace();
                return;
            }
        }
    }

    public URL getDocumentURL() {
        return this.documentURL;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void redirectDocumentOpen(String string) {
        if (this.eventName.equals("edit")) {
            this.composer.newText(string);
        }
    }

    Composer getComposer() {
        return this.composer;
    }
}

