/*
 * Decompiled with CFR 0.152.
 */
package netscape.jsdebug;

import netscape.jsdebug.InvalidInfoException;
import netscape.jsdebug.StackFrameInfo;

public abstract class ThreadStateBase {
    protected Thread thread;
    protected boolean valid;
    protected boolean runningHook;
    protected boolean resumeWhenDone;
    protected int status;
    protected int continueState;
    protected StackFrameInfo[] stack;
    protected Object returnValue;
    protected Throwable currentException;
    protected int currentFramePtr;
    protected ThreadStateBase previous;
    public static final int THR_STATUS_UNKNOWN = 1;
    public static final int THR_STATUS_ZOMBIE = 2;
    public static final int THR_STATUS_RUNNING = 3;
    public static final int THR_STATUS_SLEEPING = 4;
    public static final int THR_STATUS_MONWAIT = 5;
    public static final int THR_STATUS_CONDWAIT = 6;
    public static final int THR_STATUS_SUSPENDED = 7;
    public static final int THR_STATUS_BREAK = 8;
    public static final int DEBUG_STATE_DEAD = 1;
    public static final int DEBUG_STATE_RUN = 2;
    public static final int DEBUG_STATE_RETURN = 3;
    public static final int DEBUG_STATE_THROW = 4;
    private static final boolean ASS = true;

    public static ThreadStateBase getThreadState(Thread thread) throws InvalidInfoException {
        throw new InternalError("unimplemented");
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isRunningHook() {
        return this.runningHook;
    }

    public int getStatus() {
        return this.status;
    }

    public abstract int countStackFrames() throws InvalidInfoException;

    public abstract StackFrameInfo getCurrentFrame() throws InvalidInfoException;

    public synchronized StackFrameInfo[] getStack() throws InvalidInfoException {
        StackFrameInfo stackFrameInfo;
        if (this.stack == null) {
            this.stack = new StackFrameInfo[this.countStackFrames()];
        }
        if (this.stack.length == 0) {
            return this.stack;
        }
        this.stack[this.stack.length - 1] = stackFrameInfo = this.getCurrentFrame();
        int n = this.stack.length - 2;
        while (n >= 0) {
            this.stack[n] = stackFrameInfo = stackFrameInfo.getCaller();
            --n;
        }
        return this.stack;
    }

    public void leaveSuspended() {
        this.resumeWhenDone = false;
    }

    public synchronized void resume() {
        if (this.runningHook) {
            this.resumeWhenDone = true;
            return;
        }
        this.resume0();
    }

    protected abstract void resume0();

    public int getContinueState() {
        return this.continueState;
    }

    public int setContinueState(int n) {
        int n2 = this.continueState;
        this.continueState = n;
        return n2;
    }

    public Object getReturnValue() throws IllegalStateException {
        if (this.continueState != 3) {
            throw new IllegalStateException("no value being returned");
        }
        return this.returnValue;
    }

    public Throwable getException() throws IllegalStateException {
        if (this.continueState != 4) {
            throw new IllegalStateException("no exception throw in progress");
        }
        return this.currentException;
    }
}

