/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

public class ClassInfo {
    String className;
    int classCount;
    String[] classNames;
    int[] classVersions;
    int fieldCount;
    String[] fieldNames;
    byte[] fieldTypes;

    public ClassInfo(String string) {
        this.className = string;
        this.classNames = new String[8];
        this.classVersions = new int[8];
        this.fieldNames = new String[24];
        this.fieldTypes = new byte[24];
    }

    public void addClass(String string, int n) {
        this.ensureClassCapacity(this.classCount);
        this.classNames[this.classCount] = string;
        this.classVersions[this.classCount] = n;
        ++this.classCount;
    }

    public void addField(String string, byte by) {
        this.ensureFieldCapacity(this.fieldCount);
        this.fieldNames[this.fieldCount] = string;
        this.fieldTypes[this.fieldCount] = by;
        ++this.fieldCount;
    }

    public String className() {
        return this.className;
    }

    public int classCount() {
        return this.classCount;
    }

    public String[] classNames() {
        String[] stringArray = new String[this.classCount];
        System.arraycopy(this.classNames, 0, stringArray, 0, this.classCount);
        return stringArray;
    }

    public int[] classVersions() {
        int[] nArray = new int[this.classCount];
        System.arraycopy(this.classVersions, 0, nArray, 0, this.classCount);
        return nArray;
    }

    public int fieldCount() {
        return this.fieldCount;
    }

    public String[] fieldNames() {
        String[] stringArray = new String[this.fieldCount];
        System.arraycopy(this.fieldNames, 0, stringArray, 0, this.fieldCount);
        return stringArray;
    }

    public byte[] fieldTypes() {
        byte[] byArray = new byte[this.fieldCount];
        System.arraycopy(this.fieldTypes, 0, byArray, 0, this.fieldCount);
        return byArray;
    }

    protected void ensureClassCapacity(int n) {
        if (n < this.classNames.length) {
            return;
        }
        int n2 = this.classNames.length == 0 ? 8 : 2 * this.classNames.length;
        while (n2 < n) {
            n2 = 2 * n2;
        }
        int n3 = this.classNames.length;
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        System.arraycopy(this.classNames, 0, stringArray, 0, n3);
        System.arraycopy(this.classVersions, 0, nArray, 0, n3);
        this.classNames = stringArray;
        this.classVersions = nArray;
    }

    protected void ensureFieldCapacity(int n) {
        int n2 = this.fieldCapacityFor(n);
        if (n2 < 0) {
            return;
        }
        int n3 = this.fieldNames.length;
        String[] stringArray = new String[n2];
        byte[] byArray = new byte[n2];
        System.arraycopy(this.fieldNames, 0, stringArray, 0, n3);
        System.arraycopy(this.fieldTypes, 0, byArray, 0, n3);
        this.fieldNames = stringArray;
        this.fieldTypes = byArray;
    }

    public int fieldCapacityFor(int n) {
        int n2 = 0;
        if (n < this.fieldNames.length) {
            return -1;
        }
        n2 = this.fieldNames.length == 0 ? 24 : 2 * this.fieldNames.length;
        while (n2 < n) {
            n2 = 2 * n2;
        }
        return n2;
    }
}

