/*
 * Decompiled with CFR 0.152.
 */
package netscape.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.Hashtable;
import netscape.net.Cache;
import netscape.net.CacheObject;
import netscape.net.CacheRequest;
import netscape.net.URLInputStream;
import netscape.net.URLOutputStream;
import netscape.security.AppletSecurity;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.security.UserTarget;

public class URLConnection
extends java.net.URLConnection {
    static final String EOL = "\r\n";
    int pStreamData;
    URLInputStream currentInputStream;
    URLOutputStream currentOutputStream;
    String postHeaders;
    boolean useSARCache = false;
    Hashtable properties;
    static Hashtable defaultProperties;
    private String filename;
    private String path;
    private String name;
    private String mimeTypeHint;
    private int type;
    private int maxSize;
    private boolean isOpen = false;
    private Cache cache;
    private final int GET_FIRST = 1;
    private final int GET_NEXT = 2;
    private final int GET_LAST = 3;
    private boolean enabled = true;
    static final int BUF_SIZE = 1024;
    static byte[] junk;
    String rangeHeader;

    protected URLConnection(URL uRL) {
        super(uRL);
        String string = null;
        try {
            string = InetAddress.getByName(uRL.getHost()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {}
        boolean bl = !SecurityManager.isPrivilegeEnabled("UniversalRedirect");
        this.pCreate(uRL.toExternalForm(), string, bl);
    }

    private native void pCreate(String var1, String var2, boolean var3);

    protected native void finalize();

    public void connect() throws IOException {
        Object object;
        if (this.connected) {
            return;
        }
        System.getSecurityManager().checkURLConnect(this.url);
        this.connected = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.postHeaders != null) {
            stringBuffer.append(this.postHeaders);
        }
        boolean bl = false;
        Hashtable hashtable = this.properties;
        if (hashtable == null) {
            hashtable = defaultProperties;
        }
        if (hashtable != null) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (string.equalsIgnoreCase("Content-length")) continue;
                if (string.equalsIgnoreCase("Content-type")) {
                    bl = true;
                }
                String string2 = (String)hashtable.get(string);
                stringBuffer.append(string);
                stringBuffer.append(":");
                stringBuffer.append(string2);
                stringBuffer.append(EOL);
            }
        }
        if (!bl) {
            stringBuffer.append("Content-type: multipart/form-data");
            stringBuffer.append(EOL);
        }
        this.postHeaders = stringBuffer.toString();
        this.properties = null;
        if (this.currentOutputStream != null) {
            this.currentOutputStream.close();
        }
        object = (URLInputStream)this.getInputStream();
        ((URLInputStream)object).open();
        this.rangeHeader = null;
    }

    public int getContentLength() {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return -1;
        }
        return this.getContentLength0();
    }

    public native int getContentLength0();

    public String getContentType() {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        return this.getContentType0();
    }

    public native String getContentType0();

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        return this.getHeaderField0(string);
    }

    public native String getHeaderField0(String var1);

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        return this.getHeaderFieldKey0(n);
    }

    public native String getHeaderFieldKey0(int var1);

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new UnknownServiceException("protocol doesn't support input");
        }
        if (this.currentInputStream == null) {
            this.currentInputStream = new URLInputStream(this);
        }
        return this.currentInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (!this.doOutput) {
            throw new UnknownServiceException("protocol doesn't support output");
        }
        if (this.currentOutputStream == null) {
            this.currentOutputStream = new URLOutputStream(this);
            this.currentOutputStream.open();
        }
        return this.currentOutputStream;
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (string.equalsIgnoreCase("Range")) {
            this.rangeHeader = string2;
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (string2 != null) {
            this.properties.put(string, string2);
            return;
        }
        this.properties.remove(string);
    }

    public String getRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(string);
    }

    public static void setDefaultRequestProperty(String string, String string2) {
        if (defaultProperties == null) {
            defaultProperties = new Hashtable();
        }
        if (string2 != null) {
            defaultProperties.put(string, string2);
            return;
        }
        defaultProperties.remove(string);
    }

    public static String getDefaultRequestProperty(String string) {
        if (defaultProperties == null) {
            return null;
        }
        return (String)defaultProperties.get(string);
    }

    native void close() throws IOException;

    void setUseSARCache(boolean bl) {
        this.useSARCache = bl;
    }

    void setName(String string) {
        this.name = string;
    }

    void setFilename(String string) {
        this.filename = string;
    }

    void setPath(String string) {
        this.path = string;
    }

    void setMimeTypeHint(String string) {
        this.mimeTypeHint = string;
    }

    boolean getUseSARCache() {
        return this.useSARCache;
    }

    void openCache(String string, String string2, String string3, Cache cache) {
        if (!this.enabled) {
            return;
        }
        this.path = string;
        this.filename = string2;
        this.name = string3;
        this.maxSize = 0;
        this.cache = cache;
        this.isOpen = this.nOpenCache();
    }

    void openCache(String string, String string2, String string3, Cache cache, int n) {
        if (!this.enabled) {
            return;
        }
        this.path = string;
        this.filename = string2;
        this.name = string3;
        this.maxSize = n;
        this.cache = cache;
        this.isOpen = this.nOpenCache();
    }

    private native boolean nOpenCache();

    void setMaxSize(int n) {
        this.maxSize = n;
        this.nUpdateCache();
    }

    private native void nUpdateCache();

    String isURLInCache(String string) {
        if (!this.enabled) {
            return null;
        }
        return this.nIsURLInCache(string);
    }

    private native String nIsURLInCache(String var1);

    void getURL(URL uRL) {
        if (!this.enabled) {
            return;
        }
        if (!this.isOpen) {
            this.nOpenCache();
            this.isOpen = true;
        }
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        UserTarget userTarget = (UserTarget)Target.findTarget("UniversalConnect");
        privilegeManager.enablePrivilege(userTarget);
        try {
            URLConnection uRLConnection = (URLConnection)uRL.openConnection();
            uRLConnection.setUseSARCache(true);
            uRLConnection.setName(this.name);
            uRLConnection.setFilename(this.filename);
            uRLConnection.setPath(this.path);
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                while (inputStream.read(junk) >= 0) {
                }
            }
            catch (IOException iOException) {}
            inputStream.close();
        }
        catch (IOException iOException) {}
        privilegeManager.revertPrivilege(userTarget);
    }

    void getURL(CacheRequest cacheRequest) throws MalformedURLException {
        if (!this.enabled) {
            return;
        }
        URL uRL = cacheRequest.getURL();
        if (!this.isOpen) {
            this.nOpenCache();
            this.isOpen = true;
        }
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        UserTarget userTarget = (UserTarget)Target.findTarget("UniversalConnect");
        privilegeManager.enablePrivilege(userTarget);
        try {
            URLConnection uRLConnection = (URLConnection)uRL.openConnection();
            uRLConnection.setUseSARCache(true);
            uRLConnection.setName(this.name);
            uRLConnection.setFilename(this.filename);
            uRLConnection.setPath(this.path);
            uRLConnection.setMimeTypeHint(cacheRequest.getMimeTypeHint());
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                while (inputStream.read(junk) >= 0) {
                }
            }
            catch (IOException iOException) {}
            cacheRequest.setLocation(uRLConnection.getHeaderField("Location"));
            cacheRequest.setContentType(uRLConnection.getHeaderField("Content-type"));
            cacheRequest.setContentLength(uRLConnection.getHeaderField("Content-length"));
            cacheRequest.setLastModified(uRLConnection.getHeaderField("Last-modified"));
            cacheRequest.setExpires(uRLConnection.getHeaderField("Expires"));
            inputStream.close();
        }
        catch (IOException iOException) {}
        privilegeManager.revertPrivilege(userTarget);
    }

    InputStream getInputStream(CacheRequest cacheRequest) throws IOException {
        if (!this.enabled) {
            return null;
        }
        URL uRL = cacheRequest.getURL();
        InputStream inputStream = null;
        if (!this.isOpen) {
            this.nOpenCache();
            this.isOpen = true;
        }
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        UserTarget userTarget = (UserTarget)Target.findTarget("UniversalConnect");
        privilegeManager.enablePrivilege(userTarget);
        URLConnection uRLConnection = (URLConnection)uRL.openConnection();
        uRLConnection.setUseSARCache(true);
        uRLConnection.setName(this.name);
        uRLConnection.setFilename(this.filename);
        uRLConnection.setPath(this.path);
        uRLConnection.setMimeTypeHint(cacheRequest.getMimeTypeHint());
        inputStream = uRLConnection.getInputStream();
        cacheRequest.setLocation(uRLConnection.getHeaderField("Location"));
        cacheRequest.setContentType(uRLConnection.getHeaderField("Content-type"));
        cacheRequest.setContentLength(uRLConnection.getHeaderField("Content-length"));
        cacheRequest.setLastModified(uRLConnection.getHeaderField("Last-modified"));
        cacheRequest.setExpires(uRLConnection.getHeaderField("Expires"));
        privilegeManager.revertPrivilege(userTarget);
        return inputStream;
    }

    InputStream getInputStream(URL uRL) throws IOException {
        if (!this.enabled) {
            return null;
        }
        InputStream inputStream = null;
        if (!this.isOpen) {
            this.nOpenCache();
            this.isOpen = true;
        }
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        UserTarget userTarget = (UserTarget)Target.findTarget("UniversalConnect");
        privilegeManager.enablePrivilege(userTarget);
        URLConnection uRLConnection = (URLConnection)uRL.openConnection();
        uRLConnection.setUseSARCache(true);
        uRLConnection.setName(this.name);
        uRLConnection.setFilename(this.filename);
        uRLConnection.setPath(this.path);
        inputStream = uRLConnection.getInputStream();
        privilegeManager.revertPrivilege(userTarget);
        return inputStream;
    }

    boolean put(String string, String string2, Hashtable hashtable) {
        if (!this.enabled) {
            return false;
        }
        String string3 = (String)hashtable.get("Content-type");
        String string4 = (String)hashtable.get("Content-length");
        String string5 = (String)hashtable.get("Last-modified");
        String string6 = (String)hashtable.get("Date");
        return this.nPut(string, string2, string3, string5 != null ? Long.parseLong(string5) : 0L, string4 != null ? Integer.parseInt(string4) : 0, string6 != null ? Long.parseLong(string6) : 0L);
    }

    private native boolean nPut(String var1, String var2, String var3, long var4, int var6, long var7);

    void remove(String string) {
        if (!this.enabled) {
            return;
        }
        if (!this.isOpen) {
            return;
        }
        this.nRemove(string);
    }

    void remove(URL uRL) {
        if (!this.enabled) {
            return;
        }
        this.remove(uRL.toString());
    }

    private native void nRemove(String var1);

    void clear() {
        if (!this.enabled) {
            return;
        }
        if (!this.isOpen) {
            return;
        }
        this.nClear();
    }

    private native void nClear();

    void delete() {
        if (!this.enabled) {
            return;
        }
        if (!this.isOpen) {
            return;
        }
        this.nDelete();
    }

    private native void nDelete();

    void closeCache() {
        if (!this.enabled) {
            return;
        }
        if (!this.isOpen) {
            return;
        }
        this.nCloseCache();
        this.isOpen = false;
    }

    private native void nCloseCache();

    void getFirstManagedCache(CacheObject cacheObject) {
        if (!this.enabled) {
            return;
        }
        this.nEnumManagedCaches(cacheObject, 1);
    }

    void getLastManagedCache(CacheObject cacheObject) {
        if (!this.enabled) {
            return;
        }
        this.nEnumManagedCaches(cacheObject, 3);
    }

    void getNextManagedCache(CacheObject cacheObject) {
        if (!this.enabled) {
            return;
        }
        this.nEnumManagedCaches(cacheObject, 2);
    }

    private native void nEnumManagedCaches(CacheObject var1, int var2);

    public static String guessContentTypeFromName(String string) {
        return java.net.URLConnection.guessContentTypeFromName(string);
    }

    static {
        junk = new byte[1024];
    }
}

