/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.ttydebug;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import symantec.tools.debug.DebuggerCallback;
import symantec.tools.debug.NoSuchLineNumberException;
import symantec.tools.debug.RemoteArray;
import symantec.tools.debug.RemoteClass;
import symantec.tools.debug.RemoteDebugger;
import symantec.tools.debug.RemoteField;
import symantec.tools.debug.RemoteInt;
import symantec.tools.debug.RemoteObject;
import symantec.tools.debug.RemoteStackFrame;
import symantec.tools.debug.RemoteStackVariable;
import symantec.tools.debug.RemoteThread;
import symantec.tools.debug.RemoteThreadGroup;
import symantec.tools.debug.RemoteValue;

public class TTY
implements DebuggerCallback {
    RemoteDebugger debugger;
    RemoteThread currentThread;
    RemoteThreadGroup currentThreadGroup;
    PrintStream out;
    PrintStream console;
    private String lastArgs;

    private RemoteThread indexToThread(int n) throws Exception {
        this.setDefaultThreadGroup();
        RemoteThread[] remoteThreadArray = this.currentThreadGroup.listThreads(true);
        if (n == 0 || n > remoteThreadArray.length) {
            return null;
        }
        return remoteThreadArray[n - 1];
    }

    private int parseThreadId(String string) throws Exception {
        int n;
        if (string.startsWith("t@")) {
            string = string.substring(2);
        }
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (this.indexToThread(n) == null) {
            this.out.println("\"" + string + "\" is not a valid thread id.");
            return 0;
        }
        return n;
    }

    private void printPrompt() throws Exception {
        if (this.currentThread == null) {
            this.out.print("> ");
        } else {
            this.out.print(String.valueOf(this.currentThread.getName()) + "[" + (this.currentThread.getCurrentFrameIndex() + 1) + "] ");
        }
        this.out.flush();
    }

    public synchronized void printToConsole(String string) throws Exception {
        this.console.print(string);
        this.console.flush();
    }

    public void breakpointEvent(RemoteThread remoteThread) throws Exception {
        this.out.print("\nBreakpoint hit: ");
        RemoteStackFrame[] remoteStackFrameArray = remoteThread.dumpStack();
        if (remoteStackFrameArray.length > 0) {
            this.out.println(remoteStackFrameArray[0].toString());
            this.currentThread = remoteThread;
        } else {
            this.out.println("Invalid thread specified in breakpoint.");
        }
        this.printPrompt();
    }

    public void stepEvent(RemoteThread remoteThread) throws Exception {
        this.out.print("\nSource step: ");
        RemoteStackFrame[] remoteStackFrameArray = remoteThread.dumpStack();
        if (remoteStackFrameArray.length > 0) {
            this.out.println(remoteStackFrameArray[0].toString());
            this.currentThread = remoteThread;
        } else {
            this.out.println("Invalid thread specified in step.");
        }
        this.printPrompt();
    }

    public void exceptionEvent(RemoteThread remoteThread, String string) throws Exception {
        this.out.println("Exception raised:  \"" + string + "\"");
        remoteThread.setCurrentFrameIndex(0);
        this.currentThread = remoteThread;
        this.printPrompt();
    }

    public void threadDeathEvent(RemoteThread remoteThread) throws Exception {
        this.out.println("\n" + remoteThread.getName() + " died.");
        if (remoteThread == this.currentThread) {
            this.currentThread = null;
        }
        this.printPrompt();
    }

    public void quitEvent() throws Exception {
        StringTokenizer stringTokenizer;
        String string = null;
        if (this.lastArgs != null && (stringTokenizer = new StringTokenizer(this.lastArgs)).hasMoreTokens()) {
            string = new String("\n" + stringTokenizer.nextToken() + " exited");
        }
        if (string == null) {
            string = new String("\nThe application exited");
        }
        this.out.println(string);
        this.currentThread = null;
        System.exit(0);
    }

    void classes() throws Exception {
        RemoteClass[] remoteClassArray = this.debugger.listClasses();
        this.out.println("** classes list **");
        int n = 0;
        while (n < remoteClassArray.length) {
            this.out.println(remoteClassArray[n].description());
            ++n;
        }
    }

    void methods(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        try {
            RemoteClass remoteClass = this.getClassFromToken(string);
            RemoteField[] remoteFieldArray = remoteClass.getMethods();
            int n = 0;
            while (n < remoteFieldArray.length) {
                this.out.println(remoteFieldArray[n].getTypedName());
                ++n;
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
            return;
        }
    }

    int printThreadGroup(RemoteThreadGroup remoteThreadGroup, int n) throws Exception {
        Object object;
        int n2;
        int n3;
        this.out.println("Group " + remoteThreadGroup.getName() + ":");
        RemoteThread[] remoteThreadArray = remoteThreadGroup.listThreads(false);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < remoteThreadArray.length) {
            n3 = remoteThreadArray[n6].description().length();
            if (n3 > n4) {
                n4 = n3;
            }
            if ((n2 = ((String)(object = (Object)remoteThreadArray[n6].getName())).lastIndexOf(46)) >= 0 && ((String)object).length() > n2) {
                object = ((String)object).substring(n2 + 1);
            }
            if (((String)object).length() > n5) {
                n5 = ((String)object).length();
            }
            ++n6;
        }
        n3 = 0;
        while (n3 < remoteThreadArray.length) {
            object = new char[80];
            n2 = 0;
            while (n2 < 79) {
                object[n2] = 32;
                ++n2;
            }
            object[79] = false;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((char[])object);
            stringBuffer.insert(n3 + n + 1 < 10 ? 1 : 0, n3 + n + 1);
            stringBuffer.insert(2, ".");
            int n7 = 4;
            stringBuffer.insert(n7, remoteThreadArray[n3].description());
            n7 += n4 + 1;
            String string = remoteThreadArray[n3].getName();
            int n8 = string.lastIndexOf(46);
            if (n8 >= 0 && string.length() > n8) {
                string = string.substring(n8 + 1);
            }
            stringBuffer.insert(n7, string);
            stringBuffer.insert(n7 += n5 + 1, remoteThreadArray[n3].getStatus());
            stringBuffer.setLength(79);
            this.out.println(stringBuffer.toString());
            ++n3;
        }
        object = this.debugger.listThreadGroups(remoteThreadGroup);
        n2 = 0;
        while (n2 < ((Object)object).length) {
            if (remoteThreadGroup != object[n2]) {
                n += this.printThreadGroup((RemoteThreadGroup)object[n2], n + remoteThreadArray.length);
            }
            ++n2;
        }
        return remoteThreadArray.length;
    }

    private void setDefaultThreadGroup() throws Exception {
        if (this.currentThreadGroup == null) {
            RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
            this.currentThreadGroup = remoteThreadGroupArray[0];
        }
    }

    void threads(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.setDefaultThreadGroup();
            this.printThreadGroup(this.currentThreadGroup, 0);
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            if (string.equals(remoteThreadGroupArray[n].getName())) {
                this.printThreadGroup(remoteThreadGroupArray[n], 0);
                return;
            }
            ++n;
        }
        this.out.println(String.valueOf(string) + " is not a valid threadgroup name.");
    }

    void threadGroups() throws Exception {
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            this.out.println(String.valueOf(new Integer(n + 1).toString()) + ". " + remoteThreadGroupArray[n].description() + " " + remoteThreadGroupArray[n].getName());
            ++n;
        }
    }

    void setThread(int n) throws Exception {
        this.setDefaultThreadGroup();
        RemoteThread remoteThread = this.indexToThread(n);
        if (remoteThread == null) {
            this.out.println("\"" + n + "\" is not a valid thread id.");
            return;
        }
        this.currentThread = remoteThread;
    }

    void thread(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Thread number not specified.");
            return;
        }
        int n = this.parseThreadId(stringTokenizer.nextToken());
        if (n == 0) {
            return;
        }
        this.setThread(n);
    }

    void threadGroup(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Threadgroup name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteThreadGroup[] remoteThreadGroupArray = this.debugger.listThreadGroups(null);
        int n = 0;
        while (n < remoteThreadGroupArray.length) {
            if (string.equals(remoteThreadGroupArray[n].getName())) {
                this.currentThreadGroup = remoteThreadGroupArray[n];
                return;
            }
            ++n;
        }
        this.out.println(String.valueOf(string) + " is not a valid threadgroup name.");
    }

    void run(StringTokenizer stringTokenizer) throws Exception {
        RemoteObject remoteObject;
        String[] stringArray = new String[100];
        int n = 0;
        if (!stringTokenizer.hasMoreTokens() && this.lastArgs != null) {
            stringTokenizer = new StringTokenizer(this.lastArgs);
            this.out.println("run " + this.lastArgs);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
            if (n != 1) continue;
            remoteObject = this.debugger.findClass(stringArray[0]);
            if (remoteObject == null) {
                this.out.println("Could not load the " + stringArray[0] + " class.");
                return;
            }
            stringArray[0] = ((RemoteClass)remoteObject).getName();
        }
        if (n > 0) {
            remoteObject = this.debugger.run(n, stringArray);
            if (remoteObject != null) {
                this.currentThreadGroup = remoteObject;
                this.setThread(1);
                this.out.println("running ...");
                return;
            }
            this.out.println(String.valueOf(stringArray[0]) + " failed.");
            return;
        }
        this.out.println("No class name specified.");
    }

    void load(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("Class name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        RemoteClass remoteClass = this.debugger.findClass(string);
        if (remoteClass == null) {
            this.out.print(String.valueOf(string) + " not found");
            this.out.println(string.indexOf(46) > 0 ? " (try the full name)" : "");
            return;
        }
        this.out.println(remoteClass.toString());
    }

    /*
     * Unable to fully structure code
     */
    void suspend(StringTokenizer var1_1) throws Exception {
        if (var1_1.hasMoreTokens()) ** GOTO lbl22
        this.setDefaultThreadGroup();
        var2_2 = this.currentThreadGroup.listThreads(true);
        var3_4 = 0;
        while (var3_4 < var2_2.length) {
            var2_2[var3_4].suspend();
            ++var3_4;
        }
        this.out.println("All (non-system) threads suspended.");
        return;
lbl-1000:
        // 1 sources

        {
            var2_3 = var1_1.nextToken();
            try {
                var3_5 = Integer.valueOf(var2_3);
            }
            catch (NumberFormatException v0) {
                var3_5 = 0;
            }
            var4_6 = this.indexToThread(var3_5);
            if (var4_6 == null) {
                this.out.println("\"" + var2_3 + "\" is not a valid thread id.");
                continue;
            }
            var4_6.suspend();
lbl22:
            // 3 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl23:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    void resume(StringTokenizer var1_1) throws Exception {
        if (var1_1.hasMoreTokens()) ** GOTO lbl26
        this.setDefaultThreadGroup();
        var2_2 = this.currentThreadGroup.listThreads(true);
        var3_4 = 0;
        while (var3_4 < var2_2.length) {
            var2_2[var3_4].resume();
            ++var3_4;
        }
        if (this.currentThread != null) {
            this.currentThread.resetCurrentFrameIndex();
        }
        this.out.println("All threads resumed.");
        return;
lbl-1000:
        // 1 sources

        {
            var2_3 = var1_1.nextToken();
            try {
                var3_5 = Integer.valueOf(var2_3);
            }
            catch (NumberFormatException v0) {
                var3_5 = 0;
            }
            var4_6 = this.indexToThread(var3_5);
            if (var4_6 == null) {
                this.out.println("\"" + var2_3 + "\" is not a valid thread id.");
                continue;
            }
            var4_6.resume();
            if (var4_6 != this.currentThread) continue;
            this.currentThread.resetCurrentFrameIndex();
lbl26:
            // 4 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl27:
        // 1 sources

    }

    void cont() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        this.debugger.cont();
    }

    void step() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            this.currentThread.step(true);
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not at breakpoint.");
            return;
        }
    }

    void next() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            this.currentThread.next();
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not at breakpoint.");
            return;
        }
    }

    void stepout() throws Exception {
        if (this.currentThread == null) {
            this.out.println("Nothing suspended.");
            return;
        }
        try {
            this.currentThread.stepout();
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread is not at breakpoint.");
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    void kill(StringTokenizer var1_1) throws Exception {
        if (var1_1.hasMoreTokens()) ** GOTO lbl26
        this.out.println("Usage: kill <threadgroup name> or <thread id>");
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.nextToken();
            try {
                var3_3 = Integer.valueOf(var2_2);
            }
            catch (NumberFormatException v0) {
                var3_3 = 0;
            }
            var4_4 = this.indexToThread(var3_3);
            if (var4_4 != null) {
                this.out.println("killing thread: " + var4_4.getName());
                var4_4.stop();
                return;
            }
            var5_5 = this.debugger.listThreadGroups(null);
            var5_5 = this.debugger.listThreadGroups(var5_5[0]);
            var6_6 = 0;
            while (var6_6 < var5_5.length) {
                if (var5_5[var6_6].getName().equals(var2_2)) {
                    this.out.println("killing threadgroup: " + var2_2);
                    var5_5[var6_6].stop();
                    return;
                }
                ++var6_6;
            }
            this.out.println("\"" + var2_2 + "\" is not a valid threadgroup or id.");
lbl26:
            // 2 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl27:
        // 1 sources

    }

    void catchException(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            String[] stringArray = this.debugger.getExceptionCatchList();
            int n = 0;
            while (n < stringArray.length) {
                this.out.print("  " + stringArray[n]);
                if ((n & 4) == 3 || n == stringArray.length - 1) {
                    this.out.println();
                }
                ++n;
            }
            return;
        }
        String string = stringTokenizer.nextToken();
        try {
            RemoteClass remoteClass = this.getClassFromToken(string);
            remoteClass.catchExceptions();
            return;
        }
        catch (Exception exception) {
            this.out.println("Invalid exception class name: " + string);
            return;
        }
    }

    void ignoreException(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            String[] stringArray = this.debugger.getExceptionCatchList();
            int n = 0;
            while (n < stringArray.length) {
                this.out.print("  " + stringArray[n]);
                if ((n & 4) == 3 || n == stringArray.length - 1) {
                    this.out.println();
                }
                ++n;
            }
            return;
        }
        String string = stringTokenizer.nextToken();
        try {
            RemoteClass remoteClass = this.getClassFromToken(string);
            remoteClass.ignoreExceptions();
            return;
        }
        catch (Exception exception) {
            this.out.println("Invalid exception class name: " + string);
            return;
        }
    }

    void up(StringTokenizer stringTokenizer) throws Exception {
        if (this.currentThread == null) {
            this.out.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 == 0) {
                this.out.println("Usage: up [n frames]");
                return;
            }
            n = n2;
        }
        try {
            this.currentThread.up(n);
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Thread isn't suspended.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("End of stack.");
            return;
        }
    }

    void down(StringTokenizer stringTokenizer) throws Exception {
        if (this.currentThread == null) {
            this.out.println("Current thread not set.");
            return;
        }
        int n = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (n2 == 0) {
                this.out.println("usage: down [n frames]");
                return;
            }
            n = n2;
        }
        try {
            this.currentThread.down(n);
            return;
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Thread isn't suspended.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("End of stack.");
            return;
        }
    }

    void dumpStack(RemoteThread remoteThread) throws Exception {
        RemoteStackFrame[] remoteStackFrameArray = remoteThread.dumpStack();
        if (remoteStackFrameArray.length == 0) {
            this.out.println("Thread is not running (no stack).");
            return;
        }
        int n = remoteStackFrameArray.length;
        int n2 = remoteThread.getCurrentFrameIndex();
        while (n2 < n) {
            this.out.print("  [" + (n2 + 1) + "] ");
            this.out.println(remoteStackFrameArray[n2].toString());
            ++n2;
        }
    }

    void where(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            if (this.currentThread == null) {
                this.out.println("No thread specified.");
                return;
            }
            this.dumpStack(this.currentThread);
            return;
        }
        String string = stringTokenizer.nextToken();
        if (string.toLowerCase().equals("all")) {
            this.setDefaultThreadGroup();
            RemoteThread[] remoteThreadArray = this.currentThreadGroup.listThreads(true);
            int n = 0;
            while (n < remoteThreadArray.length) {
                this.out.println(String.valueOf(remoteThreadArray[n].getName()) + ": ");
                this.dumpStack(remoteThreadArray[n]);
                ++n;
            }
            return;
        }
        int n = this.parseThreadId(string);
        if (n == 0) {
            return;
        }
        this.dumpStack(this.indexToThread(n));
    }

    void trace(String string, StringTokenizer stringTokenizer) throws Exception {
        boolean bl;
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println("(i)trace < \"on\" | \"off\" >");
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("on")) {
            bl = true;
        } else if (string2.equals("off")) {
            bl = false;
        } else {
            this.out.println("(i)trace < \"on\" | \"off\" >");
            return;
        }
        if (string.equals("trace")) {
            this.debugger.trace(bl);
            return;
        }
        this.debugger.itrace(bl);
    }

    void memory() throws Exception {
        this.out.println("Free: " + this.debugger.freeMemory() + ", total: " + this.debugger.totalMemory());
    }

    void gc() throws Exception {
        RemoteObject[] remoteObjectArray = new RemoteObject[]{this.currentThread, this.currentThreadGroup};
        this.debugger.gc(remoteObjectArray);
    }

    private RemoteClass getClassFromToken(String string) throws Exception {
        RemoteObject remoteObject;
        if (string.startsWith("0x") || Character.isDigit(string.charAt(0))) {
            int n;
            try {
                n = RemoteValue.fromHex(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n == 0 || (remoteObject = this.debugger.get(new Integer(n))) == null) {
                throw new IllegalArgumentException();
            }
            if (!(remoteObject instanceof RemoteClass)) {
                throw new IllegalArgumentException();
            }
        } else {
            remoteObject = this.debugger.findClass(string);
            if (remoteObject == null) {
                throw new IllegalArgumentException();
            }
        }
        return remoteObject;
    }

    void listBreakpoints() throws Exception {
        String[] stringArray = this.debugger.listBreakpoints();
        if (stringArray.length > 0) {
            this.out.println("Current breakpoints set:");
            int n = 0;
            while (n < stringArray.length) {
                this.out.println("\t" + stringArray[n]);
                ++n;
            }
            return;
        }
        this.out.println("No breakpoints set.");
    }

    void stop(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        String string = null;
        try {
            RemoteField remoteField;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("at")) {
                boolean bl = true;
            } else if (string2.equals("in")) {
                boolean bl = false;
            } else {
                this.out.println("Usage: stop at <class>:<line_number> or");
                this.out.println("       stop in <class>.<method_name>");
                return;
            }
            if (string2.equals("at")) {
                String string3;
                int n;
                string = stringTokenizer.nextToken(": \t\n\r");
                RemoteClass remoteClass = this.getClassFromToken(string);
                String string4 = remoteClass.setBreakpointLine(n = Integer.valueOf(string3 = stringTokenizer.nextToken()).intValue());
                if (string4.length() > 0) {
                    this.out.println(string4);
                    return;
                }
                this.out.println("Breakpoint set at " + remoteClass.getName() + ":" + n);
                return;
            }
            string = stringTokenizer.nextToken(": \t\n\r");
            RemoteClass remoteClass = null;
            String string5 = null;
            try {
                remoteClass = this.getClassFromToken(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int n = string.lastIndexOf(".");
                if (n == -1) {
                    this.out.println("\"" + string + "\" is not a valid id or class name.");
                    return;
                }
                string5 = string.substring(n + 1);
                string = string.substring(0, n);
                remoteClass = this.getClassFromToken(string);
            }
            if (string5 == null) {
                string5 = stringTokenizer.nextToken();
            }
            try {
                remoteField = remoteClass.getMethod(string5);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.out.println("Class " + remoteClass.getName() + " doesn't have a method " + string5);
                return;
            }
            String string6 = remoteClass.setBreakpointMethod(remoteField);
            if (string6.length() > 0) {
                this.out.println(string6);
                return;
            }
            this.out.println("Breakpoint set in " + remoteClass.getName() + "." + string5);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("Usage: stop at <class>:<line_number> or");
            this.out.println("       stop in <class>.<method_name>");
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.out.println("Invalid line number.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
            return;
        }
    }

    void clear(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        String string = null;
        String string2 = null;
        RemoteClass remoteClass = null;
        try {
            string = stringTokenizer.nextToken(": \t\n\r");
            try {
                remoteClass = this.getClassFromToken(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RemoteField remoteField;
                int n = string.lastIndexOf(".");
                if (n == -1) {
                    this.out.println("\"" + string + "\" is not a valid id or class name.");
                    return;
                }
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
                remoteClass = this.getClassFromToken(string);
                try {
                    remoteField = remoteClass.getMethod(string2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.out.println("\"" + string2 + "\" is not a valid method name of class " + remoteClass.getName());
                    return;
                }
                String string3 = remoteClass.clearBreakpointMethod(remoteField);
                if (string3.length() > 0) {
                    this.out.println(string3);
                    return;
                }
                this.out.println("Breakpoint cleared at " + remoteClass.getName() + "." + string2);
                return;
            }
            String string4 = stringTokenizer.nextToken();
            int n = Integer.valueOf(string4);
            String string5 = remoteClass.clearBreakpointLine(n);
            if (string5.length() > 0) {
                this.out.println(string5);
                return;
            }
            this.out.println("Breakpoint cleared at " + remoteClass.getName() + ": " + n);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.out.println("Usage: clear <class>:<line_number>");
            this.out.println("   or: clear <class>.<method>");
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.out.println("Usage: clear <class>:<line_number>");
            this.out.println("   or: clear <class>.<method>");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("\"" + string + "\" is not a valid id or class name.");
            return;
        }
    }

    void list(StringTokenizer stringTokenizer) throws Exception {
        int n;
        RemoteStackFrame remoteStackFrame = null;
        if (this.currentThread == null) {
            this.out.println("No thread specified.");
            return;
        }
        try {
            remoteStackFrame = this.currentThread.getCurrentFrame();
        }
        catch (IllegalAccessError illegalAccessError) {
            this.out.println("Current thread isn't suspended.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.out.println("Thread is not running (no stack).");
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    n = remoteStackFrame.getRemoteClass().getMethodLineNumber(string);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.out.println(String.valueOf(string) + " is not a valid line number or " + "method name for class " + remoteStackFrame.getRemoteClass().getName());
                    return;
                }
                catch (NoSuchLineNumberException noSuchLineNumberException) {
                    this.out.println("Line number information not found in " + remoteStackFrame.getRemoteClass().getName());
                    return;
                }
            }
        } else {
            n = remoteStackFrame.getLineNumber();
        }
        int n2 = n > 4 ? n - 4 : 1;
        int n3 = n2 + 9;
        InputStream inputStream = remoteStackFrame.getRemoteClass().getSourceFile();
        if (inputStream == null) {
            this.out.println("Unable to find " + remoteStackFrame.getRemoteClass().getSourceFileName());
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        String string = null;
        int n4 = 1;
        while (n4 <= n2) {
            string = dataInputStream.readLine();
            ++n4;
        }
        if (string == null) {
            this.out.println(String.valueOf(new Integer(n).toString()) + " is an invalid line number for the file " + remoteStackFrame.getRemoteClass().getSourceFileName());
        }
        int n5 = n2;
        while (n5 < n3 && string != null) {
            this.out.print(String.valueOf(new Integer(n5).toString()) + "\t" + (n5 == n ? "=> " : "   "));
            this.out.println(string);
            string = dataInputStream.readLine();
            ++n5;
        }
    }

    void use(StringTokenizer stringTokenizer) throws Exception {
        if (!stringTokenizer.hasMoreTokens()) {
            this.out.println(this.debugger.getSourcePath());
            return;
        }
        this.debugger.setSourcePath(stringTokenizer.nextToken());
    }

    private void printVar(RemoteStackVariable remoteStackVariable) {
        this.out.print("  " + remoteStackVariable.getName());
        if (remoteStackVariable.inScope()) {
            RemoteValue remoteValue = remoteStackVariable.getValue();
            this.out.println(" = " + (remoteValue == null ? "null" : remoteValue.description()));
            return;
        }
        this.out.println(" is not in scope");
    }

    void locals() throws Exception {
        if (this.currentThread == null) {
            this.out.println("No default thread specified: use the \"thread\" command first.");
            return;
        }
        RemoteStackVariable[] remoteStackVariableArray = this.currentThread.getStackVariables();
        if (remoteStackVariableArray == null || remoteStackVariableArray.length == 0) {
            this.out.println("No local variables: try compiling with -g");
            return;
        }
        this.out.println("Method arguments:");
        int n = 0;
        while (n < remoteStackVariableArray.length) {
            if (remoteStackVariableArray[n].methodArgument()) {
                this.printVar(remoteStackVariableArray[n]);
            }
            ++n;
        }
        this.out.println("Local variables:");
        int n2 = 0;
        while (n2 < remoteStackVariableArray.length) {
            if (!remoteStackVariableArray[n2].methodArgument()) {
                this.printVar(remoteStackVariableArray[n2]);
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean print(StringTokenizer var1_1, boolean var2_2, boolean var3_3) throws Exception {
        if (var1_1.hasMoreTokens()) ** GOTO lbl148
        this.out.println("No objects specified.");
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5 = null;
            var6_6 = ".[(";
            var7_7 = var1_1.nextToken();
            var8_8 = new StringTokenizer(var7_7, var6_6, true);
            var9_9 = var8_8.nextToken();
            var10_10 = var7_7;
            if (var9_9.startsWith("t@")) {
                this.setDefaultThreadGroup();
                var11_11 = this.currentThreadGroup.listThreads(true);
                try {
                    var4_4 = Integer.valueOf(var9_9.substring(2));
                }
                catch (NumberFormatException v0) {
                    var4_4 = 0;
                }
                if (var4_4 <= 0 || var4_4 > ((RemoteThread[])var11_11).length) {
                    this.out.println("\"" + var9_9 + "\" is not a valid thread id.");
                    return false;
                }
                var5_5 = var11_11[var4_4 - 1];
            } else if (var9_9.startsWith("$s")) {
                try {
                    var11_12 = Integer.valueOf(var9_9.substring(2));
                }
                catch (NumberFormatException v1) {
                    this.out.println("\"" + var9_9 + "\" is not a valid slot.");
                    return false;
                }
                if (this.currentThread != null) {
                    var12_14 = this.currentThread.getStackVariables();
                    if (var12_14 == null || var11_12 >= ((RemoteStackVariable[])var12_14).length) {
                        this.out.println("\"" + var9_9 + "\" is not a valid slot.");
                        return false;
                    }
                    var5_5 = var12_14[var11_12].getValue();
                }
            } else if (var9_9.startsWith("0x") || Character.isDigit(var9_9.charAt(0))) {
                try {
                    var4_4 = RemoteValue.fromHex(var9_9);
                }
                catch (NumberFormatException v2) {
                    var4_4 = 0;
                }
                if (var4_4 == 0 || (var5_5 = this.debugger.get(new Integer(var4_4))) == null) {
                    this.out.println("\"" + var9_9 + "\" is not a valid id.");
                    return false;
                }
            } else {
                if (this.currentThread != null) {
                    var11_11 = this.currentThread.getStackVariable(var9_9);
                    if (var11_11 != null && !var11_11.inScope()) {
                        this.out.println(String.valueOf(var9_9) + " is not in scope.");
                        return false;
                    }
                    v3 = var5_5 = var11_11 == null ? null : var11_11.getValue();
                }
                if (var5_5 == null) {
                    if (!var9_9.equals("this") && this.print(new StringTokenizer((String)(var11_11 = "this." + var9_9)), var2_2, true)) {
                        return true;
                    }
                    var5_5 = this.debugger.findClass(var9_9);
                    if (var5_5 == null) {
                        if (!var3_3) {
                            this.out.println("\"" + var7_7 + "\" is not a " + "valid id or class name.");
                        }
                        return false;
                    }
                }
            }
            var12_14 = var11_11 = new RemoteInt(-1);
            var13_15 = "";
            var9_9 = var8_8.hasMoreTokens() != false ? var8_8.nextToken() : null;
            while (var9_9 != null) {
                if (var9_9.equals(".")) {
                    if (!var8_8.hasMoreTokens()) {
                        this.out.println("\"" + var7_7 + "\" is not a valid expression.");
                        return false;
                    }
                    var9_9 = var8_8.nextToken();
                    if (var12_14 != var11_11) {
                        this.out.println("\"" + var13_15 + "\" is not an object.");
                        return false;
                    }
                    var13_15 = var9_9;
                    var12_14 = ((RemoteObject)var5_5).getFieldValue(var9_9);
                    if (var12_14 == null) {
                        this.out.println("\"" + var9_9 + "\" is not a valid field of " + var5_5.description());
                        return false;
                    }
                    if (var12_14.isObject()) {
                        var5_5 = var12_14;
                        var12_14 = var11_11;
                    }
                    var9_9 = var8_8.hasMoreTokens() != false ? var8_8.nextToken() : null;
                    continue;
                }
                if (var9_9.equals("[")) {
                    if (!var8_8.hasMoreTokens()) {
                        this.out.println("\"" + var7_7 + "\" is not a valid expression.");
                        return false;
                    }
                    var9_9 = var8_8.nextToken("]");
                    try {
                        var14_16 = Integer.valueOf(var9_9);
                        var12_14 = ((RemoteArray)var12_14).getElement(var14_16);
                    }
                    catch (NumberFormatException v4) {
                        this.out.println("\"" + var9_9 + "\" is not a valid decimal number.");
                        return false;
                    }
                    catch (ArrayIndexOutOfBoundsException v5) {
                        this.out.println(String.valueOf(var9_9) + " is out of bounds for " + var5_5.description());
                        return false;
                    }
                    if (var12_14 != null && var12_14.isObject()) {
                        var5_5 = var12_14;
                        var12_14 = var11_11;
                    }
                    if (!var8_8.hasMoreTokens() || !(var9_9 = var8_8.nextToken()).equals("]")) {
                        this.out.println("\"" + var7_7 + "\" is not a valid expression.");
                        return false;
                    }
                    var9_9 = var8_8.hasMoreTokens() != false ? var8_8.nextToken(var6_6) : null;
                    continue;
                }
                if (var9_9.equals("(")) {
                    this.out.println("print <method> not supported yet.");
                    return false;
                }
                this.out.println("invalid expression");
                return false;
            }
            this.out.print(String.valueOf(var10_10) + " = ");
            if (var12_14 != var11_11) {
                this.out.println(var12_14 == null ? "null" : var12_14.description());
                continue;
            }
            if (var2_2 && var5_5 instanceof RemoteObject) {
                this.out.println(String.valueOf(var5_5.description()) + " {");
                if (var5_5 instanceof RemoteClass) {
                    var14_17 = (RemoteClass)var5_5;
                    this.out.print("    superclass = ");
                    var15_20 = var14_17.getSuperclass();
                    this.out.println(var15_20 == null ? "null" : var15_20.description());
                    this.out.print("    loader = ");
                    var16_21 = var14_17.getClassLoader();
                    this.out.println(var16_21 == null ? "null" : var16_21.description());
                    var17_22 = var14_17.getInterfaces();
                    if (var17_22 != null && var17_22.length > 0) {
                        this.out.println("    interfaces:");
                        var18_23 = 0;
                        while (var18_23 < var17_22.length) {
                            this.out.println("        " + var17_22[var18_23]);
                            ++var18_23;
                        }
                    }
                }
                var14_18 = ((RemoteObject)var5_5).getFields();
                if (var5_5 instanceof RemoteClass && var14_18.length > 0) {
                    this.out.println();
                }
                var15_19 = 0;
                while (var15_19 < var14_18.length) {
                    var16_21 = var14_18[var15_19].getTypedName();
                    var17_22 = var14_18[var15_19].getModifiers();
                    this.out.print("    " + (String)var17_22 + (String)var16_21 + " = ");
                    var18_24 = ((RemoteObject)var5_5).getFieldValue(var15_19);
                    this.out.println(var18_24 == null ? "null" : var18_24.description());
                    ++var15_19;
                }
                this.out.println("}");
                continue;
            }
            this.out.println(var5_5.toString());
lbl148:
            // 4 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl149:
        // 1 sources

        return true;
    }

    void help() {
        this.out.println("** command list **");
        this.out.println("threads [threadgroup]     -- list threads");
        this.out.println("thread <thread id>        -- set default thread");
        this.out.println("suspend [thread id(s)]    -- suspend threads (default: all)");
        this.out.println("resume [thread id(s)]     -- resume threads (default: all)");
        this.out.println("where [thread id] | all   -- dump a thread's stack");
        this.out.println("threadgroups              -- list threadgroups");
        this.out.println("threadgroup <name>        -- set current threadgroup\n");
        this.out.println("print <id> [id(s)]        -- print object or field");
        this.out.println("dump <id> [id(s)]         -- print all object information\n");
        this.out.println("locals                    -- print all local variables in current stack frame\n");
        this.out.println("classes                   -- list currently known classes");
        this.out.println("methods <class id>        -- list a class's methods\n");
        this.out.println("stop in <class id>.<method> -- set a breakpoint in a method");
        this.out.println("stop at <class id>:<line> -- set a breakpoint at a line");
        this.out.println("up [n frames]             -- move up a thread's stack");
        this.out.println("down [n frames]           -- move down a thread's stack");
        this.out.println("clear <class id>:<line>   -- clear a breakpoint");
        this.out.println("step                      -- execute current line");
        this.out.println("cont                      -- continue execution from breakpoint\n");
        this.out.println("catch <class id>          -- break for the specified exception");
        this.out.println("ignore <class id>         -- ignore when the specified exception\n");
        this.out.println("list [line number|method] -- print source code");
        this.out.println("use [source file path]    -- display or change the source path\n");
        this.out.println("memory                    -- report memory usage");
        this.out.println("gc                        -- free unused objects\n");
        this.out.println("load classname            -- load Java class to be debugged");
        this.out.println("run <class> [args]        -- start execution of a loaded Java class");
        this.out.println("!!                        -- repeat last command");
        this.out.println("help (or ?)               -- list commands");
        this.out.println("exit (or quit)            -- exit debugger");
    }

    void executeCommand(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().toLowerCase();
        try {
            if (string.equals("print")) {
                this.print(stringTokenizer, false, false);
                return;
            }
            if (string.equals("dump")) {
                this.print(stringTokenizer, true, false);
                return;
            }
            if (string.equals("locals")) {
                this.locals();
                return;
            }
            if (string.equals("classes")) {
                this.classes();
                return;
            }
            if (string.equals("methods")) {
                this.methods(stringTokenizer);
                return;
            }
            if (string.equals("threads")) {
                this.threads(stringTokenizer);
                return;
            }
            if (string.equals("thread")) {
                this.thread(stringTokenizer);
                return;
            }
            if (string.equals("suspend")) {
                this.suspend(stringTokenizer);
                return;
            }
            if (string.equals("resume")) {
                this.resume(stringTokenizer);
                return;
            }
            if (string.equals("threadgroups")) {
                this.threadGroups();
                return;
            }
            if (string.equals("threadgroup")) {
                this.threadGroup(stringTokenizer);
                return;
            }
            if (string.equals("catch")) {
                this.catchException(stringTokenizer);
                return;
            }
            if (string.equals("ignore")) {
                this.ignoreException(stringTokenizer);
                return;
            }
            if (string.equals("cont")) {
                this.cont();
                return;
            }
            if (string.equals("step")) {
                this.step();
                return;
            }
            if (string.equals("next")) {
                this.next();
                return;
            }
            if (string.equals("stepout")) {
                this.stepout();
                return;
            }
            if (string.equals("kill")) {
                this.kill(stringTokenizer);
                return;
            }
            if (string.equals("where")) {
                this.where(stringTokenizer);
                return;
            }
            if (string.equals("up")) {
                this.up(stringTokenizer);
                return;
            }
            if (string.equals("down")) {
                this.down(stringTokenizer);
                return;
            }
            if (string.equals("load")) {
                this.load(stringTokenizer);
                return;
            }
            if (string.equals("run")) {
                this.run(stringTokenizer);
                return;
            }
            if (string.equals("memory")) {
                this.memory();
                return;
            }
            if (string.equals("gc")) {
                this.gc();
                return;
            }
            if (string.equals("trace") || string.equals("itrace")) {
                this.trace(string, stringTokenizer);
                return;
            }
            if (string.equals("stop")) {
                this.stop(stringTokenizer);
                return;
            }
            if (string.equals("clear")) {
                this.clear(stringTokenizer);
                return;
            }
            if (string.equals("list")) {
                this.list(stringTokenizer);
                return;
            }
            if (string.equals("use")) {
                this.use(stringTokenizer);
                return;
            }
            if (string.equals("help") || string.equals("?")) {
                this.help();
                return;
            }
            if (string.equals("quit") || string.equals("exit")) {
                this.debugger.close();
                System.exit(0);
                return;
            }
            this.out.println("huh? Try help...");
            return;
        }
        catch (Exception exception) {
            this.out.println("Internal exception:");
            this.out.flush();
            exception.printStackTrace();
            return;
        }
    }

    void readCommandFile(File file) {
        try {
            if (file.canRead()) {
                String string;
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                while ((string = dataInputStream.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    this.executeCommand(stringTokenizer);
                }
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public TTY(String string, String string2, String string3, String string4, PrintStream printStream, PrintStream printStream2, boolean bl) throws Exception {
        Object object;
        System.out.println("Initializing jdb...");
        this.out = printStream;
        this.console = printStream2;
        this.debugger = string2 == null ? new RemoteDebugger(string3, this, bl) : new RemoteDebugger(string, string2, this, bl);
        DataInputStream dataInputStream = new DataInputStream(System.in);
        String string5 = null;
        if (string4 != null && string4.length() > 0) {
            object = new StringTokenizer(string4);
            this.load((StringTokenizer)object);
            this.lastArgs = string4;
        }
        Thread.currentThread().setPriority(5);
        object = new File(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "jdb.ini");
        if (!((File)object).canRead()) {
            object = new File(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".jdbrc");
        }
        this.readCommandFile((File)object);
        object = new File(String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "startup.jdb");
        this.readCommandFile((File)object);
        while (true) {
            StringTokenizer stringTokenizer;
            this.printPrompt();
            String string6 = dataInputStream.readLine();
            if (string6 == null) {
                this.out.println("Input stream closed.");
                return;
            }
            if (string6.startsWith("!!") && string5 != null) {
                string6 = String.valueOf(string5) + string6.substring(2);
                this.out.println(string6);
            }
            if (!(stringTokenizer = new StringTokenizer(string6)).hasMoreTokens()) continue;
            string5 = string6;
            this.executeCommand(stringTokenizer);
        }
    }

    public static void main(String[] stringArray) {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            string = "localhost";
        }
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string6 = stringArray[n];
            if (string6.equals("-dbgtrace")) {
                bl = true;
            } else if (string6.equals("-cs") || string6.equals("-checksource") || string6.equals("-noasyncgc") || string6.equals("-prof") || string6.equals("-v") || string6.equals("-verbose") || string6.equals("-verify") || string6.equals("-noverify") || string6.equals("-verifyremote") || string6.equals("-verbosegc") || string6.startsWith("-ms") || string6.startsWith("-mx") || string6.startsWith("-ss") || string6.startsWith("-oss") || string6.startsWith("-D")) {
                string5 = String.valueOf(string5) + string6 + " ";
            } else if (string6.equals("-classpath")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No classpath specified.");
                    System.exit(1);
                }
                string5 = String.valueOf(string5) + string6 + " " + stringArray[++n] + " ";
            } else if (string6.equals("-host")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No host specified.");
                    System.exit(1);
                }
                string2 = stringArray[++n];
            } else if (string6.equals("-password")) {
                if (n == stringArray.length - 1) {
                    System.out.println("No password specified.");
                    System.exit(1);
                }
                string3 = stringArray[++n];
            } else {
                string4 = String.valueOf(string4) + string6 + " ";
            }
            ++n;
        }
        if (string2 != null && string3 == null) {
            System.out.println("A debug password must be specified for remote debugging.");
            System.exit(1);
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            if (!string2.equals(string) && string3.length() == 0) {
                System.out.println("No password supplied for accessing remote Java interpreter.");
                System.out.println("The password is reported by the remote interpreterwhen it is started.");
                System.exit(1);
            }
            new TTY(string2, string3, string5, string4, System.out, System.out, bl);
            return;
        }
        catch (SocketException socketException) {
            System.out.println("Failed accessing debugging session on " + string2 + ": invalid password.");
            return;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Failed accessing debugging session on " + string2 + ": invalid password.");
            return;
        }
        catch (Exception exception) {
            System.out.print("Internal exception:  ");
            System.out.flush();
            exception.printStackTrace();
            return;
        }
    }
}

