/*---------------------------------------------------------------------------*
 * File:	rmemset.c
 *---------------------------------------------------------------------------*
 * Copyright (C) 1997 1998 Geoff Wing <mason@primnet.com.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *--------------------------------------------------------------------------*
 * Fast memset()
 * Written 1997 Geoff Wing <mason@primenet.com.au>
 * $Id: rmemset.c 1.1 Sun, 03 Aug 1997 16:47:17 +0000 oec $
 *--------------------------------------------------------------------------*/

#include "../config.h"
#ifdef PROTOTYPES
#define __PROTO(p)      p
#else
#define __PROTO(p)      ()
#endif
#include "rmemset.pro"

/* PROTO */
void
rmemset(void *b, unsigned char c, int len)
{
    int             val, i, *rp;
    unsigned char  *lp, lc;

    lc = c;
    if ((i = len) < 16) {
/* A: probably not worth all the calculations */
	for (lp = b; i--;)
	    *lp++ = lc;
    } else {
/* B: presume integers write the best */
/* B1: write out preceding characters so we align on an integer boundary */
	if ((i = ((int)b % SIZEOF_INT)) == 0)
	    rp = b;
	else {
	    i = SIZEOF_INT - i;
	    len -= i;
	    for (lp = b; i--;)
		*lp++ = lc;
	    rp = (int *)lp;
	}

/* B2: do the fast writing */
	val = (lc << 8) + lc;
#if SIZEOF_INT >= 4
	val = (val << 16) | val;
#endif
#if SIZEOF_INT >= 8
	val = (val << 32) | val;
#endif
#if SIZEOF_INT == 16
	val = (val << 64) | val;
#endif
	for (i = len / SIZEOF_INT; i--;)
	    *rp++ = val;

/* B3: write trailing characters which come after the last integer boundary */
	if ((i = (len % SIZEOF_INT)) != 0)
	    for (lp = (unsigned char *)rp; i--;)
		*lp++ = lc;
    }
}
