
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <Xm/ComboBoxP.h>
#include <Xm/GrabShellP.h>

#if !defined(CB_IdealEBHeight)
#define CB_IdealEBHeight(w) \
    (((XmComboBoxWidget)(w))->combo_box.ideal_ebheight)
#endif

#if !defined(CB_IdealEBWidth)
#define CB_IdealEBWidth(w) \
    (((XmComboBoxWidget)(w))->combo_box.ideal_ebwidth)
#endif

void XdbPrintComboBoxResources(Widget w)
{
  Dimension arrowSize, arrowSpacing;
  Dimension marginWidth, marginHeight;

  XtVaGetValues(w,
                XmNarrowSize, &arrowSize,
                XmNarrowSpacing, &arrowSpacing,
                XmNmarginWidth, &marginWidth,
                XmNmarginHeight, &marginHeight,
                NULL);

  fprintf(stderr,"ArrowSize (%d)\n",(int) arrowSize);
  fprintf(stderr,"ArrowSpacing (%d)\n",(int) arrowSpacing);
  fprintf(stderr,"MarginWidth (%d)\n",(int) marginWidth);
  fprintf(stderr,"MarginHeight (%d)\n",(int) marginHeight);
  fprintf(stderr,"IdealEBHeight (%d)\n",(int) CB_IdealEBHeight(w));
  fprintf(stderr,"IdealEBWidth (%d)\n",(int) CB_IdealEBWidth(w));
  fprintf(stderr,"HitRectX(%d)\n",(int) CB_HitRect(w).x);
  fprintf(stderr,"HitRectY(%d)\n",(int) CB_HitRect(w).y);
  fprintf(stderr,"HitRectWidth(%d)\n",(int) CB_HitRect(w).width);
  fprintf(stderr,"HitRectHeight(%d)\n",(int) CB_HitRect(w).height);
}

void XdbPrintGrabShellResources(Widget w)
{
  int grabStyle = -1;
  Boolean ownerEvents, saveUnder, overrideRedirect;
  Dimension shadowThickness;

  XtVaGetValues(w,
                XmNgrabStyle, &grabStyle,
                XtNoverrideRedirect, &overrideRedirect,
                XmNownerEvents, &ownerEvents,
                XtNsaveUnder, &saveUnder,
                XmNshadowThickness, &shadowThickness,
                NULL);

  fprintf(stderr,"GrabStyle (%d)\n",grabStyle);
  fprintf(stderr,"OverrideRedirect (%d)\n",(int) overrideRedirect);
  fprintf(stderr,"OwnerEvents (%d)\n",(int) ownerEvents);
  fprintf(stderr,"SaveUnder (%d)\n",(int) saveUnder);
  fprintf(stderr,"ShadowThickness (%d)\n",(int) shadowThickness);
}

void XdbPrintResources(Widget w)
{
   if (XmIsComboBox(w))
   {
      XdbPrintComboBoxResources(w);
   }
   else if (XmIsGrabShell(w))
   {
      XdbPrintGrabShellResources(w);
   }
}

