                       /*  ET6000 driver  Don Secrest  version 0.22 */
                       /*   March 24, 1998 */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <asm/page.h>
#include "vga.h"
#include "libvga.h"
#include "driver.h"
/* #include "ramdac/ramdac.h" */
#include <linux/pci.h>

#ifdef DB6K
#include <time.h>
FILE *outf;
static int compareregs(void);
static int textset = 0;
static void prtmodeinfo(vga_modeinfo *m);
static char *not_written = "ET6000 subroutine %s is not written yet.\n";
static unsigned char *textstore = 0;
static unsigned char *vgatextstore = 0;
#define DNOTW(a) fprintf(outf,not_written,a)
#define DPRT(a) fprintf(outf,a)
#else
#define DNOTW(a)
#define DPRT(a)
#endif  /* DB6K */

#define SEG_SELECT 0x3CD

static unsigned long pci_confgspace = 0;
static unsigned long base1;

/* The following are set by init so that they may be restored to their */
/* state in setmode.                                                   */

static unsigned char pci40std,pci42std,pci58std,pci59std=0;
static char mem_type;
static int et6000_memory;
static int et6000_chiptype;
static int et6000_interlaced(int mode);
static et6000_chiptype = 0;
static int x3_4,x3_5,x3_8 = 0,x3_a; /* On init these get set according */
				    /*  to color */
union longword {
  unsigned char b[4];
  unsigned short w[2];
  unsigned long l;
};

/* The following are in the order of apearance in struct DriverSpecs as are */
/* the program entries.                                                     */

static int  et6000_saveregs(unsigned char regs[]);
static void et6000_setregs(const unsigned char regs[], int mode);
static void et6000_unlock(void);
static void et6000_lock(void);
static int  et6000_test(void);
static int  et6000_init(int force, int par1, int par2);
static void et6000_setpage(int page);
static void et6000_setrdpage(int page);
static void et6000_setwrpage(int page);
static int  et6000_setmode(int mode, int prv_mode);
static int  et6000_modeavailable(int mode);
static void et6000_setdisplaystart(int address);
static void et6000_setlogicalwidth(int width);
static void et6000_getmodeinfo(int mode,vga_modeinfo *modeinfo);
/* Obsolete blit functions left out here. */
static int  et6000_ext_set(unsigned what, va_list params);
static int  et6000_accel(unsigned operation, va_list params);
static int  et6000_linear(int op, int param);
/*
** End of the DriverSpecs function declarations         
*/
/* Mode table */
#if defined(DYNAMIC)

static ModeTable *et6000_modes = NULL;
static ModeTable No_Modes = END_OF_MODE_TABLE;

#else				/* !defined(DYNAMIC) */

#include "et6000.regs"

static ModeTable et6000_modes[] =
{
/* *INDENT-OFF* */
    OneModeEntry(320x200x32K),
    OneModeEntry(320x200x64K),
    OneModeEntry(320x200x16M),
    OneModeEntry(640x480x256),
    OneModeEntry(640x480x32K),
    OneModeEntry(640x480x64K),
    OneModeEntry(640x480x16M),
    OneModeEntry(800x600x16),
    OneModeEntry(800x600x256),
    OneModeEntry(800x600x32K),
    OneModeEntry(800x600x64K),
    /*    OneModeEntry(800x600x16M),   */
    /*    OneModeEntry(1024x786x32K),  */
    /*    OneModeEntry(1024x786x64K),  */
    /*    OneModeEntry(1280x1024x256), */
    OneModeEntry(1024x768x16),
    OneModeEntry(1024x768x256),
    OneModeEntry(1280x1024x16),
    END_OF_MODE_TABLE
/* *INDENT-ON* */
};

#endif				/* !defined(DYNAMIC) */

/* Function table (exported) */

DriverSpecs __svgalib_et6000_driverspecs =
{
    et6000_saveregs,
    et6000_setregs,
    et6000_unlock,
    et6000_lock,
    et6000_test,
    et6000_init,
    et6000_setpage,
    et6000_setrdpage,
    et6000_setwrpage,
    et6000_setmode,
    et6000_modeavailable,
    et6000_setdisplaystart,
    et6000_setlogicalwidth,
    et6000_getmodeinfo,
    0,				/* bitblt */
    0,				/* imageblt */
    0,				/* fillblt */
    0,				/* hlinelistblt */
    0,				/* bltwait */
    et6000_ext_set,
    et6000_accel,
    et6000_linear,
    NULL,			/* accelspecs */
    NULL,			/* emulation */
};

static int  et6000_saveregs(unsigned char regs[]) /* Called frm vga_saveregs */
{
  int i;

  et6000_unlock();
#ifdef DB6K
  { 
    fprintf(outf,"In saveregs, regs at %x\n",(int) regs);
    fflush(outf);
  }
  /* return(0);       Testing */
#endif
  /* Save extended CRT registers. */
  for(i = 0; i < 3;i++) {
    port_out(0x33 + i,__svgalib_CRT_I);
                                /* regs 30 and 31 are readonly and no 32   */
    regs[EXT + 3 + i] = port_in(__svgalib_CRT_D);
                                        /* 36h and 37 do not exist on et6k */
  }
  port_out(0x3f,__svgalib_CRT_I);
  regs[EXT + 8] = port_in(__svgalib_CRT_D);
  port_out(0x18,__svgalib_CRT_I);
  regs[EXT + 2] = port_in(__svgalib_CRT_D);
                                        /* ET6000 only.                    */
  /* Extended sequencer register 7 in EXT+9 doesen't exist on et6000. */
  /* Also EXT+10 doesn't exist. There is no 0x3c3 on et6000.          */
  regs[EXT + 11] = port_in(SEG_SELECT);
  regs[EXT + 10] = port_in(0x3cb); /* I am using EXT+10 for the high  */
                                   /* order segment select bits.      */
                                   /* Reset flip flop. Page 137       */
                                   /* of the et6000 manual. These two */
                                   /* regs 10 & 11 are 0 for linear.  */
  regs[EXT] = inb(base1 | 0x58);   /* Offset 58 describes 16bpp       */
  regs[EXT + 6] = inb(base1 | 0x59); /* bit1 = 0  555 RGB             */
                                     /*        1  565 RGB             */
                                   /* Offset 59 bits <32> set bpp.    */
                                   /* ---------------------           */
                                   /* | 3 | 2 |           |           */
                                   /* =====================           */
                                   /* | 0 | 0 | 24    bpp |           */
                                   /* | 0 | 1 |  8    bpp |           */
                                   /* | 1 | 0 | 15/16 bpp |           */
  port_in(__svgalib_IS1_R);        /* ---------------------           */
  __svgalib_delay();                   
  port_out(0x16,ATT_IW);           
  __svgalib_delay();
  regs[EXT + 12] = port_in(ATT_R); 
  __svgalib_delay();
  port_in(__svgalib_IS1_R);
  __svgalib_delay();
  port_out(0x17,ATT_IW);
  __svgalib_delay();
  regs[EXT + 7] = port_in(ATT_R);
  port_out(0x06,SEQ_I);
  regs[EXT + 9] = inb(base1 | 0x40);   /* Sets memory mapping.            */
  regs[EXT + 1] = inb(base1 | 0x42);   /* Saved for future use.           */
  return(13);                          /* ET6000 requires 13 EXT regs.    */
                                       /* We may find that it needs more! */
}

/* Set chipset-specific registers */

static void et6000_setregs(const unsigned char regs[], int mode)
{
  int i;
  unsigned char save;
  /* et6000.setlinear(0);   Write this one! */
  /* ET4000 shuts off linear at this point. */
  /* We either do not have these registers  */
  /* or they are read only.                 */
#ifdef DB6K
  fprintf(outf,"In setregs for regs at %x, mode = %d\n",(int) regs,mode);
  fflush(outf);
  /* return;       Testing */
#endif

  et6000_unlock();
  /* Write some et6000 specific registers. */
  port_out(regs[EXT+11],SEG_SELECT);
  port_out(regs[EXT+10],0x3cb);            /* I am using EXT+10 for Segment */
                                           /* These two registers must be   */
                                           /* set to zero for linear modes  */
  outb(base1 | 0x40,regs[EXT + 9]);
  /* Unprotect writing CRT reg 0x35 */
  port_out(0x11,__svgalib_CRT_I);
  save = port_in(__svgalib_CRT_D);
  port_out(save &0x7F,__svgalib_CRT_D);

  /* Write extended CRT regs */            
  for(i = 0;i < 3;i++) {
    port_out(0x33 + i,__svgalib_CRT_I);
    port_out(regs[EXT + 3 + i],__svgalib_CRT_D);
  }
  port_out(0x3F,__svgalib_CRT_I);
  port_out(regs[EXT + 8],__svgalib_CRT_D);
  port_out(0x18,__svgalib_CRT_I);
  port_out(regs[EXT + 2],__svgalib_CRT_D);
                                      /* See saveregs for these registers. */
  outb(base1 | 0x58,(vga_getcolors() == (1 << 16))? (regs[EXT] | 0x02):
                                                        regs[EXT]);
  outb(base1 | 0x59,regs[EXT + 6]);

    /* For True Color modes we must devide the MCLK by 3. */
    outb(base1 | 0x42,regs[EXT + 1]);
    outb(base1 | 0x40,regs[EXT + 9]);

  /* Original value for reg 0x11. */
  port_out(0x11,__svgalib_CRT_I);
  port_out(save,__svgalib_CRT_D);

  /* Write extended attribute register. */
  port_in(__svgalib_IS1_R);   /* Reset flip flop. Page 137 of et6000 chip */
  __svgalib_delay();          /* manual.                                  */
  port_out(0x16,ATT_IW);
  __svgalib_delay();
  port_out(regs[EXT + 12],ATT_IW);
  __svgalib_delay();
  port_in(__svgalib_IS1_R);
  __svgalib_delay();
  port_out(0x17,ATT_IW);
  __svgalib_delay();
  port_out(regs[EXT + 7],ATT_IW);
  /* I don't have an external DAC so I didn't include the last 3 regs.     */
}

static void et6000_unlock(void)
{
  if(x3_8)
    outb(x3_8,0xa0);
    else
      printf("et6000_unlock called when et6000 was not initialized.\n");
}

static void et6000_lock(void)
{
  if(x3_8) {
#ifdef DB6K
    fprintf(outf,"Lock called\n");
    fflush(outf);
#endif
    return;                /* et4000 does this, I don't know why! */
    outb(x3_8,0);          /* I think it is because we lose root  */
  }                        /* privalege after initialize and can  */
  else                     /* no longer unlock registers.         */
    printf("et6000_lock called when et6000 was not initialized.\n");
}

static int  et6000_test(void)
{
  if(et6000_chiptype)
    return(1);
  else {
    et6000_init(0,0,0);
    DPRT("In et6000 test\n");
    if(et6000_chiptype)
      return(1);
    return(0);

    }
}

static int  et6000_init(int force, int par1, int par2)
{
  int typ,cn;
  unsigned char pci1,mem_cfg_reg,pci2;
  unsigned long pcil1,pcil2,prefix;
  union longword value;
#ifdef DB6K
  char dboutfile[30];
  sprintf(dboutfile,"D%ld.txt",time(NULL));
  outf = fopen(dboutfile,"w");
  if(!outf){
    printf("Can't open a debug output file in et6000_init.\n");
    exit(1);
  }
#endif
  if(et6000_chiptype)
    return(1);             /* An attempt to reenter init. */
#ifdef DYNAMIC
    if (et6000_modes == NULL) {
	FILE *regs;

	regs = fopen(ET6000_REGS, "r");
	if (regs != 0) {                /* We have a builtin dac. Clocks    */
	    et6000_modes = NULL;        /* are not used at present.         */
	    __svgalib_readmodes(regs, &et6000_modes, 0,0);
	    fclose(regs);
	} else
	    et6000_modes = &No_Modes;
    }
#endif
  /* Check for ET6000 chiptype.                                             */
  /* Get PCI and VL configuration space.  The VL buss has not been checked. */
  /* I have a PCI buss.                                                     */
  if(!x3_8) {
    /* Test color mode or mono mode */
    if(inb(0x3cc) & 1) {
      x3_4 = 0x3d4;
      x3_5 = 0x3d5;
      x3_8 = 0x3d8;
      x3_a = 0x3da;
    }
    else {
      x3_4 = 0x3b4;
      x3_5 = 0x3b5;
      x3_8 = 0x3b8;
      x3_a = 0x3ba;
    }
  }
    if(iopl(3) == -1)
      {
          printf("No permission to use PCI ports.\n");
          perror("PCI ports");
      }
                              /* We need permission to use ports above 0x3ff */
                              /* so iopl must be executed while we are       */
                              /* running as root.  We are first called by    */
                              /* vga_init and after returning our uid is     */
                              /* reset to user, so we must leave this        */
                              /* permission in effect.                       */
    outb(0xCF8,0);
    outb(0xCFA,0);
    pci1 = inb(0xCF8);
    pci2 = inb(0xCFA);
                             /* It appears that the byte activation of 0xCF8
			     ** is for a typ 2 PCI buss or perhaps a VESA buss,
                             ** I dont know.  My buss is type 1 so I didn't do
                             ** anything but test it.  I get back 0xFF, so then
                             ** I try the long iout which works for my buss.
                             */
#ifdef DB6K
fprintf(outf,"0xCF8 gives %d and 0xCFA gives %d\n",pci1,pci2);
#endif
    if((pci1 == 0x00) && (pci2 == 0x00))
      typ = 2;
    else
      {
	pcil1 = inl(0xCF8);
	outl(0xCF8,0x80000000);
	pcil2 = inl(0xCF8);
	outl(0xCF8,pcil2);                  /* Restore CF8 */
#ifdef DB6K
fprintf(outf,"0xCF8 long gives %x, the old value was %x\n",(int) pcil2,
	(int) pcil1);
#endif
        if(pcil2 == 0x80000000)
	  typ = 1;
	else
	  typ = 0;
      }
    if(typ != 1)
      {
	printf("PCI bus error.  We only handle type 1 PCI bus "
	       "at present.\nThis is type %d\n",typ);
	return(1);
      }
                         /* Here I am assuming type one and searching for the
			 ** video card.  The search command is a 16 bit number
                         ** starting with a 1 in the highorder position.  The
                         ** form is
			 **        10000000000000nncccccfffoooooooo
                         ** where
                         ** nn is the PCI buss number. I assumed only 1 nn = 0
			 ** ccccc is the card number.  Mine is 0x14.
			 ** fff is the function.  Mine is 0 and I assume it is
			 ** true for video cards. It may not be, I don't know.
			 ** oooooooo  is the configuration space off set.
			 */
    cn = 0;
    while(cn < 0x20)
      {
	prefix = 0x80000000 + (cn << 11);
	    outl(0xCF8,prefix);
	    value.l = inl(0xCFC);
	    if(value.w[0] == 0x100c && value.w[1] == 0x3208)
	      {
		          /* Found et6000 
		          ** The first long word is ddddvvvv where vvvv is the
			  ** vendor and dddd is the device.  Since the 80x86 is
			  ** a little endian machine the low order bit is 
			  ** stored lowest in memory, so word 0 is the vendor 
			  ** 0x100c Tseng Labs and word 1 is the device 0x3208
			  **  the et6000 video card.
			  */
DPRT("Found et6000\n");
		et6000_chiptype = ET6000;   /* Defined in vga.h */
		pci_confgspace = prefix;
		et6000_unlock();            /* Set key. */
		mem_type = inb(0x3c2) & 1;  /* 0 = DRAM, 1 = MDRAM */

                outl(0xCF8,prefix | 0x14);  /* The value base1 is at offset */
                base1 = inl(0xCFC) & ~0xFF; /* 14 hex. The start of confg.  */
		              /* 3C2 is the input status register.  It has
			      ** things like the monitor ID and the video
			      ** memory type.  The two low order bits are
			      ** both zero for DRAM and both 1 for MDRAM.
			      ** Offset 0x45 is the memory configuration
			      ** register which gives the memory size depending
			      ** on the type.  Aparently one can't have 1Mbyte
			      ** of MDRAM.
			      */
		if(!pci59std) {
		  /* Saving pcibuss registers so they may be restored. */
		  pci40std = inb(base1 | 0x40);
		  pci42std = inb(base1 | 0x42);
		  pci58std = inb(base1 | 0x58);
		  pci59std = inb(base1 | 0x59);
		}
		mem_cfg_reg = inb(base1 | 0x45) & 3;
		if(mem_type)
		  {   /* MDRAM type */
		    if(mem_cfg_reg == 1)
		      et6000_memory = 4;      /* 4 MBytes of MDRAM */
		    else
		      et6000_memory = 2;      /* 2 MBytes of MDRAM */
		  }
		else   /* DRAM */
		  {
		    if(mem_cfg_reg == 2)
		      et6000_memory = 4;      /* 4 MBytes of DRAM */
		    else if(mem_cfg_reg == 1)
		      et6000_memory = 2;      /* 2 MBytes of DRAM */
		    else
		      et6000_memory = 1;      /* 1 MByte or DRAM  */
		  }

#ifdef DB6K
fprintf(outf,"pci_confgspace %08x, memtype %d and memsize %d MBytes\n",
       (int) pci_confgspace,mem_type,et6000_memory);
#endif
                printf("Using Tseng ET6000 driver (%d MBytes %sDRAM)\n",
		       et6000_memory,mem_type ? "M" : "");
		__svgalib_driverspecs = &__svgalib_et6000_driverspecs;
                break;  
	      }
	    else
	cn++;
      }
    return(0);
}

static unsigned char last_page = 0;

/* Bank switching function.  Set 64k bank number. */
static void et6000_setpage(int page)
{
    /* Set both read and write bank. 3cd */
    port_out(last_page = (page | ((page & 15) << 4)), SEG_SELECT);
	/* Write page4-5 to bits 0-1 of ext. bank register, */
	/* and to bits 4-5. */
    /* return;       Testing */
	outb(0x3cb, ((inb(0x3cb) & ~0x33) | (page >> 4) | (page & 0x30)));
}

static void et6000_setrdpage(int page)
{
  DPRT("In setrdpage.\n");
  last_page &= 0x0F;
  last_page |= (page << 4);
  port_out(last_page,SEG_SELECT);
  outb(0x3cb,(inb(0x3cb) & ~0x30) | (page & 0x30));
}

static void et6000_setwrpage(int page)
{
  DPRT("In setwrpage");
  last_page &= 0xF0;
  last_page |= (page | 0x0F);
  port_out(last_page,SEG_SELECT);
  outb(0x3cb,(inb(0x3cb) & ~0x03) | page >> 4);
}

static int  et6000_setmode(int mode, int prv_mode)
{

    const unsigned char *regs;
    unsigned char i;

#ifdef DB6K
    fprintf(outf,"In setmode, mode = %d, prv_mode = %d\n",mode,prv_mode);
    compareregs();
#endif
	/* Standard dac behaviour */
    switch (et6000_modeavailable(mode)) {
    case STDVGADRV:
	/* Reset extended register that is set to non-VGA */
	/* compatible value for 132-column textmodes (at */
	/* least on some cards). */
DPRT("STDVGADRV\n");
	et6000_unlock();
	outb(__svgalib_CRT_I, 0x34);            /* 3#4 */
	i = inb(__svgalib_CRT_D);               /* 3#5 */
	if ((i & 0x02) == 0x02)                 /* Clock0 select bit 2 */
	    outb(__svgalib_CRT_D, (i & 0xFD));  /* Turn it off. */
	                              /* Make sure pci buss is set right. */
#ifdef DB6K
	fprintf(outf,"reg 42 = %2x before.\n",inb(base1 | 0x42));
#endif
	outb(base1 | 0x40,pci40std);
	outb(base1 | 0x42,pci42std);
	outb(base1 | 0x58,pci58std);
	outb(base1 | 0x59,pci59std);
#ifdef DB6K
	fprintf(outf,"pci42 = %2x, pci58 = %2x, pci59 = %2x\n",pci42std,
		pci58std,pci59std);
	fprintf(outf,"reg 42 = %2x after.\n",inb(base1 | 0x42));
#endif
	return __svgalib_vga_driverspecs.setmode(mode, prv_mode);
    case SVGADRV:
DPRT("SVGADRV\n");
	regs = LOOKUPMODE(et6000_modes, mode);
	if (regs != NULL)
	    break;
    default:
	return 1;		/* mode not available */
    }
    __svgalib_setregs(regs);
    et6000_setregs(regs, mode);
    return 0;
}

static int  et6000_modeavailable(int mode)
{
  const unsigned char *regs;
  struct info *info;
  regs = LOOKUPMODE(et6000_modes,mode);
#ifdef DB6K
  if(regs)
    fprintf(outf,"In modeavailable, regs = %x, mode = %d\n",(int) regs,mode);
#endif
  if(regs == NULL || mode == GPLANE16)
    return(__svgalib_vga_driverspecs.modeavailable(mode));
  if(regs == DISABLE_MODE || mode <= TEXT || mode > GLASTMODE)
    return(0);
  info = &__svgalib_infotable[mode];
  if(et6000_memory*1024*1024 < info->ydim*info->xbytes)
    return(0);       /* The xbytes is xdim*bytesperpixel
                     ** The DAC is built in and I should be able to create
		     **	anything I have memory for.  I will DISABLE_MODE what
		     ** I can't handle. */
  return(SVGADRV);
}

static void et6000_setdisplaystart(int address)
{
  DNOTW("setdisplaystart");
  exit(1);
}

static void et6000_setlogicalwidth(int width)
{
  DNOTW("setlogicalwidth");
  exit(1);
}

static void et6000_getmodeinfo(int mode,vga_modeinfo *modeinfo)
{
  switch(modeinfo->colors){
  case 16:
    modeinfo->maxpixels = 65536*8;
    break;
  default:
    if(modeinfo->bytesperpixel > 0)
      modeinfo->maxpixels = et6000_memory*1024*1024/
	modeinfo->bytesperpixel;
    else
      modeinfo->maxpixels = et6000_memory*1024*1024;
    break;
  }
  modeinfo->maxlogicalwidth = 4088;              /* Why? */
  modeinfo->startaddressrange = 0xfffff;
  if(mode == G320x200x256)
    modeinfo->startaddressrange = 0;
  modeinfo->haveblit = 0;
  modeinfo->memory = et6000_memory*1024;         /* In kbytes. */
  modeinfo->flags |= HAVE_RWPAGE | HAVE_EXT_SET;
  if(et6000_interlaced(mode))
    modeinfo->flags |= IS_INTERLACED;
  modeinfo->flags |= EXT_INFO_AVAILABLE | CAPABLE_LINEAR;
  modeinfo->chiptype = et6000_chiptype;
#ifdef DB6K
  fprintf(outf,"\nModeinfo at the end of the subroutine:\n");
  prtmodeinfo(modeinfo);
  fprintf(outf,"Text mode errors = %d\n",compareregs());
}

static void prtmodeinfo(vga_modeinfo *m)
{
  fprintf(outf,"width\t\t\t%4d\nheight\t\t\t%4d\nbytesperpixel\t\t%4d\
\ncolors\t\t\t%4d\nlinewidth\t\t%4d\nmaxlogicalwidth\t\t%4d\
\nstartaddressrange\t%4d\nmaxpixels\t\t%4d\nhaveblit\t\t%4d\nflags\t\t\t%4x\
\nchiptype\t\t%4d\nmemory\t\t\t%4dkbytes\nlinewidth_unit\t\t%4d\
\nlinear_aperture\t\t%4s\naperture_size\t\t%4d\nset_aperture_page\t%4x\
\nextensions\t\t%4s\n",
	  m->width,m->height,m->bytesperpixel,m->colors,m->linewidth,
	  m->maxlogicalwidth,m->startaddressrange,m->maxpixels,m->haveblit,
	  m->flags,m->chiptype,m->memory,m->linewidth_unit,
	  m->linear_aperture?"yes":"no",m->aperture_size,
	  m->set_aperture_page ? (int) *m->set_aperture_page : (int) 0,
	  (int) m->extensions ? "yes" : "no");
}

static int compareregs(void)
{
  int n,i;

  n = 0;
    if(textset == 0) {
      textstore = malloc(MAX_REGS);
      vgatextstore = malloc(MAX_REGS);
      textset = 1;
    }
    if(textset == 1) {
      vga_gettextmoderegs(textstore);
      fputc('C',outf);
      if(textstore[25] == 1) 
	textset = 2;
    }
    if(textset == 2) {
	vga_gettextmoderegs(vgatextstore);
      fprintf(outf,"textstore = %x and vgatextstore = %x.\n",(int) textstore,
	   (int) vgatextstore);
      for(i = 0;i < 73;i++) {
	if(textstore[i] != vgatextstore[i]) {
	  fprintf(outf,"register %d text = %2x, vgatext = %2x\n",i,
		textstore[i],vgatextstore[i]);
	  n++;
	}
      }
      if(vgatextstore[25] == 0)
	textset = 1;
    }
  return(n);
}
#else
}
#endif

static int  et6000_ext_set(unsigned what, va_list params)
{
  DNOTW("ext_set");
  return(0);
}

static int  et6000_accel(unsigned operation, va_list params)
{
  DNOTW("accel");
  return(0);
}

static int  et6000_linear(int op, int param)
{
  DNOTW("linear");
  return(-1);
}

/* Programs not exported. */

static int et6000_interlaced(int mode)
{
  const unsigned char *regs;

  DPRT("In interlaced\n");
#ifdef DB6K
  fprintf(outf,"Text mode errors = %d\n",compareregs());
#endif
    if (et6000_modeavailable(mode) != SVGADRV)
	return 0;
    regs = LOOKUPMODE(et6000_modes, mode);
    if (regs == NULL || regs == DISABLE_MODE)
	return 0;
    return (regs[EXT + 5] & 0x80) != 0;		/* CRTC 35H */

                      /* This is a copy from et4000. */
}
