/***********************************************************
Copyright 1993 by Ove Kalkan

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
 * IconB.c - IconB widget
 *
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>
#include <X11/extensions/shape.h>
#include "IconBP.h"

#include <stdio.h>


/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */
static char defaultTranslations[] =
    "<EnterWindow>:	highlight()		\n\
     <LeaveWindow>:	unhighlight() reset()	\n\
     <Btn1Down>:	set() highlight()	\n\
     <Btn1Up>:		notify() unset()	";

#define offset(field) XtOffsetOf(IconBRec, field)
static XtResource resources[] = {
   {XtNimage,  XtCPixmap, XtRPixmap, sizeof(Pixmap),
	offset(iconB.image), XtRImmediate, (XtPointer) None},
   {XtNshape,  XtCPixmap, XtRPixmap, sizeof(Pixmap),
	offset(iconB.shape), XtRImmediate, (XtPointer) None},
   {XtNsimage,  XtCPixmap, XtRPixmap, sizeof(Pixmap),
	offset(iconB.simage), XtRImmediate, (XtPointer) None},
   {XtNsshape,  XtCPixmap, XtRPixmap, sizeof(Pixmap),
	offset(iconB.sshape), XtRImmediate, (XtPointer) None},
   {XtNimageWidth, XtCWidth, XtRDimension,  sizeof(Dimension),
	offset(iconB.width), XtRImmediate, (XtPointer)0},
   {XtNimageHeight, XtCHeight, XtRDimension, sizeof(Dimension),
	offset(iconB.height), XtRImmediate, (XtPointer)0},
   {XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer), 
	offset(iconB.callbacks), XtRCallback, (XtPointer)NULL},
   {XtNhighlightThickness, XtCThickness, XtRDimension, sizeof(Dimension),
	offset(iconB.highlight_thickness), XtRImmediate,
	(XtPointer) 2},
};
#undef offset

static void Initialize();
static void Redisplay();
static Boolean SetValues();
static void ClassInitialize();
static void Destroy();
static void Resize();
static void Realize();

static void Set(), Reset(), Notify(), Unset();
static void Highlight(), Unhighlight();

static XtActionsRec actionsList[] = {
  {"set",		Set},
  {"notify",		Notify},
  {"highlight",		Highlight},
  {"reset",		Reset},
  {"unset",		Unset},
  {"unhighlight",	Unhighlight}
};

IconBClassRec iconBClassRec = {
  {
/* core_class fields */	
#define superclass		(&simpleClassRec)
    /* superclass	  	*/	(WidgetClass) superclass,
    /* class_name	  	*/	"IconB",
    /* widget_size	  	*/	sizeof(IconBRec),
    /* class_initialize   	*/	ClassInitialize,
    /* class_part_initialize	*/	NULL,
    /* class_inited       	*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize		  	*/	XtInheritRealize,
    /* actions		  	*/	actionsList,
    /* num_actions	  	*/	XtNumber(actionsList),
    /* resources	  	*/	resources,
    /* num_resources	  	*/	XtNumber(resources),
    /* xrm_class	  	*/	NULLQUARK,
    /* compress_motion	  	*/	TRUE,
    /* compress_exposure  	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest	  	*/	FALSE,
    /* destroy		  	*/	Destroy,
    /* resize		  	*/	Resize,
    /* expose		  	*/	Redisplay,
    /* set_values	  	*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus	 	*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private   	*/	NULL,
    /* tm_table		   	*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
/* Simple class fields initialization */
  {
    /* change_sensitive		*/	XtInheritChangeSensitive
  }
};

WidgetClass iconBWidgetClass = (WidgetClass)&iconBClassRec;
/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static void ClassInitialize()
{
    XawInitializeWidgetSet();
}



static void GetnormalGC(lw)
    IconBWidget lw;
{
    XGCValues	values;

    values.foreground	= lw->core.border_pixel;
    values.background	= lw->core.background_pixel;
    values.graphics_exposures = False;

    lw->iconB.normal_GC = XtGetGC(
	(Widget)lw,
	(unsigned) GCForeground | GCBackground | GCGraphicsExposures,
	&values);
}

static void GetgrayGC(lw)
    IconBWidget lw;
{
    XGCValues	values;

    values.foreground = lw->core.border_pixel;
    values.background = lw->core.background_pixel;
    values.fill_style = FillTiled;
    values.tile       = XmuCreateStippledPixmap(XtScreen((Widget)lw),
						lw->core.border_pixel, 
						lw->core.background_pixel,
						lw->core.depth);
    values.graphics_exposures = False;

    lw->iconB.stipple = values.tile;
    lw->iconB.gray_GC = XtGetGC((Widget)lw, 
				(unsigned) GCForeground | GCBackground |
					   GCTile | GCFillStyle |
					   GCGraphicsExposures,
				&values);
}


/* ARGSUSED */
static void Initialize(request, new)
 Widget request, new;
{
    IconBWidget lw = (IconBWidget) new;

    GetnormalGC(lw);
    GetgrayGC(lw);

    if (lw->core.height == 0)
        lw->core.height = lw->iconB.height;

    if (lw->core.width == 0)		/* need iconB.lbm_width */
        lw->core.width = lw->iconB.width;

    lw->iconB.set = FALSE;

    (*XtClass(new)->core_class.resize) ((Widget)lw);
} /* Initialize */

/*
 * Repaint the widget window
 */

/* ARGSUSED */
static void Redisplay(w, event, region)
    Widget w;
    XEvent *event;
    Region region;
{
    IconBWidget lw = (IconBWidget) w;
    GC gc;
    Pixmap image;
    Pixmap shape;

    gc = XtIsSensitive((Widget)lw) ? lw->iconB.normal_GC : lw->iconB.gray_GC;
    image = lw->iconB.set ? lw->iconB.simage : lw->iconB.image;
    shape = lw->iconB.set ? lw->iconB.sshape : lw->iconB.shape;

    if (image != None && lw->iconB.width != 0 && lw->iconB.height != 0) {
         int x, y;
         Display *dpy = XtDisplay((Widget) lw);
         Window win = XtWindow((Widget) lw);

         x = (lw->core.width - lw->iconB.width)/2;
         y = (lw->core.height - lw->iconB.height)/2;

         XFillRectangle(dpy,win,gc,0,0,lw->core.width,lw->core.height);
         if (shape != None) {
              XShapeCombineMask(dpy,win,ShapeBounding,x,y,shape,ShapeSet);
         }
         XCopyArea (dpy,image,win,gc,0,0,lw->iconB.width,lw->iconB.height,x,y);
    }
    else {
         Display *dpy = XtDisplay((Widget) lw);
         Window win = XtWindow((Widget) lw);

         XFillRectangle(dpy,win,lw->iconB.gray_GC,0,0,lw->core.width,lw->core.height);
    }
}

/*
 * Set specified arguments into widget
 */

static Boolean SetValues(current, request, new, args, num_args)
    Widget current, request, new;
    ArgList args;
    Cardinal *num_args;
{
    IconBWidget curlw = (IconBWidget) current;
    IconBWidget reqlw = (IconBWidget) request;
    IconBWidget newlw = (IconBWidget) new;
    Boolean redisplay;

    if (curlw->iconB.image != newlw->iconB.image) {
	redisplay = True;
    }
    if (curlw->iconB.shape != newlw->iconB.shape) {
	redisplay = True;
    }
    if (curlw->iconB.simage != newlw->iconB.simage) {
	redisplay = True;
    }
    if (curlw->iconB.sshape != newlw->iconB.sshape) {
	redisplay = True;
    }
    if (curlw->iconB.width != newlw->iconB.width) {
	redisplay = True;
    }
    if (curlw->iconB.height != newlw->iconB.height) {
	redisplay = True;
    }

    if (curlw->core.border_pixel != newlw->core.border_pixel
	|| curlw->core.background_pixel != newlw->core.background_pixel) {

	XtReleaseGC(new, curlw->iconB.normal_GC);
	XtReleaseGC(new, curlw->iconB.gray_GC);
	XmuReleaseStippledPixmap( XtScreen(current), curlw->iconB.stipple );
	GetnormalGC(newlw);
	GetgrayGC(newlw);
	redisplay = True;
    }
    return (redisplay || XtIsSensitive(current) != XtIsSensitive(new));
}

static void Destroy(w)
    Widget w;
{
    IconBWidget lw = (IconBWidget) w;

    XtReleaseGC( w, lw->iconB.normal_GC );
    XtReleaseGC( w, lw->iconB.gray_GC);
    XmuReleaseStippledPixmap( XtScreen(w), lw->iconB.stipple );
}

static void Realize(w)
    Widget w;
{
    IconBWidget lw = (IconBWidget) w;
}

static void Resize(w)
    Widget w;
{
    IconBWidget lw = (IconBWidget) w;
}



/* Actions */

static	void	Notify(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
    IconBWidget lw = (IconBWidget) w;
    XtCallCallbackList(w, lw->iconB.callbacks, NULL);
}


static	void	Set(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
    IconBWidget lw = (IconBWidget) w;

    lw->iconB.set = TRUE;
    Redisplay(w,NULL,NULL);
}


static	void	Highlight(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
    IconBWidget lw = (IconBWidget) w;

    if (XtIsRealized(w) && XtIsSensitive(w)) {
        int	i;
        Display *dpy = XtDisplay((Widget) lw);
        Window win = XtWindow((Widget) lw);

        for (i = 0; i < lw->iconB.highlight_thickness; i++)
             XDrawRectangle(dpy,win,lw->iconB.normal_GC,i,i,
                            lw->core.width-i*2-1,lw->core.height-i*2-1);
    }
}


static	void	Reset(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
    IconBWidget lw = (IconBWidget) w;
}


static	void	Unset(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
    IconBWidget lw = (IconBWidget) w;
    lw->iconB.set = FALSE;
    Redisplay(w,NULL,NULL);
}


static	void	Unhighlight(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
    IconBWidget lw = (IconBWidget) w;
    Redisplay(w,NULL,NULL);
}
