#include <stdio.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h> 
#include <Xm/ToggleB.h>

void Doit(Widget w, XtPointer client, XtPointer call)
{
	char	*s = (char *)client;
	String	v = NULL;
	short	rows;

	fprintf(stderr, "Callback %s, widget value '%s'\n", s, XmTextGetString(w));

	XtVaGetValues(w,
		XmNvalue,	&v,
		XmNrows,	&rows,
	    NULL);

	fprintf(stderr, "GetValues => value '%s', rows %d\n", v, rows);
	XtFree(v);
}

void change(Widget w, XtPointer client, XtPointer call)
{
	Widget t = (Widget)client;
	XmToggleButtonCallbackStruct *cbp = (XmToggleButtonCallbackStruct*)call;

	fprintf(stderr, "Setting text cursorPositionVisible to %d\n", cbp->set);
	XtVaSetValues(t, XmNcursorPositionVisible, cbp->set, NULL);
}

char *fallback[] = {
	"*text*blinkRate:	500",
	"*text.value:		abc",
	NULL
};

int
main(int argc, char **argv)
{
  Widget toplevel, text, rc, toggle;
  XtAppContext app;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app,"Label",NULL,0,&argc,argv, fallback, NULL);

  rc = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, toplevel,
	NULL);

  toggle = XtVaCreateManagedWidget("cursor visible", xmToggleButtonWidgetClass,
	rc,
		XmNset,	True,
	NULL);

  text = XtVaCreateManagedWidget("text", xmTextWidgetClass, rc, 
		XmNrows, 10,
	NULL); 

  XtAddCallback(toggle, XmNvalueChangedCallback, change, (XtPointer)text);
  XtAddCallback(toggle, XmNvalueChangedCallback, Doit, XmNvalueChangedCallback);

  XtAddCallback(text, XmNmodifyVerifyCallback, Doit, XmNmodifyVerifyCallback);
  XtAddCallback(text, XmNactivateCallback, Doit, XmNactivateCallback);
  XtAddCallback(text, XmNlosingFocusCallback, Doit, XmNlosingFocusCallback);
  XtAddCallback(text, XmNfocusCallback, Doit, XmNfocusCallback);

  XtRealizeWidget(toplevel);
  XtAppMainLoop(app);

  exit(0);
}
