#ifndef S_SERV_H
#define S_SERV_H

#include "struct.h"

/*=============================================================================
 * General defines
 */

/*-----------------------------------------------------------------------------
 * Macro's
 */

#define STAT_PING	-7
#define STAT_LOG	-6	/* logfile for -x */
#define STAT_MASTER	-5	/* Local ircd master before identification */
#define STAT_CONNECTING -4
#define STAT_HANDSHAKE	-3
#define STAT_ME		-2
#define STAT_UNKNOWN	-1
#define STAT_SERVER	0
#define STAT_CLIENT	1

/*
 * status macros.
 */
#define IsRegisteredUser(x)	((x)->status == STAT_CLIENT)
#define IsRegistered(x)		((x)->status >= STAT_SERVER)
#define IsConnecting(x)		((x)->status == STAT_CONNECTING)
#define IsHandshake(x)		((x)->status == STAT_HANDSHAKE)
#define IsMe(x)			((x)->status == STAT_ME)
#define IsUnknown(x)		((x)->status == STAT_UNKNOWN || \
				 (x)->status == STAT_MASTER)
#define IsServer(x)		((x)->status == STAT_SERVER)
#define IsClient(x)		((x)->status == STAT_CLIENT)
#define IsLog(x)		((x)->status == STAT_LOG)
#define IsPing(x)		((x)->status == STAT_PING)

#define SetMaster(x)		((x)->status = STAT_MASTER)
#define SetConnecting(x)	((x)->status = STAT_CONNECTING)
#define SetHandshake(x)		((x)->status = STAT_HANDSHAKE)
#define SetMe(x)		((x)->status = STAT_ME)
#define SetUnknown(x)		((x)->status = STAT_UNKNOWN)
#define SetServer(x)		((x)->status = STAT_SERVER)
#define SetClient(x)		((x)->status = STAT_CLIENT)
#define SetLog(x)		((x)->status = STAT_LOG)
#define SetPing(x)		((x)->status = STAT_PING)

/*=============================================================================
 * Proto types
 */

extern int m_server(aClient *cptr, aClient *sptr, int parc, char *parv[]);
extern int m_server_estab(aClient *cptr, aConfItem *aconf, aConfItem *bconf);
extern int m_error(aClient *cptr, aClient *sptr, int parc, char *parv[]);
extern int m_end_of_burst(aClient *cptr, aClient *sptr, int parc, char *parv[]);
extern int m_end_of_burst_ack(aClient *cptr, aClient *sptr,
			      int parc, char *parv[]);

extern int max_connection_count, max_client_count;

#endif /* S_SERV_H */
