.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.TH man 1 "September 2, 1995"
.LO 1
.SH NAME
man \- format and display the on-line manual pages
.br
manpath \- determine user's search path for man pages
.SH SYNOPSIS
man [\-acdfhkKtwW] [\-m system] [\-p string] [\-C config_file] [\-M path]
[\-P pager] [\-S section_list] [section] name ...
.SH DESCRIPTION
.B man
formats and displays the on-line manual pages.  This version knows
about the
.B MANPATH
and
.B (MAN)PAGER
environment variables, so you can have
your own set(s) of personal man pages and choose whatever program you
like to display the formatted pages.  If
.I section
is specified,
.B man
only looks in that section of the manual.
You may also specify the order to search the sections for entries
and which preprocessors to run on the source files via command line options
or environment variables.
If
.I name
contains a / then it is first tried as a filename, so that you can do
.B "man ./foo.5"
or even
.B "man /cd/foo/bar.1.gz\fR.\fP"
.SH OPTIONS
.TP
.B \-\^C " config_file"
Specify the man.conf file to use; the default is
.BR @man_config_file@ .
(See
.BR man.conf (5).)
.TP
.B \-\^M " path"
Specify the list of directories to search for man pages.
If no such option is given, the environment variable
.B MANPATH
is used. If no such environment variable is found, the default list
is found by consulting
.BR @man_config_file@ .
An empty substring of
.B MANPATH
denotes the default list.
.TP
.B \-\^P " pager"
Specify which pager to use. 
This option overrides the
.B MANPAGER
environment variable, which in turn overrides the
.B PAGER
variable.  By default,
.B man
uses
.BR @pager@ .
.TP
.B \-\^S " section_list"
List is a colon separated list of manual sections to search.
This option overrides the
.B MANSECT
environment variable.
.TP
.B \-\^a
By default,
.B man
will exit after displaying the first manual page it
finds.  Using this option forces
.B man
to display all the manual pages that match
.B name, 
not just the first.
.TP
.B \-\^c
Reformat the source man page, even when an up-to-date cat page exists.
This can be meaningful if the cat page was formatted for a screen
with a different number of columns, or if the preformatted page
is corrupted.
.TP
.B \-\^d
Don't actually display the man pages, but do print gobs of debugging
information.
.TP
.B \-\^D
Both display and print debugging info.
.TP
.B \-\^f
Equivalent to
.BR whatis .
.TP
.B \-\^h
Print a one-line help message and exit.
.TP
.B \-\^k
Equivalent to
.BR apropos .
.TP
.B \-\^K
Search for the specified string in *all* man pages. Warning: this is
probably very slow! It helps to specify a section.
(Just to give a rough idea, on my machine this takes about a minute
per 500 man pages.)
.TP
.B \-\^m " system"
Specify an alternate set of man pages to search based on the system
name given.
.TP
.B \-\^p " string"
Specify the sequence of preprocessors to run before
.B nroff
or
.BR troff .
Not all installations will have a full set of preprocessors.
Some of the preprocessors and the letters used to designate them are: 
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
This option overrides the
.B MANROFFSEQ
environment variable.
.TP
.B \-\^t
Use
.B @troff@
to format the manual page, passing the output to 
.B stdout.
The output from
.B @troff@
may need to be passed through some filter or another before being
printed.
.TP
.B \-\^w \fRor\fP \-\-path
Don't actually display the man pages, but do print the location(s) of
the files that would be formatted or displayed. If no argument is given:
display (on stdout) the list of directories that is searched by
.B man
for man pages. If
.B manpath
is a link to man, then "manpath" is equivalent to "man --path".
.TP
.B \-\^W
Like \-\^w, but print file names one per line, without additional information.
This is useful in shell commands like
.ft CW
.B "man -aW man | xargs ls -l"
.ft

.SH "CAT PAGES"
Man will try to save the formatted man pages, in order to save
formatting time the next time these pages are needed.
Traditionally, formatted versions of pages in DIR/manX are
saved in DIR/catX, but other mappings from man dir to cat dir
can be specified in
.BR @man_config_file@ .
No cat pages are saved when the required cat directory does not exist.
.PP
It is possible to make
.B man
suid to a user man. Then, if a cat directory
has owner man and mode 0755 (only writable by man), and the cat files
have owner man and mode 0644 or 0444 (only writable by man, or not
writable at all), no ordinary user can change the cat pages or put
other files in the cat directory. If
.B man
is not made suid, then a cat directory should have mode 0777
if all users should be able to leave cat pages there.
.PP
The option
.B \-c
forces reformatting a page, even if a recent cat page exists.


.SH ENVIRONMENT
.TP
.B MANPATH
If
.B MANPATH
is set, its value is used as the path to search for manual pages.
.TP
.B MANROFFSEQ
If
.B MANROFFSEQ
is set, its value is used to determine the set of preprocessors run
before running
.B nroff
or
.BR troff .
By default, pages are passed through
the table preprocessor before
.BR nroff .
.TP
.B MANSECT
If
.B MANSECT
is set, its value is used to determine which manual sections to search.
.TP
.B MANWIDTH
If
.B MANWIDTH
is set, its value is used as the width manpages should be displayed.
Otherwise the pages may be displayed over the whole width of your
screen.
.TP
.B MANPAGER
If
.B MANPAGER
is set, its value is used as the name of the program to use to display
the man page.  If not, then
.B PAGER
is used. If that has no value either,
.B @pager@
is used.
.TP
.B LANG
If
.B LANG
is set, its value defines the name of the subdirectory where man
first looks for man pages. Thus, the command `LANG=dk man 1 foo'
will cause man to look for the foo man page in .../dk/man1/foo.1,
and if it cannot find such a file, then in .../man1/foo.1,
where ... is a directory on the search path.
.TP
.B "NLSPATH, LC_MESSAGES, LANG"
The environment variables
.B NLSPATH
and
.B LC_MESSAGES
(or
.B LANG
when the latter does not exist)
play a role in locating the message catalog.
(But the English messages are compiled in, and for English no catalog
is required.)
Note that programs like col(1) called by man also use e.g. LC_CTYPE.
.TP
.B PATH
.B PATH
is used in the construction of the default search path for man pages.
.TP
.B SYSTEM
.B SYSTEM
is used to get the default alternate system name (for use
with the
.B \-m
option). 
.SH "SEE ALSO"
apropos(1), whatis(1), less(1), groff(1).
.SH BUGS
The
.B \-t
option only works if a troff-like program is installed.
.br
If you see blinking \e255 or <AD> instead of hyphens,
put `LESSCHARSET=latin1' in your environment.
