/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.debug;

import java.io.DataInputStream;
import symantec.tools.debug.Agent;
import symantec.tools.debug.AgentConstants;
import symantec.tools.debug.DebuggerCallback;
import symantec.tools.debug.RemoteAgent;
import symantec.tools.debug.RemoteThread;

class AgentIn
implements Runnable,
AgentConstants {
    RemoteAgent agent;
    DebuggerCallback client;
    DataInputStream in;

    AgentIn(RemoteAgent remoteAgent, DataInputStream dataInputStream, DebuggerCallback debuggerCallback, boolean bl) {
        this.agent = remoteAgent;
        this.client = debuggerCallback;
        this.in = dataInputStream;
    }

    public void run() {
        Agent.addSystemThread(Thread.currentThread());
        boolean bl = false;
        try {
            block13: while (true) {
                int n = this.in.read();
                switch (n) {
                    default: {
                        continue block13;
                    }
                    case -1: {
                        if (!bl) {
                            this.client.printToConsole("\nThe communications channel closed.\n");
                            bl = true;
                            this.client.quitEvent();
                            return;
                        }
                    }
                    case 33: {
                        int n2 = this.in.read() + (this.in.read() << 8);
                        Object object = new byte[n2];
                        this.in.readFully((byte[])object, 0, n2);
                        String string = new String((byte[])object, 0);
                        this.client.printToConsole(string);
                        continue block13;
                    }
                    case 46: {
                        RemoteThread remoteThread = (RemoteThread)this.agent.readValue(this.in);
                        this.client.breakpointEvent(remoteThread);
                        continue block13;
                    }
                    case 83: {
                        RemoteThread remoteThread = (RemoteThread)this.agent.readValue(this.in);
                        this.client.stepEvent(remoteThread);
                        continue block13;
                    }
                    case 52: {
                        this.agent.message("AgentIn: exceptionEvent!");
                        RemoteThread remoteThread = (RemoteThread)this.agent.readValue(this.in);
                        Object object = this.in.readUTF();
                        this.agent.message("text=" + (String)object);
                        this.client.exceptionEvent(remoteThread, (String)object);
                        continue block13;
                    }
                    case 66: {
                        RemoteThread remoteThread = (RemoteThread)this.agent.readValue(this.in);
                        this.agent.message("AgentIn: threadDeath in " + remoteThread.getName());
                        this.client.threadDeathEvent(remoteThread);
                        continue block13;
                    }
                    case 67: 
                }
                break;
            }
            bl = true;
            this.client.quitEvent();
            return;
        }
        catch (Exception exception) {
            try {
                if (!bl) {
                    this.client.printToConsole("\nFatal exception (AgentIn): " + exception + "\n");
                    this.client.quitEvent();
                    return;
                }
            }
            catch (Exception exception2) {
                return;
            }
            return;
        }
    }
}

