/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.RDN;

public final class DN {
    Vector m_rdns = new Vector();
    boolean m_rfc = true;
    public static final char[] ESCAPED_CHAR = new char[]{',', '+', '\"', '\\', '<', '>', ';'};

    public DN() {
    }

    public DN(String string) {
        if (string == null) {
            return;
        }
        if (this.isRFC(string)) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            StringBuffer stringBuffer2 = new StringBuffer();
            while (n < stringBuffer.length()) {
                stringBuffer2.append(stringBuffer.charAt(n));
                if (stringBuffer.charAt(n) == '\\') {
                    char c = stringBuffer.charAt(n + 1);
                    int n2 = 0;
                    while (n2 < ESCAPED_CHAR.length) {
                        if (c == ESCAPED_CHAR[n2]) {
                            stringBuffer2.append(stringBuffer.charAt(++n));
                            break;
                        }
                        ++n2;
                    }
                } else if (stringBuffer.charAt(n) == ',') {
                    stringBuffer2.setLength(stringBuffer2.length() - 1);
                    this.appendRDN(stringBuffer2);
                    stringBuffer2 = new StringBuffer();
                }
                ++n;
            }
            this.appendRDN(stringBuffer2);
            return;
        }
        if (string.indexOf(47) != -1) {
            this.m_rfc = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            Vector<RDN> vector = new Vector<RDN>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!RDN.isRDN(string2)) continue;
                vector.addElement(new RDN(string2));
            }
            int n = vector.size() - 1;
            while (n >= 0) {
                this.m_rdns.addElement(vector.elementAt(n));
                --n;
            }
            return;
        }
        this.m_rdns.addElement(new RDN(string));
    }

    public void addRDNToFront(RDN rDN) {
        this.m_rdns.insertElementAt(rDN, 0);
    }

    public void addRDNToBack(RDN rDN) {
        this.m_rdns.addElement(rDN);
    }

    public void addRDN(RDN rDN) {
        if (this.m_rfc) {
            this.addRDNToFront(rDN);
            return;
        }
        this.addRDNToBack(rDN);
    }

    public int countRDNs() {
        return this.m_rdns.size();
    }

    public Vector getRDNs() {
        return this.m_rdns;
    }

    public String[] explodeDN(boolean bl) {
        if (this.m_rdns.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.m_rdns.size()];
        int n = 0;
        while (n < this.m_rdns.size()) {
            stringArray[n] = bl ? ((RDN)this.m_rdns.elementAt(n)).getValue() : ((RDN)this.m_rdns.elementAt(n)).toString();
            ++n;
        }
        return stringArray;
    }

    public boolean isRFC() {
        return this.m_rfc;
    }

    public String toRFCString() {
        String string = "";
        int n = 0;
        while (n < this.m_rdns.size()) {
            if (n != 0) {
                string = String.valueOf(string) + ",";
            }
            string = String.valueOf(string) + ((RDN)this.m_rdns.elementAt(n)).toString();
            ++n;
        }
        return string;
    }

    public String toOSFString() {
        String string = "";
        int n = 0;
        while (n < this.m_rdns.size()) {
            if (n != 0) {
                string = "/" + string;
            }
            RDN rDN = (RDN)this.m_rdns.elementAt(n);
            string = String.valueOf(rDN.toString()) + string;
            ++n;
        }
        return string;
    }

    public String toString() {
        if (this.m_rfc) {
            return this.toRFCString();
        }
        return this.toOSFString();
    }

    public static boolean isDN(String string) {
        DN dN = new DN(string);
        return dN.countRDNs() > 0;
    }

    public boolean equals(DN dN) {
        return dN.toRFCString().toUpperCase().equals(this.toRFCString().toUpperCase());
    }

    public DN getParent() {
        DN dN = new DN();
        int n = this.m_rdns.size() - 1;
        while (n > 0) {
            dN.addRDN((RDN)this.m_rdns.elementAt(n));
            --n;
        }
        return dN;
    }

    public boolean contains(DN dN) {
        Vector vector = dN.m_rdns;
        Vector vector2 = this.m_rdns;
        int n = vector.size() - 1;
        int n2 = vector2.size() - 1;
        while (n >= 0 && n2 >= 0) {
            RDN rDN = (RDN)vector.elementAt(n);
            RDN rDN2 = (RDN)vector2.elementAt(n2);
            if (!rDN2.equals(rDN)) {
                return false;
            }
            --n;
            --n2;
        }
        return true;
    }

    private boolean isRFC(String string) {
        int n = string.indexOf(44);
        while (n > 0 && n < string.length() - 1) {
            if (string.charAt(n - 1) != '\\') {
                return true;
            }
            n = string.indexOf(44, n + 1);
        }
        return false;
    }

    private void appendRDN(StringBuffer stringBuffer) {
        String string = new String(stringBuffer);
        if (RDN.isRDN(string)) {
            this.m_rdns.addElement(new RDN(string));
        }
    }
}

