/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;

public class JDAPControl {
    String m_type;
    boolean m_criticality = false;
    byte[] m_vals;

    public JDAPControl(String string, boolean bl, byte[] byArray) {
        this.m_type = string;
        this.m_criticality = bl;
        this.m_vals = byArray;
    }

    public JDAPControl(BERElement bERElement) {
        BERSequence bERSequence = (BERSequence)bERElement;
        try {
            this.m_type = new String(((BEROctetString)bERSequence.elementAt(0)).getValue(), "UTF8");
        }
        catch (Throwable throwable) {}
        BERElement bERElement2 = bERSequence.elementAt(1);
        if (bERElement2 instanceof BERBoolean) {
            this.m_criticality = ((BERBoolean)bERElement2).getValue();
        } else {
            this.m_vals = ((BEROctetString)bERElement2).getValue();
        }
        if (bERSequence.size() >= 3) {
            this.m_vals = ((BEROctetString)bERSequence.elementAt(2)).getValue();
        }
    }

    public BERElement getBERElement() {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BEROctetString(this.m_type));
        bERSequence.addElement(new BERBoolean(this.m_criticality));
        if (this.m_vals == null || this.m_vals.length < 1) {
            bERSequence.addElement(new BEROctetString(null));
        } else {
            bERSequence.addElement(new BEROctetString(this.m_vals, 0, this.m_vals.length));
        }
        return bERSequence;
    }

    public String getID() {
        return this.m_type;
    }

    public boolean isCritical() {
        return this.m_criticality;
    }

    public byte[] getValue() {
        return this.m_vals;
    }

    public String toString() {
        return "Control { type=" + this.m_type + ", criticality=" + this.m_criticality;
    }
}

