/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.OffScreenImageSource;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WImage;

class WGraphics
extends Graphics {
    int pData;
    Color foreground;
    Font font;
    int originX;
    int originY;
    private ImageRepresentation imagerep;

    private native void createFromComponent(WComponentPeer var1);

    private native void createFromGraphics(WGraphics var1);

    private native void imageCreate(ImageRepresentation var1);

    private native void pSetFont(Font var1);

    private native void pSetForeground(Color var1);

    WGraphics(WGraphics wGraphics) {
        this.createFromGraphics(wGraphics);
    }

    WGraphics(WComponentPeer wComponentPeer) {
        this.createFromComponent(wComponentPeer);
        Font font = wComponentPeer.target.getFont();
        if (font == null) {
            font = new Font("Helvetica", 0, 10);
        }
        this.setFont(font);
    }

    public WGraphics(WImage wImage) {
        OffScreenImageSource offScreenImageSource = (OffScreenImageSource)wImage.getSource();
        this.imagerep = offScreenImageSource.getImageRep();
        this.imageCreate(this.imagerep);
        this.setFont(new Font("Arial", 0, 12));
    }

    public Graphics create() {
        WGraphics wGraphics = new WGraphics(this);
        wGraphics.foreground = this.foreground;
        wGraphics.font = this.font;
        wGraphics.originX = this.originX;
        wGraphics.originY = this.originY;
        wGraphics.imagerep = this.imagerep;
        return wGraphics;
    }

    public void translate(int n, int n2) {
        this.originX += n;
        this.originY += n2;
    }

    public native void dispose();

    public void setFont(Font font) {
        if (font != null && this.font != font) {
            this.font = font;
            this.pSetFont(font);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    public void setColor(Color color) {
        if (color != null && color != this.foreground) {
            this.foreground = color;
            this.pSetForeground(color);
        }
    }

    public Color getColor() {
        return this.foreground;
    }

    public native void setPaintMode();

    public native void setXORMode(Color var1);

    public Rectangle getClipRect() {
        Rectangle rectangle = new Rectangle();
        this.getClipRect(rectangle);
        return rectangle;
    }

    native void getClipRect(Rectangle var1);

    public native void clipRect(int var1, int var2, int var3, int var4);

    public native void clearRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void drawString(String var1, int var2, int var3);

    public native void drawChars(char[] var1, int var2, int var3, int var4, int var5);

    public native void drawBytes(byte[] var1, int var2, int var3, int var4, int var5);

    public native int drawStringWidth(String var1, int var2, int var3);

    public native int drawCharsWidth(char[] var1, int var2, int var3, int var4, int var5);

    public native int drawBytesWidth(byte[] var1, int var2, int var3, int var4, int var5);

    public native void drawLine(int var1, int var2, int var3, int var4);

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep(-1, -1);
        return imageRepresentation.drawImage(this, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        if (n3 < 0) {
            n3 = -1;
        }
        if (n4 < 0) {
            n4 = -1;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep(n3, n4);
        return imageRepresentation.drawImage(this, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep(-1, -1);
        return imageRepresentation.drawImage(this, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        if (n3 < 0) {
            n3 = -1;
        }
        if (n4 < 0) {
            n4 = -1;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep(n3, n4);
        return imageRepresentation.drawImage(this, n, n2, color, imageObserver);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawPolygon(int[] var1, int[] var2, int var3);

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.originX + "," + this.originY + "]";
    }
}

