/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import sun.awt.image.Image;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.OffScreenImageSource;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Image;

public class X11Graphics
extends Graphics {
    int pData;
    Color foreground;
    Font font;
    int originX;
    int originY;
    Image image;

    private native void createFromComponent(MComponentPeer var1);

    private native void createFromGraphics(X11Graphics var1);

    private native void imageCreate(ImageRepresentation var1);

    private native void pSetFont(Font var1);

    private native void pSetForeground(Color var1);

    X11Graphics(X11Graphics x11Graphics) {
        this.createFromGraphics(x11Graphics);
        this.font = x11Graphics.getFont();
        if (this.font == null) {
            this.font = new Font("Dialog", 0, 12);
        }
        this.pSetFont(this.font);
    }

    X11Graphics(MComponentPeer mComponentPeer) {
        this.createFromComponent(mComponentPeer);
        this.font = mComponentPeer.target.getFont();
        if (this.font == null) {
            this.font = new Font("Dialog", 0, 12);
        }
        this.pSetFont(this.font);
    }

    public X11Graphics(X11Image x11Image) {
        OffScreenImageSource offScreenImageSource = (OffScreenImageSource)x11Image.getSource();
        this.imageCreate(offScreenImageSource.getImageRep());
        this.image = x11Image;
        this.font = new Font("Dialog", 0, 12);
        this.pSetFont(this.font);
    }

    public Graphics create() {
        X11Graphics x11Graphics = new X11Graphics(this);
        x11Graphics.foreground = this.foreground;
        x11Graphics.font = this.font;
        x11Graphics.originX = this.originX;
        x11Graphics.originY = this.originY;
        x11Graphics.image = this.image;
        return x11Graphics;
    }

    public void translate(int n, int n2) {
        this.originX += n;
        this.originY += n2;
    }

    public native void dispose();

    public void setFont(Font font) {
        if (font != null && this.font != font) {
            this.font = font;
            this.pSetFont(font);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    public void setColor(Color color) {
        if (color != null && color != this.foreground) {
            this.pSetForeground(color);
            this.foreground = color;
        }
    }

    public Color getColor() {
        return this.foreground;
    }

    public native void setPaintMode();

    public native void setXORMode(Color var1);

    public native Rectangle getClipRect();

    public native void clipRect(int var1, int var2, int var3, int var4);

    public native void clearRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void drawString(String var1, int var2, int var3);

    public native void drawChars(char[] var1, int var2, int var3, int var4, int var5);

    public native void drawBytes(byte[] var1, int var2, int var3, int var4, int var5);

    public native int drawStringWidth(String var1, int var2, int var3);

    public native int drawCharsWidth(char[] var1, int var2, int var3, int var4, int var5);

    public native int drawBytesWidth(byte[] var1, int var2, int var3, int var4, int var5);

    public native void drawLine(int var1, int var2, int var3, int var4);

    public boolean drawImage(java.awt.Image image, int n, int n2, ImageObserver imageObserver) {
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep(-1, -1);
        return imageRepresentation.drawImage(this, n, n2, null, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        if (n3 < 0) {
            n3 = -1;
        }
        if (n4 < 0) {
            n4 = -1;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep(n3, n4);
        return imageRepresentation.drawImage(this, n, n2, null, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep(-1, -1);
        return imageRepresentation.drawImage(this, n, n2, color, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        if (n3 < 0) {
            n3 = -1;
        }
        if (n4 < 0) {
            n4 = -1;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep(n3, n4);
        return imageRepresentation.drawImage(this, n, n2, color, imageObserver);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawPolygon(int[] var1, int[] var2, int var3);

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.originX + "," + this.originY + "]";
    }
}

