/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.OffScreenImageSource;
import sun.awt.macos.MComponentPeer;
import sun.awt.macos.MacFontMetrics;
import sun.awt.macos.MacImage;

public class MacGraphics
extends Graphics {
    int pData;
    Color foreground;
    Font font;
    int originX;
    int originY;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    ImageRepresentation imageRepresentation;
    MComponentPeer componentPeer;

    private native void createFromComponent(MComponentPeer var1);

    private native void createFromGraphics(MacGraphics var1);

    private native void createFromIRepresentation(ImageRepresentation var1);

    private native void pSetFont(Font var1);

    private native void pSetForeground(Color var1);

    private native void pSetScaling(float var1, float var2);

    private native void pSetOrigin(int var1, int var2);

    MacGraphics(MacGraphics macGraphics) {
        this.imageRepresentation = macGraphics.imageRepresentation;
        this.componentPeer = macGraphics.componentPeer;
        this.createFromGraphics(macGraphics);
    }

    MacGraphics(MComponentPeer mComponentPeer) {
        this.componentPeer = mComponentPeer;
        this.createFromComponent(mComponentPeer);
    }

    public MacGraphics(Image image) {
        OffScreenImageSource offScreenImageSource = (OffScreenImageSource)image.getSource();
        this.imageRepresentation = offScreenImageSource.getImageRep();
        this.createFromIRepresentation(this.imageRepresentation);
        this.setFont(new Font("Dialog", 0, 9));
    }

    public Graphics create() {
        MacGraphics macGraphics = new MacGraphics(this);
        macGraphics.foreground = this.foreground;
        macGraphics.font = this.font;
        macGraphics.originX = this.originX;
        macGraphics.originY = this.originY;
        macGraphics.scaleX = this.scaleX;
        macGraphics.scaleY = this.scaleY;
        macGraphics.imageRepresentation = this.imageRepresentation;
        return macGraphics;
    }

    public void translate(int n, int n2) {
        this.originX = (int)((float)this.originX + (float)n * this.scaleX);
        this.originY = (int)((float)this.originY + (float)n2 * this.scaleY);
        this.pSetOrigin(this.originX, this.originY);
    }

    public void scale(float f, float f2) {
        this.scaleX *= f;
        this.scaleY *= f2;
        this.pSetScaling(this.scaleX, this.scaleY);
    }

    public native void dispose();

    public void finalize() {
        this.dispose();
    }

    public void setFont(Font font) {
        if (font != null && this.font != font) {
            this.font = font;
            this.pSetFont(font);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return MacFontMetrics.getFontMetrics(font);
    }

    public void setColor(Color color) {
        if (color != null && color != this.foreground) {
            this.foreground = color;
            this.pSetForeground(color);
        }
    }

    public Color getColor() {
        return this.foreground;
    }

    public native void setPaintMode();

    public native void setXORMode(Color var1);

    public Rectangle getClipRect() {
        Rectangle rectangle = new Rectangle();
        this.getClipRect(rectangle);
        return rectangle;
    }

    native void getClipRect(Rectangle var1);

    public native void clipRect(int var1, int var2, int var3, int var4);

    public native void clearRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void drawString(String var1, int var2, int var3);

    public native void drawChars(char[] var1, int var2, int var3, int var4, int var5);

    public native void drawBytes(byte[] var1, int var2, int var3, int var4, int var5);

    public native int drawStringWidth(String var1, int var2, int var3);

    public native int drawCharsWidth(char[] var1, int var2, int var3, int var4, int var5);

    public native int drawBytesWidth(byte[] var1, int var2, int var3, int var4, int var5);

    public native void drawLine(int var1, int var2, int var3, int var4);

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        ImageRepresentation imageRepresentation = ((MacImage)image).getImageRep(-1, -1);
        return imageRepresentation.drawImage(this, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        if (n3 < 0) {
            n3 = -1;
        }
        if (n4 < 0) {
            n4 = -1;
        }
        ImageRepresentation imageRepresentation = ((MacImage)image).getImageRep(n3, n4);
        return imageRepresentation.drawImage(this, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        MacImage macImage = (MacImage)image;
        ImageRepresentation imageRepresentation = macImage.getImageRep(-1, -1);
        return imageRepresentation.drawImage(this, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        MacImage macImage = (MacImage)image;
        if (n3 < 0) {
            n3 = -1;
        }
        if (n4 < 0) {
            n4 = -1;
        }
        ImageRepresentation imageRepresentation = macImage.getImageRep(n3, n4);
        return imageRepresentation.drawImage(this, n, n2, color, imageObserver);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawPolygon(int[] var1, int[] var2, int var3);

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.originX + "," + this.originY + "," + this.scaleX + "," + this.scaleY + "]";
    }
}

