/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import java.util.Enumeration;
import netscape.softupdate.InstallObject;
import netscape.softupdate.ProgressDetails;
import netscape.softupdate.ProgressWindow;
import netscape.softupdate.SoftwareUpdate;
import netscape.softupdate.Strings;

class ProgressMediator {
    private ProgressWindow progress;
    private ProgressDetails details;
    private SoftwareUpdate su;

    ProgressMediator(SoftwareUpdate softwareUpdate) {
        this.su = softwareUpdate;
        this.progress = null;
        this.details = null;
    }

    protected void finalize() throws Throwable {
        this.CleanUp();
    }

    private void CleanUp() {
        if (this.progress != null) {
            this.progress.hide();
            this.progress.dispose();
        }
        if (this.details != null) {
            this.details.btnCancel_Clicked(null);
        }
        this.progress = null;
        this.details = null;
        this.su = null;
    }

    private void ShowProgress() {
        if (this.su.GetSilent()) {
            return;
        }
        if (this.progress == null) {
            this.progress = new ProgressWindow(this);
        }
        this.progress.toFront();
        this.progress.show();
        this.progress.toFront();
    }

    private void ShowDetails() {
        if (this.su.GetSilent()) {
            return;
        }
        if (this.details == null) {
            this.details = new ProgressDetails(this);
            this.details.setTitle(String.valueOf(Strings.details_WinTitle()) + this.su.GetUserPackageName());
            this.details.label1.setText(Strings.details_Explain(this.su.GetUserPackageName()));
            Enumeration enumeration = this.su.GetInstallQueue();
            while (enumeration.hasMoreElements()) {
                InstallObject installObject = (InstallObject)enumeration.nextElement();
                this.details.detailArea.appendText(String.valueOf(installObject.toString()) + "\n");
            }
            this.details.show();
        }
        this.details.toFront();
    }

    protected void DetailsHidden() {
        this.details = null;
    }

    protected void UserCancelled() {
        if (this.su != null) {
            this.su.UserCancelled();
        }
    }

    protected void UserApproved() {
        if (this.su != null) {
            this.su.UserApproved();
        }
    }

    protected void MoreInfo() {
        this.ShowDetails();
    }

    protected void StartInstall() {
        this.ShowProgress();
        if (this.progress != null) {
            this.progress.setTitle(String.valueOf(Strings.progress_Title()) + this.su.GetUserPackageName());
            this.progress.status.setText(String.valueOf(Strings.progress_GettingReady()) + this.su.GetUserPackageName());
            this.progress.progress.setText("");
            this.progress.install.disable();
        }
    }

    protected void ConfirmWithUser() {
        this.ShowProgress();
        if (this.progress != null) {
            this.progress.progress.setText("");
            this.progress.status.setText(String.valueOf(Strings.progress_ReadyToInstall1()) + this.su.GetUserPackageName());
            this.progress.install.enable();
            return;
        }
        this.UserApproved();
    }

    protected void ScheduleForInstall(InstallObject installObject) {
        String string = installObject.toString();
        if (this.progress != null) {
            this.progress.progress.setText(string);
        }
        if (this.details != null) {
            this.details.detailArea.appendText(String.valueOf(string) + "\n");
        }
    }

    void Complete() {
        this.CleanUp();
    }
}

