/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import netscape.security.Target;
import netscape.softupdate.SoftUpdateException;
import netscape.softupdate.SoftwareUpdate;
import netscape.softupdate.Strings;
import netscape.softupdate.VersionRegistry;

final class FolderSpec {
    private String urlPath = null;
    private String folderID;
    private String versionRegistryPath;
    private String userPackageName;
    static final int INVALID_PATH_ERR = -100;
    static final int USER_CANCELLED_ERR = -101;

    FolderSpec(String string, String string2, String string3) {
        this.folderID = string;
        this.versionRegistryPath = string2;
        this.userPackageName = string3;
    }

    String GetDirectoryPath() throws SoftUpdateException {
        String string = null;
        if (this.urlPath == null) {
            if (this.folderID.compareTo("User Pick") == 0) {
                this.urlPath = VersionRegistry.getDefaultDirectory(this.versionRegistryPath);
                if (this.urlPath == null) {
                    this.PickDefaultDirectory();
                }
            } else if (this.folderID.compareTo("Installed") == 0) {
                this.urlPath = this.versionRegistryPath;
            } else {
                int n = this.NativeGetDirectoryPath();
                if (n != 0) {
                    throw new SoftUpdateException(this.folderID, n);
                }
            }
        }
        string = this.urlPath;
        return string;
    }

    String MakeFullPath(String string) throws SoftUpdateException {
        if (this.GetSecurityTargetID() == 0 && string.regionMatches(0, "..", 0, 2)) {
            throw new SoftUpdateException(Strings.error_IllegalPath(), -209);
        }
        String string2 = String.valueOf(this.GetDirectoryPath()) + this.GetNativePath(string);
        return string2;
    }

    private native int NativeGetDirectoryPath();

    private native String GetNativePath(String var1);

    private void PickDefaultDirectory() throws SoftUpdateException {
        this.urlPath = this.NativePickDefaultDirectory();
        if (this.urlPath == null) {
            throw new SoftUpdateException(this.folderID, -100);
        }
        VersionRegistry.setDefaultDirectory(this.versionRegistryPath, this.urlPath);
    }

    private native String NativePickDefaultDirectory() throws SoftUpdateException;

    Target GetSecurityTarget() {
        int n = this.GetSecurityTargetID();
        return Target.findTarget(SoftwareUpdate.targetNames[n]);
    }

    private native int GetSecurityTargetID();

    public String toString() {
        String string;
        try {
            string = this.GetDirectoryPath();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }
}

