/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout
implements LayoutManager,
Serializable {
    int hgap;
    int vgap;
    int rows;
    int cols;

    public GridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public GridLayout(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("invalid rows,cols");
        }
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.insets();
        int n = container.countComponents();
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            Component component = container.getComponent(n6);
            Dimension dimension = component.preferredSize();
            if (n4 < dimension.width) {
                n4 = dimension.width;
            }
            if (n5 < dimension.height) {
                n5 = dimension.height;
            }
            ++n6;
        }
        return new Dimension(insets.left + insets.right + n3 * n4 + (this.cols - 1) * this.hgap, insets.top + insets.bottom + n2 * n5 + (this.rows - 1) * this.vgap);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.insets();
        int n = container.countComponents();
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            Component component = container.getComponent(n6);
            Dimension dimension = component.minimumSize();
            if (n4 < dimension.width) {
                n4 = dimension.width;
            }
            if (n5 < dimension.height) {
                n5 = dimension.height;
            }
            ++n6;
        }
        return new Dimension(insets.left + insets.right + n3 * n4 + (this.cols - 1) * this.hgap, insets.top + insets.bottom + n2 * n5 + (this.rows - 1) * this.vgap);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = container.countComponents();
        int n2 = this.rows;
        int n3 = this.cols;
        if (n == 0) {
            return;
        }
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        int n4 = container.width - (insets.left + insets.right);
        int n5 = container.height - (insets.top + insets.bottom);
        n4 = (n4 - (n3 - 1) * this.hgap) / n3;
        n5 = (n5 - (n2 - 1) * this.vgap) / n2;
        int n6 = 0;
        int n7 = insets.left;
        while (n6 < n3) {
            int n8 = 0;
            int n9 = insets.top;
            while (n8 < n2) {
                int n10 = n8 * n3 + n6;
                if (n10 < n) {
                    container.getComponent(n10).reshape(n7, n9, n4, n5);
                }
                ++n8;
                n9 += n5 + this.vgap;
            }
            ++n6;
            n7 += n4 + this.hgap;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }
}

