/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int n) {
        this(n, 5, 5);
    }

    public FlowLayout(int n, int n2, int n3) {
        this.align = n;
        this.hgap = n2;
        this.vgap = n3;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = container.countComponents();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            if (((Component)serializable).visible) {
                Dimension dimension2 = ((Component)serializable).preferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                if (n2 > 0) {
                    dimension.width += this.hgap;
                }
                dimension.width += dimension2.width;
            }
            ++n2;
        }
        serializable = container.insets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = container.countComponents();
        int n2 = 0;
        while (n2 < n) {
            serializable = container.getComponent(n2);
            if (((Component)serializable).visible) {
                Dimension dimension2 = ((Component)serializable).minimumSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                if (n2 > 0) {
                    dimension.width += this.hgap;
                }
                dimension.width += dimension2.width;
            }
            ++n2;
        }
        serializable = container.insets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
        return dimension;
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (this.align) {
            case 1: {
                n += n3 / 2;
                break;
            }
            case 2: {
                n += n3;
            }
        }
        int n7 = n5;
        while (n7 < n6) {
            Component component = container.getComponent(n7);
            if (component.visible) {
                component.move(n, n2 + (n4 - component.height) / 2);
                n += this.hgap + component.width;
            }
            ++n7;
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = container.width - (insets.left + insets.right + this.hgap * 2);
        int n2 = container.countComponents();
        int n3 = 0;
        int n4 = insets.top + this.vgap;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            Component component = container.getComponent(n7);
            if (component.visible) {
                Dimension dimension = component.preferredSize();
                component.resize(dimension.width, dimension.height);
                if (n3 == 0 || n3 + dimension.width <= n) {
                    if (n3 > 0) {
                        n3 += this.hgap;
                    }
                    n3 += dimension.width;
                    n5 = Math.max(n5, dimension.height);
                } else {
                    this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n7);
                    n3 = dimension.width;
                    n4 += this.vgap + n5;
                    n5 = dimension.height;
                    n6 = n7;
                }
            }
            ++n7;
        }
        this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n2);
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=left";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=right";
            }
        }
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

