
#ifndef lint
static char sccsid[] = "@(#)bomb.c	3.11h 96/09/30 xlockmore";

#endif
/* 
 * bomb.c - temporary screen lock for public labs
 *
 * See xlock.c for copying information.
 *
 * Revision History:
 * 09-Jan-95: Assorted defines to control various aspects of bomb mode.
 *            Uncomment, or otherwise define the appropriate line
 *            to obtain the relevant behaviour, thanks to Dave Shield
 *            <D.T.Shield@csc.liv.ac.uk>.
 * 20-Dec-94: Time patch for multiprocessor machines (ie. Sun10) thanks to
 *            Nicolas Pioch <pioch@Email.ENST.Fr>.
 * 1994:      Written.  Copyright (c) 1994 Dave Shield
 *            Liverpool Computer Science
 */

#ifndef VMS

#include "xlock.h"

#include <sys/signal.h>
#ifdef SYSLOG
#include <syslog.h>
#endif
#include <stdio.h>

																										  /* #define SIMPLE_COUNTDOWN *//* Display a simple integer countdown,     */
			      /*  rather than a "MIN:SEC" format.        */
#define COLOUR_CHANGE		/* Display cycles through the colour wheel */
			      /*  rather than staying red throughout.    */

#define FULL_COUNT_FONT         "-*-*-*-*-*-*-34-*-*-*-*-*-*-*"
#define ICON_COUNT_FONT         "-*-*-*-*-*-*-8-*-*-*-*-*-*-*"
#define COUNTDOWN       600	/* No. seconds to lock for */
#define NDIGITS         4	/* Number of digits in count */

#define MAX_DELAY       1000000	/* Max delay between updates */
#define NAP_TIME        5	/* Sleep between shutdown attempts */
#define DELTA           10	/* Border around the digits */
#define RIVET_RADIUS    6	/* Size of detonator 'rivets' */

ModeSpecOpt bomb_opts =
{0, NULL, 0, NULL, NULL};

typedef struct {
	int         width, height;
	int         x, y;
	int         delta;
	int         countdown;
	int         text_width;
	int         text_ascent;
	int         text_descent;
} bombstruct;

static bombstruct *bombs = NULL;

extern unsigned long allocPixel(Display * dpy, Colormap, char *, char *);


	/*
	 *  Game Over - player 1
	 *
	 *  This user has hogged the terminal for long enough
	 *  Log them out, and let someone else use it.
	 */
static void
explode(ModeInfo * mi)
{
	bombstruct *bp = &bombs[MI_SCREEN(mi)];
	char        buff[NDIGITS + 2];

	/*
	 *  ToDo:
	 *      Improve the graphics - some sort of explosion?
	 *      (Will need to involve the main X event loop)
	 */
#ifdef SIMPLE_COUNTDOWN
	(void) sprintf(buff, "%.*s", NDIGITS, "*********");
#else
	(void) sprintf(buff, "%.*s:**", NDIGITS - 2, "*******");
#endif
	XSetForeground(MI_DISPLAY(mi), MI_GC(mi), MI_PIXEL(mi, 1));
	XDrawString(MI_DISPLAY(mi), MI_WINDOW(mi), MI_GC(mi),
		    bp->x, bp->y, buff, NDIGITS);

#ifndef DEBUG
	if (!MI_WIN_IS_INWINDOW(mi) && !MI_WIN_IS_INROOT(mi) &&
	    !MI_WIN_IS_NOLOCK(mi)) {
#ifdef SYSLOG
		syslog(LOG_INFO, "xlock expired. closing down (uid %d) on %s\n",
		       getuid(), getenv("DISPLAY"));
#endif
#ifndef KILL_ALL_OTHERS
#define KILL_ALL_OTHERS -1
		(void) signal(SIGHUP, SIG_IGN);
		(void) signal(SIGTERM, SIG_IGN);
#endif
		(void) kill(KILL_ALL_OTHERS, SIGHUP);
		(void) sleep(NAP_TIME);
		(void) kill(KILL_ALL_OTHERS, SIGTERM);
		(void) sleep(NAP_TIME);

#ifdef SYSLOG
		syslog(LOG_NOTICE, "xlock failed to exit - sending kill (uid %d)\n",
		       getuid());
#endif
		(void) kill(KILL_ALL_OTHERS, SIGKILL);
		(void) sleep(NAP_TIME);

#ifdef SYSLOG
		syslog(LOG_WARNING, "xlock still won't exit - suicide (uid %d)\n",
		       getuid());
#endif
		(void) kill(getpid(), SIGKILL);
		exit(-1);
	} else
#endif
	{
		/*
		 *  If debugging, not locked, or in a subwindow
		 *      probably inappropriate to actually log out.
		 */
		(void) fprintf(stderr, "BOOM!!!!\n");
		(void) kill(getpid(), SIGTERM);
	}
}

	/*
	 *  Determine whether to "fully" lock the terminal, or
	 *    whether the time-limited version should be imposed.
	 *
	 *  Policy:
	 *      Members of staff can fully lock
	 *        (hard-wired user/group names + file read at run time)
	 *      Students (i.e. everyone else)
	 *          are forced to use the time-limit version.
	 *
	 *  An alternative policy could be based on display location
	 */
#define FULL_LOCK       1
#define TEMP_LOCK       0

#ifndef STAFF_FILE
#define STAFF_FILE      "/usr/remote/etc/xlock.staff"
#endif

static char *staff_users[] =
{				/* List of users allowed to lock */
	"root",
	0
};

static char *staff_groups[] =
{				/* List of groups allowed to lock */
	0
};

#undef passwd
#undef pw_name
#undef getpwnam
#include <pwd.h>
#include <grp.h>

int
full_lock(void)
{
	uid_t       uid;
	gid_t       gid;

	struct passwd *pwp;
	struct group *gp;
	FILE       *fp;

	char      **cpp;
	char        buf[BUFSIZ];
	extern Bool inwindow, inroot, nolock;

	if ((uid = getuid()) == 0)
		return (FULL_LOCK);	/* root */
	pwp = getpwuid(uid);

	gid = getgid();
	gp = getgrgid(gid);

	if (!inwindow && !inroot && !nolock)
		return (FULL_LOCK);	/* (mostly) harmless user */

	for (cpp = staff_users; *cpp != NULL; cpp++)
		if (!strcmp(*cpp, pwp->pw_name))
			return (FULL_LOCK);	/* Staff user */

	for (cpp = staff_groups; *cpp != NULL; cpp++)
		if (!strcmp(*cpp, gp->gr_name))
			return (FULL_LOCK);	/* Staff group */

	if ((fp = fopen(STAFF_FILE, "r")) == NULL)
		return (TEMP_LOCK);

	while ((fgets(buf, BUFSIZ, fp)) != NULL) {
		char       *cp;

		if ((cp = (char *) strchr(buf, '\n')) != NULL)
			*cp = '\0';
		if (!strcmp(buf, pwp->pw_name) || !strcmp(buf, gp->gr_name))
			return (FULL_LOCK);	/* Staff user or group */
	}
	return (TEMP_LOCK);
}

static void
rivet(ModeInfo * mi, int x, int y)
{
	Display    *display = MI_DISPLAY(mi);
	GC          gc = MI_GC(mi);

	XSetForeground(display, gc, MI_WIN_BLACK_PIXEL(mi));
	XDrawArc(display, MI_WINDOW(mi), gc, x, y,
		 2 * RIVET_RADIUS, 2 * RIVET_RADIUS, 70 * 64, 130 * 64);
	XSetForeground(display, gc, MI_WIN_WHITE_PIXEL(mi));
	XDrawArc(display, MI_WINDOW(mi), gc, x, y,
		 2 * RIVET_RADIUS, 2 * RIVET_RADIUS, 270 * 64, 90 * 64);
}

static void
detonator(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	GC          gc = MI_GC(mi);
	bombstruct *bp = &bombs[MI_SCREEN(mi)];
	int         b_width, b_height;
	int         b_x, b_y;

	b_width = bp->width / 2;
	b_height = bp->height / 3;
	b_x = bp->width / 4;
	b_y = bp->height * 2 / 5;


	XSetForeground(display, gc,
		allocPixel(display, XDefaultColormap(display, MI_SCREEN(mi)),
			   "grey", "white"));
	XFillRectangle(display, MI_WINDOW(mi), gc,
		       b_x, b_y, b_width, b_height);

	/*
	 *  If a full size screen (and colour),
	 *      'rivet' the box to it
	 */
	if (bp->width > 100 && MI_NPIXELS(mi) > 2) {
		rivet(mi, b_x + RIVET_RADIUS, b_y + RIVET_RADIUS);
		rivet(mi, b_x + RIVET_RADIUS, b_y + b_height - 3 * RIVET_RADIUS);
		rivet(mi, b_x + b_width - 3 * RIVET_RADIUS, b_y + RIVET_RADIUS);
		rivet(mi, b_x + b_width - 3 * RIVET_RADIUS,
		      b_y + b_height - 3 * RIVET_RADIUS);
	}
}
void
init_bomb(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	GC          gc = MI_GC(mi);
	bombstruct *bp;
	XFontStruct *c_font;
	char        number[NDIGITS + 2];

  if (bombs == NULL) {
    if ((bombs = (bombstruct *) calloc(MI_NUM_SCREENS(mi),
                 sizeof (bombstruct))) == NULL)
      return;
  }
  bp = &bombs[MI_SCREEN(mi)];

	bp->width = MI_WIN_WIDTH(mi);
	bp->height = MI_WIN_HEIGHT(mi);
	bp->x = (bp->width / 2);
	bp->y = (bp->height * 3 / 5);	/* Central-ish on the screen */

	/* Set up text font */

	if (bp->width > 100) {	/* Full screen */
		c_font = XLoadQueryFont(display, FULL_COUNT_FONT);
		bp->delta = DELTA;
	} else {		/* icon window */
		c_font = XLoadQueryFont(display, ICON_COUNT_FONT);
		bp->delta = 2;
	}
	XSetFont(display, gc, c_font->fid);

#ifdef SIMPLE_COUNTDOWN
	(void) sprintf(number, "%0*d", NDIGITS, 0);
#else
	(void) sprintf(number, "%.*s:**", NDIGITS - 2, "*******");
#endif
	bp->text_width = XTextWidth(c_font, number, NDIGITS + 1);
	bp->x -= (bp->text_width / 2);
	bp->text_ascent = c_font->max_bounds.ascent;
	bp->text_descent = c_font->max_bounds.descent;

	if (MI_DELAY(mi) > MAX_DELAY)
		MI_DELAY(mi) = MAX_DELAY;	/* Time cannot move slowly */
	if (bp->countdown == 0)	/* <--Stricter if uncommented */
		bp->countdown = (time((long *) NULL) + COUNTDOWN);	/* Prime the detonator */

	XClearWindow(display, MI_WINDOW(mi));
	/*
	 *  Draw the graphics
	 *      Very simple - detonator box with countdown
	 *
	 *  ToDo:  Improve the graphics
	 *      (e.g. stick of dynamite, with burning fuse?)
	 */
  detonator(mi);
}




void
draw_bomb(ModeInfo * mi)
{
	Display    *display = MI_DISPLAY(mi);
	GC          gc = MI_GC(mi);
	bombstruct *bp = &bombs[MI_SCREEN(mi)];
	char        number[NDIGITS + 2];
	unsigned long crayon;
	time_t      countleft;

	countleft = (bp->countdown - time((long *) NULL));
	if (countleft <= 0)
		explode(mi);	/* Bye, bye.... */

#ifdef SIMPLE_COUNTDOWN
	(void) sprintf(number, "%0*d", NDIGITS, (int) countleft);
#else
	(void) sprintf(number, "%0*d:%02d", NDIGITS - 2,
		       (int) countleft / 60, (int) countleft % 60);
#endif

	/* Blank out the previous number .... */
	XSetForeground(display, gc, MI_WIN_BLACK_PIXEL(mi));
	XFillRectangle(display, MI_WINDOW(mi), gc,
		       bp->x - bp->delta,
		       (bp->y - bp->text_ascent) - bp->delta,
		       bp->text_width + (2 * bp->delta),
		     (bp->text_ascent + bp->text_descent) + (2 * bp->delta));

	/* ... and count down */
	if (MI_NPIXELS(mi) <= 2)
		crayon = MI_WIN_WHITE_PIXEL(mi);
	else
#ifdef COLOUR_CHANGE
		crayon = MI_PIXEL(mi, countleft * MI_NPIXELS(mi) / COUNTDOWN);
#else
		crayon = MI_PIXEL(mi, 1);
#endif
	XSetForeground(display, gc, crayon);
	XDrawString(display, MI_WINDOW(mi), gc, bp->x, bp->y,
		    number, strlen(number));
}

void
release_bomb(ModeInfo * mi)
{
  if (bombs != NULL) {
    (void) free((void *) bombs);
    bombs = NULL;
  }
}

void
refresh_bomb(ModeInfo * mi)
{
  detonator(mi);
}

#endif
