.\" -*- nroff -*-
.TH ypbind 8 "November 1995" "ypbind Version 2.2"
.SH NAME
ypbind - NIS binding process
.SH SYNOPSIS
.B
/usr/sbin/ypbind
[
.B \-debug
] [
.B \-broken_server
] [
.B \-ypset
] [
.B \-ypsetme
]
.SH DESCRIPTION
.B ypbind
finds the server for a NIS domain and stores the information about it
in a
.B binding file.
The binding file resides in the directory
.B /var/yp/binding
and is conventionally named
.BR domainname.version .
The only supported version is version 2.

Unless the option
.B \-debug
is used, ypbind detaches itself from the controlling terminal and puts
itself into background.
.B ypbind
uses
.B syslog()
for logging errors and warnings.

At startup or when receiving signal SIGHUP,
.B ypbind
parses the file
.B /etc/yp.conf
and tries to use the entries for its initial binding. Valid entries
are

.B domain
.I nisdomain
.B server
.I hostname
.RS
Use server
.I hostname
for the domain
.IR nisdomain .
.RE

.B domain
.I nisdomain
.B broadcast
.RS
Use broadcast on the local net for domain
.IR nisdomain .
.RE

.B ypserver
.I hostname
.RS
Use server
.I server
for the local domain. The IP-address of
.I server
must be listed in
.BR /etc/hosts .
.RE

If the file does not exist of if there are no valid entries,
.B ypbind
broadcasts on the local net looking for a NIS server for the local
domain. 

.B ypbind
is split into two processes. The master process services RPC requests
asking for binding info. The slave process initializes the binding and
checks it periodically. Upon failure, the binding is invalidated and
the process tries again to find a valid server.

.SH OPTIONS
.IP \-ypset
.BR ypset (8)
may be used to change the binding for a domain.

.IP \-ypsetme
.BR ypset (8)
may only be used from the local host to change the
binding for a domain.

.IP \-debug
starts
.B ypbind
in debug mode.
.B ypbind
will not put itself into background, and error messages and debug
output are written to standard error.

.IP \-broken_server
lets
.B ypbind
accept answers from servers running on an illegal port number. This should
usually be avoided, but is required on Solaris 2.4 (there should be a patch
for Solaris which fixes this broken behaviour.)

.SH FILES
.B /etc/yp.conf
- configuration file.

.BI /var/yp/binding/ domainname.version
- binding file containing information about
.IR domain .

.B /var/run/ypbind.pid
- contains the process id of the currently running
.B ypbind
master process.
.B ypbind
sets a write lock to this file to prevent multiple copies of itself
from running.

.SH BUGS
.B ypbind
will only use the last entry for a domain from
.BR /etc/yp.conf ,
binding to multiple servers for a single domain is
not yet supported.

.SH AUTHOR
.B ypbind
was written by Swen Thuemmler <swen@uni-paderborn.de>. Michael Rausch
<mrausch@ernie.mi.uni-koeln.de> added support for SysV-IPC. Numerous
bugfixes from other contributors.
