##  $Revision: 1.4 $
##  control.ctl - access control for control messages
##  Format:
##	<message>:<from>:<newsgroups>:<action>
##  The last match found is used.
##	<message>	Control message or "all" if it applies
##			to all control messages.
##	<from>		Pattern that must match the From line.
##	<newsgroups>	Pattern that must match the newsgroup being
##			newgroup'd or rmgroup'd (ignored for other messages).
##	<action>	What to do:
##			    doit	Perform action (usually sends mail too)
##			    doifarg	Do if command has an arg (see sendsys)
##			    doit=xxx	Do action; log to xxx (see below)
##			    drop	Ignore message
##			    log		One line to error log
##			    log=xxx	Log to xxx (see below)
##			    mail	Send mail to admin
##			xxx=mail to mail; xxx= (empty) to toss; xxx=/full/path
##			to log to /full/path; xxx=foo to log to ${LOG}/foo.log

##	DEFAULT
all:*:*:mail

##	CHECKGROUPS MESSAGES
checkgroups:*:*:mail

##	IHAVE/SENDME MESSAGES
ihave:*:*:drop
sendme:*:*:drop

##	NEWGROUP MESSAGES
newgroup:*:*:doit=mail

##	RMGROUP MESSAGES
rmgroup:*:*:mail

##	SENDSYS
sendsys:*:*:doifarg

##	SENDUUNAME
senduuname:*:*:doit=mail

##	VERSION
version:*:*:doit=mail
