#include <stdio.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>
/***************************************************************************
 *
 * Function:   fcloseall
 *
 * Description:
 *   Close all open files and flush any pending buffers
 *
 * Input:
 *    none.
 *
 * Output:
 *    the number of streams closed or EOF to indicate an error
 */

int fcloseall (void)
    {
    FILE *stream = &_iob[3];
    int  nResult = 0;
/*
 *  Close the streams
 */
    FUNC_ENTRY ("fcloseall");
    while (stream <= _lastiob)
        {
	if (inuse (stream))
	    {
	    if (fclose (stream) != -1)
	        {
		++nResult;
	        }
	    }
	++stream;
        }
/*
 *  Return the count of files closed
 */
    FUNC_EXIT ("fcloseall");
    return (nResult);
    }

/********************************************************************
 *
 * Function:    _cleanup
 *
 * Description:
 *    Do the standard cleanup routines for the files. All pending files
 *    are flushed and closed.
 *
 * Entry:
 *    none.
 *
 * Returns:
 *    none.
 */

void _cleanup(void)
    {
/*
 *  Close the standard files
 */
    FUNC_ENTRY ("_cleanup");
    (void) fclose (stdin);
    (void) fclose (stdout);
    (void) fclose (stderr);
/*
 *  Close the other files in the system
 */
    (void) fcloseall();
    FUNC_EXIT ("_cleanup");
    }
