/*  LAST EDIT: Fri Sep 29 17:57:39 1995 by Thorsten Kukuk (kukuk)  */
/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Modified for use with ypserv by Thorsten Kukuk <kukuk@uni-paderborn.de>
*/

#include <memory.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#include "yp.h"

static struct timeval TIMEOUT = { 25, 0 };
 
ypresp_key_val *
ypproc_first_2( ypreq_nokey *argp, CLIENT *clnt)
{
        static ypresp_key_val res;
 
        memset((char*)&res, 0, sizeof(res));
        if (clnt_call(clnt, YPPROC_FIRST, xdr_ypreq_key,
		      (void *) argp, xdr_ypresp_key_val,
		      (void *) &res, TIMEOUT) != RPC_SUCCESS) {
                return (NULL);
        }
        return (&res);
}
 
void *
ypproc_clear_2( void *argp, CLIENT *clnt)
{
        static char res;
 
        memset((char*)&res, 0, sizeof(res));
        if (clnt_call(clnt, YPPROC_CLEAR, xdr_void, argp, xdr_void, &res, TIMEOUT) != RPC_SUCCESS) {
                return (NULL);
        }
        return ((void *)&res);
}
 
 
ypresp_all *
ypproc_all_2( ypreq_nokey *argp, CLIENT *clnt)
{
        static ypresp_all res;
 
        memset(&res, 0, sizeof(res));
        if (clnt_call(clnt, YPPROC_ALL, xdr_ypreq_nokey,
		      (void *) argp, xdr_ypresp_all,
		      (void *) &res, TIMEOUT) != RPC_SUCCESS) {
                return (NULL);
        }
        return (&res);
}
 
 
ypresp_master *
ypproc_master_2( ypreq_nokey *argp, CLIENT *clnt)
{
        static ypresp_master res;
 
        memset(&res, 0, sizeof(res));
        if (clnt_call(clnt, YPPROC_MASTER, xdr_ypreq_nokey,
		      (void *) argp, xdr_ypresp_master,
		      (void *) &res, TIMEOUT) != RPC_SUCCESS) {
                return (NULL);
        }
        return (&res);
}
 

ypresp_maplist *
ypproc_maplist_2( domainname *argp, CLIENT *clnt)
{
        static ypresp_maplist res;
 
        memset((char*)&res, 0, sizeof(res));
        if (clnt_call(clnt, YPPROC_MAPLIST, xdr_domainname,
		      (void *) argp, xdr_ypresp_maplist,
		      (void *) &res, TIMEOUT) != RPC_SUCCESS) {
                return (NULL);
        }
        return (&res);
}
 
