.\" Copyright (c) 1991 Free Software Foundation
.\" See section COPYING for conditions for redistribution
.TH @PROGRAM@ 1 "June 1993" "cygnus support" "GNU Development Tools"
.de BP
.sp
.ti \-.2i
\(**
..

.SH NAME
@PROGRAM@ \- demangle C++ symbols

.SH SYNOPSIS
.hy 0
.na
.TP
.B @PROGRAM@
.RB "[\|" \-_ | \-\-strip-underscores "\|]"
.RB "[\|" "\-s {gnu,lucid,arm} " | " \-\-format={gnu,lucid,arm}" "\|]"
.RB "[\|" \-\-help "\|]"
.RB "[\|" \-\-version "\|]"
.RB "[\|" symbol "...\|]"
.SH DESCRIPTION
The C++ language provides function overloading, which means that you can
write many functions with the same name (providing each takes parameters
of different types).  All C++ function names are encoded into a
low-level assembly label (this process is known as
.I mangling\c
).  The 
.B @PROGRAM@
program does the inverse mapping: it decodes (\fIdemangles\fR)
low-level names into user-level names so that the linker can keep
these overloaded functions from clashing.
.PP
Every alphanumeric word (consisting of letters, digits, underscores,
dollars, or periods) seen in the input is a potential label.  If the
label decodes into a C++ name, the C++ name replaces the low-level
name in the output.
.PP
You can use
.B @PROGRAM@
to decipher individual symbols by specifying these symbols on the
command line.
.PP
If no
.B symbol
arguments are given,
.B @PROGRAM@
reads symbol names from the standard input and writes the demangled
names to the standard output.  All results are printed on the standard
output.
.SH OPTIONS
.TP
.B \-_
.TP
.B \-\-strip\-underscores
On some systems, both the C and C++ compilers put an
underscore in front of every name.  For example, the C name 
.B foo
gets the low-level name 
.BR _foo .
This option removes the leading underscore.

.TP
.B "\-s {gnu,lucid,arm}"
.TP
.B \-\-format={gnu,lucid,arm}
GNU
.B nm
can decode three different methods of mangling, used by different C++
compilers.  This option selects which method it uses: the one used by
the GNU compiler, the one used by the Lucid compiler, or the one
specified by the C++ Annotated Reference Manual.  The default is the
GNU style.

.TP
.B \-\-help
Print a summary of the options to
.B @PROGRAM@
and exit.

.TP
.B \-\-version
Print the version number of
.B @PROGRAM@
and exit.

.SH "SEE ALSO"
.RB "`\|" binutils "\|'" 
entry in 
.B
info\c
\&; 
.I
The GNU Binary Utilities\c
\&, Roland H. Pesch (June 1993).

.SH COPYING
Copyright (c) 1993 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
