------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--            S Y S T E M . P A R T I T I O N _ I N T E R F A C E           --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.5 $                             --
--                                                                          --
--    Copyright (C) 1991,92,93,94,95,1996 Free Software Foundation, Inc.    --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

with System.RPC;
package System.Partition_Interface is

   function Get_Local_Partition_ID return System.RPC.Partition_ID;
   --  Return the Partition_ID of the calling thread. Supports implementation
   --  of D'Partition_ID for the case where D is known to be local (non-RCI,
   --  non-Shared_Passive, non-self reference).

   subtype Subprogram_Id is Natural;
   --  This type is used exclusively by stubs. It denotes which subprogram
   --  within an RCI is being called.

   subtype Library_Unit_Name is String;

   function Get_Active_Partition_ID
     (Name : Library_Unit_Name)
      return System.RPC.Partition_ID;
   --  Return the Partition_ID of the partition to which the named remote
   --  call interface package is assigned. Supports implementation of
   --  D'Partition_ID for RCI packages.

   function Get_Passive_Partition_ID
     (Name : Library_Unit_Name)
      return System.RPC.Partition_ID;
   --  Return the partition ID of the partition to which the named shared
   --  passive package was assigned. Supports the implementation of
   --  D'Partition_ID for shared passive packages. This separate function
   --  is necessary because shared passive packages have no thread of control
   --  of their own, and cannot register themselves by making a call to
   --  Register_Server_Elaboration. This function currently always returns 0.

   procedure Register_Server_Elaboration
     (Name     : Library_Unit_Name;
      Receiver : System.RPC.RPC_Receiver;
      Version  : String);
   --  Registers the fact that the receiving stub for package Name is now
   --  elaborated. Register the access value to the package's RPC_Receiver
   --  procedure and the version of the package. Called by the receiving
   --  stub for RCI package Name.

   function Get_RCI_Package_Receiver
     (Name : in Library_Unit_Name)
      return System.RPC.RPC_Receiver;
   --  Return the access value to Name's RPC_Receiver procedure. Called by
   --  the calling stub when it is necessary to make an RCI call. The value
   --  returned is for marshalling into the Params stream. This call blocks
   --  until the receiving stub for Name is elaborated.

end System.Partition_Interface;
