------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                       S Y S T E M . B I T _ O P S                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--            Copyright (C) 1996 Free Software Foundation, Inc.             --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

with System;                use System;
with System.Unsigned_Types; use System.Unsigned_Types;

package body System.Bit_Ops is

   LE : constant := Standard'Default_Bit_Order;
   --  Static constant set to 0 for big-endian, 1 for little-endian

   --  The following is an array of masks used to mask the final byte, either
   --  at the high end (big-endian case) or the low end (little-endian case).

   Masks : constant array (0 .. 7) of Packed_Byte :=
     (2#1111_1111#,
      (1 - LE) * 2#1000_0000# + LE * 2#0000_0001#,
      (1 - LE) * 2#1100_0000# + LE * 2#0000_0011#,
      (1 - LE) * 2#1110_0000# + LE * 2#0000_0111#,
      (1 - LE) * 2#1111_0000# + LE * 2#0000_1111#,
      (1 - LE) * 2#1111_1000# + LE * 2#0001_1111#,
      (1 - LE) * 2#1111_1100# + LE * 2#0011_1111#,
      (1 - LE) * 2#1111_1110# + LE * 2#0111_1111#);

   -------------
   -- Bit_Not --
   -------------

   function Bit_Not (Str : Bits; Len : Natural) return Bits is
      Rlen   : constant Natural := (Len + 7) / 8;
      Result : Bits (0 .. Rlen - 1);

   begin
      for J in Result'Range loop
         Result (J) := not Str (Str'First + J);
      end loop;

      if Len /= 0 then
         Result (Result'Last) :=
           Result (Result'Last) and Masks (Len mod 8);
      end if;

      return Result;
   end Bit_Not;

end System.Bit_Ops;
